#################################################
#################################################
#								#
#                CHAPTER 12: 				#
#    Modelling Multivariate Serological Data	#
#								#
# last update: 26/08/2012				#
# made in R version 2.9.2                       #
# when running in a higher R version: using     #
# the library VGAM results in a but             #
#################################################
#################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter12")

### Define Functions 
######################

# 95% confidence intervals 
ci<-function(x){quantile(x,prob=c(0.025,0.975),na.rm=T)}
# expit
expit<-function(eta){return(exp(eta)/(1+exp(eta)))}
# pavit
pavit<- function(datai){
pai1<-pai2<-datai
N<- length(pai1)
for(i in 1:(N-1)){
	if (pai2[i] > pai2[i+1]){
     pool<-(pai1[i]+pai1[i+1])/2
     pai2[i:(i+1)]<- pool
     k<- i+1	
       for(j in (k-1):1){
       	if (pai2[j] >  pai2[k]){
	       pool.2<- sum(pai1[j:k])/length(pai1[j:k])
	       pai2[j:k]<- pool.2}   
}
}
}	
return(list(pai1=pai1,pai2=pai2))
}

# numerical for the FOI
foi.num<-function(x,p)
{
grid<-sort(unique(x))
pgrid<-(p[order(x)])[duplicated(sort(x))==F]
dp<-diff(pgrid)/diff(grid)
foi<-approx((grid[-1]+grid[-length(grid)])/2,dp,grid[c(-1,-length(grid))])$y/(1-pgrid[c(-1,-length(grid))])
return(list(grid=grid[c(-1,-length(grid))],foi=foi))
}

################################
# PART 1: READ IN THE DATASETS #
################################
# (1) rubella and mumps in the UK
#---------------------------------
rub.mumps.uk<-read.table("c:/book/chapter4/Rubella-Mumps-UK.dat",header=T)
names(rub.mumps.uk)

# Creating the binary version
rubella.mumps.uk<-rbind(cbind(rep(rub.mumps.uk$Age,rub.mumps.uk$PP),1,1),
			cbind(rep(rub.mumps.uk$Age,rub.mumps.uk$PN),1,0),
			cbind(rep(rub.mumps.uk$Age,rub.mumps.uk$NP),0,1),
			cbind(rep(rub.mumps.uk$Age,rub.mumps.uk$NN),0,0))
rubella.mumps.uk<-data.frame(rubella.mumps.uk[order(rubella.mumps.uk[,1]),])
names(rubella.mumps.uk)<-c("age","rubres","mumpsres")

y1<-rubella.mumps.uk$rubres
y2<-rubella.mumps.uk$mumpsres
age<-rubella.mumps.uk$age


# (2) the varicella zoster virus and parvovirus B19 in Belgium
#--------------------------------------------------------------
vzv.parvo.be<-read.table("c:/book/chapter4/VZV-B19-BE.dat",header=T)
vzv.parvo.be<-vzv.parvo.be[!is.na(vzv.parvo.be$VZVres)&!is.na(vzv.parvo.be$parvores)&!is.na(vzv.parvo.be$age)&vzv.parvo.be$age<70&vzv.parvo.be$age>=1,]
vzv.parvo.be<-vzv.parvo.be[order(vzv.parvo.be$age),]
names(vzv.parvo.be)

y1<-vzv.parvo.be$VZVres
y2<-vzv.parvo.be$parvores
age<-vzv.parvo.be$age

# Define the necessary variables and attach the data
#----------------------------------------------------
a<-unique(age)
covariate<-seq(min(age),max(age),1)

# Counts per age-value
PP<-as.vector(hist(age[y1=="1"&y2=="1"],plot=F,breaks=c(0,a))$counts)
PN<-as.vector(hist(age[y1=="1"&y2=="0"],plot=F,breaks=c(0,a))$counts)
NP<-as.vector(hist(age[y1=="0"&y2=="1"],plot=F,breaks=c(0,a))$counts)
NN<-as.vector(hist(age[y1=="0"&y2=="0"],plot=F,breaks=c(0,a))$counts)

# Plot the marginal observed prevalences per integer age-values
# Extra plot (not in book)
par(mfrow=c(1,2))
grid<-sort(unique(round(age)))
neg1<-table(y1,round(age))[1,]
pos1<-table(y1,round(age))[2,]
tot1<-neg1+pos1
plot(grid,pos1/tot1,cex=0.02*tot1,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,max(a)),ylim=c(0,1))
grid<-sort(unique(round(age)))
neg2<-table(y2,round(age))[1,]
pos2<-table(y2,round(age))[2,]
tot2<-neg2+pos2
plot(grid,pos2/tot2,cex=0.02*tot2,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,max(a)),ylim=c(0,1))

# Attach the data
data<-data.frame(NN,NP,PN,PP,a=sort(a))
attach(data)

##################################################
## Section 12.2: Marginal and Conditional Models #
##								 #
## 12.2.1: The bivariate Dale Model Applied to   #
##         Airborne Infections			 #
##################################################

library(VGAM)

# BDM without constraints
#-------------------------
sel<-NULL
k.vec<-seq(0,0.1,0.001)
for (j in 1:length(k.vec)){
k<-k.vec[j]
fit.s<-vgam(cbind(NN,NP,PN,PP)~s(a,spar=k),binom2.or(zero=NULL),data)
BIC<-deviance(fit.s)+log(dim(data)[1])*(3*dim(data)[1]-df.residual(fit.s))
sel<-rbind(sel,c(k,BIC))
}
sparopt<-sel[which.min(sel[,2]),1]

# Optimal value
#---------------
fit.s1<-vgam(cbind(NN,NP,PN,PP)~s(a,spar=sparopt),binom2.or(zero=NULL),data)
summary(fit.s1)
BIC1<-deviance(fit.s1)+log(dim(data)[1])*(3*dim(data)[1]-df.residual(fit.s1))


# Age-independent OR
#--------------------
fit.s2<-vgam(cbind(NN,NP,PN,PP)~s(a,spar=sparopt),binom2.or(zero=NULL),constraints=list("(Intercept)"=diag(3),"s(a, spar = sparopt)"=diag(3)[,1:2]))
summary(fit.s2)
BIC2<-deviance(fit.s2)+log(dim(data)[1])*(3*dim(data)[1]-df.residual(fit.s2))

# Select appropriate fit for the following analyses
#---------------------------------------------------
fit.s<-fit.s1


# BDM-bootstrap CI
#------------------
runs<-1000
runs.mat.pi1<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi2<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.or<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi00<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi01<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi10<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi11<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi2condpi1<-matrix(NA,nrow=runs,ncol=length(covariate))
runs.mat.pi1condpi2<-matrix(NA,nrow=runs,ncol=length(covariate))

for (i in 1:runs)
{
print(c("bootstrap",i))
bootsample<-sample(c(1:length(a)),length(a),replace=T)
#fit.boot<-vgam(cbind(NN,NP,PN,PP)~s(a,spar=sparopt),binom2.or(zero=NULL),constraints=list("(Intercept)"=diag(3),"s(a, spar = sparopt)"=diag(3)[,1:2]),data=data[bootsample,])
fit.boot<-vgam(cbind(NN,NP,PN,PP)~s(a,spar=sparopt),binom2.or(zero=NULL),data=data[bootsample,])
runs.mat.pi1[i,]<-approx(x=a[bootsample],y=predictors(fit.boot)[,1],xout=covariate)$y
runs.mat.pi2[i,]<-approx(x=a[bootsample],y=predictors(fit.boot)[,2],xout=covariate)$y
runs.mat.or[i,]<-approx(x=a[bootsample],y=predictors(fit.boot)[,3],xout=covariate)$y
runs.mat.pi00[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,1],xout=covariate)$y
runs.mat.pi01[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,2],xout=covariate)$y
runs.mat.pi10[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,3],xout=covariate)$y
runs.mat.pi11[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,4],xout=covariate)$y
runs.mat.pi1condpi2[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,4]/(fitted(fit.boot)[,2]+fitted(fit.boot)[,4]),xout=covariate)$y
runs.mat.pi2condpi1[i,]<-approx(x=a[bootsample],y=fitted(fit.boot)[,4]/(fitted(fit.boot)[,3]+fitted(fit.boot)[,4]),xout=covariate)$y
}

### FIGURE 12.1 & 12.2
#-----------------------
# The natural parameters
windows(record=TRUE, width=7, height=3.5)
par(mfrow=c(1,3),cex.axis=1.3,cex.lab=1.5,lwd=3,las=1,mgp=c(3, 0.5, 0))

plot(c(range(a)),c(0,1),type="n",xlab="Age",ylab="serorevalence")
lines(covariate,expit(apply(runs.mat.pi1[1:runs,],2,ci)[1,]),lty=2,lwd=2)
lines(covariate,expit(apply(runs.mat.pi1[1:runs,],2,ci)[2,]),lty=2,lwd=2)
points(grid,pos1/tot1,cex=0.015*tot1,pch=1,lwd=1)
lines(a,(fitted(fit.s)[,3]+fitted(fit.s)[,4]),lty=1,lwd=2)
#title(c("Prevalence"))

plot(c(range(a)),c(0,1),type="n",xlab="Age",ylab="serorevalence")
lines(covariate,expit(apply(runs.mat.pi2[1:runs,],2,ci)[1,]),lty=2,lwd=2)
lines(covariate,expit(apply(runs.mat.pi2[1:runs,],2,ci)[2,]),lty=2,lwd=2)
points(grid,pos2/tot2,cex=0.015*tot2,pch=1,lwd=1)
lines(a,(fitted(fit.s)[,2]+fitted(fit.s)[,4]),lty=1,lwd=2)
#title(c("Prevalence"))

plot(c(range(a)),c(0,max((exp(predictors(fit.s)[,3])))),type="n",xlab="Age",ylab="odds ratio")
lines(covariate,exp(apply(runs.mat.or[1:runs,],2,ci)[1,]),lty=2,lwd=2)
lines(covariate,exp(apply(runs.mat.or[1:runs,],2,ci)[2,]),lty=2,lwd=2)
lines(a,(exp(predictors(fit.s)[,3])),lwd=2)
lines(range(a),c(1,1),lwd=2)
#title("OR")


##################################################
## Section 12.2: Marginal and Conditional Models #
##								 #
## 12.2.2: The marginal, conditional and joint   #
##         Force of Infection 			 #
##################################################

# Joint probabilities: barplot

### FIGURE 12.3 (left and right panel)
#-------------------------------------
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

rawprobs<-rbind(table(round(age),y1==1&y2==1)[,2]/table(round(age)),
+table(round(age),y1==1&y2==0)[,2]/table(round(age)),
+table(round(age),y1==0&y2==1)[,2]/table(round(age)),
+table(round(age),y1==0&y2==0)[,2]/table(round(age)))
barplot(rawprobs, plot = TRUE, beside = F,space=0,cex.axis=0.8,ylab="probabilities",xlab="Age")
lines(-0.5+a,fitted(fit.s)[,4],lty=1,lwd=2)
lines(-0.5+a,fitted(fit.s)[,4]+fitted(fit.s)[,3],lty=1,lwd=2)
lines(-0.5+a,fitted(fit.s)[,4]+fitted(fit.s)[,3]+fitted(fit.s)[,2],lty=1,lwd=2)


# Applying the pavit function
#-----------------------------
p11<-pavit(fitted(fit.s)[order(a),4])$pai2
p1m<-pavit(fitted(fit.s)[order(a),3]+fitted(fit.s)[order(a),4])$pai2
pm1<-pavit(fitted(fit.s)[order(a),2]+fitted(fit.s)[order(a),4])$pai2
p10<-p1m-p11
p01<-pm1-p11
p00<-1-p11-p10-p01

# The comparison between monotoniced and non-monotoniced curves
# extra figure - not in book
#---------------------------------------------------------------
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

plot(c(range(a)),c(0,1),type="n",xlab="Age",ylab="Joint probabilities")
lines(sort(a),p11,lty=1,col=2)
lines(sort(a),fitted(fit.s)[order(a),4],lty=1)
lines(sort(a),p10,lty=2,col=2)
lines(sort(a),fitted(fit.s)[order(a),3],lty=2)
lines(sort(a),p01,lty=3,col=2)
lines(sort(a),fitted(fit.s)[order(a),2],lty=3)
lines(sort(a),p00,lty=4,col=2)
lines(sort(a),fitted(fit.s)[order(a),1],lty=4)
#title("BDM joint probabilities")
#legend(3,1,c("P(1,1)","P(1,0)","P(0,1)","P(0,0)"),lty=1:4,cex=0.6)
#legend(10,1,c("Monotone","Monotonicity constraint"),text.col=c(2,1),cex=0.6)



# Putting prevalences and FOI on the same curve 
# Together with bootstrap CI - all using the pavit                   
#--------------------------------------------------
runs.mat.pi1.pav<-matrix(NA,ncol=length(covariate),nrow=runs)
runs.mat.pi2.pav<-matrix(NA,ncol=length(covariate),nrow=runs)
foi.mat1<-matrix(NA,ncol=length(covariate)-2,nrow=runs)
foi.mat2<-matrix(NA,ncol=length(covariate)-2,nrow=runs)
foi.mat1.pav<-matrix(NA,ncol=length(covariate)-2,nrow=runs)
foi.mat2.pav<-matrix(NA,ncol=length(covariate)-2,nrow=runs)
pav<-function(x){x[!is.na(x)]<-pavit(x[!is.na(x)])$pai2; return(x)}
for (i in 1:runs)
{
runs.mat.pi1.pav[i,]<-pav(runs.mat.pi1[i,])
foi.mat1[i,]<-foi.num(covariate,expit(runs.mat.pi1[i,]))$foi
foi.mat1.pav[i,]<-apply(cbind(0,foi.mat1[i,]),1,max)
runs.mat.pi2.pav[i,]<-pav(runs.mat.pi2[i,])
foi.mat2[i,]<-foi.num(covariate,expit(runs.mat.pi2[i,]))$foi
foi.mat2.pav[i,]<-apply(cbind(0,foi.mat2[i,]),1,max)
print(c("bootstrap run",i))
}

# The pavit versions
# extra figure - not in book
#----------------------------
foiy1<-apply(cbind(0,foi.num(covariate,approx(a,fitted(fit.s)[order(a),3]+fitted(fit.s)[order(a),4],covariate)$y)$foi),1,max)
par(mfrow=c(1,1))
plot(sort(a),fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),3],xlab="age",ylab="",type="l",xlim=c(0,41),ylim=c(0,1),lwd=2,lty=1)
points(grid,pos1/tot1,cex=0.02*tot1,pch=1)
lines(covariate,apply(expit(runs.mat.pi1.pav),2,ci)[1,],xlim=c(0,40),lty=2,lwd=2)
lines(covariate,apply(expit(runs.mat.pi1.pav),2,ci)[2,],xlim=c(0,40),lty=2,lwd=2)
lines(covariate[-c(1,length(covariate))],foiy1,lty=1,lwd=2)
lines(covariate[-c(1,length(covariate))],apply(foi.mat1.pav,2,ci)[1,],xlim=c(0,40),lty=2,lwd=2)
lines(covariate[-c(1,length(covariate))],apply(foi.mat1.pav,2,ci)[2,],xlim=c(0,40),lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
legend(5,0.975,c("Prevalence and CI Curves"),bty="n",cex=0.8)
legend(10,0.25,c("FOI and CI Curves"),bty="n",cex=0.8)

foiy2<-apply(cbind(0,foi.num(covariate,approx(a,fitted(fit.s)[order(a),2]+fitted(fit.s)[order(a),4],covariate)$y)$foi),1,max)
par(mfrow=c(1,1))
plot(sort(a),fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),2],xlab="age",ylab="",type="l",xlim=c(0,41),ylim=c(0,1),lwd=2)
points(grid,pos2/tot2,cex=0.02*tot2,pch=1)
lines(covariate,apply(expit(runs.mat.pi2.pav),2,ci)[1,],lty=2,lwd=2)
lines(covariate,apply(expit(runs.mat.pi2.pav),2,ci)[2,],lty=2,lwd=2)
lines(covariate[-c(1,length(covariate))],foiy2,lty=1,lwd=2)
lines(covariate[-c(1,length(covariate))],apply(foi.mat2.pav,2,ci)[1,],lty=2,lwd=2)
lines(covariate[-c(1,length(covariate))],apply(foi.mat2.pav,2,ci)[2,],lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
legend(10,0.90,c("Prevalence and CI Curves"),bty="n",cex=0.8)
legend(15,0.25,c("FOI and CI Curves"),bty="n",cex=0.8)

# Plot of the conditional prevalences together with their FOI-curves
#--------------------------------------------------------------------
p.y1.1.c.y2.1<-pavit(approx(a,fitted(fit.s)[order(a),4]/(fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),2]),a)$y)$pai2
lambda.y1.1.c.y2.1<-apply(cbind(foi.num(a,p.y1.1.c.y2.1)$foi,0),1,max)
p.y1.1.c.y2.0<-pavit(approx(a,fitted(fit.s)[order(a),3]/(fitted(fit.s)[order(a),1]+fitted(fit.s)[order(a),3]),a)$y)$pai2
lambda.y1.1.c.y2.0<-apply(cbind(foi.num(a,p.y1.1.c.y2.0)$foi,0),1,max)
p.y2.1.c.y1.1<-pavit(approx(a,fitted(fit.s)[order(a),4]/(fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),3]),a)$y)$pai2
lambda.y2.1.c.y1.1<-apply(cbind(foi.num(a,p.y2.1.c.y1.1)$foi,0),1,max)
p.y2.1.c.y1.0<-pavit(approx(a,fitted(fit.s)[order(a),2]/(fitted(fit.s)[order(a),2]+fitted(fit.s)[order(a),1]),a)$y)$pai2
lambda.y2.1.c.y1.0<-apply(cbind(foi.num(a,p.y2.1.c.y1.0)$foi,0),1,max)

# Plot of the conditional prevalences together with their FOI-curves
### FIGURE 12.5
#--------------------------------------------------------------------

### left panel
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

plot(a,pavit(p.y1.1.c.y2.1)$pai2,type="l",xlab="age",ylab="",ylim=c(0,1),col=1,lwd=2,lty=2)
lines(a,pavit(p.y1.1.c.y2.0)$pai2,lty=3,col=1,lwd=2)
lines(a,fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),3],lty=1,lwd=2)
lines(covariate,apply(cbind(approx(x=a[-1],y=diff(pavit(predictors(fit.s)[,1])$pai2)/diff(a)*expit(pavit(predictors(fit.s)[-1,1])$pai2),xout=covariate)$y,0),1,max),lty=1,lwd=2)
lines(a[-c(1,length(a))],lambda.y1.1.c.y2.1,lty=2,col=1,lwd=2)
lines(a[-c(1,length(a))],lambda.y1.1.c.y2.0,lty=3,col=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
#legend(-3,0.98,c("(Conditional) Prevalence Curves"),bty="n",cex=0.8)
legend(15,0.98,c("(Conditional) Prevalence Curves"),bty="n",cex=0.8)
legend(12,0.2,c("(Conditional) FOI Curves"),bty="n",cex=0.8)
#legend(20,0.6,c("y1=1","y1=1|y2=1","y1=1|y2=0"),lty=1:3,cex=1)

### right panel
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(3, 0.5, 0))

plot(a,pavit(p.y2.1.c.y1.1)$pai2,type="l",xlab="age",ylab="",ylim=c(0,1),col=1,lwd=2,lty=2)
lines(a,pavit(p.y2.1.c.y1.0)$pai2,lty=3,col=1,lwd=2)
lines(a,pavit(fitted(fit.s)[order(a),4]+fitted(fit.s)[order(a),2])$pai2,lty=1,lwd=2)
lines(a[-c(1,length(a))],lambda.y2.1.c.y1.1,lty=2,col=1,lwd=2)
lines(a[-c(1,length(a))],lambda.y2.1.c.y1.0,lty=3,col=1,lwd=2)
lines(covariate,apply(cbind(0,approx(x=a[-1],y=diff(pavit(predictors(fit.s)[,2])$pai2)/diff(a)*expit(pavit(predictors(fit.s)[-1,2])$pai2),xout=covariate)$y,0),1,max),lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
legend(10,0.88,c("(Conditional) Prevalence Curves"),bty="n",cex=0.8)
legend(18,0.15,c("(Conditional) FOI Curves"),bty="n",cex=0.8)
#legend(10,1.0,c("y2=1|y1=1","y2=1|y1=0","y2=1"),lty=1:3,cex=1)

# The joint FOI
### FIGURE 12.6
#---------------
pii11<-fitted(fit.s)[,4]
pii00<-fitted(fit.s)[,1]
pi1<-fitted(fit.s)[,4]+fitted(fit.s)[,3]
pi2<-fitted(fit.s)[,4]+fitted(fit.s)[,2]

windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,3.1,4.1,3))
plot(a[-1],apply(cbind(diff(pii11)/diff(a)/(1-pii11[-1]),0),1,max),xlim=c(0,40),ylim=c(0,1),type="l",xlab="age",ylab="sero-prevalence",lwd=2,lty=2)
lines(a,p11,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
mtext(side=4,"force-of-infection",las=3,line=1.4)

##################################################
## Section 12.3: Individual Heterogeneity        #
##								 #
##################################################

# The shared gamma frailty model - gamma function
#-------------------------------------------------
library(stats4)

GF<-function(alpha1eta=0.06,beta1eta=0.2,gamma1eta=0.005,alpha2eta=0.06,beta2eta=0.2,gamma2eta=0.005,thetaeta=1){
alpha1=exp(alpha1eta);beta1=exp(beta1eta);gamma1=exp(gamma1eta);alpha2=exp(alpha2eta);beta2=exp(beta2eta);gamma2=exp(gamma2eta);theta=exp(thetaeta)
Lambda1<-alpha1*gamma1^(beta1+1)*gamma(beta1+1)*pgamma(a/gamma1,beta1+1)
Lambda2<-alpha2*gamma2^(beta2+1)*gamma(beta2+1)*pgamma(a/gamma2,beta2+1)
p00<-(exp(Lambda1/theta)+exp(Lambda2/theta)-1)^(-theta)
p10<-exp(-Lambda2)-p00
p01<-exp(-Lambda1)-p00
p11<-1-p00-p01-p10
return(-sum(PP*log(p11)+PN*log(p10)+NP*log(p01)+NN*log(p00)))
}
fit.org<-mle(GF,start=list(alpha1eta=-1,beta1eta=-1,gamma1eta=-1,alpha2eta=-1,beta2eta=-1,gamma2eta=-1,thetaeta=-1))
fit<-fit.org
summary(fit)
pll.max<-logLik(fit)

alpha1=exp(coef(fit))[1];beta1=exp(coef(fit))[2];gamma1=exp(coef(fit))[3]
alpha2=exp(coef(fit))[4];beta2=exp(coef(fit))[5];gamma2=exp(coef(fit))[6]
theta=exp(coef(fit))[7]

#### FIGURE 12.7 & 12.8
windows(record=TRUE, width=7, height=3.5)
par(mfrow=c(1,3),cex.axis=1.2,cex.lab=1.4,lwd=3,las=1,mgp=c(2.1, 0.5, 0))

plot(c(range(a)),c(0,1),type="n",xlab="age",ylab="seroprevalence")
points(grid,pos1/tot1,cex=0.015*tot1,pch=1,lwd=1)
lines(a,1-exp(-alpha1*gamma1^(beta1+1)*gamma(beta1+1)*pgamma(a/gamma1,beta1+1)),lty=1,lwd=2)
lines(a,alpha1*a^(beta1)*exp(-a/gamma1),lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
mtext(side=4,"force-of-infection",las=3,line=1.6,cex=0.9)

plot(c(range(a)),c(0,1),type="n",xlab="age",ylab="seroprevalence")
points(grid,pos2/tot2,cex=0.015*tot2,pch=1,lwd=1)
lines(a,1-exp(-alpha2*gamma2^(beta2+1)*gamma(beta2+1)*pgamma(a/gamma2,beta2+1)),lty=1,lwd=2)
lines(a,alpha2*a^(beta2)*exp(-a/gamma2),lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
mtext(side=4,"force-of-infection",las=3,line=1.6,cex=0.9)

plot(density(rgamma(100000,exp(coef(fit))[7],exp(coef(fit)[7]))),lwd=2,xlab="relative risk",ylab="density",main="")


# 95% confidence intervals
llci<-cbind(exp(coef(fit))-1.96*sqrt(exp(coef(fit))^2*diag(vcov(fit))),exp(coef(fit))+1.96*sqrt(exp(coef(fit))^2*diag(vcov(fit))))

# Profile likelihood confidence intervals
plci<-exp(confint(fit))

# Output
round(cbind(exp(coef(fit)),llci,plci),2)

# Test for heterogeneity
#------------------------
independence<-function(alpha1eta=0.06,beta1eta=0.2,gamma1eta=0.005,alpha2eta=0.06,beta2eta=0.2,gamma2eta=0.005){
alpha1=exp(alpha1eta);beta1=exp(beta1eta);gamma1=exp(gamma1eta);alpha2=exp(alpha2eta);beta2=exp(beta2eta);gamma2=exp(gamma2eta)
Lambda1<-alpha1*gamma1^(beta1+1)*gamma(beta1+1)*pgamma(a/gamma1,beta1+1)
Lambda2<-alpha2*gamma2^(beta2+1)*gamma(beta2+1)*pgamma(a/gamma2,beta2+1)
p00<-exp(-Lambda1-Lambda2)
p10<-exp(-Lambda2)-p00
p01<-exp(-Lambda1)-p00
p11<-1-p00-p01-p10
return(-sum(PP*log(p11)+PN*log(p10)+NP*log(p01)+NN*log(p00)))
}
fit.ind<-mle(independence,start=list(alpha1eta=-1,beta1eta=-1,gamma1eta=-1,alpha2eta=-1,beta2eta=-1,gamma2eta=-1))
summary(fit.ind)

# LRT p-value based on 50:50 mixture of chi-square 0 and 1
#----------------------------------------------------------
(1-pchisq(-2*(logLik(fit.ind)-logLik(fit.org)),df=1))/2

# Save Image to store results when producing bootstrap confidence intervals
#---------------------------------------------------------------------------
# outfile="c:/book/chapter12/output.Rdata"
# save.image(outfile)

