######################################################
######################################################
#								     #
#                CHAPTER 15: 				     #
#  	Informing WAIFW with Data on Social Contacts   #
#								     #
# last update: 26/08/2012				     #
######################################################
######################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter15")

### Define Necessary Functions

#  The social contact hypothesis
##### CONTACT.FITTER #######

contact.fitter<-function(a,y,rij,muy,N,D,Lmax,plots="TRUE",startpar){
L<-Lmax*mean(exp(-cumsum(muy)))
qproc<-function(a,y,qpar,rij,Lmax,N,D,plots="TRUE"){
	if (Lmax>100){return("Please specify Lmax<100")}
	bij<-365*qpar*(rij)[1:Lmax,1:Lmax]
	foiiprev<-rep(0.01,Lmax)
	muy<-muy[1:Lmax]
	tol<-1
	it<-0
	while ((tol>1e-10)&(it<2000)){
		foii<-(N/L)*D*bij%*%(as.matrix(foiiprev/(foiiprev+muy))*matrix(c(1-exp(-(1-A)*(foiiprev[1]+muy[1])),exp(-(1-A)*(foiiprev[1]+muy[1])-c(0,cumsum(foiiprev[-1]+muy[-1])[1:(Lmax-2)]))-exp(-(1-A)*(foiiprev[1]+muy[1])-c(cumsum(foiiprev[-1]+muy[-1])))),ncol=1))		
		foii<- apply(cbind(0,foii),1,max)
		foii<- apply(cbind(1,foii),1,min)
		tol<-sum((foii-foiiprev)^2)
		it<-it+1
		foiiprev<-foii
	}
	if (plots=="TRUE"){
		par(mfrow=c(1,1))
    		par(mar=c(5,4,4,4)+0.3)
            plot(c(A,1:max(floor(a))),1-exp(c(0,-(1-A)*foii[1],-(1-A)*foii[1]-cumsum(foii[-1])[1:(max(floor(a))-1)])),type="l",xlab="age",ylab="prevalence",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),1-exp(-(1-A)*foii[1]-cumsum(foii[-1])[max(floor(a)):(Lmax-2)]),lty=2,lwd=2)
            htab<-table(floor(a),y)
            points(c(A,sort(unique(floor(a)))[-1]),htab[,2]/(htab[,1]+htab[,2]),cex=0.02*(htab[,1]+htab[,2]),lwd=1.1)
            par(new=TRUE)
            plot(c(A,1:max(floor(a))),foii[1:(max(floor(a))+1)],type="l",axes=FALSE,bty="n",xlab="",ylab="",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),foii[(max(floor(a))+2):Lmax],lty=2,lwd=2)
            axis(4,at=pretty(range(foii)))
		#contour(c(0:(Lmax-1)),c(0:(Lmax-1)),bij,xlab="age of susceptible",ylab="age of infectious")
	}	
	prev<-rep(NA,length(a))
	ll<-rep(NA,length(a))
	for (i in 1:length(a)){
		prev[i]<-(1-exp(c(-(a[i]-A)*foii[1],-(1-A)*foii[1]-cumsum(c(0,foii[-1]))-(foii[-1])[floor(a[i])]*(a[i]-floor(a[i])))))[floor(a[i])+1]
		ll[i]<-y[i]*log(prev[i]+1e-8)+(1-y[i])*log(1-prev[i]+1e-8)
	}
	R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
	Mij<-diag(c(My[1:Lmax]))
	R0vec<-eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values
	return(list(ll=-2*sum(ll),eivalues=R0vec,prev=prev,bij=bij))
}
qproc.fitter<-function(qpar){return(qproc(a,y,qpar,rij,Lmax,N,D,plots="TRUE")$ll)}
q.result<-nlm(qproc.fitter,startpar)
result.global<-qproc(a=a,y=y,q=q.result$estimate,rij=rij,Lmax=Lmax,N=N,D=D)
return(list(qhat=q.result$estimate,deviance=q.result$minimum,aic=q.result$minimum+2,bic=q.result$minimum+log(length(y)),bij=result.global$bij,R0=max(as.real(result.global$eivalues))))
}


##### CONTACT.FITTER.LOCATION ######

contact.fitter.location<-function(a,y,rij1,rij2,rij3,rij4,rij5,rij6,muy,N,D,Lmax,plots="TRUE",startpar){
no.rij<-max((rij1!=0))+max((rij2!=0))+max((rij3!=0))+max((rij4!=0))+max((rij5!=0))+max((rij6!=0))
L<-Lmax*mean(exp(-cumsum(muy)))
qproc<-function(a,y,qpar,rij,Lmax,N,D,plots="TRUE"){
	qpar<-qpar^2
	if (Lmax>100){return("Please specify Lmax<100")}
	bij<-365*(qpar[1]*(rij1)[1:Lmax,1:Lmax]+qpar[2]*(rij2)[1:Lmax,1:Lmax]+qpar[3]*(rij3)[1:Lmax,1:Lmax]+qpar[4]*(rij4)[1:Lmax,1:Lmax]+qpar[5]*(rij5)[1:Lmax,1:Lmax]+qpar[6]*(rij6)[1:Lmax,1:Lmax])
	foiiprev<-rep(0.01,Lmax)
	muy<-muy[1:Lmax]
	tol<-1
	it<-0
	while ((tol>1e-10)&(it<2000)){
		foii<-(N/L)*D*bij%*%(as.matrix(foiiprev/(foiiprev+muy))*matrix(c(1-exp(-(1-A)*(foiiprev[1]+muy[1])),exp(-(1-A)*(foiiprev[1]+muy[1])-c(0,cumsum(foiiprev[-1]+muy[-1])[1:(Lmax-2)]))-exp(-(1-A)*(foiiprev[1]+muy[1])-c(cumsum(foiiprev[-1]+muy[-1])))),ncol=1))		
		foii<- apply(cbind(0,foii),1,max)
		foii<- apply(cbind(1,foii),1,min)
		tol<-sum((foii-foiiprev)^2)
		it<-it+1
		foiiprev<-foii
	}
	if (plots=="TRUE"){
		par(mfrow=c(1,1))
    		par(mar=c(5,4,4,4)+0.3)
            plot(c(A,1:max(floor(a))),1-exp(c(0,-(1-A)*foii[1],-(1-A)*foii[1]-cumsum(foii[-1])[1:(max(floor(a))-1)])),type="l",xlab="age",ylab="prevalence",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),1-exp(-(1-A)*foii[1]-cumsum(foii[-1])[max(floor(a)):(Lmax-2)]),lty=2,lwd=2)
            htab<-table(floor(a),y)
            points(c(A,sort(unique(floor(a)))[-1]),htab[,2]/(htab[,1]+htab[,2]),cex=0.02*(htab[,1]+htab[,2]),lwd=1.1)
            par(new=TRUE)
            plot(c(A,1:max(floor(a))),foii[1:(max(floor(a))+1)],type="l",axes=FALSE,bty="n",xlab="",ylab="",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),foii[(max(floor(a))+2):Lmax],lty=2,lwd=2)
            axis(4,at=pretty(range(foii)))
		#contour(c(0:(Lmax-1)),c(0:(Lmax-1)),bij,xlab="age of susceptible",ylab="age of infectious")
	}	
	prev<-rep(NA,length(a))
	ll<-rep(NA,length(a))
	for (i in 1:length(a)){
		prev[i]<-(1-exp(c(-(a[i]-A)*foii[1],-(1-A)*foii[1]-cumsum(c(0,foii[-1]))-(foii[-1])[floor(a[i])]*(a[i]-floor(a[i])))))[floor(a[i])+1]
		ll[i]<-y[i]*log(prev[i]+1e-8)+(1-y[i])*log(1-prev[i]+1e-8)
	}
	R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
	Mij<-diag(c(My[1:Lmax]))
	R0vec<-eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values
	return(list(ll=-2*sum(ll),eivalues=R0vec,prev=prev,bij=bij))
}
qproc.fitter<-function(qpar){return(qproc(a,y,qpar,rij,Lmax,N,D,plots="TRUE")$ll)}
q.result<-nlm(qproc.fitter,sqrt(startpar),hessian=T)
result.global<-qproc(a=a,y=y,q=q.result$estimate,rij=rij,Lmax=Lmax,N=N,D=D)
return(list(qhat=q.result$estimate^2,qhess=q.result$hessian,deviance=q.result$minimum,aic=q.result$minimum+no.rij*2,bic=q.result$minimum+no.rij*log(length(y)),bij=result.global$bij,R0=max(as.real(result.global$eivalues))))
}

#### CONTACT.FITTER.LOGLINEAR #####
contact.fitter.loglinear<-function(a,y,rij,int=F,muy,N,D,Lmax,plots="TRUE",startpar){
L<-Lmax*mean(exp(-cumsum(muy)))
qproc<-function(a,y,qpar,rij,Lmax,N,D,plots="TRUE"){
	if (int==F){qpar[3]=0}
	if (Lmax>100){return("Please specify Lmax<100")}
	q.f<-function(x,y){exp(qpar[1]+qpar[2]*x+qpar[2]*y+qpar[3]*y*x)}
	qij<-outer(c(1:Lmax),c(1:Lmax),q.f)
	bij<-365*qij*(rij)[1:Lmax,1:Lmax]
	foiiprev<-rep(0.01,Lmax)
	muy<-muy[1:Lmax]
	tol<-1
	it<-0
	while ((tol>1e-10)&(it<2000)){
		foii<-(N/L)*D*bij%*%(as.matrix(foiiprev/(foiiprev+muy))*matrix(c(1-exp(-(1-A)*(foiiprev[1]+muy[1])),exp(-(1-A)*(foiiprev[1]+muy[1])-c(0,cumsum(foiiprev[-1]+muy[-1])[1:(Lmax-2)]))-exp(-(1-A)*(foiiprev[1]+muy[1])-c(cumsum(foiiprev[-1]+muy[-1])))),ncol=1))		
		foii<- apply(cbind(0,foii),1,max)
		foii<- apply(cbind(1,foii),1,min)
		tol<-sum((foii-foiiprev)^2)
		it<-it+1
		foiiprev<-foii
	}
	if (plots=="TRUE"){
		par(mfrow=c(1,1))
    		par(mar=c(5,4,4,4)+0.3)
            plot(c(A,1:max(floor(a))),1-exp(c(0,-(1-A)*foii[1],-(1-A)*foii[1]-cumsum(foii[-1])[1:(max(floor(a))-1)])),type="l",xlab="age",ylab="prevalence",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),1-exp(-(1-A)*foii[1]-cumsum(foii[-1])[max(floor(a)):(Lmax-2)]),lty=2,lwd=2)
            htab<-table(floor(a),y)
            points(c(A,sort(unique(floor(a)))[-1]),htab[,2]/(htab[,1]+htab[,2]),cex=0.02*(htab[,1]+htab[,2]),lwd=1.1)
            par(new=TRUE)
            plot(c(A,1:max(floor(a))),foii[1:(max(floor(a))+1)],type="l",axes=FALSE,bty="n",xlab="",ylab="",ylim=c(0,1),xlim=c(0,80),lwd=2)
            lines((max(floor(a))+1):(Lmax-1),foii[(max(floor(a))+2):Lmax],lty=2,lwd=2)
            axis(4,at=pretty(range(foii)))
		#contour(c(0:(Lmax-1)),c(0:(Lmax-1)),bij,xlab="age of susceptible",ylab="age of infectious")
	}	
	prev<-rep(NA,length(a))
	ll<-rep(NA,length(a))
	for (i in 1:length(a)){
		prev[i]<-(1-exp(c(-(a[i]-A)*foii[1],-(1-A)*foii[1]-cumsum(c(0,foii[-1]))-(foii[-1])[floor(a[i])]*(a[i]-floor(a[i])))))[floor(a[i])+1]
		ll[i]<-y[i]*log(prev[i]+1e-8)+(1-y[i])*log(1-prev[i]+1e-8)
	}
	R0ij<-(N/L)*D*bij[1:Lmax,1:Lmax]
	Mij<-diag(c(My[1:Lmax]))
	if (sum(is.na(Mij%*%R0ij))==0){
	R0vec<-eigen(Mij%*%R0ij,symmetric=FALSE,only.values=TRUE,EISPACK=FALSE)$values}
	return(list(ll=-2*sum(ll),eivalues=R0vec,prev=prev,bij=bij))
}
qproc.fitter<-function(qpar){return(qproc(a=a,y=y,qpar=qpar,rij=rij,Lmax=Lmax,N=N,D=D,plots="TRUE")$ll)}
q.result<-nlm(qproc.fitter,startpar,hessian=T)
result.global<-qproc(a=a,y=y,q=q.result$estimate,rij=rij,Lmax=Lmax,N=N,D=D)
return(list(qhat=q.result$estimate[q.result$estimate!=0],qhess=q.result$hessian[q.result$estimate!=0,q.result$estimate!=0],deviance=q.result$minimum,aic=q.result$minimum+sum(q.result$estimate!=0)*2,bic=q.result$minimum+sum(q.result$estimate!=0)*log(length(y)),bij=result.global$bij,L=L,D=D,N=N,R0=max(as.real(result.global$eivalues))))
}

### PARAMETERS
### Estimating the mortality function for 2006 for Belgium (source: EUROSTAT)
ND<-c(489,47,29,21,12,12,16,15,15,6,6,14,17,19,17,23,34,33,62,71,68,68,78,71,71,96,86,83,79,80,83,93,126,120,121,132,135,176,161,193,196,218,257,277,331,376,356,435,460,453,535,545,576,668,692,759,722,819,939,1015,1051,973,1113,996,940,1074,1252,1367,1468,1541,1661,1838,2012,2236,2517,2793,2938,2994,3311,3516,3727,3857,4088,4161,4261,4274,4061,2509,2049,2159,2205,2550,2330,1992,1569,1242,1000,726,533,996)
PS<-c(118366,117271,114562,113894,116275,118030,116761,117742,119583,119887,118963,119958,124637,129143,131030,129724,127187,126433,124377,124883,122201,124482,126459,130129,133897,135009,134516,133495,132705,132040,130602,135638,140537,146151,150467,152113,151656,151412,153371,158268,162456,167652,164871,161671,162060,159735,160672,157030,153820,151114,148978,145929,142374,141215,135525,135968,134692,135991,134291,134131,113024,112198,105880,92772,84462,93787,100820,101866,97208,94145,92451,93027,91640,93593,91933,89900,81718,77891,73104,70082,67057,62178,57642,51786,47466,42065,28004,17186,14492,13838,13957,13358,10442,8063,5604,4289,2843,2068,1368,2146)
AGE<-c(0:(length(ND)-1))
# mortality rates
library(mgcv)
demfit<-gam(ND~s(AGE),offset=log(PS),family="poisson",link="log")
muy<-predict(demfit,type="response")
My<-exp(-cumsum(muy))
L<-mean(My)*100
# Mean duration of infectiousness
D<-6/365
# Maximum life (if type mortality this is the life expectancy)
Lmax<-100
# Population size
N<-sum(PS)
# Age of loss of maternal immunity (0<A<1)
A<-0.5
# Mortality function
My<-My[1:Lmax]
muy<-muy[1:Lmax]
# Age category
breakpoints<-c(0.5,2,6,12,19,31,100)

###################################################
## Section 15.1: Estimation from Serological Data #
## and Data on Social Contacts                    #
##								  #
###################################################

### Reading in the data: Parvovirus B19 in Belgium
vzv.parvo.be<-read.table("c:/book/chapter4/VZV-B19-BE.dat",header=T)
vzv.parvo.be<-vzv.parvo.be[!is.na(vzv.parvo.be$parvores)&!is.na(vzv.parvo.be$age)&vzv.parvo.be$age<70&vzv.parvo.be$age>=1,]
#vzv.parvo.be<-vzv.parvo.be[!is.na(vzv.parvo.be$VZVres)&!is.na(vzv.parvo.be$age)&vzv.parvo.be$age<70&vzv.parvo.be$age>=0.5,]
vzv.parvo.be<-vzv.parvo.be[order(vzv.parvo.be$age),]
names(vzv.parvo.be)
#y<-vzv.parvo.be$VZVres
y<-vzv.parvo.be$parvores
a<-vzv.parvo.be$age

### Read in matrices
rij1<-as.matrix(read.table("contacts belgium/all contacts.txt"))
rij2<-as.matrix(read.table("contacts belgium/close.txt"))
rij3<-as.matrix(read.table("contacts belgium/nonclose.txt"))
rij4<-as.matrix(read.table("contacts belgium/close-15.txt"))
rij5<-as.matrix(read.table("contacts belgium/close+15.txt"))
rij6<-as.matrix(read.table("contacts belgium/close+1h.txt"))
rij7<-as.matrix(read.table("contacts belgium/close+4h.txt"))
rij8<-as.matrix(read.table("contacts belgium/nonclose+1h.txt"))
rij9<-as.matrix(read.table("contacts belgium/close+15_nonclose+1h.txt"))
rij10<-as.matrix(read.table("contacts belgium/close_nonclose+1h.txt"))

### Extra figure
rij<-rij7
persp(c(0:(dim(rij)[1]-1)),c(0:(dim(rij)[1]-1)),rij,phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)

# Fit the different matrices to the serology and select on minimal AIC
contact.result<-contact.fitter(a=a,y=y,rij=rij1,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij2,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij3,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij4,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij5,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-1)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij6,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-1)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij7,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij8,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij9,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter(a=a,y=y,rij=rij10,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)

### FIGURE 15.2 (right panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

contact.result<-contact.fitter(a=a,y=y,rij=rij7,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=5e-2)
c(contact.result$q,contact.result$R0,contact.result$aic)

### FIGURE 15.2 (left panel)
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

Lmax=85
persp(c(0,1:Lmax),c(0,1:Lmax),N*D/L*cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),contact.result$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)


### Refinements
rij1<-as.matrix(read.table("contacts belgium/location/home.txt"))
rij2<-as.matrix(read.table("contacts belgium/location/school.txt"))
rij3<-as.matrix(read.table("contacts belgium/location/work.txt"))
rij4<-as.matrix(read.table("contacts belgium/location/leisure.txt"))
rij5<-as.matrix(read.table("contacts belgium/location/transport.txt"))
rij6<-as.matrix(read.table("contacts belgium/location/otherplace.txt"))

contact.result<-contact.fitter.location(a=a,y=y,rij1,rij2,rij3,0*rij4,0*rij5,rij6,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=c(0.4,0.001,0.001,0.001,0.001,0.001))
c(contact.result$q,contact.result$R0,contact.result$aic)
contact.result<-contact.fitter.location(a=a,y=y,rij1,rij2,rij3,0*rij4,0*rij5,rij6,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=c(0.01,0.41,0.001,0.001,0.001,0.001))
c(contact.result$q,contact.result$R0,contact.result$aic)

rij7<-as.matrix(read.table("contacts belgium/close+4h.txt"))

contact.result<-contact.fitter.loglinear(a=a,y=y,rij=rij7,int=F,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=c(-2.3,0,0))
c(contact.result$qhat,contact.result$R0,contact.result$aic)
contact.result$qhat/sqrt(diag(solve(contact.result$qhess)))
contact.result<-contact.fitter.loglinear(a=a,y=y,int=T,rij=rij7,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=c(-2.3,0,0))
c(contact.result$qhat,contact.result$R0,contact.result$aic)
contact.result$qhat/sqrt(diag(solve(contact.result$qhess)))

### FIGURE 15.3
windows(record=TRUE, width=5, height=5)
par(las=1,cex.axis=1.1,cex.lab=1.1,lwd=3,mgp=c(2, 0.5, 0),mar=c(4.1,4.1,4.1,3))

Lmax=85
contact.result<-contact.fitter.loglinear(a=a,y=y,rij=rij7,int=F,muy=muy,N=N,D=D,Lmax=85,plots="TRUE",startpar=c(-2.3,0,0))
persp(c(0,1:Lmax),c(0,1:Lmax),contact.result$N*contact.result$D/contact.result$L*cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),contact.result$bij)),phi=30,theta=-45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)
#persp(c(0,1:Lmax),c(0,1:Lmax),contact.result$N*contact.result$D/contact.result$L*cbind(rep(0,Lmax+1),rbind(rep(0,Lmax),contact.result$bij)),phi=30,theta=45,ticktype="detailed",xlab="a",ylab="a'",zlab="",expand=0.5)


