##############################################################
##############################################################
#								             #
#                CHAPTER 16: 				             #
#    Integrating Estimated Parameters in a Basic SIR Model   #
#								             #
# last update: 26/08/2012				             #
##############################################################
##############################################################

rm(list=ls(all=TRUE))
setwd("c:/book/chapter16")

library(odesolve)
library(foreign)

# Mortality function for BE anno 2006 
# The number of deaths during the year 2006 and the average population anno 2006-2007
#-------------------------------------------------------------------------------------
ND<-c(489,47,29,21,12,12,16,15,15,6,6,14,17,19,17,23,34,33,62,71,68,68,78,71,71,96,86,83,79,80,83,93,126,120,121,132,135,176,161,193,196,218,257,277,331,376,356,435,460,453,535,545,576,668,692,759,722,819,939,1015,1051,973,1113,996,940,1074,1252,1367,1468,1541,1661,1838,2012,2236,2517,2793,2938,2994,3311,3516,3727,3857,4088,4161,4261,4274,4061,2509,2049,2159,2205,2550,2330,1992,1569,1242,1000,726,533,996)
PS2006<-c(118366,117271,114562,113894,116275,118030,116761,117742,119583,119887,118963,119958,124637,129143,131030,129724,127187,126433,124377,124883,122201,124482,126459,130129,133897,135009,134516,133495,132705,132040,130602,135638,140537,146151,150467,152113,151656,151412,153371,158268,162456,167652,164871,161671,162060,159735,160672,157030,153820,151114,148978,145929,142374,141215,135525,135968,134692,135991,134291,134131,113024,112198,105880,92772,84462,93787,100820,101866,97208,94145,92451,93027,91640,93593,91933,89900,81718,77891,73104,70082,67057,62178,57642,51786,47466,42065,28004,17186,14492,13838,13957,13358,10442,8063,5604,4289,2843,2068,1368,2146)
PS2007<-c(121718,119795,118426,115497,114720,117067,118696,117411,118410,120276,120530,119564,120635,125230,129754,131590,130406,128061,127594,125749,126481,124131,126329,128238,131953,135668,136899,136289,135193,134314,133529,132009,136806,141763,147274,151465,153140,152332,152104,153956,158802,162872,168005,165246,161831,162098,159919,160630,156922,153601,150843,148660,145653,141968,140728,134950,135309,134021,135186,133339,133033,112049,111107,104865,91833,83476,92583,99546,100390,95774,92563,90691,91139,89531,91210,89332,86949,78757,74757,69725,66407,63301,58200,53457,47599,43154,37679,24848,14954,12433,11668,11580,10843,8262,6242,4243,3076,2039,1414,2240)
PS<-(PS2006+PS2007)/2

# Read in the force of infection
#--------------------------------
foi<-read.table("psplinefoihatvzv.txt")$V1

######################################
# Initial parameters			 #
######################################
Tinit = c(1, 200)       							# Initialization period
Truns = 200
months.days = c(30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31)   # Months in days
cohort.size = 120000 #9943749/100					 	# Cohort size
alpha.days = 7                                                   	# Infectious period (days)
n.ageclass = 100                                                 	# Number of age classes
lower.age = seq(0,99,1)                                      	# Lower age-values
mu <- - log( 1 - (ND/PS)[1:100])                                  # Mortality rate for Belgium
tol = 1.00E-10		                                          # Precision
resolution<-365									# Resolution (nr subdivisions wrt time)
#p<-0											# Vaccination coverage
#p<-0.33
p<-0.75

######################################
# Subcalculations 			 #
######################################
year.days = sum(months.days)                                      # Length of the year
alpha.rate = year.days/alpha.days                                 # Infectiousness rate (years^-1)
surv = rep(0,100);calc = rep(0,100);L = rep(0,100);surv[1]= 100
for (k in 2:100){surv[k]=surv[k-1]*exp(-mu[k-1])}
for (k in 1:100){calc[k]=surv[k]*(1-exp(-mu[k]))/mu[k]}
for (k in 1:100){L[k]=sum(calc[k:100])/surv[k] }      		# Life expectancy
upper.age=rep(0, 100)
for (k in 1:(n.ageclass-1)){upper.age[k]=lower.age[k+1]-1};upper.age[n.ageclass]=100

##################################################
# Example: Close contacts longer than 15 minutes #
##################################################
q<-0.173										# Proportionality factor for the contact matrix option 1
contactdata<-as.matrix(read.table("c:/book/chapter15/contacts belgium/close+15.txt"))
image(as.matrix(contactdata))

# Replicate the last age-category
cij<-matrix(min(contactdata),nrow=100,ncol=100)
cij[1:86,1:86]<-as.matrix(contactdata)
betas = 365*q*cij

# R0
max(as.real(eigen(cohort.size*exp(-cumsum(mu))/alpha.rate*betas)$value))			

# Call the CORE
choice<-"RAScontact"
source("c:/book/chapter16/SIR age-structured core - finer grid.R")
source("c:/book/chapter16/SIR age-structured vaccination - finer grid.R")

#######################################################
# EXAMPLE WAIFW W2 (Goeyvaerts et al. (JRSS-C, 2010)) #
#######################################################
brks<-c(0,2,6,12,19,31)
beta1<-1.413; beta2<-1.335; beta3<-1.064; beta4<-0.000; beta5<-0.343; beta6<-0.000
W2<-matrix(beta6,ncol=100,nrow=100); W2[1:31,1:31]<-beta5; W2[1:19,1:19]<-beta4; W2[1:12,1:12]<-beta3; W2[1:6,1:6]<-beta1; W2[3:6,3:6]<-beta2; W2<-W2*(10^-4)
persp(W2)

# R0
max(120000*7/365*eigen(W2)$value)

# Call the CORE
choice<-"RASWAIFWW2"
source("c:/book/chapter16/SIR age-structured core - finer grid.R")
source("c:/book/chapter16/SIR age-structured vaccination - finer grid.R")

#####################################
# EXAMPLE STATIC CONSTANT FOI MODEL #
#####################################
foi<-read.table("pcwfoihatvzv.txt")$V1

# Call the CORE
choice<-"RASFOI"
source("c:/book/chapter16/SIR age-structured core - finer grid.R")
source("c:/book/chapter16/SIR age-structured vaccination - finer grid.R")

