#################################################
#################################################
#								#
#                CHAPTER 8: 				#
#     	     CASE STUDY                     #
#								#
# last update: 25/08/2012				#
#################################################
#################################################

setwd("c:/book/chapter8")

###################################################################
## Section 8.6: Non-, Semi- and Parametric Methods to            ##
##		    Estimate the prevalence and force of infection   ##
##		    a case study                                     ##
###################################################################


rubella<-read.table("c:/book/chapter4/Rubella-UK.dat",header=T)
age<-c(rep(rubella$Age,rubella$Pos),rep(rubella$Age,rubella$Neg))
resp<-c(rep(1,sum(rubella$Pos)),rep(0,sum(rubella$Neg)))
y<-resp[order(age)]
a<-age[order(age)]

# Functions
############################################################
foi.num<-function(x,p)
{
grid<-sort(unique(x))
pgrid<-(p[order(x)])[duplicated(sort(x))==F]
dp<-diff(pgrid)/diff(grid)
foi<-approx((grid[-1]+grid[-length(grid)])/2,dp,grid[c(-1,-length(grid))])$y/(1-pgrid[c(-1,-length(grid))])
return(list(grid=grid[c(-1,-length(grid))],foi=foi))
}

# Scatterplot using proportions over 1-year age-categories
############################################################
grid<-sort(unique(round(a)))
neg<-table(y,round(a))[1,]
pos<-table(y,round(a))[2,]
tot<-neg+pos

par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
#title("Rubella Seroprevalence UK")

#########################################
## PARAMETRIC MODELS                   ##
#########################################
loglik1<-function(theta){
alpha<-abs(theta[1])
beta<-abs(theta[2])
p<-1-exp((alpha/beta)*a*exp(-beta*a)+1/beta*(alpha/beta)*(exp(-beta*a)-1))
return(-sum(y*log(p)+(1-y)*(log(1-p))))
}
result<-abs(nlminb(c(0.1,0.1),loglik1)$par)

alphaopt<-result[1]
betaopt<-result[2]
p<-function(a){1-exp((alphaopt/betaopt)*a*exp(-betaopt*a)+1/betaopt*(alphaopt/betaopt)*(exp(-betaopt*a)-1))}
l<-function(a){alphaopt*a*exp(-betaopt*a)}
plot(a,p(a),type="l",ylim=c(0,1))
lines(a,l(a),lty=1)
lines(foi.num(a,p(a))$grid,foi.num(a,p(a))$foi,lty=1)
# BIC-value
2*loglik1(c(alphaopt,betaopt))+log(length(y))*2

#########################################
##  FRACTIONAL POLYNOMIALS             ##
#########################################
# Fp fitting up to 2nd degree
#pgrid<-c(-2,-1,-0.5,0,0.5,1,2,3,4)
pgrid<-seq(-2,3,0.1)
out1<-array(NA,c(length(pgrid)))
out2<-array(NA,c(length(pgrid),length(pgrid)))
p<-rep(NA,2)
for (i in 1:length(pgrid)){
for (j in i:length(pgrid)){
p[1]<-pgrid[i]
p[2]<-pgrid[j]
ifelse(p[1]!=0,a1<-a^p[1],a1<-log(a))
ifelse(p[2]==p[1],a2<-a1*log(a),ifelse(p[2]!=0,a2<-a^p[2],a2<-log(a)))
# First order
fit1<-glm(y~a1,family="binomial")
if (i==1&j==1){prev.dev1<-fit1$dev}
mon1<-!(sum(diff(fit1$fitted.values)<0)>0)
if (fit1$dev<prev.dev1){min.dev1<-c(i,j);prev.dev1<-fit1$dev}
#print(c(i,fit1$dev,mon1))
out1[i]<-fit1$dev
# Second order
fit2<-glm(y~a1+a2,family="binomial")
if (i==1&j==1){prev.dev2<-fit2$dev}
mon2<-!(sum(diff(fit2$fitted.values)<0)>0)
if (fit2$dev<prev.dev2){min.dev2<-c(i,j);prev.dev2<-fit2$dev}
print(c(i,j,fit2$dev,mon2))
out2[i,j]<-fit2$dev
}}

minA<-function(x){return(min(x,na.rm=T))}
# Column
which.min(apply(out2,2,minA))
# Row
which.min(apply(out2,1,minA))

min.dev1
min.dev2

dr<-min.dev2
p[1]<-pgrid[dr[1]]
p[2]<-pgrid[dr[2]]
ifelse(p[1]!=0,a1<-a^p[1],a1<-log(a))
ifelse(p[2]==p[1],a1*log(a),ifelse(p[2]!=0,a2<-a^p[2],a2<-log(a)))
fit<-glm(y~a1+a2,family="binomial")

pi.fv<-fit$fitted.values
win.graph()
par(mfrow=c(1,2))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,pi.fv)
lines(foi.num(a,pi.fv)$grid,foi.num(a,pi.fv)$foi)

#########################################
##  LOCAL LIKELIHOOD FIT               ##
#########################################
library(locfit)
par(mfrow=c(3,4))

#######################################################
# AN EXERCISE TO ILLUSTRATE DIFFERENT OPTIONS OF LOCFIT
#######################################################
# The built-in function of aic doesn't work
# aic(lpfit,pen=log(length(a)))[4]
# This is our own function
BIClf<-function(lpfit){return(-2*(sum(y*log(fitted(lpfit))+(1-y)*log(1-fitted(lpfit))))-log(length(a))*as.vector(aic(lpfit,pen=1)[4]-aic(lpfit,pen=2)[4]))}

## default choices: logit link, tricube kernel, degree 2 polynomial, local estimation by using 45% if nearest neighbors
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
lpfit<-locfit(y~a,family="binomial")
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial")
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## default choices: logit link, tricube kernel, degree 2 polynomial, 
## specific choice: local estimation by using 30% if nearest neighbors
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
alpha=0.3
lpfit<-locfit(y~a,family="binomial",alpha=alpha)
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## default choices: logit link, tricube kernel, degree 2 polynomial, 
## specific choice: local estimation by using a constant bandwidth equal to 20
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
alpha=c(0,20)
lpfit<-locfit(y~a,family="binomial",alpha=alpha)
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## default choices: logit link, tricube kernel, 
## specific choice: local estimation by using a constant bandwidth equal to 20,  degree 1 polynomial,
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
degree=1
alpha=c(0,20)
lpfit<-locfit(y~a,family="binomial",alpha=alpha,deg=degree)
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha,deg=degree)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## default choices: logit link, 
## specific choice: local estimation by using a constant bandwidth equal to 20,  degree 1 polynomial, epanechnikov kernel
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
degree=1
alpha=c(0,20)
kernel="epan"
lpfit<-locfit(y~a,family="binomial",alpha=alpha,deg=degree,kern=kernel)
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha,deg=degree,kern=kernel)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## default choices: logit link, tricube kernel, 
## specific choice: parametric logit-linear model by using a constant bandwidth equal to 2000000,  degree 1 polynomial,
#######################################################################################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
degree=1
alpha=c(0,2000000)
lpfit<-locfit(y~a,family="binomial",alpha=alpha,deg=degree)
lpfit
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha,deg=degree)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## ABOUT OTHER OPTIONS: THE ONLY OTHER LINK AVAILABLE FOR BINOMIAL DATA IS THE ARCSIN LINK
############################################################################################

## GLOBAL AND LOCAL CONFIDENCE BANDS, ALL OPTIONS ON DEFAULT
#############################################################
lpfit<-locfit(y~a,family="binomial")
plot(lpfit, band="global")
plot(lpfit, band="local")

## GENERALIZED CROSS VALIDATION FOR SELECTING THE BANDWIDTH (NEAREST NEIGHBOR OR CONSTANT)
###########################################################################################

## nearest neighbor gcv with all other options put on default value
##################################################################
alpha=seq(0.2,2, by=0.05)
plot(gcvplot(y~a,family="binomial",alpha=alpha))
# plot with horizontal axis given by alpha
res=cbind(alpha,summary(gcvplot(y~a,family="binomial",alpha=alpha,deg=2)))
plot(res[,1],res[,3],type="n",main="Nearest Neighbor GCV",xlab="% Neighbors",ylab="GCV")
lines(res[,1],res[,3])
# This indicates 0.8 would be a reasonable choice

## constant bandwidth gcv with all other options put on default value
######################################################################
alpha=cbind(rep(0,length(seq(5,20, by=1))),seq(5,20, by=1))
plot(gcvplot(y~a,family="binomial",alpha=alpha))
# plot with horizontal axis given by alpha
res=cbind(alpha[,2],summary(gcvplot(y~a,family="binomial",alpha=alpha)))
plot(res[,1],res[,3],type="n",main="Nearest Neighbor GCV",xlab="% Neighbors",ylab="GCV")
lines(res[,1],res[,3])
# This indicates 15 would be a reasonable choice

## overlaid plot of the gcv choices for both type of bandwidths
## all other choices on default (note degree 2 is default)
###############################################################
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(-0.1,1))
# nearest neighbor
alpha=0.5
lpfit<-locfit(y~a,family="binomial",alpha=alpha)
lines(a,fitted(lpfit),lty=1,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

# constant bandwidth
alpha=c(0,15)
lpfit<-locfit(y~a,family="binomial",alpha=alpha)
lines(a,fitted(lpfit),lty=2,lwd=2)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
lines(a,lpfoi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
abline(h=0)
BIClf(lpfit)

## CONCLUSION: NEAREST NEIGHBOR LOCAL REGRESSION OUTPERFORMS THE CONSTANT BANDWIDTH VERSION AS IT CLEARLY BETTER 
## DEALS WITH SPARSE DATA FOR HIGHER AGES

#########################################
##  SEMI_PARAMETRIC MODEL S            ##
#########################################
# Hastie and Tibshirani (use BIC to select the smoothing parameter)
############################################################
AICf<-function(fit){return(fit$deviance+2*(fit$nl.df+2))}
BICf<-function(fit){return(fit$deviance+log(length(fit$y))*(fit$nl.df+2))}
AICcf<-function(fit){return(fit$deviance+(length(fit$y)+(fit$nl.df+2))/(1-((fit$nl.df+2)+2)/length(fit$y)))}

detach(package:mgcv)
library(gam)
out<-matrix(NA,ncol=7,nrow=100)
for (i in 1:100){
dfi<-1+0.5*i
fit.gam.logit.ht<-gam(y~s(a,df=dfi),family=binomial(link="logit"))
fit.gam.cloglog.ht<-gam(y~s(a,df=dfi),family=binomial(link="cloglog"))
out[i,]<-c(dfi,AICf(fit.gam.logit.ht),AICf(fit.gam.cloglog.ht),BICf(fit.gam.logit.ht),BICf(fit.gam.cloglog.ht),AICcf(fit.gam.logit.ht),AICcf(fit.gam.cloglog.ht))
}
fit.gam.logit.ht.aic<-gam(y~s(a,df=out[which.min(out[,2]),1]),family=binomial(link="logit"))
fit.gam.cloglog.ht.aic<-gam(y~s(a,df=out[which.min(out[,3]),1]),family=binomial(link="cloglog"))
fit.gam.logit.ht.bic<-gam(y~s(a,df=out[which.min(out[,4]),1]),family=binomial(link="logit"))
fit.gam.cloglog.ht.bic<-gam(y~s(a,df=out[which.min(out[,5]),1]),family=binomial(link="cloglog"))
fit.gam.logit.ht.aicc<-gam(y~s(a,df=out[which.min(out[,6]),1]),family=binomial(link="logit"))
fit.gam.cloglog.ht.aicc<-gam(y~s(a,df=out[which.min(out[,7]),1]),family=binomial(link="cloglog"))

fit.gam.logit.ht<-fit.gam.logit.ht.bic
fit.gam.cloglog.ht<-fit.gam.cloglog.ht.bic
win.graph(); par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="Rubella Seroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,predict(fit.gam.logit.ht,type="response"),lty=1,lwd=2,col=3)
lines(a,predict(fit.gam.cloglog.ht,type="response"),lty=2,lwd=2,col=3)
h1<-foi.num(a,predict(fit.gam.logit.ht,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.ht,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
legend(20,0.4,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

# Plot of AIC as a function of DF
win.graph(); par(mfrow=c(3,2))
plot(out[,1],out[,2],main="AIC logit",xlab="df",ylab="criterion")
plot(out[,1],out[,3],main="AIC cloglog",xlab="df",ylab="criterion")
plot(out[,1],out[,4],main="BIC logit",xlab="df",ylab="criterion")
plot(out[,1],out[,5],main="BIC cloglog",xlab="df",ylab="criterion")
plot(out[,1],out[,6],main="AICc logit",xlab="df",ylab="criterion")
plot(out[,1],out[,7],main="AICc cloglog",xlab="df",ylab="criterion")

# Eilers and Marx (1996)
#############################################################
library(splines)
source("GLM functions Eilers and Marx.R")
AICme<-function(fit){return(fit$dev+2*(fit$eff.df))}
BICme<-function(fit){return(fit$dev+log((dim(fit$summary.predicted)[1]))*(fit$eff.df))}
out<-matrix(NA,ncol=3,nrow=400)
for (i in 1:100){
lambda<-0+0.5*(i-1)
me.fit<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=lambda,x.predicted=a)
out[i,]<-c(lambda,me.fit$aic,BICme(me.fit))
}

par(mfrow=c(2,2))
plot(out[,1],out[,2],type="l",main="AIC logit")
plot(out[,1],out[,3],type="l",main="BIC logit")
me.fit<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=out[which.min(out[,2]),1],x.predicted=a)
me.fit<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=out[which.min(out[,3]),1],x.predicted=a)

me.fit.AIC<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=out[which.min(out[,2]),1],x.predicted=a)
AICme(me.fit.AIC)
me.fit.BIC<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=out[which.min(out[,3]),1],x.predicted=a)
BICme(me.fit.BIC)

par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="RubellaSeroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,me.fit$summary.predicted[,3],lty=1,lwd=2,col=3)
h1<-foi.num(a,me.fit$summary.predicted[,3])
lines(h1$grid,h1$foi,lty=1,lwd=2)

# cloglog and logit link
me.fit.BIC.logit<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=80,x.predicted=a)
me.fit.BIC.cloglog<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="cloglog",family="binomial",lambda=200,x.predicted=a)

# Wood (2006)
############################################################
detach(package:gam)
library(mgcv)

BICWood<-function(fit){return(fit$deviance+log(length(fit$y))*sum(fit$edf))}

# 1) Thin plate splines (default gam option)
#--------------------------------------------
fit.gam.logit.tps<-gam(y~s(a,bs="tp"),family=binomial(link="logit"))
fit.gam.cloglog.tps<-gam(y~s(a,bs="tp"),family=binomial(link="cloglog"))

par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="RubellaSeroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,predict(fit.gam.logit.tps,type="response"),lty=1,lwd=2)
lines(a,predict(fit.gam.cloglog.tps,type="response"),lty=2,lwd=2)
legend(20,0.2,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

par(mfrow=c(1,1))
plot(grid,pos/tot,type="n",pch=1,main="RubellaForce of Infection UK",xlab="age",ylab="force of infection",xlim=c(0,45),ylim=c(-0.1,0.5))
h1<-foi.num(a,predict(fit.gam.logit.tps,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.tps,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
legend(20,0.4,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

# 2) Cubic regression splines
#-----------------------------
fit.gam.logit.cr<-gam(y~s(a,bs="cr"),family=binomial(link="logit"))
fit.gam.cloglog.cr<-gam(y~s(a,bs="cr"),family=binomial(link="cloglog"))

par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,main="RubellaSeroprevalence UK",xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,predict(fit.gam.logit.cr,type="response"),lty=1,lwd=2,col=1)
lines(a,predict(fit.gam.cloglog.cr,type="response"),lty=2,lwd=2,col=1)
legend(20,0.2,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2,col=1)

par(mfrow=c(1,1))
plot(grid,pos/tot,type="n",pch=1,main="RubellaForce of Infection UK",xlab="age",ylab="force of infection",xlim=c(0,45),ylim=c(-0.1,0.5))
h1<-foi.num(a,predict(fit.gam.logit.cr,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.cr,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
legend(20,0.4,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

# Figure Penalized Likelihood Approaches
#########################################
par(mfrow=c(2,2))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,predict(fit.gam.logit.ht,type="response"),lty=1,lwd=2,col=1)
lines(a,predict(fit.gam.cloglog.ht,type="response"),lty=2,lwd=2,col=1)
h1<-foi.num(a,predict(fit.gam.logit.ht,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.ht,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,me.fit.BIC.logit$summary.predicted[,3],lty=1,lwd=2,col=1)
lines(a,me.fit.BIC.cloglog$summary.predicted[,3],lty=2,lwd=2,col=1)
h1<-foi.num(a,me.fit.BIC.logit$summary.predicted[,3])
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,me.fit.BIC.cloglog$summary.predicted[,3])
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,predict(fit.gam.logit.cr,type="response"),lty=1,lwd=2,col=1)
lines(a,predict(fit.gam.cloglog.cr,type="response"),lty=2,lwd=2,col=1)
h1<-foi.num(a,predict(fit.gam.logit.cr,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.cr,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,predict(fit.gam.logit.tps,type="response"),lty=1,lwd=2)
lines(a,predict(fit.gam.cloglog.tps,type="response"),lty=2,lwd=2)
h1<-foi.num(a,predict(fit.gam.logit.tps,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gam.cloglog.tps,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))

# Summary Table AIC-BIC
########################
BICf(fit.gam.logit.ht.bic)
BICf(fit.gam.cloglog.ht.bic)
BICme(me.fit.BIC.logit)
BICme(me.fit.BIC.cloglog)
BICWood(fit.gam.logit.cr)
BICWood(fit.gam.cloglog.cr)
BICWood(fit.gam.logit.tps)
BICWood(fit.gam.cloglog.tps)

# GLMM framework
############################################################
detach(package:gam)
library(mgcv)

# 1) Thin plate splines 
#-----------------------
fit.gamm.logit.tps<-gamm(y~s(a,bs="tp"),family=binomial(link="logit"))
fit.gamm.cloglog.tps<-gamm(y~s(a,bs="tp"),family=binomial(link="cloglog"))

win.graph(); par(mfrow=c(1,2))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,predict(fit.gamm.logit.tps$gam,type="response"),lty=1,lwd=2)
lines(a,predict(fit.gamm.cloglog.tps$gam,type="response"),lty=2,lwd=2)
h1<-foi.num(a,predict(fit.gamm.logit.tps$gam,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gamm.cloglog.tps$gam,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
legend(20,0.4,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

# 2) Cubic regression splines 
#-----------------------------
fit.gamm.logit.cr<-gamm(y~s(a,bs="cr"),family=binomial(link="logit"))
fit.gamm.cloglog.cr<-gamm(y~s(a,bs="cr"),family=binomial(link="cloglog"))

plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
lines(a,predict(fit.gamm.logit.cr$gam,type="response"),lty=1,lwd=2)
lines(a,predict(fit.gamm.cloglog.cr$gam,type="response"),lty=2,lwd=2)
h1<-foi.num(a,predict(fit.gamm.logit.cr$gam,type="response"))
lines(h1$grid,h1$foi,lty=1,lwd=2)
h2<-foi.num(a,predict(fit.gamm.cloglog.cr$gam,type="response"))
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
legend(20,0.4,c("logit-link","cloglog-link"),lty=c(1,2),lwd=2)

# Adaptive spline smoothing
############################
library(AdaptFit)
kn.mean<-default.knots(a,20)
kn.var<-default.knots(a,5)
fit.nonadapt<-asp(y~f(a,knots=kn.mean),adap=F,family="binomial",tol=1e-6,niter=1000,niter.var=10000,omit.missing=T,spar.method="REML")
fit.adapt<-asp(y~f(a,knots=kn.mean,var.knot=kn.var),family="binomial",tol=1e-3,niter=10000,niter.var=1000,omit.missing=T,spar.method="REML",returnFit=T)
pi.adapt<-fit.adapt$fitted
pi.nonadapt<-fit.nonadapt$fitted

win.graph(); par(mfrow=c(1,2))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,pi.nonadapt,lty=2,lwd=2)
h2<-foi.num(a,pi.nonadapt)
lines(h2$grid,h2$foi,lty=2,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))

plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="",xlim=c(0,45),ylim=c(-0.1,1))
lines(a,pi.adapt,lty=1,lwd=2)
h1<-foi.num(a,pi.adapt)
lines(h1$grid,h1$foi,lty=1,lwd=2)
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))

###########################
###########################
# In summary:
###########################
###########################
# -1) Nonlinear 1
loglik1<-function(theta){
alpha<-abs(theta[1])
beta<-abs(theta[2])
gamma<-abs(theta[3])
p<-1-exp((alpha/beta)*a*exp(-beta*a)+1/beta*(alpha/beta-gamma)*(exp(-beta*a)-1)-gamma*a)
return(-sum(y*log(p)+(1-y)*(log(1-p))))
}
result<-abs(nlminb(c(0.1,0.1,0.1),loglik1)$par)
alphaopt<-result[1]
betaopt<-result[2]
gammaopt<-result[3]
p1<-function(a){1-exp((alphaopt/betaopt)*a*exp(-betaopt*a)+1/betaopt*(alphaopt/betaopt-gammaopt)*(exp(-betaopt*a)-1)-gammaopt*a)}
# BIC-value
2*nlminb(c(0.1,0.1,0.1),loglik1)$objective+log(length(y))*3

# 0) Nonlinear 2
loglik2<-function(theta){
alpha<-abs(theta[1])
beta<-abs(theta[2])
p<-1-exp((alpha/beta)*a*exp(-beta*a)+1/beta*(alpha/beta)*(exp(-beta*a)-1))
return(-sum(y*log(p)+(1-y)*(log(1-p))))
}
result<-abs(nlminb(c(0.1,0.1),loglik2)$par)
alphaopt<-result[1]
betaopt<-result[2]
p2<-function(a){1-exp((alphaopt/betaopt)*a*exp(-betaopt*a)+1/betaopt*(alphaopt/betaopt)*(exp(-betaopt*a)-1))}
# BIC-value
2*nlminb(c(0.1,0.1),loglik2)$objective+log(length(y))*2

# 1) The best fractional polynomial (-0.9,-0.9)
p<-c(-0.9,-0.4)
ifelse(p[1]!=0,a1<-a^p[1],a1<-log(a))
ifelse(p[2]==p[1],a2<-a1*log(a),ifelse(p[2]!=0,a2<-a^p[2],a2<-log(a)))
fit<-glm(y~a1+a2,family="binomial")
print("BIC of the best FP")
print(AIC(fit,k=log(length(y))))

# 2) The best local polynomial fit of degree 2
library(locfit)
BIClf<-function(lpfit){return(-2*(sum(y*log(fitted(lpfit))+(1-y)*log(1-fitted(lpfit))))-log(length(a))*as.vector(aic(lpfit,pen=1)[4]-aic(lpfit,pen=2)[4]))}
alpha=0.8
lpfit<-locfit(y~a,family="binomial",alpha=alpha)
lpfitd1<-locfit(y~a,deriv=1,family="binomial",alpha=alpha)
lpfoi=fitted(lpfitd1)*fitted(lpfit)
BIClf(lpfit)

# 3) The best spline (penalized likelihood framework)
library(gam)
source("GLM functions Eilers and Marx.R")
BICme<-function(fit){return(fit$dev+log((dim(fit$summary.predicted)[1]))*(fit$eff.df))}
me.fit.BIC.logit<-pspline.fit(response=y,x.var=a,ps.intervals=20,degree=3,order=2,link="logit",family="binomial",lambda=80,x.predicted=a)
BICme(me.fit.BIC.logit)

# Plot Chapter
win.graph(); par(mfrow=c(1,1))
plot(grid,pos/tot,cex=0.01*tot,pch=1,xlab="age",ylab="seroprevalence",xlim=c(0,45),ylim=c(0,1))
#title("Seroprevalence Rubella UK")
# Nonlinear fit Farrington: 1 and 2 (gamma=0)
#lines(a,p1(a),lty=4,lwd=2)#,col=2)
#lines(foi.num(a,p1(a))$grid,foi.num(a,p1(a))$foi,lty=4,lwd=2)#,col=2)
lines(a,p2(a),lty=4,lwd=2)#,col=3)
lines(foi.num(a,p2(a))$grid,foi.num(a,p2(a))$foi,lty=4,lwd=2)#,col=3)
# FP fit
pi.fv<-fit$fitted.values
lines(a,pi.fv,lwd=2)
lines(foi.num(a,pi.fv)$grid,foi.num(a,pi.fv)$foi,lwd=2)
# Locfit
lines(a,fitted(lpfit),lty=2,lwd=2)
lines(a,lpfoi,lty=2,lwd=2)
# B-spline
lines(a,me.fit.BIC.logit$summary.predicted[,3],lty=3,lwd=2)
h1<-foi.num(a,me.fit.BIC.logit$summary.predicted[,3])
lines(h1$grid,h1$foi,lty=3,lwd=2)
# Extra layout
axis(side=4,at=c(0.0,0.1,0.2,0.3,0.4))
#abline(h=0)

# Comparing genmod and glm
alpha<-0.07
beta<-0.202
gamma<-0.036
# Bernouilli
p<-1-exp((alpha/beta)*a*exp(-beta*a)+1/beta*(alpha/beta-gamma)*(exp(-beta*a)-1)-gamma*a)
-sum(y*log(p)+(1-y)*(log(1-p)))
# Binomial
p<-1-exp((alpha/beta)*rubella$Age*exp(-beta*rubella$Age)+1/beta*(alpha/beta-gamma)*(exp(-beta*rubella$Age)-1)-gamma*rubella$Age)
-sum(rubella$Pos*log(p)+rubella$Neg*(log(1-p)))

log(length(rubella$Age))
log(length(a))

# A small simulation study to look at how BIC is best defined for GLMs
BIC1<-function(fit){return(-2*logLik(fit)+2*log(length(rubella$Age)))}
BIC2<-function(fit){return(-2*logLik(fit)+2*log(length(a)))}
true.mu<-function(x){
eta<--2-1*x+0.08*x^2
return(exp(eta)/(1+exp(eta)))
}
plot(c(0:80),true.mu(c(0:80)))

simruns<-100
out<-matrix(NA,ncol=3,nrow=simruns)
for (k in 1:simruns){
ys<-rep(NA,length(a))
for (i in 1:length(a)){ys[i]<-rbinom(1,1,true.mu(a[i]))}
fit0<-glm(ys~1,family=binomial)
fit1<-glm(ys~a,family=binomial)
fit2<-glm(ys~poly(a,2),family=binomial)
fit3<-glm(ys~poly(a,3),family=binomial)
fit4<-glm(ys~poly(a,4),family=binomial)

out[k,1]<-k
out[k,2]<-which.min(c(BIC1(fit0),BIC1(fit1),BIC1(fit2),BIC1(fit3),BIC1(fit4)))
out[k,3]<-which.min(c(BIC2(fit0),BIC2(fit1),BIC2(fit2),BIC2(fit3),BIC2(fit4)))
}


