program coch_oae99

use InitiateCoch
use InitiateOae99
use CochFunctions
use IFQWIN
use IFCORE
use IFPORT
use my_rgb          !use latest version
use GraphParams     !use latest version

IMPLICIT NONE

integer(4) ::  dum4
logical   :: lsecond
character Ctext(6)*40,txt11*15,txt20*17
character txtprt(5)*40
record/rccoord/  sprev

!Declaration of arrays.
! real(4) only for output parameter snapshots

real(4), allocatable :: xplot(:),yplot(:),yplot0(:)
real(4), allocatable :: y4max(:),vmax(:)
real(4) :: hchar

!Declaration of variables.

!1) Integers.

integer(4) :: j, ilabel
integer(4) :: np, mode


!2) Reals.

real(8) :: lambda
real(8) :: d00
real(8) :: T 
real(8) :: Asq, Asq1, Asq0   
real(8) :: elapsed_time
real(8) :: d_m_factor
real(8) :: s_m_factor

!3) Logicals

logical*1 l_nostim, l_noprobe

!4) namelists

namelist /coch0/ nt_ME,s_r_factor,s_x_factor &
&       ,x_0, dt
namelist /init/  l_init,l_store,l_screenplot, l_out, T_max
namelist /cochlea/ n,BM_impedance_factor,FREQUENCY_MAP
namelist /stimpars/ t0,StimulusPeriod,ProbePeriod			&
&       ,L_stim,L_probe,probe_onset_duration    &
&       ,num_sec_tot,l_coupler
namelist /nonlinearity/ NonLin,alpha            &
&      /nonlin2/ beta  							&
&      /nonlin3/ gamma							&
&      /nonlin4/ d_factor
 

!!
!!*************MAIN PROGRAM (LABEL 1-9)********************
!!

!     I/O statements.

open (15,file='pearcan.dt')

open (2,file='newpar.dat')
read (2,coch0)
read (2,init)
read (2,cochlea)

!    Initialisation variables, based on parameters.
t0_d=t0
T_d=t0_d
ms_BM= 5.d-1*BM_impedance_factor         != 0.5
select case (FREQUENCY_MAP)
case ($STRAIGHT)
  lambda=300.d0                          != 300.
  ss0BM =  1.d10*BM_impedance_factor     != 10^10
case ($GREENWOOD)    
  lambda=60.d0                           != 60*2*2.3 in GREENWOOD map
  ss0BM=0.8558d10*BM_impedance_factor    != 10^10
end select 
d_ow_1=xl_BM/dfloat(n)           != H=1./float(N)


print*, 'values read for n =', n
        
allocate (Y(0:n,2),V(0:n,2)                  &
&        ,M(0:n,1:4)						 &
&        ,g(0:n)							 &
&        ,q(0:n)							 &
&        ,b(0:N),k(0:N)   					 &
&        ,xplot(n+1),yplot(n+1),yplot0(n+1)  &
&        ,y4max(0:n),vmax(0:n)		   )

read (2,stimpars)
!print*, 'stimpars done'
!read(*,*)
read (2,nonlinearity)
!print*, 'NonLin=', NonLin
!print*, 'nonlinearity0 done'
!read(*,*)
read (2,nonlin2)							    
!print*, 'NonLin2 done'
!read(*,*)
read (2,nonlin3)
!print*, 'NonLin3 done'
!read(*,*)
read (2,nonlin4)
!print*, 'NonLin4 done'
!read(*,*)
close(2)

!print*, 'All done. NonLin=', NonLin
!read(*,*)
!Initialisation of y and v at time T=t0

if (l_init) then
  irl=(n+1)*8 !16
  select case (FREQUENCY_MAP)
  case ($STRAIGHT)
  open(17,file='v00.bin',access='direct',recl=irl)
  open(18,file='y00.bin',access='direct',recl=irl)
  case ($GREENWOOD)
  open(17,file='v01.bin',access='direct',recl=irl)
  open(18,file='y01.bin',access='direct',recl=irl)
  end select
  read(17,rec=1) (v(i,1),i=0,n)  
  read(18,rec=1) (y(i,1),i=0,n)
  close (17)
  close (18)
else
	Y=0.d0
	V=0.d0
end if

y4max=0.d0
vmax=0.d0

!    Calculation of all other relevant values.
!    1: Calculation of values related to t- and x-direction.
!      (t:time, x:distance along BM)

dx=(xl_BM - h_Scala - d_ow_1)/dfloat(n)
xrel_ow_1=d_ow_1/dx
dt2=dt/par2
dt6=dt/6.d0
print*,'dx ',dx
print*,'xrel_ow ',xrel_ow_1
print*,'dt2 ',dt2
read(*,*)

!   2) Calculation of values related to acoustic mass of cochlear fluid
!      and of the BM.
      
S_Scala=h_Scala*b_Scala
b_BM   =b_Scala
ma_BM  =ms_BM/(b_BM*dx)
ma_F01 =(rho*d_ow_1)/S_Scala
ma_F   =(rho*dx)/S_Scala


!    3) Calculation of values related to middle ear.
 
w_ME=par2*PI_D*f_ME
if (l_coupler) then 
  ds_ME=(nt_ME*nt_ME*d_cp*S_ST)
else
  ds_ME=(nt_ME*nt_ME*Zaa*S_ST)
end if
ms_ME=(ds_ME/w_ME)*Q_ME
ss_ME=ms_ME*w_ME*w_ME
if (l_coupler) then
  m0_RK4=ms_BM/(ms_ME+(nt_ME*nt_ME*m_cp)*S_ST)
  gam0=ma_BM/((ms_ME/S_ST)+(nt_ME*nt_ME*m_cp))
  r_Xtr0=(nt_ME*nt_ME*S_ST*s_cp)/ms_BM
else
  m0_RK4=ms_BM/ms_ME
  gam0=(S_ST*ma_BM)/ms_ME
  r_Xtr0=0.d0
end if  
AxA=(par2*rho*b_BM)/(ms_BM*S_Scala)
alf0=gam0*AxA*dx
!pECmax=-200.d0

g0r_factor=ms_ME*m0_RK4/nt_ME
q0_factor =ms_BM/nt_ME - g0r_factor 
Y01_factor=ss_ME/nt_ME 
d_m_factor=ds_ME/ms_BM      
s_m_factor=ss_ME/ms_BM
      

!    
!    4) Calculation of values related to 'loudness' and frequency
!       of an external stimulus.

!print*,' Test1'

T_section   = StimulusPeriod*DBLE(INT(T_sect_default/StimulusPeriod)+0.5)
num_pps     = NINT(T_section/dt) 
probe1_begin=  0.d0 !StimulusPeriod*8.d0
probe_duration=DBLE(DINT(DINT(40.d-3/ProbePeriod)/2.) )*ProbePeriod


kmax=num_sec_tot*num_pps
print*,'T_section', T_section
print*,'num_pps',num_pps
print*,'kmax ',kmax 

!
!

read(*,*)
!print*,' Test2'

p0x=nt_ME/ms_BM
if (L_stim < -150.) then
  p_stim=0.
else
  p_stim=p0 * 10.**(L_stim/20.)
end if
if (L_probe < -150.) then
  p_probe=0.
else
  p_probe=p0 * 10.**(L_probe/20.)
end if


probe1_begin= DBLE(num_sec_tot-4)*T_section + probe1_begin
probe1_end  = probe1_begin + probe_duration
probe2_begin= probe1_begin + T_section
probe2_end  = probe1_end   + T_section

!print*,'p1',probe1_begin, probe1_end
!print*,'p2',probe2_begin, probe2_end
!read(*,*)


! 5) Calculation of stiffness BM and exponential part of damping.
!(Dimensionless.)

select case (FREQUENCY_MAP)
case ($STRAIGHT)
 E1=exp(-lambda*dx/par2)
 E2=E1*E1
 s(0)=ss0BM/ms_BM
 d(0)=eps*dsqrt(ss0BM/ms_BM)
 s(1)=s(0)*E2**(d_ow_1/dx)
 d(1)=d(0)*E1**(d_ow_1/dx)
 do  i=2,n
   s(i)=s(i-1)*E2 
   d(i)=d(i-1)*E1 
 enddo
case ($GREENWOOD)
 E1=DEXP(-lambda*dx*DLOG(1.d1))  
!print*,E1
!read(*,*)
 E2=0.8d0*DEXP(-2.1d0*DLOG(1.d1))
 s000=DSQRT(ss0BM/ms_BM)
 s00 =s000*(par1-E2)
 s(0)=s00*s00
 ES1 =E1**(d_ow_1/dx)
 s00 =s000*(ES1-E2)
 s(1)=s00*s00
 do i = 2,n
   ES1 = ES1*E1
   s00 = s000*(ES1-E2)
   s(i)= s00*s00
 enddo

!  Now (22 dec 95) we developed a non-constant Q damping profile
!  with the $GREENWOOD map. Q is about 25 at the stapes, and exactly 1
!  at the APEX, in order to get an optimal [frequency independent]
!  matching impedance at that point! Because ES1-E2 at n is required,
!  we first evaluated s. Not strictly necessary, but avoid 'problems'
!  at n=1. See also line 844, and check sign of additional term

 !d00 = DSQRT(ms_BM*(ES1-E2)*DSQRT(ss0BM))
 d00 = par2*DSQRT(DSQRT(s(n)))     !mod 13-4-00 > Q=0.5
 do i=0,n
       d(i)=d00*DSQRT(DSQRT(s(i)))
 end do 
! print*,d(1)
! print*,d(400)
! read(*,*)
end select !FREQUENCY_MAP
 

! 6) Calculation of diagonal elements of tridiagonal matrix A.
!   This has to be done only once because A is time invariant.


Asq =AxA*dx*dx
Asq1=Asq*xrel_ow_1
AME=par1+(gam0*Asq*xrel_ow_1)
ASC01=par1+xrel_ow_1+AxA*d_ow_1*dx
ASC=par2+Asq      !=a_o
AHT=par1 + Asq + DSQRT(Asq)
KHTfactor=par2*rho*dx/S_Scala*DSQRT(s(n))
Asq0=gam0*Asq1



! 7) Calculation of coefficients necessary to solve the tridiagonal system.
!(First the tridiagonal matrix is transformed into a lower triangle
! matrix.
! Furthermore we use the fact that matrix A is represented by only
! three different diagonal elements (AME,ASC and AHT) and all sub- 
! and super diagonal elements are equal to -1.)
!    december 1995: weer teruggezet in eigen (en HWH) notatie,
!    daarin kan ik de GAUSS-eliminatie beter terugvinden.


b(n)=par1/AHT
do j = n-1,2,-1
  b(j)=par1/(ASC-b(j+1))
end do
b(1)=par1/(ASC01-xrel_ow_1*b(2))
b(0)=par1/(AME - b(1))


!cc!     mfac overeenkomend met mfac2 voor Duifhuis massa bij het 
!cc!     helicotrema, dus niet optimaal afgesloten !!
!cc!     mfac=1.107932516
!cc!     mfac overeenkomend met mfac2 voor optimale afsluiting bij
!cc!     een emissie van ongeveer 1.5 kHz
!cc!     mfac=1.205249

!=====================include plotting info=========================
IF(l_screenplot) THEN

do  i=1,n+1
  xplot(i)=max(1,i-1)/float(n)*xl_BM  !i=0 interferes with grafics axis
  yplot(i)=float(mod(i,4))
end do

Ctext(1)='position along membrane'
Ctext(2)='BM-velocity'
if (L_stim.ge.0)then
  if (INT(L_stim).ge.10) then
      if (INT(L_stim).ge.100) then
          assign 312 to ilabel
      else
          assign 311 to ilabel
      end if
  else 
          assign 310 to ilabel
  end if
else 
  if (INT(L_stim).le.-10) then
    if (INT(L_stim).le.-100) then
        if(int(L_stim).le.-150) then
           l_nostim=.true.
        else
           assign 313 to ilabel
        end if
    else
        assign 312 to ilabel
    end if
  else 
    assign 311 to ilabel
  end if
end if
if(.not.l_nostim) write(txtprt(1),ilabel) nint(L_stim)

if (L_probe.ge.0)then
  if (INT(L_probe).ge.10) then
    if (INT(L_probe).ge.100) then
        assign 312 to ilabel
    else
        assign 311 to ilabel
    end if
  else 
        assign 310 to ilabel
  end if
else 
  if (INT(L_probe).le.-10) then
    if (INT(L_probe).le.-100) then
        if(int(L_probe).le.-150) then
           l_noprobe=.true.
        else
           assign 313 to ilabel
        end if
    else
        assign 312 to ilabel
    end if
  else 
    assign 311 to ilabel
  end if
end if
if(.not.l_noprobe) write(txtprt(2),ilabel) nint(L_probe)

write(txtprt(3),314) BM_impedance_factor
310     format(i1)
311     format(i2)
312     format(i3)
313     format(i4)
314     format(f4.1)

if(l_noprobe) then
  if(l_nostim) then
    txtprt(4)='no stimulus'
  else
  txtprt(4)= 'Ls = '//txtprt(1)(:LEN_TRIM(txtprt(1)))//  &
& ' dB, BMfactor:'//txtprt(3)(:LEN_TRIM(txtprt(3)))
  end if
else
  if(l_nostim) then
  txtprt(4)= 'Lp = '//txtprt(2)(:LEN_TRIM(txtprt(2)))//  &
& ' dB, BMfactor:'//txtprt(3)(:LEN_TRIM(txtprt(3)))
  else
  txtprt(4)= 'Ls = '//txtprt(1)(:LEN_TRIM(txtprt(1)))//  &
& ', Lp = '//txtprt(2)(:LEN_TRIM(txtprt(2)))//			  &
& ' dB, BMfactor:'//txtprt(3)(:LEN_TRIM(txtprt(3)))
  end if
endif

select case (NonLin)
case (1)  ! LIN damping   and      LIN stiffness
  Ctext(3)='linear'
case (2)  ! Pass cosh damping and  LIN stiffness
  Ctext(3)='passive NL #2'
case (3)  ! Act cosh/sinh damping and LIN stiffness 
  Ctext(3)='active NL #3'
case (4)  ! Pass cosh damping and NL stiffness
  Ctext(3)='passive NL damping & NL stiffness #4'
case (5)  ! Act cosh/sinh damping and NL stiffness 
  Ctext(3)='active NL damping & NL stiffness #5'
case (6)  ! LIN damping   and   nl stiffness svn
  Ctext(3)='NL stiffness #6'
case (7)  ! NL (goldstein) damping and LIN stiffness
  Ctext(3)='NL damping #7'
case (8)  ! NL damping and NL stiffness (goldstein)
  Ctext(3)='NL damping & stiffness #8'
case (9)  ! new NL damping 
  Ctext(3)='NL damping 006'
end select

Ctext(4)=txtprt(4)(:LEN_TRIM(txtprt(4)))
write(Ctext(5),315) 1.d-3/StimulusPeriod
315 format('f=',f5.2)
xl=15.
yl=10.
hchar=.4
np=n+1
mode=1
xmin=0.
xmax=SNGL(xl_BM)
zmin=-MAX(sngl(p_stim/p0),sngl(p_probe/p0),50.)*1.e-7
zmax=-zmin

call pl_open(1)

dum4=setbkcolorrgb(my_rgb_WHITE)
dum4=setcolorrgb (my_rgb_BLACK)
dum4=settextcolorrgb(my_rgb_BLACK) 
mode=401
call graphs(linlin,xplot,yplot,np,xl,yl,hchar,Ctext,mode)
call gwrite ('gr-hdh')
mode=21
lsecond=.false.

END IF !l_screenplot
!=======================================================
T=T_d
t0=t0_d

!C************************* RK4 LOOP ***********************
!C

do kk=1,kmax

do k_RK4=1,4

select case (k_RK4)
case (1)
 F0=F(t0,T)
 kkRK4=1
case (2)
 F0=F(t0,T+dt2)
 do i=0,n
   Y(i,2)=Y(i,1)+V(i,1)*dt2
   V(i,2)=V(i,1)+M(i,1)*parh
 enddo
 kkRK4=2
case (3)
! F0=F(t0,T+dt2) :the F function was already called, and the value 
!	has not changed: k_RK4 increases cyclically
 do i=0,n
   Y(i,2)=Y(i,1)+V(i,2)*dt2
   V(i,2)=V(i,1)+M(i,2)*parh
 enddo
 kkRK4=2
case (4)
 F0=F(t0,T+dt)
 do i=0,n
   Y(i,2)=Y(i,1)+V(i,2)*dt
   V(i,2)=V(i,1)+M(i,3)
 enddo
 kkRK4=2
end select 

g(0)=ds_ME/ms_BM*V(0,kkRK4)+ss_ME/ms_BM*Y(0,kkRK4)
do i=1,n 
  g(i)=GG(V(i,kkRK4),Y(i,kkRK4),i)
enddo


select case (k_RK4)
case (1)
 F0=F(t0,T)
case (2)
 F0=F(t0,T+dt2)
case (3)
case (4)
 F0=F(t0,T+dt)
end select 


!************Solution of matrix equation A*q(t)=-a.g(t).**********************
!
!    Method: (Refined) Gauss elimination.

Vsom=0.
do i=1,n
  Vsom=Vsom+V(i,kkRK4)
end do  
Vsom=Vsom*dx*b_BM

!IF(l_screenplot) THEN
!if (mod(kk,20).eq.0) then   
! write(txt20,'(a6,e10.3)') 'Vsom:',Vsom
! call settextposition(1,0,sprev)
! call outtext (txt20)
! write(txt20,'(a6,e10.3)') 'Vst:',S_ST*V(0,kkRK4)
! call settextposition(2,0,sprev)
! call outtext (txt20)
!endif
!END IF !l_screenplot

! 1) Calculating modified right hand side.


k(n)= -Asq*g(n)+KHTfactor*(S_ST*V(0,kkRK4)+Vsom)
do i = n-1,2,-1
  k(i)= -Asq*g(i) + k(i+1)*b(i+1)
end do
k(1) = -Asq*g(1)*xrel_ow_1 + k(2)*b(2)
k(0) = -(gam0*Asq*xrel_ow_1)*(p0x*F0+g(0)+r_Xtr0*Y(0,kkRK4)) &
&     +k(1)*b(1)  


! 2) Backsubstitution.

q(0)=-k(0)*b(0)
do i = 1,n
  q(i)=(q(i-1)-k(i))*b(i)
end do  

! 3)  Calculation of RK4 coefficients M(i,1)

M(0,k_RK4)=m0_RK4*(q(0)-g(0)-p0x*F0-r_Xtr0*Y(0,kkRK4))*dt
do i=1,n
  M(i,k_RK4)=(q(i)-g(i))*dt
enddo

! Solution stored in array q.
! End do loop, except for computation pEC if k_RK4=1

! 5)  Calculation of the pressure at the ear drum (ear canal)
!Notation: pEC

if (k_RK4.eq.1 .and. n_section.ge.1) then

  pEC=q0_factor*q(0) + g0r_factor*(p0x*F0+g(0)+r_Xtr0*Y(0,1))   &
&     +Y01_factor*Y(0,1)

!  pEC=( q(0)*(ms_BM-ms_ME*m0_RK4)
!&      +ms_ME*m0_RK4*(p0x*F0+g(0)+r_Xtr0*Y(0,1))
!&      -ss_ME*Y(0,1))/nt_ME
     
!
  write(15,*) t,pEC, F0
!  write(15,'(e15.8)') SNGL(pEC)
end if
  
enddo 
!..end...............of.....................k_RK4 loop.............!

do i=0,n
   Y(i,1)=Y(i,1)+(V(i,1)+ (M(i,1)+M(i,2)+M(i,3))*parh6)*dt
   V(i,1)=V(i,1)+(M(i,1)+par2*(M(i,2)+M(i,3))+M(i,4))*parh6
enddo

!   Increment time 
!   & Output statements [optional]

IF (mod(kk,100).eq.0) then   
   write(txt11,100) (T+dt)*1000.,' ms ', n_section
 100  format(' ',F7.2,A3,I2)


!===============================================================c
IF (l_screenplot) THEN
!c plotting commands included
!===============================================================c

do i=1,n+1
    yplot0(i)=yplot(i)
    yplot(i)=SNGL(V(i-1,1))
end do

call settextposition(4,0,sprev)
call outtext (txt11)

if(lsecond) then
   dum4=setcolorrgb(my_rgb_WHITE) !int2($GRAY))
   call graphs(linlin,xplot,yplot0,np,xl,yl,hchar,Ctext,21)
end if
dum4=setcolorrgb(my_rgb_BLUE) !int2($BLACK))
dum4=settextcolorrgb(my_rgb_RED)
call graphs(linlin,xplot,yplot,np,xl,yl,hchar,Ctext,mode)
lsecond=.true.

!===================================================================c
END IF !l_screenplot
! local end plotting commands
!===================================================================c
END IF   

!   dt is not sufficiently accurate, even in DBLE, to compute T by
!   straightforward additional increments.

!n_section=MAX(nint( DBLE(kk)/DBLE(num_pps)) -(num_sec_tot - 5),0)
n_section=MAX(int(real(kk/num_pps)) -(num_sec_tot - 5),0)
T=dble(kk*NINT(1.d8*dt)) * 1.d-8

if (n_section > 0) then
  do i=0,n
    y4max(i)=MAX(y4max(i),y(i,1))
    vmax(i)=MAX(vmax(i),v(i,1))
  end do
end if

end do !kk-loop

!C************************ END OF RK4 LOOP ****************************

!plotbegin ===============
IF(l_screenplot)THEN
read(*,*)
call pl_close
END IF !l_screenplot
!plotend =================

if (l_store) then
  irl=(n+1)*8 !16
  select case (FREQUENCY_MAP)
  case ($STRAIGHT)
  if(l_nostim .and. l_noprobe)then
    open(19,file='v00.bin',access='direct',recl=irl)
    open(20,file='y00.bin',access='direct',recl=irl)
  else
    open(19,file='v10.bin',access='direct',recl=irl)
    open(20,file='y10.bin',access='direct',recl=irl)
  endif
  case ($GREENWOOD)
  if(l_nostim .and. l_noprobe)then
    open(19,file='v01.bin',access='direct',recl=irl)
    open(20,file='y01.bin',access='direct',recl=irl)
  else
    open(19,file='v11.bin',access='direct',recl=irl)
    open(20,file='y11.bin',access='direct',recl=irl)
  endif
  end select
  write(19,rec=1) (v(i,1),i=0,n)  
  write(20,rec=1) (y(i,1),i=0,n)
  close (19)
  close (20)
end if

open(21,file='profile.dt')
do i=0,n
  write(21,'(3(e12.7,2x))') float(i)*0.8725e-4,vmax(i),y4max(i)
end do
close (21)

deallocate (Y,V,M,g,q,b,k,xplot,yplot)
deallocate (yplot0,y4max,vmax)

close (15)

stop
end

!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

!include 'CochRoutines.f90'
!include 'TimeStruct.f90'

!===================================================================
