! Creates window with <UNITnr>, and <width> and <height> in pixels and with a <title>

SUBROUTINE CreateWindow(UNITnr, width, height, title)
	USE MessageModule
	USE IFQWIN
	IMPLICIT NONE
	INTEGER, INTENT(IN) :: UNITnr
	INTEGER, INTENT(IN) :: width
	INTEGER, INTENT(IN) :: height
	CHARACTER (*), INTENT(IN) :: title
	TYPE (windowconfig) wc
	TYPE (qwinfo) wInfo
	LOGICAL status
	LOGICAL(4) :: setWinConfigResult
	integer(2) :: wraponResult
	INTEGER ios

	OPEN (UNIT = UNITnr, FILE = 'USER', IOFOCUS = .TRUE., IOSTAT = ios)
	! window must be at least 140 x 40 pixels
	wc.numxpixels = INT2(MAX(140, width))
	wc.numypixels = INT2(MAX(40, height))
	wc.numtextcols = -1
	wc.numtextrows = -1
	wc.numcolors   = -1
	wc.title= title
	wc.fontsize = -1
	status = SETWINDOWCONFIG(wc)
	IF ( .NOT. status) THEN
		CALL message (TRIM(title) // MessageText(WINDOWINITIALIZATIONERROR), MessageTitle(WINDOWINITIALIZATIONERROR)) 
		setWinConfigResult = SETWINDOWCONFIG(wc)
	ENDIF
	wraponResult = WRAPON ($GWRAPOFF)
	
END SUBROUTINE CreateWindow
