! SampleDown will return the value of input[index-windowBoundary] after
! downsampling, by convoluting the input-array around
! position index-windowBoundary with the Inverse FourierTransform of a
! low pass filter (= window)
! index should point to the last inserted value of input, so index-windowBoundary
! is the middle value of the array. This value can be convoluted with
! window using the M values in front, the M values after and the middle value of the input itself
! SampleDown = SOM {input(i) * window (j)}
! where i is index-2windowBoundary to index (so centered around index-windowBoundary)
! and j is windowBoundary to -windowBoundary
! input should be a cyclic array of size 2windowBoundary+1

FUNCTION SampleDown  (input, index)
	USE SampleDownModule
	IMPLICIT NONE

	REAL SampleDown
	INTEGER, INTENT(IN)	:: index
	REAL, INTENT(IN) :: input (0 : 2 * windowBoundary)
	REAL output

	INTEGER i
	INTEGER input_i

	output = 0
	input_i = index
	DO i = -windowBoundary, windowBoundary
		input_i = input_i + 1
		IF (input_i > 2*windowBoundary) input_i = 0
		output = output + input(input_i) * window(-i)
	ENDDO

	SampleDown = output

END FUNCTION SampleDown