SUBROUTINE InitializeGraphs
	USE Declare
	USE GraphsModule
	USE SampleDownModule
	USE DFLIB
	IMPLICIT NONE
	integer(4) :: AboutboxQQresults

	AboutboxQQresults = ABOUTBOXQQ ("Model of the cochlea\n\nJohan Kruseman\nmod H Duifhuis"C)

	n_plotpoints = (n-1)/plotEvery_n_points +1
	t_plotpoints = kmax/plotEvery_t_points +1
	ALLOCATE (section_axis(0: n_plotpoints-1), &
								membrane_y_pixel (0: n_plotpoints-1), &
								white(0: n_plotpoints), &
								black(0: n_plotpoints), &
								velocityMatrix (0:n_plotpoints-1, 0:t_plotpoints-1), &
								positionMatrix (0:n_plotpoints-1, 0:t_plotpoints-1), &
								velocityStapes (0:t_plotpoints-1), &
								positionStapes (0:t_plotpoints-1), &
								PositionPhase(0:n_plotpoints - 1), &
								VelocityPhase(0:n_plotpoints - 1), &
								previousPosition(0:n_plotpoints - 1), &
								previousVelocity(0:n_plotpoints - 1), &
								STAT = err)

	IF (err /= 0) CALL AllocationError

	IF (preventAliasing) THEN
		CALL InitializeSampleDown(plotEvery_t_points)
		ALLOCATE (LastPositionPoints(0:n_plotpoints - 1, 0: 2*windowBoundary), &
									LastVelocityPoints(0:n_plotpoints - 1, 0: 2*windowBoundary), &
									STAT = err)
		IF (err /= 0) CALL AllocationError

		LastPositionPoints = 0
		LastVelocityPoints = 0
		LastIndex = 0
		positionMatrix = 0
		velocityMatrix = 0
	ENDIF

	PositionPhase = -1
	VelocityPhase = -1
	StapesPositionPhase = -1
	StapesVelocityPhase = -1
	previousPosition = 0
	previousVelocity = 0
	prevStapesPosition = 0
	prevStapesVelocity = 0
	PlotPhase = useSignal1 .AND. .NOT. useSignal2 .AND. .NOT. useSignal3 .AND. .NOT. useAudioFile

	section_axis = [0 : n_plotpoints - 1]
	membrane_y_pixel = 0
	white = #FFFFFF
	black = #000000
	t_plotCounter = -1

END SUBROUTINE InitializeGraphs