SUBROUTINE InitializeFiles
	USE Declare
	USE FilesModule
	USE MessageModule
	USE DFLIB
	IMPLICIT NONE
	INTEGER length, startIndex
	LOGICAL driveLetterPresent

	IF (storePressureEarCanal .OR. storeTesting .OR. storeProfile .OR. storeProbing) THEN
		OutputDirectory = ADJUSTL(OutputDirectory)
		driveLetterPresent = INDEX(OutputDirectory, ":") == 2
		length = LEN_TRIM(outputDirectory)

		! replace all forward slashes by backward slashes
		DO i=1, length
			IF (OutputDirectory(i:i) == "/") OutputDirectory(i:i) = "\"
		ENDDO

		! Make sure directory ends with a backward slash
		IF (length==0 .OR. OutputDirectory(length:length) /= "\") OutputDirectory = TRIM(OutputDirectory) // "\"
		length = LEN_TRIM(outputDirectory)

		startIndex = 1
		IF (driveLetterPresent) startIndex = 3
		IF (outputDirectory(startIndex:startIndex) == "\") startIndex = startIndex + 1

		! scan for back slashes and make (sub)directories
		DO WHILE (startIndex <= length)
			i = INDEX (outputDirectory(startIndex:length), "\") + startIndex - 1
			ok = MAKEDIRQQ(OutputDirectory(1:i))
			IF (.NOT. ok .AND. GETLASTERRORQQ() /= ERR$EXIST) THEN
				! directory could not be made
				CALL Message (MessageText(CREATEDIRECTORYERROR), MessageTitle(CREATEDIRECTORYERROR)) 
				storePressureEarCanal = .FALSE.
				storeProfile = .FALSE.
				storeProbing = .FALSE.
				storeTesting = .FALSE.
				EXIT
			ENDIF
			startIndex = i + 1
		ENDDO
	
		IF (OutputDirectory == "\") OutputDirectory = ""

		IF (storeBinary) THEN
			WriteFormat = 'BINARY'
			storeExtraInfo = .FALSE.
		ELSE
			WriteFormat = 'FORMATTED'
		ENDIF
	ENDIF

END SUBROUTINE  InitializeFiles