SUBROUTINE InitializeZweig

	USE Declare
	IMPLICIT NONE
	REAL(8) f_resonance(n)
	REAL(8) exact_delay(n)
	REAL(8) relative_position(n)
	REAL(8) adaptation(n)
	REAL(8) HighFrequencyAdaptationFactor

	IF (damping == ZWEIGLINEAR .OR. damping == ZWEIGNONLINEAR) THEN

		ALLOCATE (	delay (n), &
					delay_deviation (n), &
					Yzweig(n), &
					ZweigSample1(n), &
					ZweigSample2(n), &
					ZweigRhoAdapted(n), &
					ZweigDampingAdaptation(n), &
					STAT = err)

		IF (err/=0) CALL AllocationError

		! make adaptations for the zweig rho and damping for the nonlinear case, so the negative damping
		! will limit to a positive damping at the boundaries with Q = zweig_Q_at_boundaries and the stength
		! of the stabilizing delayed feed back force, controlled by rho, will vanish at the boundaries

		HighFrequencyAdaptationFactor = 20
		IF (ParameterSet == GUINEA_PIG .AND. damping == ZWEIGLINEAR) HighFrequencyAdaptationFactor = 5

		relative_position = x(1:n) / cochleaLength(ParameterSet)
		adaptation = 1 - DEXP(-HighFrequencyAdaptationFactor * relative_position) - DEXP(-20 * (1-relative_position))
		ZweigRhoAdapted = ZweigRho * adaptation
		ZweigDampingAdaptation = (1 - constantQ / ZweigQAtBoundaries) * adaptation + constantQ / ZweigQAtBoundaries

		f_resonance = DSQRT(sdivm(1:n)) / (2 * pi)
		exact_delay = ZweigFactor / (f_resonance * dt)		! exact delay in (fraction of) number of samples
		delay = INT (exact_delay) + 1						! delay in integer number of samples
		delay_deviation = DFLOAT(delay) - exact_delay		! deviation from exact delay, nessecary for interpolation

		ALLOCATE (Ybuffer(SUM(delay)), STAT = err)
		IF (err/=0) CALL AllocationError

		Ybuffer = 0
		ZweigSample1(1) = 1
		DO i = 2, n
			ZweigSample1(i) = ZweigSample1(i-1) + delay(i-1)
		ENDDO
		ZweigSample2 = ZweigSample1 + 1
	ENDIF

END SUBROUTINE InitializeZweig
