! Updates rescale dialog box depending on the value of <plotPositions>
! If <PlotPositions>, default settings for positions will be set,
! otherwise default settings for velocities will be set.

SUBROUTINE RadioButtons (dlg, id, event)
	USE GraphsModule
	USE DialogDeclare
	IMPLICIT NONE
	INCLUDE 'resource.fd'
	INCLUDE 'DialogInclude'
	LOGICAL plotPositions
	logical(4) :: ok

    ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)
	ok = DLGSETLOG (dlg, RADIO_setSmallestAsMin, .TRUE.)
	ok = DLGSETLOG (dlg, RADIO_setLargestAsMax, .TRUE.)

	IF (plotPositions) THEN
		ok = DLGSETCHAR (dlg, GROUP_MinimumToPlot, "Minimum displacement to plot")
		ok = DLGSETCHAR (dlg, GROUP_MaximumToPlot, "Maximum displacement to plot")
		!sets positions in nm
		ok = DLGSETCHAR (dlg, EDIT_NewMinimumValue, RealToString (DBLE (minimumPosition) * 1d9, 3))
		ok = DLGSETCHAR (dlg, EDIT_NewMaximumValue, RealToString (DBLE (maximumPosition) * 1d9, 3))
		ok = DLGSETCHAR (dlg, TEXT_Minimum, "nm")
		ok = DLGSETCHAR (dlg, TEXT_Maximum, "nm")
	ELSE
		ok = DLGSETCHAR (dlg, GROUP_MinimumToPlot, "Minimum velocity to plot")
		ok = DLGSETCHAR (dlg, GROUP_MaximumToPlot, "Maximum velocity to plot")
		!sets velocities in nm/ms
		ok = DLGSETCHAR (dlg, EDIT_NewMinimumValue, RealToString (DBLE (minimumVelocity) * 1d6, 3))
		ok = DLGSETCHAR (dlg, EDIT_NewMaximumValue, RealToString (DBLE (maximumVelocity) * 1d6, 3))
		ok = DLGSETCHAR (dlg, TEXT_Minimum, "nm/ms")
		ok = DLGSETCHAR (dlg, TEXT_Maximum, "nm/ms")
	ENDIF

END SUBROUTINE