SUBROUTINE UpdateMinimumValue (dlg, id, event)
	USE Declare
	USE GraphsModule
	USE DFLOGM
	IMPLICIT NONE
	INCLUDE 'resource.fd'
	INCLUDE 'DialogInclude'
	REAL newMinimumValue
	CHARACTER(22) text
	logical(4) :: result1

	ok = DLGGETLOG (dlg, RADIO_plotPositions, plotPositions)

	SELECT CASE (id)
	CASE (RADIO_setSmallestAsMin)
		IF (plotPositions) THEN
			newMinimumValue = minimumPosition * 1e9
		ELSE
			newMinimumValue = minimumVelocity * 1e6
		ENDIF
	CASE (RADIO_setCurrentAsMin)
		IF (plotPositions) THEN
			newMinimumValue = minimumPositionToPlot * 1e9
		ELSE
			newMinimumValue = minimumVelocityToPlot * 1e6
		ENDIF
	CASE (RADIO_setNewAsMin)
		newMinimumValue = 0
	END SELECT
	result1= DLGSETCHAR (dlg, EDIT_NewMinimumValue, RealToString (DBLE (newMinimumValue), 3))
END SUBROUTINE UpdateMinimumValue