! <GetLong> is a long value (4 characters) read from the
! current postion from the open file <handler> using
! Little Endian order (see example below)

INTEGER FUNCTION GetLong (handler)
	IMPLICIT NONE
	INTEGER handler
	EXTERNAL ReadChar
	INTEGER(2) ReadChar
	INTEGER(4) i1, i2, i3, i

	! first read the 4 characters seperately
	i1 = ReadChar(handler)
	i2 = ReadChar(handler)
	i3 = ReadChar(handler)
	i = ReadChar(handler)

	! Combine values of characters in little endian order to form a long value.
	! Shift binary pattern of last read character 8 positions (that is multiplying
	! with 2^8=256) and add character <i3>
	i = OR (LSHIFT(i, 8), i3)
	! repeat process off shifting and adding for the rest of the characters read
	i = OR (LSHIFT(i, 8), i2)
	GetLong = OR (LSHIFT(i, 8), i1)

END FUNCTION GetLong

! For example, the binary pattern from the current position in the file is:
!   11111111    00000000    11110000    00001111

!   i1 = 255
!   i2 = 0
!   i3 = 240
!   i = 15

!   i = i * 256 + i3 = 15 * 256 + 240 = 4080
!   i = i * 256 + i2 = 4080 * 256 + 0 = 1044480
!   GetLong = i * 256 + i1 = 1044480 * 256 + 255 = 267387135
! The last read character is thus most significant, while the first read character
! is least significant (that is little Endian order)
