! GetSample reads a sample of size <bytes> from the current position
! of the open file <handler>
! <Bytes> has to be either 1, 2 or 4

REAL FUNCTION GetSample (bytes, handler)
	USE WaveReadModule
	IMPLICIT NONE
	INTEGER bytes
	INTEGER handler
	EXTERNAL GetUnsignedByte, GetShort, GetLong
	INTEGER(2) GetUnsignedByte
	INTEGER(2) GetShort
	INTEGER GetLong

	SELECT CASE (bytes)
	CASE (1)
		GetSample = REAL(GetUnsignedByte (handler) - 128)
	CASE (2)
		GetSample = REAL(GetShort (handler))
	CASE (4)
		GetSample = REAL(GetLong (handler))
	END SELECT

END FUNCTION GetSample