! Open and read <audiofile> and store data in WaveData
! If <useLeftChannel> data from the left channel is stored, else data from the right channel
! Set Audio Format data
! Set WaveFileErrorMessage and InfoMessage

SUBROUTINE WaveRead (audiofile, useLeftChannel, keepData)
	USE WaveReadModule
	USE WINMM
	IMPLICIT NONE

	CHARACTER(127), INTENT(IN) :: audiofile
	LOGICAL, INTENT(IN) :: useLeftChannel
	LOGICAL, INTENT(IN) :: keepData	!if true written data will be kept in wavedata, else memory will be freed
	INTEGER handler
	INTEGER answer

	CALL OpenWaveFile (audiofile, handler)
	CALL FindWaveChunk (handler)
	CALL ReadFmtChunk (handler)
	CALL CheckFMTvalues
	CALL ReadDataChunk (handler)
	CALL ReadData (handler, useLeftChannel)
	IF (ALLOCATED(WaveData) .AND. .NOT. keepData) DEALLOCATE (WaveData)
	CALL CloseWaveFile (handler)

END SUBROUTINE WaveRead