! Main program

! Reads parameters from parameter file <parameter.dat>
! *Reads nonLinearity file <gamma.dat> in case of active damping
! *Reads membrane status from <final_y.bin> and <final_v.bin>
! *Reads and resamples wavefile
! Performs the GaussElimination/RK4-loop:
!		calculating the position and velocity of each section of the membrane for each time step
!		*writing the pressure at the ear canal to file
!		*writing the velocity and position of the user set probe points to file
!		*plotting the graphs (legend, membrane, stimulus, cochleagram)
!		*calculating the phase of each section relative to the signal
! *Plots profile (maximum position or velocity of each section) and phase of each section (of f1 only, iff detectable)
! Displays rescale dialog box and plots the rescaled graphs until finish button is pressed 
! *Writes final membrane status to <final_y.bin> and <final_v.bin>
! *Writes profile to user set file
! *mod Dec 09: add phase to profile data (using the phase calculation mentioned above

! * Actions starting with an *, will only be performed if selected, and specified in <parameter.dat>

PROGRAM cochlea
	USE WaveReadModule
	USE Declare
	USE FilesModule
	USE MessageModule
	USE WindowsModule !, ONLY: LEGEND_UNIT, LAST_LEGEND_POSITION
	USE IFQWIN
	IMPLICIT NONE
	TYPE (rccoord) LAST_LEGEND_POSITION
	TYPE (qwinfo)  winfo
	integer(2) :: irow
	integer(4) :: kk100,kmd100, kkl, nkmod, kmod
	REAL :: time_begin, time_end
	integer(4) :: SETACTIVEQQresult
	logical(4) :: lplot
	integer(4) :: wresult
	
	CALL ReadParameterFile (FN_parameters)
	lplot=plotstimulus.or.plotmembrane.or.plotCochleagram.or.plotProfile
    if(lplot) then
	  IF (.NOT. ParameterFileSucceeded) &
		CALL Message (MessageText(INCORRECTPARAMETERFILE), MessageTitle(INCORRECTPARAMETERFILE)) 
	else
	    winfo%TYPE = QWIN$set
	    winfo%H = 228
	    winfo%W = 290
	    wresult =  SETWSIZEQQ(QWIN$FRAMEWINDOW, winfo)
	end if
	CALL ReadNonLinearityFile
	CALL Initialize
	CALL ReadMembraneStatus 
	CALL OpenPressureEarCanal
	IF(storeProbing) CALL OpenProbing
	IF(storeTesting) Call OpenTestOutputFile
    CALL InitializeGraphs
	lGetPhase=(storeProfile.or.Plotprofile).and. PlotPhase
    CALL CreateWindows
    CALL InitializeLegend(.FALSE.)
	IF (UseAudioFile) THEN
		CALL WaveRead (audiofilename, useLeftChannel, .TRUE.)
		CALL Resample (2d0 * ComputationalFrequency)
	ENDIF
	

	CALL CPU_TIME(time_begin)
	phi1=signal1Phase * pi
	phi2=signal2Phase * pi
	nkmod=kmax/100
	kmod =mod(kmax,100)
	DO kk100 = 0, nkmod-1
	  do kmd100=0,99
	    kk = kk100*100 + kmd100
		t = dt * kk
		if(storePressureEarCanal) CALL WritePressureEarCanal
		IF(storeProbing) CALL WriteProbing
		IF(plotMembrane .or. plotCochleagram .or. plotStimulus .or. plotPhase ) CALL PlotGraphs   !plot- of get Phase ?
		IF(lGetPhase) CALL FindPhase
		CALL RK4
	  enddo
	  CALL UpdateLegend(100 * kk / kmax)
	ENDDO
!!Note: the last block may contain different number of elements (kmod < 100)
!! hence: separate treatment for the last block
	kkl=kk+1
	DO kk=kkl,kkl+kmod
		t = dt * kk
		if(storePressureEarCanal) CALL WritePressureEarCanal
		IF(storeProbing) CALL WriteProbing
		IF(plotMembrane .or. plotCochleagram .or. plotStimulus .or. plotPhase ) CALL PlotGraphs
		IF(lgetPhase) CALL FindPhase
		CALL RK4
	ENDDO
!!now write requested final points
    if (lplot) CALL UpdateLegend(100 * kk / kmax)
	t = t + dt
	if(storePressureEarCanal) CALL WritePressureEarCanal
	IF(storeProbing) CALL WriteProbing


	CALL CPU_TIME(time_end)
	if (plotLegend) then
	 SETACTIVEQQresult = SETACTIVEQQ (LEGEND_UNIT)
	 irow=LAST_LEGEND_ROW !+ 1
	 CALL SETTEXTPOSITION (irow, int2(0), LAST_LEGEND_POSITION )
	 WRITE (LEGEND_UNIT,*) "Time: ", time_end - time_begin
    end if
    
	CALL DeInitialize (.TRUE.)

	CALL ClosePressureEarCanal
	IF(storeProbing) CALL CloseProbing
	CALL WriteMembraneStatus
	if (lGetPhase) CALL CalculatePhases
	CALL WriteProfile !! phase data included Dec '09
	if (lplot) then 
	    CALL PlotProfileGraph
	    !CALL CalculatePhases
	    CALL PlotPhaseGraph
	    CALL Rescale
!	    read(*,*)	 
  	end if
!	read(*,*)
	CALL DeInitialize (.FALSE.)
!	read(*,*)
   	SETACTIVEQQresult=SETEXITQQ(QWIN$EXITNOPERSIST)

 END PROGRAM cochlea