! Displays file dialog box to let the user select an audio file
! Checks whether selected file is correct and, when correct:
! Asks user if the total computation time should match the duration of the audio file
! Shows wave file info in dialog box

SUBROUTINE OpenAudioFileButton (dlg, id, callbacktype)

	USE Declare
	USE WaveReadModule
	USE DialogDeclare
	USE MessageModule
	USE USER32
	USE IFLOGM
	IMPLICIT NONE

	TYPE (dialog) dlg
	INTEGER id, callbacktype
	CHARACTER (127) FileName
	integer(4) :: ifunc

	CALL FileNameBox (.TRUE., .FALSE., FileName)
	IF (FileName /= "") THEN
		AudioFileName = FileName
		CALL WaveRead (AudioFileName, useLeftChannel, .FALSE.)
		IF (WaveFileErrorMessage /= "") THEN
			ifunc= MessageBox (dlg%hwnd, WaveFileErrorMessage, "Error wave file"C, MB_OK)
		ELSE
			IF (InfoMessage /= "") ifunc= MessageBox (dlg%hwnd, InfoMessage, "Info wave file"C, MB_OK)
			CALL Message (dlg%hwnd, FREQUENCYMATCH)
			i = MessageBox (dlg%hwnd, "Would you like the total computation time\nto match the duration of the audio file?"C, "Matching durations"C, MB_YESNO)
			IF (i == IDYES) THEN
				CALL SetRealToDialog (dlg_tab1, EDIT_t_max, audioFileTotalTime*1000)	
				CALL UpdateCochleagramSize(dlg_tab1, TEXT_CochleagramSize, 0)
			ENDIF
			ok = DLGSETLOG (dlg, RADIO_useAudioFile, .TRUE.)
			CALL ChangedStimulus (dlg, 0, 0)
		ENDIF
		CALL ShowWaveFileInfo (dlg)
	ENDIF

END SUBROUTINE OpenAudioFileButton