! Routine called if main dialog box is first displayed (inited) or destroyed

! If main dialog box is inited, then all except the first sub dialog boxes
! (tab pages) are hided
! If main dialog box is destroyed, then QuitMessage is posted (see
! WIN32-applications)

SUBROUTINE MainSub( dlg, id, callbacktype )

	USE DialogDeclare
	USE DFWIN
	USE IFLOGM
	IMPLICIT NONE

	TYPE (dialog) dlg
	INTEGER id, callbacktype
	INTEGER hwnd
	logical(4) :: ok

	IF (callbacktype == dlg_init) THEN
		! main dialog box is displayed for the first time

		! hide all tab pages
		hwnd = GetDlgItem(dlg.hwnd, ID_TAB)
		ok =  DlgModeless(dlg_tab1, SW_HIDE, hwnd)
		ok =  DlgModeless(dlg_tab2, SW_HIDE, hwnd)
		ok =  DlgModeless(dlg_tab3, SW_HIDE, hwnd)
		ok =  DlgModeless(dlg_tab4, SW_HIDE, hwnd)
		ok =  DlgModeless(dlg_tab5, SW_HIDE, hwnd)
		ok =  DlgModeless(dlg_tab6, SW_HIDE, hwnd)

		! show first tab page
		ok =  DLGSETINT(dlg, ID_TAB, 1, dlg_state)
	
	ELSEIF (callbacktype == dlg_destroy) THEN
		! main dialog box is destroyed
		CALL PostQuitMessage(0)
	ENDIF

END SUBROUTINE MainSub
