SUBROUTINE InitGraph (dlg)

	USE Declare
	USE DialogDeclare
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	EXTERNAL RealToString
	CHARACTER(22) RealToString
	EXTERNAL UpdateCochleagramSize
	EXTERNAL UpdateScaleOptions
	EXTERNAL UpdatePreventAliasing

	! select graphs
	CALL SetLogToDialog (dlg, CHECK_plotLegend, plotLegend)
	CALL SetLogToDialog (dlg, CHECK_plotStimulus, plotStimulus)
	CALL SetLogToDialog (dlg, CHECK_plotMembrane, plotMembrane)
	CALL SetLogToDialog (dlg, CHECK_plotCochleagram, plotCochleagram)
	CALL SetLogToDialog (dlg, CHECK_plotProfile, plotProfile)

	!graph size
	CALL SetIntegerToDialog (dlg, EDIT_plotEvery_n_points, plotEvery_n_points)
	ok = DLGSETSUB (dlg, EDIT_plotEvery_n_points, UpdateCochleagramSize)
	CALL SetIntegerToDialog (dlg, EDIT_plotEvery_t_points, plotEvery_t_points)
	ok = DLGSETSUB (dlg, EDIT_plotEvery_t_points, UpdateCochleagramSize)
	CALL SetLogToDialog (dlg, CHECK_preventAliasing, preventAliasing)
	ok = DLGSETSUB (dlg, CHECK_preventAliasing, UpdatePreventAliasing)

	!plot options
	CALL SetLogToDialog (dlg, RADIO_plotPositions, plotPositions)
	ok = DLGSETSUB (dlg, RADIO_plotPositions, UpdateScaleOptions)
	CALL SetLogToDialog (dlg, RADIO_plotVelocities,  .NOT. plotPositions)
	ok = DLGSETSUB (dlg, RADIO_plotVelocities, UpdateScaleOptions)

	CALL UpdateScaleOptions (dlg, 0, 0)

END SUBROUTINE InitGraph