SUBROUTINE InitStimulusFile (dlg)

	USE Declare
	USE DialogDeclare
	USE WaveReadModule
	USE DFLOGM
	IMPLICIT NONE
	TYPE (dialog) dlg
	EXTERNAL ChangedStimulus
	EXTERNAL OpenAudioFileButton
	EXTERNAL PlayAudioFileButton

	! Radio buttons
	IF (useAudioFile) THEN
		ok =  DLGSETLOG (dlg, RADIO_useAudioFile, .TRUE.)
	ELSE
		ok =  DLGSETLOG (dlg, RADIO_composeStimulus, .TRUE.)
	ENDIF
	ok =  DLGSETSUB (dlg, RADIO_composeStimulus, ChangedStimulus)
	ok =  DLGSETSUB (dlg, RADIO_useAudioFile, ChangedStimulus)

	IF (useLeftChannel) THEN
		ok =  DLGSETLOG (dlg, RADIO_useLeftChannel, .TRUE.)
	ELSE
		ok =  DLGSETLOG (dlg, RADIO_useRightChannel, .TRUE.)
	ENDIF
		 
	! Audiofile values
	ok =  DlgSetSub (dlg, BUTTON_OpenAudioFile, OpenAudioFileButton)
	ok =  DlgSetSub (dlg, BUTTON_play, PlayAudioFileButton)
	CALL SetRealToDialog (dlg, EDIT_audioFileLevel, audioFileLevel)

	CALL ShowWaveFileInfo (dlg)

END SUBROUTINE InitStimulusFile
