! Opens <FileName> for buffered I/O and returnd file handler in <handler>
! <FileName> must not exceed 127 characters
! If failed, WaveFileErrorMessage will be set

SUBROUTINE OpenWaveFile (FileName, handler)
	USE WaveReadModule
	USE WINMM

	IMPLICIT NONE
	CHARACTER(127), INTENT (IN) :: FileName
	TYPE (T_MMIOINFO), POINTER :: info
	INTEGER, INTENT (OUT) :: handler

	WaveFileErrorMessage = ""
	InfoMessage = ""
	NULLIFY (info)
	handler = mmioOpen(FileName, info, MMIO_READ .OR. MMIO_ALLOCBUF)
	IF (handler == NULL) WaveFileErrorMessage = FAILEDTOOPEN

END SUBROUTINE OpenWaveFile