program mkpdatLevel

IMPLICIT none
integer(4) :: i,j,ii
integer(4)  :: numfiles, numlevels=11, numphases=12
character*2 :: num, clevel
character*3 :: cph1,cph2 !, clevel 
character*3 :: cf1= '5k0', cf2 = '6k0'
character*4 :: cfreq1, cfreq2, cfreqx
integer(4), dimension(11), parameter :: levels= (/ 30,35,40,45,50,55,60,65,70,75,80/)
real(8),   dimension(2,12) :: phase   !arg 2 = numphases!!!!!

do j=1,numphases
  phase(2,j)=mod(dble(j-1)/3.d0, 2.d0)
  phase(1,j)=mod(dble(j-1)/6.d0, 2.d0)   !voor 2f1+f2: 2. -real(j-1)/6.
enddo        

cfreq1= '5000'
cfreq2= '6000'

numfiles=numlevels*numphases
print*,'er worden',numfiles,' files gemaakt'
	
do i=1,numlevels
 write(clevel,'(i2)') levels(i)
 do j=1,numphases
  write(num(1:1),'(z1)') (i-1)
  write(num(2:2),'(z1)') j
  write(cph1,'(i3)') nint(phase(1,j)*100.)
  write(cph2,'(i3)') nint(phase(2,j)*100.)
  do ii=1,3
    if(cph1(ii:ii)== ' ') cph1(ii:ii)='0'
    if(cph2(ii:ii)== ' ') cph2(ii:ii)='0'
  end do
  if(num(1:1)==' ') num(1:1)='0'
  open(10,file='pdat'//num )
  write(10,*)  '&GENERAL'
  write(10,*)  ' N                       =   400,'
  write(10,*)  ' COMPUTATIONALFREQUENCY  =   400000.000000000     ,'
  write(10,*)  ' T_MAX                   =  6.000000000000000D-002,'
  write(10,*)  ' RETRIEVEMEMBRANESTATUS  = F,'
  write(10,*)  ' STOREMEMBRANESTATUS     = F,'
  write(10,*)  ' SETTINGSDIRECTORY       = "D:\MS\Johan15\CochleaProgram\Demo" '
  write(10,*)  '/'
  write(10,*)  ' &STIMULUS'
  write(10,*)  ' ONSETDURATION   =  1.000000000000000E-002 '
  write(10,*)  ' /'
   write(10,*)  ' &SIGNAL1'
   write(10,*)  'USESIGNAL1         = T,'
   write(10,*)  'SIGNAL1FREQUENCY   = '//cfreq1//'.00000000000  ,'
!   write(10,*)  'SIGNAL1FREQUENCY   = 1000.00000000000  ,'
   write(10,*)  'SIGNAL1PHASE       = ',phase(1,j),' ,'
   write(10,*)  'SIGNAL1LEVEL       = '//clevel//'.0000000000000  '  
!   write(10,*)  'SIGNAL1LEVEL       = 45.00000000000  '  
   write(10,*)  '/'
   write(10,*)  '&SIGNAL2'
   write(10,*)  'USESIGNAL2         = T,'
   write(10,*)  'SIGNAL2FREQUENCY   = '//cfreq2//'.00000000000   ,'
   write(10,*)  'SIGNAL2PHASE       = ',phase(2,j),' ,'
   write(10,*)  'SIGNAL2LEVEL       = '//clevel//'.0000000000000  '  
!   write(10,*)  'SIGNAL2LEVEL       = 40.0000000000000     '
   write(10,*)  '/'
   write(10,*)  '&SIGNAL3'
   write(10,*)  'USESIGNAL3      = F,'
   write(10,*)  'SIGNAL3PERIOD   =  0.125000000000000     ,'
   write(10,*)  'SIGNAL3DURATION =  1.000000000000000D-004,'
   write(10,*)  'SIGNAL3LEVEL    =   60.0000000000000     '
   write(10,*)  '/'
   write(10,*)  '&AUDIOFILE'
   write(10,*)  'USEAUDIOFILE    = F,'
   write(10,*)  'USELEFTCHANNEL  = T,'
   write(10,*)  'AUDIOFILENAME   = "E:\DEMOs\Auditory demos ASA\Track 69wav.wav" ,'
   write(10,*)  'AUDIOFILELEVEL  =   80.0000000000000 '
   write(10,*)  '/'
   write(10,*)  '&COCHLEA'
   write(10,*)  'PARAMETERSET    = 1,'
   write(10,*)  'USECONSTANTQ    = F,'
   write(10,*)  'CONSTANTQ       = 20.0000000000000 ,'
   write(10,*)  'STIFFNESS       = 1,'
   write(10,*)  'DAMPING         = 3,'
   write(10,*)  'USEACTIVEDAMPING= F,'
   write(10,*)  'USEGREENWOODMAP = T,'
   write(10,*)  'USEAPEXSHORTCUT = F,'
   write(10,*)  'USEEARCANALCOUPLER = T'
   write(10,*)  '/'
   write(10,*)  '&GRAPHS'
   write(10,*)  'PLOTLEGEND      = T,'
   write(10,*)  'PLOTSTIMULUS    = F,'
   write(10,*)  'PLOTMEMBRANE    = F,'
   write(10,*)  'PLOTCOCHLEAGRAM = F,'
   write(10,*)  'PLOTPROFILE     = F,'
   write(10,*)  'PLOTEVERY_N_POINTS =  1,'
   write(10,*)  'PLOTEVERY_T_POINTS = 10,'
   write(10,*)  'PREVENTALIASING = F,'
   write(10,*)  'PLOTPOSITIONS   = F,'
   write(10,*)  'MINIMUMPOSITIONTOPLOT   = -1.8530000E-07,'
   write(10,*)  'MAXIMUMPOSITIONTOPLOT   =  1.8510001E-07,'
   write(10,*)  'MINIMUMVELOCITYTOPLOT   = -4.9430000E-06,'
   write(10,*)  'MAXIMUMVELOCITYTOPLOT   =  4.8679999E-06'
   write(10,*)  '/'
   write(10,*)  '&OUTPUT'
   write(10,*)  'OUTPUTDIRECTORY          = "output06hfL_'//clevel//'\" ,'
   write(10,*)  'STOREPRESSUREEARCANAL    = T,'
   write(10,*)  'PRESSUREEARCANALFILENAME = "pressEC-'//cf1//'-'//cf2//'-'//clevel//'-'//cph1//'-'//cph2//'.dat" ,'
   write(10,*)  'STOREPROFILE             = F,'
   write(10,*)  'PROFILEFILENAME          = "profile2-1k75G8_70.dat" ,'
   write(10,*)  'STOREPROBING             = F,'
   write(10,*)  'PROBINGFILENAME          = "probing2-1k75G8_70.dat" ,'
   write(10,*)  'STOREEXTRAINFO  = T,'
   write(10,*)  'STOREBINARY     = F,'
   write(10,*)  'PROBES  =  1,  363,  364,  384,  385,  408, 409,  800, 2*0'
   write(10,*)  '/'
  close (10)
 end do
end do

end

