function  [smootherwin, nu]= compute_smoother(kind, par)
% Designs a triangular smoothing window. 
%
%function [smootherwin, nu]= compute_smoother(kind, par)
%
% Design can be performed by given half width or DOF. 
% If kind=='WIDTH', par= M= half width
% IF kind=='DOF'  , par= nu= degrees of freedom
% For the triangular (version of M. Jachan) it holds asymptotically: nu= 3*M+1.5. 

switch(kind)
    case 'WIDTH'
        M= par;
    case 'DOF'
        if(par==2)
           M= 0;
        else
           % M= ceil((par-1.5)/3); %For version of M. Jachan
           M = floor(par/3);
        end
end

%% Triangular Window, version of M. Jachan
% N= 2*M+1;
% n= (0:N-1)';
% smootherwin= 2/N*(N/2-abs(n-(N-1)/2)); 
% smootherwin= smootherwin/sum(smootherwin);

%% Triangular Window, verion of L. Sommerlade
h = M+1;
j = -h:h;
smootherwin = (1/h)-(abs(j')/h^2); 
smootherwin = smootherwin(2:end-1);

nu= 2/sum(smootherwin.^2);% Daniel's Formula
