function [pdc,f]=pdc(x,a,fsam)

%% Calculates the Spectrum based on AR coefficients


n=length(x);
nyquist = fsam/2;
f = (1:n/2)/(n/2)*nyquist;

omega=(1:length(f))/length(f)*pi;

pdc=zeros(length(a),length(a),length(omega));

for i=1:length(a)
    for j=1:length(a)
        for k=1:length(omega)
          if i==j
            pdc(i,j,k)=1;
          end
          pdc(i,j,k)=pdc(i,j,k)-(a(i,j)*exp(sqrt(-1).*omega(k)))';
        end
    end
end

pdct=pdc;

for i=1:length(a)
    for j=1:length(a)
        for k=1:length(omega)
          pdc(i,j,k)=abs(pdct(i,j,k))./sqrt(sum(abs(pdct(i,:,k)).^2));
        end
    end
end


