function [res] = pacf(acf)

[lr,lc]=size(acf);

rest=[acf(:,1), zeros(lr,lc-1)];
d=zeros(lr,1);

ar=zeros(lr,lc-1);
rc=zeros(lr,lc-1);
        
% Durbin-Levinson Algorithm
for K=1:lc-1,
  ar(:,K) = (acf(:,K+1)-sum(ar(:,1:K-1).*acf(:,K:-1:2),2))./rest(:,K); % Yule-Walker
  rc(:,K)  = ar(:,K);
  ar(:,1:K-1)=ar(:,1:K-1)-ar(:,K*ones(K-1,1)).*ar(:,K-1:-1:1);
  rest(:,K+1) = rest(:,K).*(1-abs(ar(:,K)).^2);
end;
        
% assign output argument
res=rc;
