function  P= compute_partialized(S)
% Computes the partialized matrix of the Hermitian matrix S. 
%
%function P= compute_partialized(S)
% The upper diagonal of P corresponds to the Coherence, whilst the lower
% diagonal corresponds to the Partial Coherence. The main diagonal is the
% same as in S. 

D= size(S, 1);
n= 1./sqrt(real(diag(S)));
N= n*n';
Coh= S.*N;
R= pinv(S);
m= 1./sqrt(real(diag(R)));
M= m*m';
pCoh= R.*M;
P= triu(Coh, 1) + diag(diag(S)) + tril(pCoh, -1);

if(0)
   D= 4;
   H= randn(D)+1i*randn(D);
   S= H*H';
   R= inv(S);
   n= 1./sqrt(diag(S));
   m= 1./sqrt(diag(R));
   N= n*n';
   M= m*m';
   
   C1= S.*N;
   C2= diag(n)*S*diag(n);
   
   PC1= R.*M;
   PC2= diag(m)*R*diag(m);
   
   
end