function [spc,f]=specAR(x,a,sigma,fsam)

%% Calculates the Spectrum based on AR coefficients


n=length(x);
nyquist = fsam/2;
f = (1:n/2)/(n/2)*nyquist;

omega=(1:length(f))/length(f)*pi;

spc=ones(length(f),1);

for i=1:length(a)
   spc=spc-(a(i)*exp(sqrt(-1).*omega.*i))'; 
end

spc=sigma./2./pi./abs(spc).^2;