function [parameters,variances]=burg(X,modelorder)

[NumberofPanels N dim]=size(X);

n=NumberofPanels*N;

ForwardError=zeros(dim, n);
BackwardError=zeros(dim, n);

ForwardParameter=zeros(modelorder,dim,dim);
BackwardParameter=zeros(modelorder,dim,dim);
	
ForwardVariance=zeros(dim,dim);
BackwardVariance=zeros(dim,dim);
ReflectionMatrix=zeros(dim,dim);
ForwardSSQ=zeros(dim,dim);
CrossSSQ=zeros(dim,dim);
BackwardSSQ=zeros(dim,dim);

M1=zeros(dim,dim);
M2=zeros(dim,dim);
M3=zeros(dim,dim);
M4=zeros(dim,dim);

V1=zeros(dim,1);
V2=zeros(dim,1);

% Initialise the parameters of the algorithmus

% Compute the sample variance matrix of the vector time series 
% and initialise ForwardVariance and BackwardVariance by this matrix 


for i=1:NumberofPanels
    Sum=squeeze(X(i,:,:))'*squeeze(X(i,:,:));
    ForwardVariance=ForwardVariance+Sum/n;
	BackwardVariance=BackwardVariance+Sum/n;
    ForwardError(:,(i-1)*N+1:i*N)=squeeze(X(i,:,:))';     % Set prediction errors in model of order 0 equal to the data
    BackwardError(:,(i-1)*N+1:i*N)=squeeze(X(i,:,:))';    % Set prediction errors in model of order 0 equal to the data
end

% Fit AR(p) model iteratively 
% 
for p=1:modelorder 
  for i=1:dim
    for j=1:dim
        
% Compute sum of squares for forward and backward prediction errors

      ForwardSSQ(i,j)=0.0;
      BackwardSSQ(i,j)=0.0;
      CrossSSQ(i,j)=0.0;
      for panel=1:NumberofPanels
        Sum=0;
        for t=p+1:N
          Sum=Sum+ForwardError(i,(panel-1)*N+t)*ForwardError(j,(panel-1)*N+t);
        end
     	ForwardSSQ(i,j)=ForwardSSQ(i,j)+Sum;
 		Sum=0;			
        for t=1:N-p
          Sum=Sum+BackwardError(i,(panel-1)*N+t)*BackwardError(j,(panel-1)*N+t);
        end
        BackwardSSQ(i,j)=BackwardSSQ(i,j)+Sum;

% Compute cross product of forward and backward prediction errors */

        Sum=0.0;
        for t=p+1:N
          Sum=Sum+ForwardError(i,(panel-1)*N+t)*BackwardError(j,(panel-1)*N+t-p);
        end
        CrossSSQ(i,j)=CrossSSQ(i,j)+Sum;
      end
      ForwardSSQ(i,j)=ForwardSSQ(i,j)/NumberofPanels;
      BackwardSSQ(i,j)=BackwardSSQ(i,j)/NumberofPanels;
      CrossSSQ(i,j)=CrossSSQ(i,j)/NumberofPanels;
    end
  end

% 

  M1 = chol(ForwardSSQ,'lower');
  M2=inv(M1)*CrossSSQ;
 
  M1 = chol(BackwardSSQ,'lower');
  ReflectionMatrix=M2*inv(M1);
 
% Compute update of parameter matrices
 
  M1 = chol(ForwardVariance,'lower');
  M2 = chol(BackwardVariance,'lower');
 
  M3=M1*ReflectionMatrix;
  M4=M2*transpose(ReflectionMatrix);
 
  M1=inv(M1);
  M2=inv(M2);
 
  ForwardParameter(p,:,:)=M3*M2;
  BackwardParameter(p,:,:)=M4*M1;
 
% Compute update of backward and forward innovation covariances
 
  M1=eye(dim);
  M2=squeeze(ForwardParameter(p,:,:))*squeeze(BackwardParameter(p,:,:));
  M1=M1-M2;
  ForwardVariance=M1*ForwardVariance;
 
  M1=eye(dim);
  M2=squeeze(BackwardParameter(p,:,:))*squeeze(ForwardParameter(p,:,:));
  M1=M1-M2;
  BackwardVariance=M2*BackwardVariance;
 
% Compute update of parameter matrices for indices less than p
 
  for j=0:p-2
    M1=squeeze(ForwardParameter(p,:,:))*squeeze(BackwardParameter(p-j-1,:,:));
 	M2=squeeze(BackwardParameter(p,:,:))*squeeze(ForwardParameter(j+1,:,:));
    ForwardParameter(j+1,:,:)=squeeze(ForwardParameter(j+1,:,:))-M1;
 	BackwardParameter(p-j-1,:,:)=squeeze(BackwardParameter(p-j-1,:,:))-M2;
  end

% Compute update of forward and backward prediction errors
  
  if p<modelorder
    for panel=1:NumberofPanels
      for t=p+1:N
        for i=1:dim
          Sum=0.0;
          for j=1:dim
            Sum=Sum+squeeze(ForwardParameter(p,i,j))*BackwardError(j,(panel-1)*N+t-p);
          end
 		  V1(i)=Sum;
        end
 
        for i=1:dim
          Sum=0;
          for j=1:dim
            Sum=Sum+squeeze(BackwardParameter(p,i,j))*ForwardError(j,(panel-1)*N+t);
          end
 		  V2(i)=Sum;
        end
        for i=1:dim
          ForwardError(i,(panel-1)*N+t)=ForwardError(i,(panel-1)*N+t)-V1(i);
          BackwardError(i,(panel-1)*N+t-p)=BackwardError(i,(panel-1)*N+t-p)-V2(i);
 		end		
      end 			
    end 		 
      
  end
  

end


parameters=ForwardParameter;
variances.native=ForwardVariance;