function  [taperwin, nu]= compute_taper(t, tapertype, taperparameter, N, Fs)
% Computes a taper for arbitrary time points as needed for point processes.
% 
%function [taperwin, nu]= compute_taper(t, tapertype, taperparameter, N, Fs)

T= N/Fs;
taperwin= ones(length(t), 1);
switch(tapertype)
   case 'none'
      taperwin= taperwin(:);
   case 'raisedcosine'
      % Taper roll-off
      taperwin= 1/sqrt(1-5/2*taperparameter)*taperwin;
      rolloff= T*taperparameter;
      Tup= t(t<2*rolloff);
      taperwin(t<2*rolloff)  = 1/sqrt(1-5/2*taperparameter)*(1-cos(pi/(2*rolloff)*Tup))/2;
      Tdo= t(t>T-2*rolloff);
      taperwin(t>T-2*rolloff)= 1/sqrt(1-5/2*taperparameter)*(1-cos(pi/(2*rolloff)*Tdo))/2;
   case 'triangular'
      Tup= t(t<T/2);
      taperwin(t<T/2)= sqrt(3)*Tup/(T/2);
      Tdo= t(t>=T/2);
      taperwin(t>=T/2)= sqrt(3)*(2-Tdo/(T/2));
end%switch(tapertype)

taperwin= taperwin(:);
% Normalize taperwin
%taperenergy= sum(taperwin.*taperwin);
%taperwin= taperwin/sqrt(taperenergy/N);


nu= sum(taperwin.^2)^2/(sum(taperwin.^4))/N;
