% fft --> LPF and HPF
% Apurba Das
% 31/05/2011

[filename, pathname] = uigetfile({'*.bmp';}, 'Brows Image');
file=cat(2,pathname,filename);
a=imread(file);
if size(a,3)==3
    a=rgb2gray(a);
end
[ri ci]=size(a);
figure(1)
subplot(221)
imshow(a);
title('Original Image');
f1=fft2(a);
f2=fftshift(f1);
subplot(222)
f22=abs(f2);
% imshow(abs(f2),[ min(min(f22)) max(max(f22))]);
imshow(f2)
title('2D DFT of the original image');
% surf(f2)
f11=abs(ifft2(f1));
% f11=abs(ifft2(f2));
subplot(223)
imshow(f2)
title('2D DFT of the original image');
subplot(224)
imshow(f11,[ min(min(f11)) max(max(f11))]);
title('IDFT of the 2D DFT');
%%

% pause,
figure;
mask=fspecial('disk',10);
[rm cm]=size(mask);
rm=rm-1;cm=cm-1;
mask1=mask./max(max(mask));
mm=zeros(ri,ci);
mm(((ri/2)-(rm/2)):((ri/2)+(rm/2)),((ci/2)-(cm/2)):((ci/2)+(cm/2)))=mask1;

lp=f2.*mm;
% lp=imfilter(f2,mask);
subplot(221)
imshow(lp);
title('Center on Trancated 2D DFT');
lp1=abs(ifft2(lp));
% f11=abs(ifft2(f2));
subplot(222)
imshow(lp1,[ min(min(lp1)) max(max(lp1))]);
title('Low pass filtered image');

mm1=ones(ri,ci)-mm;
hp=f2.*mm1;
% lp=imfilter(f2,mask);
subplot(223)
imshow(hp);
title('Center off Trancated 2D DFT');
hp1=abs(ifft2(hp));
% f11=abs(ifft2(f2));
subplot(224)
imshow(hp1,[ min(min(hp1)) max(max(hp1))]);
title('High pass filtered image');


