% Wavelet series
% Apurba Das (03-Dec-2011)

clear all;
close all;
clc;

x=0:1/100:1-0.01;
f=x.^2;
subplot(421);
axis([0 1 -0.5 1]);hold on;
plot(x,f,'k');
title('The given function')
ylabel('f(x)-->')
xlabel('(a)');
grid on;
subplot(422);
axis([0 1 -0.5 1]);hold on;
sc_00=(1/3)*ones(1,size(x,2));
plot(x,sc_00,'k');
title('V_0')
ylabel('(1/3) \phi_{0,0}(x)-->')
xlabel('(b)');
grid on;
subplot(423);
axis([0 1 -0.5 1]);hold on;
wlet_00=[ones(1,size(x,2)/2) -ones(1,size(x,2)/2)];
r_wlet_00=-0.25*wlet_00;
plot(x,r_wlet_00,'k');
title('W_0')
ylabel('-(1/4) \psi_{0,0}(x)-->')
xlabel('(c)');
grid on;
subplot(424);
axis([0 1 -0.5 1]);hold on;
v1=r_wlet_00+sc_00;
plot(x,v1,'k');
title('V_1');
xlabel('(d)');
ylabel('V_0+W_0');
grid;
subplot(425);
axis([0 1 -0.5 0.5]);hold on;
wlet_10=(1/(2^0.5))*[ones(1,size(x,2)/4) -ones(1,size(x,2)/4) -zeros(1,size(x,2)/2)];
r_wlet_10=-((2^0.5)/32)*wlet_10;
plot(x,r_wlet_10,'k');
title('K_1 * \psi_{1,0}(x)-->')
xlabel('(e)');
grid;
subplot(426);
axis([0 1 -0.5 0.5]);hold on;
r_wlet_11= -(3*(2^0.5)/32)*[zeros(1,size(x,2)/2) ones(1,size(x,2)/4) -ones(1,size(x,2)/4) ];
plot(x,r_wlet_11,'k');
title('K_2 * \psi_{1,1}(x)-->')
xlabel('(f)');

grid;
subplot(427)
w1=r_wlet_10+r_wlet_11;
axis([0 1 -0.5 0.5]);hold on;
plot(x,w1,'k');
title('W_1=K_1*\psi_{1,0}(x)+K_1*\psi_{1,1}(x)');
% title('K1 * \psi_{1,0}(x)-->')
xlabel('(g)');
grid on;
subplot(428)
axis([0 1 -0.5 1]);hold on;
w2=w1+v1;
plot(x,w2,'k');
ylabel('W_1+V_1');
title('V_2');
xlabel('(h)');
grid on;