% Example of LSB Steganography --> Transmiter
% Apurba Das (18-DEC-11)
clc;
clear all;
close all;
[file path] = uigetfile('*.bmp','Browse the Cover file');
f = cat(2,path,file);
c = imread(f);
subplot(211)
imshow(c)
title('Cover image');
[ro_c co_c seg] = size(c);

[file path] = uigetfile('*.bmp','Browse the Secret file');
f = cat(2,path,file);
m = imread(f);
[ro_m co_m seg] = size(m);
for seg=1:3
    if rem(c(1:ro_m*8,1:co_m*8,seg),2)~=0
        c(1:ro_m*8,1:co_m*8,1) = c(1:ro_m*8,1:co_m*8,1)-1;
    end
end
r_c = c(:,:,1);
g_c = c(:,:,2);
b_c = c(:,:,3);

m_r = m(:,:,1);
m_g = m(:,:,2);
m_b = m(:,:,3);

if (ro_m*8 > ro_c) || (co_m*8+16 > co_c)
    error('The cover file size is insufficient !! ');
end

% for i=1:3
%     ind = cat(2,'M.seg',num2str(i));
%     Ind = cat(2,'M',ind);
M = zeros(ro_m*co_m*8,3);
M1 = M;
% R = str2num(dec2bin(ro_m,8));
% C = str2num(dec2bin(co_m,8));
% SIZE = cat(2,R,C);
for seg=1:3
   
    
    s1 = dec2bin(m(:,:,seg),8);
    s2 = str2num(s1(:));
    M(:,seg) = s2;
%     s = cat(2,str2num(dec2bin(m(:,:,seg),8)));
%     M(:,seg) = s(:);
%     M1(:,seg) = str2num(cat(2,red(:,seg)));
end
    
%     M_r = dec2bin(m(:,:,seg),8);
%     M_r_cat = str2num(cat(2,M_r(:)));
for seg = 1:3
    k = 1;
    for i=1:ro_m
        for j=1:co_m*8
            bitset(c(i,j,seg),1) = M(k,seg);
            k=k+1;           
        end
    end
end
% SZ = str2num(SIZE);

for i=1:8
    if rem(c(1,co_c-16+i,1),2) ~= 0 
        if bitget(ro_m,i) == 0
            c(1,co_c-16+i,1) = c(1,co_c-16+i,1)-1;
        end
    else
        if bitget(ro_m,i) == 1
            c(1,co_c-16+i,1) = c(1,co_c-16+i,1)+1;
        end
    end
    if rem(c(1,co_c-8+i,1),2) ~= 0 
        if bitget(co_m,i) == 0
            c(1,co_c-8+i,1) = c(1,co_c-8+i,1)-1;
        end
    else
        if bitget(co_m,i) == 1
            c(1,co_c-8+i,1) = c(1,co_c-8+i,1)+1;
        end
    end
end

S = bitget(c(1,co_c:-1:co_c-15),1)
imwrite(c,'Stego.bmp','bmp');

subplot(212)
imshow(c)
title('Stego (image within image) image');

        
        
% bitset(r_c,1);
% bitget


