/*
 * Decompiled with CFR 0.152.
 */
package animBeans;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnimBean2
extends JPanel
implements ActionListener {
    private ImageIcon[] image;
    private String imageName = "juggler";
    private String oldImage = "juggler";
    private int numFrames;
    private int oldNumFrames = 0;
    private int currentImage = 0;
    private int delay = 100;
    private Timer animTimer;

    public static void main(String[] stringArray) {
        AnimBean2 animBean2 = new AnimBean2();
        animBean2.setVisible(true);
    }

    public AnimBean2() {
        this.loadFrames();
        this.animTimer = new Timer(this.delay, this);
        this.animTimer.start();
    }

    private void loadFrames() {
        this.numFrames = 0;
        File file = new File(this.imageName + this.numFrames + ".gif");
        while (file.exists()) {
            ++this.numFrames;
            file = new File(this.imageName + this.numFrames + ".gif");
        }
        if (this.numFrames == 0) {
            return;
        }
        this.image = new ImageIcon[this.numFrames];
        for (int i = 0; i < this.numFrames; ++i) {
            this.image[i] = new ImageIcon(this.imageName + i + ".gif");
        }
    }

    public void paint(Graphics graphics) {
        if (!this.imageName.equals(this.oldImage)) {
            this.loadFrames();
            if (this.numFrames == 0) {
                this.setImageName(this.oldImage);
                this.numFrames = this.oldNumFrames;
            } else {
                this.oldImage = this.imageName;
                this.oldNumFrames = this.numFrames;
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.currentImage = 0;
            }
        }
        if (this.numFrames > 0) {
            this.image[this.currentImage].paintIcon(this, graphics, 0, 0);
            this.currentImage = (this.currentImage + 1) % this.numFrames;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) {
        this.imageName = string;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
        this.animTimer.setDelay(this.delay);
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 120);
    }
}

