/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    int nsamples = 16384;
    double samplerate = 44100.0;
    double frequency = 1000.0;
    double omega = 2.0 * this.frequency * Math.PI;
    double signal_amplitude = 50.0;
    double noise_amplitude = 50.0;
    int cutoff = 100;
    int selector;
    int selectorn;
    double[] data;
    double[] RealIn;
    double[] ImagIn;
    double[] RealOut;
    double[] ImagOut;
    double[] RealF;
    double[] ImagF;
    double[][] spect;
    double[][] filt;
    private JSlider cutoffs;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider noises;
    private JSlider signals;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.data = new double[this.nsamples];
        this.noises.setValue((int)this.noise_amplitude);
        this.signals.setValue((int)this.signal_amplitude);
        this.RealIn = new double[this.nsamples];
        this.ImagIn = new double[this.nsamples];
        this.RealOut = new double[this.nsamples];
        this.ImagOut = new double[this.nsamples];
        this.RealF = new double[this.nsamples];
        this.ImagF = new double[this.nsamples];
        this.spect = new double[this.nsamples][2];
        this.filt = new double[this.nsamples][2];
        this.initialize();
        this.noise();
        this.spectrum();
        this.filterweak();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.noises = new JSlider();
        this.signals = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.cutoffs = new JSlider();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 378, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 533, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.noises.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.noisesMouseDragged(evt);
            }
        });
        this.signals.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.signalsMouseDragged(evt);
            }
        });
        this.jLabel1.setText("signal");
        this.jLabel3.setText("noise");
        this.jLabel2.setText("cutoff");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"mono", "double", "rectangle"}));
        this.jComboBox1.setMaximumSize(new Dimension(78, 23));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"discrete", "constant", "Gaussian"}));
        this.jComboBox2.setMaximumSize(new Dimension(78, 23));
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.cutoffs.setMaximum(200);
        this.cutoffs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NewJApplet.this.cutoffsMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                NewJApplet.this.cutoffsMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.cutoffsMouseReleased(evt);
            }
        });
        this.cutoffs.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.cutoffsMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                NewJApplet.this.cutoffsMouseMoved(evt);
            }
        });
        this.cutoffs.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewJApplet.this.cutoffsPropertyChange(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cutoffs, -2, 147, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(62, 62, 62).addComponent(this.jLabel2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.jLabel1)).addGroup(jPanel2Layout.createSequentialGroup().addGap(63, 63, 63).addComponent(this.jLabel3)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.noises, -2, 147, -2).addComponent(this.jComboBox2, -2, 132, -2))).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.signals, -2, 150, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jComboBox1, -2, 131, -2))).addContainerGap(58, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signals, -2, 36, -2).addGap(26, 26, 26).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noises, -2, -1, -2).addGap(57, 57, 57).addComponent(this.jLabel2).addGap(4, 4, 4).addComponent(this.cutoffs, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel4.setText("black = input");
        this.jLabel5.setText("red = Fourier spectrum");
        this.jLabel6.setText("blue = output");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addContainerGap(27, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(36, 36, 36).addComponent(this.jLabel4).addGap(36, 36, 36).addComponent(this.jLabel5).addGap(36, 36, 36).addComponent(this.jLabel6)).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void noise() {
        for (int i = 0; i < this.nsamples; ++i) {
            double x = (double)i / this.samplerate;
            double y = 0.0;
            switch (this.selector) {
                case 0: {
                    y = Math.sin(this.omega * x) * this.signal_amplitude;
                    break;
                }
                case 1: {
                    y = Math.sin(this.omega * x) * this.signal_amplitude + Math.sin(2.5 * this.omega * x) * this.signal_amplitude * 0.2;
                    break;
                }
                case 2: {
                    y = Math.signum(Math.sin(this.omega * x)) * this.signal_amplitude;
                }
            }
            switch (this.selectorn) {
                case 0: {
                    y += Math.signum(2.0 * Math.random() - 1.0) * this.noise_amplitude;
                    break;
                }
                case 1: {
                    y += this.noise_amplitude * (2.0 * Math.random() - 1.0);
                    break;
                }
                case 2: {
                    y += this.noise_amplitude * this.randgauss();
                }
            }
            this.data[i] = y;
        }
    }

    public boolean IsPowerOfTwo(int x) {
        int y = 2;
        for (int i = 1; i <= 15; ++i) {
            if (x == y) {
                return true;
            }
            y <<= 1;
        }
        return false;
    }

    public int NumberOfBitsNeeded(int PowerOfTwo) {
        int i1 = 0;
        for (int i = 0; i <= 16; ++i) {
            if ((PowerOfTwo & 1 << i) == 0) continue;
            i1 = i;
        }
        return i1;
    }

    public int ReverseBits(int index, int NumBits) {
        int rev = 0;
        for (int i = 0; i < NumBits; ++i) {
            rev = rev << 1 | index & 1;
            index >>= 1;
        }
        return rev;
    }

    void FourierTransform(double AngleNumerator, int nsamples, double[] RealIn, double[] ImagIn, double[] RealOut, double[] ImagOut) {
        int j;
        int i;
        int NumBits = this.NumberOfBitsNeeded(nsamples);
        for (i = 0; i < nsamples; ++i) {
            j = this.ReverseBits(i, NumBits);
            RealOut[j] = RealIn[i];
            ImagOut[j] = ImagIn[i];
        }
        int BlockEnd = 1;
        for (int BlockSize = 2; BlockSize <= nsamples; BlockSize <<= 1) {
            double delta_angle = AngleNumerator / (double)BlockSize;
            double alpha = Math.sin(0.5 * delta_angle);
            alpha = 2.0 * alpha * alpha;
            double beta = Math.sin(delta_angle);
            for (i = 0; i < nsamples; i += BlockSize) {
                double ar = 1.0;
                double ai = 0.0;
                j = i;
                for (int n = 0; n < BlockEnd; ++n) {
                    int k = j + BlockEnd;
                    double tr = ar * RealOut[k] - ai * ImagOut[k];
                    double ti = ar * ImagOut[k] + ai * RealOut[k];
                    RealOut[k] = RealOut[j] - tr;
                    ImagOut[k] = ImagOut[j] - ti;
                    int n2 = j;
                    RealOut[n2] = RealOut[n2] + tr;
                    int n3 = j++;
                    ImagOut[n3] = ImagOut[n3] + ti;
                    double delta_ar = alpha * ar + beta * ai;
                    ai += beta * ar - alpha * ai;
                    ar -= delta_ar;
                }
            }
            BlockEnd = BlockSize;
        }
    }

    void fft(int nsamples, double[] RealIn, double[] ImagIn, double[] RealOut, double[] ImagOut) {
        this.FourierTransform(Math.PI * 2, nsamples, RealIn, ImagIn, RealOut, ImagOut);
    }

    void ifft(int nsamples, double[] RealIn, double[] ImagIn, double[] RealOut, double[] ImagOut) {
        this.FourierTransform(Math.PI * -2, nsamples, RealIn, ImagIn, RealOut, ImagOut);
        int i = 0;
        while (i < nsamples) {
            int n = i;
            RealOut[n] = RealOut[n] / (double)nsamples;
            int n2 = i++;
            ImagOut[n2] = ImagOut[n2] / (double)nsamples;
        }
    }

    public void spectrum() {
        double x;
        int i;
        for (i = 0; i < this.nsamples; ++i) {
            this.RealIn[i] = this.data[i];
            this.ImagIn[i] = 0.0;
        }
        this.fft(this.nsamples, this.RealIn, this.ImagIn, this.RealOut, this.ImagOut);
        for (i = this.nsamples / 2 + 1; i < this.nsamples; ++i) {
            this.spect[i][0] = x = (double)(i - this.nsamples) * this.samplerate / (double)this.nsamples;
            this.spect[i][1] = Math.sqrt(this.RealOut[i] * this.RealOut[i] + this.ImagOut[i] * this.ImagOut[i]);
        }
        for (i = 0; i < this.nsamples / 2; ++i) {
            this.spect[i][0] = x = (double)i * this.samplerate / (double)this.nsamples;
            this.spect[i][1] = Math.sqrt(this.RealOut[i] * this.RealOut[i] + this.ImagOut[i] * this.ImagOut[i]);
        }
    }

    public void filterweak() {
        int i;
        for (i = 0; i < this.nsamples; ++i) {
            double re = this.RealOut[i];
            double im = this.ImagOut[i];
            double y = Math.sqrt(re * re + im * im);
            if (y < (double)(this.cutoff * this.cutoff * 5)) {
                this.RealF[i] = 0.0;
                this.ImagF[i] = 0.0;
                continue;
            }
            this.RealF[i] = this.RealOut[i];
            this.ImagF[i] = this.ImagOut[i];
        }
        this.ifft(this.nsamples, this.RealF, this.ImagF, this.RealIn, this.ImagIn);
        for (i = 0; i < this.nsamples; ++i) {
            double x;
            this.filt[i][0] = x = (double)i / this.samplerate;
            this.filt[i][1] = this.RealIn[i];
        }
    }

    public double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    void initialize() {
        for (int i = 0; i < this.nsamples; ++i) {
            this.spect[i][0] = i;
            this.spect[i][1] = 0.0;
            this.filt[i][0] = i;
            this.filt[i][1] = 0.0;
            this.cutoffs.setValue(this.cutoff);
        }
    }

    private void cutoffsPropertyChange(PropertyChangeEvent evt) {
    }

    private void cutoffsMouseReleased(MouseEvent evt) {
    }

    private void cutoffsMousePressed(MouseEvent evt) {
    }

    private void cutoffsMouseClicked(MouseEvent evt) {
    }

    private void cutoffsMouseMoved(MouseEvent evt) {
    }

    private void cutoffsMouseDragged(MouseEvent evt) {
        this.cutoff = this.cutoffs.getValue();
        this.filterweak();
        this.jPanel1.repaint();
    }

    private void signalsMouseDragged(MouseEvent evt) {
        this.noise_amplitude = this.noises.getValue();
        this.signal_amplitude = this.signals.getValue();
        this.cutoff = this.cutoffs.getValue();
        this.initialize();
        this.noise();
        this.spectrum();
        this.filterweak();
        this.jPanel1.repaint();
    }

    private void noisesMouseDragged(MouseEvent evt) {
        this.noise_amplitude = this.noises.getValue();
        this.signal_amplitude = this.signals.getValue();
        this.cutoff = this.cutoffs.getValue();
        this.initialize();
        this.noise();
        this.spectrum();
        this.filterweak();
        this.jPanel1.repaint();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.selector = this.jComboBox1.getSelectedIndex();
        this.initialize();
        this.noise();
        this.spectrum();
        this.filterweak();
        this.jPanel1.repaint();
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.selectorn = this.jComboBox2.getSelectedIndex();
        this.initialize();
        this.noise();
        this.spectrum();
        this.filterweak();
        this.jPanel1.repaint();
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;

        void iterate() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.black);
            this.i = 0;
            while (this.i < 500) {
                this.iy0 = (int)(100.0 - NewJApplet.this.data[this.i + 500] * 0.5);
                this.iy1 = (int)(100.0 - NewJApplet.this.data[this.i + 501] * 0.5);
                g.drawLine(this.i, this.iy0, this.i + 1, this.iy1);
                ++this.i;
            }
            g.setColor(Color.red);
            this.i = 0;
            while (this.i < NewJApplet.this.nsamples) {
                this.ix0 = (int)(NewJApplet.this.spect[this.i][0] / 40.0 + 200.0);
                this.iy0 = (int)(NewJApplet.this.spect[this.i][1] / 2000.0);
                g.drawLine(this.ix0, 400, this.ix0, 400 - this.iy0);
                ++this.i;
            }
            g.setColor(Color.green);
            g.drawLine(1, 400 - NewJApplet.this.cutoff * NewJApplet.this.cutoff / 400, 500, 400 - NewJApplet.this.cutoff * NewJApplet.this.cutoff / 400);
            g.setColor(Color.blue);
            this.i = 0;
            while (this.i < 500) {
                this.ix0 = this.i;
                this.ix1 = this.i + 1;
                this.iy0 = (int)(NewJApplet.this.filt[this.i + 500][1] * 0.5);
                this.iy1 = (int)(NewJApplet.this.filt[this.i + 501][1] * 0.5);
                g.drawLine(this.ix0, 450 - this.iy0, this.ix1, 450 - this.iy1);
                ++this.i;
            }
        }
    }
}

