/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements Runnable,
ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int N = 200;
    int MAXITER = 200;
    double J = 1.0;
    int NSQ = 40000;
    int[][] Lattice;
    double kT;
    double magav;
    int Npoints;
    int magsum;
    int done;
    int number_samples;
    char[] message;
    char cc;
    int i;
    int j;
    int iter;
    int Spin;
    double DE;
    double r;
    double[] Analytical;
    int count = 0;
    int loops = 20000;
    int ixo = 0;
    int iyo = 0;
    private JLabel averlab;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel12;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSlider jSlider1;
    private JLabel maglab;
    private JLabel nsamplab;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("0.000");
        this.image = new BufferedImage(200, 120, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 200, 120);
        this.Lattice = new int[this.N][this.N];
        this.Analytical = new double[100];
        this.Analytical[0] = 1.0;
        this.i = 1;
        while (this.i < 100) {
            double x = (double)this.i * 0.05;
            this.Analytical[this.i] = x > 2.27 ? 0.0 : Math.pow(1.0 - Math.pow(Math.sinh(2.0 * this.J / x), -4.0), 0.125);
            ++this.i;
        }
        this.reset_all();
    }

    public void run() {
        while (Thread.currentThread() == this.calculatorThread) {
            this.Metropolis();
        }
    }

    public void start() {
        if (this.calculatorThread == null) {
            this.calculatorThread = new Thread(this);
            this.calculatorThread.start();
        }
    }

    public void stop() {
        this.calculatorThread = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.count >= this.loops) {
            return;
        }
        this.timer.setInitialDelay(20);
        this.timer.setDelay(20);
        this.timer.restart();
    }

    public void reset_all() {
        this.i = 0;
        this.j = 0;
        this.count = 0;
        this.kT = 2.0;
        this.jLabel12.setText("kT=" + this.df1.format(this.kT));
        this.jSlider1.setValue((int)(this.kT * 40.0));
        this.RandomSpin();
        this.ClearAverage();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.maglab = new JLabel();
        this.nsamplab = new JLabel();
        this.averlab = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setDoubleBuffered(false);
        this.jPanel1.setMaximumSize(new Dimension(350, 550));
        this.jPanel1.setMinimumSize(new Dimension(350, 550));
        this.jPanel1.setPreferredSize(new Dimension(350, 550));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(120, 550));
        this.jPanel2.setMinimumSize(new Dimension(120, 550));
        this.jPanel2.setPreferredSize(new Dimension(120, 550));
        this.maglab.setText("magn");
        this.nsamplab.setText("nsampl");
        this.averlab.setText("Average");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.averlab).addComponent(this.nsamplab).addComponent(this.maglab)).addContainerGap(100, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(71, 71, 71).addComponent(this.nsamplab).addGap(38, 38, 38).addComponent(this.maglab).addGap(31, 31, 31).addComponent(this.averlab).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 550));
        this.jPanel3.setMinimumSize(new Dimension(0, 550));
        this.jLabel12.setText("jLabel1");
        this.jSlider1.setMaximum(200);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jButton1.setText("Reset av");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Restart");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("all up");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("randomize");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton2, -2, 125, -2).addComponent(this.jButton1, -2, 125, -2).addComponent(this.jButton4, -2, 125, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addGap(53, 53, 53).addComponent(this.jLabel12)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jSlider1, -1, 125, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton3, -1, -1, Short.MAX_VALUE)))).addContainerGap(24, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButton3).addGap(18, 18, 18).addComponent(this.jButton4).addGap(40, 40, 40).addComponent(this.jButton1).addGap(81, 81, 81).addComponent(this.jButton2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 256, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(501, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, 446, Short.MAX_VALUE).addComponent(this.jPanel2, 0, 446, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, 446, -2)).addGap(329, 329, 329)));
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.kT = (double)this.jSlider1.getValue() * 0.025;
        this.jLabel12.setText("kT=" + this.df1.format(this.kT));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.ClearAverage();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.reset_all();
        this.jPanel1.repaint();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.stop();
        this.AllUp();
        this.start();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.RandomSpin();
    }

    void AllUp() {
        Graphics g = this.jPanel1.getGraphics();
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.Lattice[i][j] = 1;
                g.setColor(Color.red);
                g.drawLine(i + 2, j + 2, i + 2, j + 2);
            }
        }
    }

    void RandomSpin() {
        Graphics g = this.jPanel1.getGraphics();
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                double r = Math.random();
                this.Lattice[i][j] = r < 0.5 ? -1 : 1;
                if (this.Lattice[i][j] > 0) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.drawLine(i + 2, j + 2, i + 2, j + 2);
            }
        }
    }

    double Energy(int i, int j, int Spin) {
        int left = j == 0 ? this.N - 1 : j - 1;
        int right = j == this.N - 1 ? 0 : j + 1;
        int top = i == 0 ? this.N - 1 : i - 1;
        int bottom = i == this.N - 1 ? 0 : i + 1;
        return -2.0 * this.J * (double)Spin * (double)(this.Lattice[i][left] + this.Lattice[i][right] + this.Lattice[top][j] + this.Lattice[bottom][j]);
    }

    void Metropolis() {
        int j;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        for (i = 0; i < this.N; ++i) {
            for (j = 0; j < this.N; ++j) {
                this.Spin = this.Lattice[i][j] < 1 ? 1 : -1;
                this.DE = this.Energy(i, j, this.Spin);
                if (this.DE < 0.0) {
                    this.Lattice[i][j] = this.Spin;
                    if (this.Spin > 0) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawLine(i + 2, j + 2, i + 2, j + 2);
                    continue;
                }
                this.r = Math.random();
                if (!(Math.exp(-this.DE / this.kT) > this.r)) continue;
                this.Lattice[i][j] = this.Spin;
                if (this.Spin > 0) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.drawLine(i + 2, j + 2, i + 2, j + 2);
            }
        }
        ++this.number_samples;
        this.magsum = 0;
        for (i = 0; i < this.N; ++i) {
            for (j = 0; j < this.N; ++j) {
                this.magsum += this.Lattice[i][j];
            }
        }
        this.magav += (double)this.magsum;
        this.nsamplab.setText("samples=" + this.number_samples);
        this.averlab.setText("average=" + this.df1.format(this.magav / (double)this.number_samples));
        this.maglab.setText("M=" + this.df1.format(this.magsum));
        this.gb.clearRect(0, 0, 200, 120);
        this.gb.setColor(Color.red);
        int ix = (int)(this.kT * 40.0) + 2;
        int iy = 110 - (int)(100.0 * Math.abs(this.magav) / (double)(this.N * this.N * this.number_samples));
        this.gb.drawOval(ix - 5, iy - 5, 10, 10);
        this.gb.setColor(Color.black);
        for (ix = 1; ix < 100; ++ix) {
            this.gb.drawLine(2 * (ix - 1), 110 - (int)(100.0 * this.Analytical[ix - 1]), 2 * ix, 110 - (int)(100.0 * this.Analytical[ix]));
        }
        g2.drawImage((Image)this.image, 0, 250, null);
    }

    void ClearAverage() {
        this.magav = 0.0;
        this.number_samples = 0;
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            NewJApplet.this.stop();
            for (int i = 0; i < NewJApplet.this.N; ++i) {
                for (int j = 0; j < NewJApplet.this.N; ++j) {
                    if (NewJApplet.this.Lattice[i][j] > 0) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawLine(i + 2, j + 2, i + 2, j + 2);
                }
            }
            g2.drawImage((Image)NewJApplet.this.image, 0, 250, null);
            g2.setColor(Color.black);
            g2.drawString("kT", 180, 380);
            g2.drawString("average magnetisation", 0, 240);
            NewJApplet.this.start();
        }
    }
}

