/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultCaret;

public class NewJApplet
extends JApplet
implements Runnable {
    volatile Thread calculatorThread;
    int funcsel = 0;
    int methsel = 0;
    double x1;
    double x2;
    double eps = 1.0E-20;
    int nmax = 500;
    int nsteps = 0;
    int nplot = 250;
    int[] ixp;
    int[] iyp;
    double[] xap;
    double[] yap;
    Graphics2D gb;
    BufferedImage image;
    DecimalFormat df;
    DecimalFormat df2;
    DecimalFormat df3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JTextArea jTextArea1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.stop();
        this.ixp = new int[this.nplot];
        this.iyp = new int[this.nplot];
        this.xap = new double[this.nmax];
        this.yap = new double[this.nmax];
        this.df = new DecimalFormat("##0.00");
        this.df2 = new DecimalFormat("0.00E00");
        this.df3 = new DecimalFormat("#0.0000000000");
        this.x1 = (double)this.jSlider1.getValue() * 0.04 - 2.0;
        this.x2 = (double)this.jSlider2.getValue() * 0.04 - 2.0;
        this.jList1.setSelectedIndex(0);
        DefaultCaret caret = (DefaultCaret)this.jTextArea1.getCaret();
        caret.setUpdatePolicy(2);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.image = new BufferedImage(510, 410, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 510, 410);
    }

    public void run() {
        if (Thread.currentThread() == this.calculatorThread) {
            double x1_l = this.x1;
            double x2_l = this.x2;
            double eps_l = this.eps;
            this.nsteps = 0;
            this.draw_new();
            switch (this.methsel) {
                case 0: {
                    this.bisection(x1_l, x2_l, eps_l);
                    break;
                }
                case 1: {
                    this.Dekker(x1_l, x2_l, eps_l);
                    break;
                }
                case 2: {
                    this.Brent(x1_l, x2_l, eps_l);
                    break;
                }
                case 3: {
                    this.Chandrupatla(x1_l, x2_l, eps_l);
                    break;
                }
                case 4: {
                    this.regulaf(x1_l, x2_l, eps_l);
                    break;
                }
                case 5: {
                    this.newton(x1_l, eps_l);
                    break;
                }
            }
        }
    }

    public void start() {
        if (this.calculatorThread == null) {
            this.calculatorThread = new Thread(this);
            this.calculatorThread.start();
        }
    }

    public void stop() {
        Thread tmpBlinker = this.calculatorThread;
        this.calculatorThread = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 510, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 404, Short.MAX_VALUE));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"x-2", "x^2-2", "x^3-2", "x^4-2", "5*sin(5x)", "cos^2(2x)-x^2", "5*(sqrt(|x+2|)-1)", "exp(-x)*ln(x)", "(x-1)^3", "x^25"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.setSelectionMode(0);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NewJApplet.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jButton1.setText("bisection");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("reg f");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Newton");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton3ActionPerformed(evt);
            }
        });
        this.jSlider1.setMaximum(110);
        this.jSlider1.setValue(0);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.setMaximum(110);
        this.jSlider2.setValue(110);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jButton4.setText("Dekker's");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("Brent");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setText("Chandrupatla");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton6ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 87, Short.MAX_VALUE).addComponent(this.jSlider2, -2, -1, -2).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE).addComponent(this.jButton6, -1, -1, Short.MAX_VALUE))).addComponent(this.jScrollPane2, -2, 438, -2)).addContainerGap(178, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider2, -2, -1, -2).addComponent(this.jSlider1, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.jScrollPane1, -2, 184, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 301, Short.MAX_VALUE))).addContainerGap()));
    }

    private void jList1MouseClicked(MouseEvent evt) {
        this.funcsel = this.jList1.getMinSelectionIndex();
        this.nsteps = 0;
        this.draw_new();
        this.jPanel1.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.methsel = 0;
        this.start();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.methsel = 4;
        this.start();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.x1 = (double)this.jSlider1.getValue() * 0.04 - 2.0;
        this.draw_new();
        this.jPanel1.repaint();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.x2 = (double)this.jSlider2.getValue() * 0.04 - 2.0;
        this.draw_new();
        this.jPanel1.repaint();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.methsel = 5;
        this.start();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.methsel = 1;
        this.start();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.methsel = 2;
        this.start();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.methsel = 3;
        this.start();
    }

    public double fun7(double x) {
        double rv = Math.abs(x) < 3.8E-4 ? 0.0 : x * Math.exp(-1.0 / (x * x));
        return rv;
    }

    public double func(double x) {
        double rv;
        switch (this.funcsel) {
            case 0: {
                rv = x - 2.0;
                break;
            }
            case 1: {
                rv = x * x - 2.0;
                break;
            }
            case 2: {
                rv = x * x * x - 2.0;
                break;
            }
            case 3: {
                rv = x * x * x * x - 2.0;
                break;
            }
            case 4: {
                rv = 5.0 * Math.sin(5.0 * x);
                break;
            }
            case 5: {
                rv = Math.cos(2.0 * x) * Math.cos(2.0 * x) - x * x;
                break;
            }
            case 6: {
                rv = 5.0 * (Math.sqrt(Math.abs(x + 2.0)) - 1.0);
                break;
            }
            case 7: {
                rv = Math.exp(-x) * Math.log(x);
                break;
            }
            case 8: {
                rv = (x - 1.0) * (x - 1.0) * (x - 1.0);
                break;
            }
            case 9: {
                rv = Math.pow(x, 25.0);
                break;
            }
            default: {
                rv = 0.0;
            }
        }
        return rv;
    }

    public double dfunc(double x) {
        double rv;
        switch (this.funcsel) {
            case 0: {
                rv = 1.0;
                break;
            }
            case 1: {
                rv = 2.0 * x;
                break;
            }
            case 2: {
                rv = 3.0 * x * x;
                break;
            }
            case 3: {
                rv = 4.0 * x * x * x;
                break;
            }
            case 4: {
                rv = 25.0 * Math.cos(5.0 * x);
                break;
            }
            case 5: {
                rv = -4.0 * Math.cos(2.0 * x) * Math.sin(2.0 * x) - 2.0 * x;
                break;
            }
            case 6: {
                rv = 2.5 * Math.signum(x + 2.0) / Math.sqrt(Math.abs(x + 2.0));
                break;
            }
            case 7: {
                rv = Math.exp(-x) / x - Math.exp(-x) * Math.log(x);
                break;
            }
            case 8: {
                rv = 3.0 * (x - 1.0) * (x - 1.0);
                break;
            }
            case 9: {
                rv = 25.0 * Math.pow(x, 24.0);
                break;
            }
            default: {
                rv = 0.0;
            }
        }
        return rv;
    }

    void newton(double x0, double eps) {
        boolean keep_iterating = true;
        boolean found_it = false;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with Newton-Raphson method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        this.xap[0] = x0;
        this.yap[0] = this.func(x0);
        this.nsteps = 1;
        double x1 = x0;
        double xm1 = x1 + 1.0;
        while (keep_iterating && !found_it) {
            double f1 = this.func(x1);
            double df1 = this.dfunc(x1);
            if (Math.abs(x1 - xm1) < 5.0E-16) {
                keep_iterating = false;
                found_it = true;
                this.jTextArea1.append(" no more change \n ");
            } else if (Math.abs(df1) == 0.0) {
                this.jTextArea1.append(" derivative too small \n");
                keep_iterating = false;
            } else {
                xm1 = x1;
                x1 -= f1 / df1;
                f1 = this.func(x1);
                this.jTextArea1.append("" + this.nsteps + "  " + x1 + "  " + f1 + "\n");
                this.xap[this.nsteps] = x1;
                this.yap[this.nsteps] = f1;
                ++this.nsteps;
                if (this.nsteps > 200) {
                    this.jTextArea1.append(" too many iterations \n");
                    keep_iterating = false;
                }
            }
            this.draw_points();
        }
        if (found_it) {
            double y = this.func(x1);
            this.jTextArea1.append(" solution after " + this.nsteps + " steps  is " + this.df3.format(x1) + "  f=" + this.df2.format(y) + "\n");
        }
        this.stop();
    }

    void regulaf(double x1, double x2, double eps) {
        boolean keep_iterating = true;
        boolean found_it = false;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with regula falsi method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        double x = x1;
        this.nsteps = 2;
        double f1 = this.func(x1);
        double f2 = this.func(x2);
        this.xap[0] = x1;
        this.yap[0] = f1;
        this.xap[1] = x2;
        this.yap[1] = f2;
        if (f1 * f2 >= 0.0) {
            this.jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + " \n");
            this.nsteps = 0;
        } else {
            double y;
            while (keep_iterating && !found_it) {
                double xold = x;
                x = x2 * f1 - x1 * f2;
                if ((x /= f1 - f2) == xold) {
                    this.jTextArea1.append(" no more change" + x + "  f=" + this.func(x) + "\n");
                    break;
                }
                y = this.func(x);
                this.xap[this.nsteps] = x;
                this.yap[this.nsteps] = y;
                ++this.nsteps;
                this.jTextArea1.append("" + (this.nsteps - 2) + " " + x + "  " + y + "\n");
                this.draw_points();
                if (this.nsteps > 200) {
                    this.jTextArea1.append(" too many iterations \n");
                    keep_iterating = false;
                }
                if (y == 0.0) {
                    keep_iterating = false;
                    found_it = true;
                    this.jTextArea1.append(" function value is small enough\n ");
                } else if (f1 * y < 0.0) {
                    x2 = x;
                    f2 = y;
                } else if (f2 * y < 0.0) {
                    x1 = x;
                    f1 = y;
                } else {
                    this.jTextArea1.append(" ... cannot find a solution \n");
                    keep_iterating = false;
                }
                if (!(x2 - x1 < eps)) continue;
                this.jTextArea1.append(" intervall is small enough \n");
                found_it = true;
                x = (x2 - x1) * 0.5;
            }
            if (found_it) {
                y = this.func(x);
                this.jTextArea1.append(" solution after " + (this.nsteps - 2) + "  steps  is  " + x + "  f=" + this.df2.format(y) + " \n");
            }
        }
        this.stop();
    }

    void bisection(double x1, double x2, double eps) {
        boolean keep_iterating = true;
        boolean found_it = false;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with bisection method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        this.nsteps = 2;
        double f1 = this.func(x1);
        double f2 = this.func(x2);
        this.xap[0] = x1;
        this.yap[0] = f1;
        this.xap[1] = x2;
        this.yap[1] = f2;
        if (f1 * f2 >= 0.0) {
            this.jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            this.nsteps = 0;
        } else {
            double y;
            double x = (x1 + x2) / 2.0;
            while (keep_iterating && !found_it) {
                double tol;
                x = (x1 + x2) / 2.0;
                y = this.func(x);
                this.xap[this.nsteps] = x;
                this.yap[this.nsteps] = y;
                ++this.nsteps;
                this.jTextArea1.append("" + (this.nsteps - 2) + "  " + x + "  " + y + "\n");
                this.draw_points();
                if (y == 0.0) {
                    keep_iterating = false;
                    found_it = true;
                    this.jTextArea1.append(" function value is small enough\n ");
                } else if (Math.signum(f1) != Math.signum(y)) {
                    x2 = x;
                    f2 = y;
                } else if (Math.signum(f2) != Math.signum(y)) {
                    x1 = x;
                    f1 = y;
                } else {
                    this.jTextArea1.append(" ... cannot find a solution \n");
                    this.jTextArea1.append(" " + y + "  " + f1 + " " + f2 + "\n");
                    keep_iterating = false;
                }
                if (!(x2 - x1 < (tol = eps + Math.abs(x1 + x2) * 5.0E-16))) continue;
                this.jTextArea1.append(" intervall is small enough \n");
                found_it = true;
                x = (x2 + x1) * 0.5;
            }
            if (found_it) {
                y = this.func(x);
                this.jTextArea1.append(" solution after " + (this.nsteps - 2) + " steps is " + x + "  f=" + this.df2.format(y) + " \n");
            }
        }
        this.stop();
    }

    void Dekker(double x1, double x2, double eps) {
        boolean keep_iterating = true;
        boolean found_it = false;
        boolean found_x = false;
        int nochange = 0;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with Dekker's combined method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        this.nsteps = 2;
        double f1 = this.func(x1);
        double f2 = this.func(x2);
        if (f1 * f2 >= 0.0) {
            this.jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            this.nsteps = 0;
        } else {
            double y;
            double c;
            double a;
            double b;
            if (Math.abs(f1) < Math.abs(f2)) {
                b = x1;
                a = x2;
                c = x2;
                double t = f1;
                f1 = f2;
                f2 = t;
            } else {
                a = x1;
                b = x2;
                c = x1;
            }
            this.xap[0] = a;
            this.yap[0] = f1;
            this.xap[1] = b;
            this.yap[1] = f2;
            double xm1 = b + 1.0;
            while (keep_iterating && !found_it) {
                double yk;
                double xk;
                double tol = eps + Math.abs(b) * 1.0E-15;
                f1 = this.func(a);
                f2 = this.func(b);
                double xm = (c + b) / 2.0;
                double xs = b - f2 * (b - a) / (f2 - f1);
                double xi = Math.abs(b - xs) < tol ? (c > b ? b + tol : b - tol) : (b < xs && xs < xm || b > xs && xs > xm ? xs : xm);
                double yi = this.func(xi);
                if (yi == 0.0) {
                    this.jTextArea1.append("function value is zero after " + (this.nsteps - 1) + "steps \n");
                    y = yi;
                    b = xi;
                    this.xap[this.nsteps] = xi;
                    this.yap[this.nsteps] = yi;
                    ++this.nsteps;
                    this.jTextArea1.append("" + (this.nsteps - 2) + "  " + b + " \n");
                    this.draw_points();
                    break;
                }
                int i = this.nsteps;
                found_x = false;
                do {
                    xk = this.xap[--i];
                    yk = this.yap[i];
                    if (!(yk * yi < 0.0)) continue;
                    found_x = true;
                } while (i >= 0 && !found_x);
                xm1 = b;
                if (Math.abs(yi) < Math.abs(yk)) {
                    a = b;
                    b = xi;
                    c = xk;
                    this.xap[this.nsteps] = xi;
                    this.yap[this.nsteps] = yi;
                } else {
                    a = xi;
                    b = xk;
                    c = xi;
                    this.xap[this.nsteps] = xk;
                    this.yap[this.nsteps] = yk;
                }
                this.draw_points();
                this.jTextArea1.append("" + (this.nsteps - 1) + "  " + this.xap[this.nsteps] + "  " + this.yap[this.nsteps] + " \n");
                if (Math.abs(xm1 - b) < tol * 0.5) {
                    if (++nochange == 1) {
                        // empty if block
                    }
                    if (nochange > 2) {
                        this.jTextArea1.append(" interval width is" + Math.abs(c - b) + "\n");
                        this.jTextArea1.append("no more iterations justified \n");
                        break;
                    }
                } else {
                    nochange = 0;
                }
                ++this.nsteps;
                if (this.nsteps >= this.nmax - 1) break;
                if (!(Math.abs(b - c) < tol)) continue;
                this.jTextArea1.append(" interval width is" + Math.abs(c - b) + "\n");
                this.jTextArea1.append(" intervall is small enough \n");
                found_it = true;
                break;
            }
            if (found_it) {
                y = this.func(b);
                this.jTextArea1.append(" solution after " + (this.nsteps - 2) + " steps is " + b + "  f=" + this.df2.format(y) + " \n");
            }
        }
        this.stop();
    }

    void Chandrupatla(double x1, double x2, double eps) {
        double fc;
        double c;
        boolean keep_iterating = true;
        boolean found_it = false;
        boolean found_x = false;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with Chandrupatla's combined method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        this.nsteps = 2;
        double f1 = this.func(x1);
        double f2 = this.func(x2);
        double b = x1;
        double a = c = x2;
        double fb = f1;
        double fa = fc = f2;
        if (f1 * f2 >= 0.0) {
            this.jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            this.nsteps = 0;
        } else {
            double t = 0.5;
            this.xap[0] = c;
            this.yap[0] = fc;
            this.xap[1] = b;
            this.yap[1] = fb;
            while (keep_iterating && !found_it) {
                double tol;
                double tl;
                double xs = a + t * (b - a);
                double ft = this.func(xs);
                if (ft == 0.0) {
                    found_it = true;
                    this.xap[this.nsteps] = b = xs;
                    this.yap[this.nsteps] = ft;
                    ++this.nsteps;
                    this.jTextArea1.append("" + (this.nsteps - 3) + " " + b + "  " + Math.abs(c - b) + "\n");
                    this.draw_points();
                    break;
                }
                if (Math.signum(ft) == Math.signum(fa)) {
                    c = a;
                    fc = fa;
                    a = xs;
                    fa = ft;
                } else {
                    c = b;
                    b = a;
                    a = xs;
                    fc = fb;
                    fb = fa;
                    fa = ft;
                }
                double xm = a;
                double fm = fa;
                if (Math.abs(fb) < Math.abs(fa)) {
                    xm = b;
                    fm = fb;
                }
                if ((tl = (tol = 2.0E-16 * Math.abs(b) + eps) / Math.abs(b - c)) > 0.5 || fm == 0.0) {
                    found_it = true;
                    this.xap[this.nsteps] = xm;
                    this.yap[this.nsteps] = fm;
                    ++this.nsteps;
                    this.jTextArea1.append(" " + (this.nsteps - 3) + " " + b + "  " + Math.abs(c - b) + "\n");
                    this.draw_points();
                    break;
                }
                double xi = (a - b) / (c - b);
                double phi = (fa - fb) / (fc - fb);
                double fl = 1.0 - Math.sqrt(1.0 - xi);
                double fh = Math.sqrt(xi);
                if (fl < phi && phi < fh) {
                    double alpha = (c - a) / (b - a);
                    double A = fa / (fb - fa);
                    double B = fc / (fb - fc);
                    double C = fa / (fc - fa);
                    double D = fb / (fc - fb);
                    t = A * B + C * D * alpha;
                } else {
                    t = 0.5;
                }
                if (t < tl) {
                    t = tl;
                }
                if (t > 1.0 - tl) {
                    t = 1.0 - tl;
                }
                this.xap[this.nsteps] = b;
                this.yap[this.nsteps] = fb;
                ++this.nsteps;
                this.jTextArea1.append(" " + (this.nsteps - 3) + " " + b + "  " + Math.abs(c - b) + "\n");
                this.draw_points();
            }
            if (found_it) {
                double y = this.func(b);
                this.jTextArea1.append(" solution after " + (this.nsteps - 3) + " steps is " + b + "  f=" + this.df2.format(y) + " \n");
            }
        }
        this.stop();
    }

    void Brent(double x1, double x2, double eps) {
        double d;
        boolean keep_iterating = true;
        boolean found_it = false;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jTextArea1.setCaretPosition(0);
        this.jTextArea1.setText("");
        this.jTextArea1.append("root finding with Dekker-Brent method\n");
        this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMinimum());
        this.nsteps = 2;
        double a = x1;
        double b = x2;
        double c = a;
        double fa = this.func(a);
        double fb = this.func(b);
        double fc = fa;
        double ee = d = b - a;
        if (fa * fb >= 0.0) {
            this.jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            this.nsteps = 0;
        } else {
            this.xap[0] = b;
            this.yap[0] = fb;
            this.xap[1] = a;
            this.yap[1] = fa;
            double q = 0.0;
            double p = 0.0;
            while (keep_iterating && !found_it) {
                if (Math.abs(fc) < Math.abs(fb)) {
                    a = b;
                    b = c;
                    c = a;
                    fa = fb;
                    fb = fc;
                    fc = fa;
                }
                double tol = 5.0E-16 * Math.abs(b) + eps;
                double xm = (c - b) * 0.5;
                if (Math.abs(xm) > tol && fb != 0.0) {
                    if (Math.abs(ee) < tol || Math.abs(fa) <= Math.abs(fb)) {
                        d = xm;
                        ee = xm;
                    } else {
                        double s = fb / fa;
                        if (a == c) {
                            p = 2.0 * xm * s;
                            q = 1.0 - s;
                        } else {
                            q = fa / fc;
                            double r = fb / fc;
                            p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                            q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                        }
                        if (p > 0.0) {
                            q = -q;
                        } else {
                            p = -p;
                        }
                        s = ee;
                        ee = d;
                        if (2.0 * p < 3.0 * xm * q - Math.abs(tol * q) && p < Math.abs(s * q * 0.5)) {
                            d = p / q;
                        } else {
                            d = xm;
                            ee = xm;
                        }
                    }
                } else {
                    found_it = true;
                    break;
                }
                a = b;
                fa = fb;
                b = Math.abs(d) > tol ? (b += d) : (xm > 0.0 ? (b += tol) : (b -= tol));
                fb = this.func(b);
                this.jTextArea1.append(" " + (this.nsteps - 1) + " " + b + "  " + fb + "\n");
                if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                    c = a;
                    fc = fa;
                    ee = d = b - a;
                }
                this.xap[this.nsteps] = b;
                this.yap[this.nsteps] = fb;
                ++this.nsteps;
                this.draw_points();
                if (!(Math.abs(b - c) < eps)) continue;
                this.jTextArea1.append(" intervall width < " + eps + "\n");
                found_it = true;
            }
            if (found_it) {
                this.jTextArea1.append(" intervall width < " + eps + "\n");
                double y = this.func(b);
                this.jTextArea1.append(" solution after " + (this.nsteps - 2) + " steps is " + b + "  f=" + this.df2.format(y) + " \n");
            }
        }
        this.stop();
    }

    public void draw_points() {
        int iy;
        int ix;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.gb.setColor(Color.RED);
        for (int i = 0; i < this.nsteps - 1; ++i) {
            ix = 2 * (int)(50.0 * this.xap[i] + 100.0);
            iy = 200 - (int)(this.yap[i] * 20.0);
            this.gb.fillOval(ix - 4, iy - 4, 8, 8);
        }
        if (this.nsteps > 0) {
            this.gb.setColor(Color.GREEN);
            ix = 2 * (int)(50.0 * this.xap[this.nsteps - 1] + 100.0);
            iy = 200 - (int)(this.yap[this.nsteps - 1] * 20.0);
            this.gb.fillOval(ix - 4, iy - 4, 8, 8);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    public void draw_new() {
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 510, 410);
        for (int i = 0; i < 250; ++i) {
            double x = -2.0 + (double)i * 0.02;
            this.ixp[i] = i * 2;
            this.iyp[i] = 200 - (int)(this.func(x) * 20.0);
        }
        this.gb.setColor(Color.black);
        this.gb.drawPolyline(this.ixp, this.iyp, this.nplot);
        int iy = 200;
        this.gb.setColor(Color.GRAY);
        this.gb.drawLine(0, iy, 500, iy);
        int ix = 2 * (int)(50.0 * this.x1 + 100.0);
        this.gb.drawLine(ix, 0, ix, 350);
        this.gb.drawString("" + this.df.format(this.x1), ix, 390);
        ix = 2 * (int)(50.0 * this.x2 + 100.0);
        this.gb.drawLine(ix, 0, ix, 350);
        this.gb.drawString("" + this.df.format(this.x2), ix, 390);
        this.draw_points();
    }

    public class myPanel
    extends JPanel {
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

