/*
 * Decompiled with CFR 0.152.
 */
package normvert;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    int[] histo;
    int[] cumulative;
    int naver;
    int nshots;
    int maxshots;
    int keep_shooting;
    double xav;
    double x2av;
    DecimalFormat df;
    DecimalFormat df2;
    int gaussian = 1;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSlider jSlider1;

    public void actionPerformed(ActionEvent e) {
        if (this.nshots == this.maxshots) {
            this.keep_shooting = 0;
        }
        if (this.keep_shooting == 1) {
            if (this.nshots < this.maxshots) {
                for (int i = 0; i < 10; ++i) {
                    this.shoot();
                    ++this.nshots;
                }
            }
            double xs = this.xav / (double)this.nshots;
            double x2s = this.x2av / (double)this.nshots;
            double s = Math.sqrt(x2s - xs * xs);
            this.jPanel1.repaint();
            this.jLabel1.setText("average:" + this.df.format(xs));
            this.jLabel2.setText("sigma :" + this.df.format(s));
            this.timer.restart();
        }
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.init_variables();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new myPanel();
        this.jSlider1 = new JSlider();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(300, 300));
        this.jPanel1.setMinimumSize(new Dimension(300, 300));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 531, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 298, Short.MAX_VALUE));
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setMinorTickSpacing(5);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jButton1.setText("start/stop");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("average");
        this.jLabel1.setMaximumSize(new Dimension(150, 15));
        this.jLabel1.setMinimumSize(new Dimension(150, 15));
        this.jLabel1.setPreferredSize(new Dimension(150, 15));
        this.jLabel2.setText("sigma");
        this.jLabel2.setMaximumSize(new Dimension(100, 15));
        this.jLabel2.setMinimumSize(new Dimension(100, 15));
        this.jLabel2.setPreferredSize(new Dimension(100, 15));
        this.jLabel3.setText("jLabel3");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Gaussian");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Coin");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(54, 54, 54).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSlider1, -2, -1, -2).addGap(45, 45, 45).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1).addComponent(this.jRadioButton2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addGap(27, 27, 27).addComponent(this.jLabel2, -2, 249, -2)))).addGroup(layout.createSequentialGroup().addGap(137, 137, 137).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 533, -2))).addContainerGap(82, Short.MAX_VALUE)));
        layout.linkSize(0, this.jRadioButton1, this.jRadioButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.jPanel1, -2, -1, -2).addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jRadioButton1)).addGap(1, 1, 1).addComponent(this.jRadioButton2).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.keep_shooting == 1) {
            this.keep_shooting = 0;
        } else {
            this.nshots = 0;
            for (int i = 0; i < 200; ++i) {
                this.histo[i] = 0;
                this.cumulative[i] = 0;
            }
            this.xav = 0.0;
            this.x2av = 0.0;
            this.keep_shooting = 1;
        }
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.naver = this.jSlider1.getValue();
        if (this.naver == 0) {
            this.naver = 1;
        }
        this.jLabel3.setText("average over:" + this.naver);
        this.nshots = 0;
        this.maxshots = (int)(10000.0 * Math.sqrt(1.0 / (double)this.naver));
        this.keep_shooting = 0;
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.gaussian = 1;
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.gaussian = 0;
    }

    public void init_variables() {
        this.histo = new int[200];
        this.cumulative = new int[200];
        this.timer = new Timer(1, this);
        this.timer.setInitialDelay(1);
        this.timer.start();
        this.naver = 1;
        for (int i = 0; i < 200; ++i) {
            this.histo[i] = 0;
            this.cumulative[i] = 0;
        }
        this.xav = 0.0;
        this.x2av = 0.0;
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        this.df = new DecimalFormat("##0.00000", unusualSymbols);
        this.df2 = new DecimalFormat("##0.00", unusualSymbols);
        this.maxshots = 10000;
        this.keep_shooting = 0;
        this.jSlider1.setValue(0);
        this.jLabel3.setText("average over:" + this.naver);
    }

    public double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    public double randcoin() {
        double r = Math.random();
        double x = r > 0.5 ? 1.0 : -1.0;
        return x;
    }

    public void shoot() {
        double r;
        int i;
        double rav = 0.0;
        if (this.gaussian == 1) {
            for (i = 0; i < this.naver; ++i) {
                r = this.randgauss();
                rav += r;
            }
        } else {
            for (i = 0; i < this.naver; ++i) {
                r = this.randcoin();
                rav += r;
            }
        }
        this.xav += (rav /= (double)this.naver);
        this.x2av += rav * rav;
        int index = (int)((rav + 3.0) * 33.0);
        if (index >= 0 && index < 200) {
            int n = index;
            this.histo[n] = this.histo[n] + 1;
            int ic = index;
            while (ic < 200) {
                int n2 = ic++;
                this.cumulative[n2] = this.cumulative[n2] + 1;
            }
        }
    }

    class myPanel
    extends JPanel {
        int i;

        myPanel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawString("-2", 78, 280);
            g.drawString("-1", 111, 280);
            g.drawString("0", 144, 280);
            g.drawString("1", 177, 280);
            g.drawString("2", 210, 280);
            g.drawString("-2", 328, 280);
            g.drawString("-1", 361, 280);
            g.drawString("0", 394, 280);
            g.drawString("1", 427, 280);
            g.drawString("2", 460, 280);
            g.drawString("Histogram", 70, 20);
            g.drawString("Cumulative distribution", 350, 20);
            g.drawLine(300, 250, 500, 250);
            this.i = 0;
            while (this.i < 200) {
                g.drawLine(this.i + 50, 250, this.i + 50, 250 - NewJApplet.this.histo[this.i]);
                ++this.i;
            }
            if (NewJApplet.this.nshots > 1) {
                this.i = 0;
                while (this.i < 199) {
                    g.drawLine(this.i + 300, 250 - NewJApplet.this.cumulative[this.i] * 150 / NewJApplet.this.nshots, this.i + 301, 250 - NewJApplet.this.cumulative[this.i + 1] * 150 / NewJApplet.this.nshots);
                    ++this.i;
                }
            }
        }
    }
}

