/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class waveapplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int NDIM = 500;
    int NHALF = 250;
    int NITER = 10000;
    double DELTAT = 0.001;
    double DELTAX = 0.1;
    double[] V;
    double[] RPSI;
    double[] IPSI;
    double[] DRPSI;
    double[] DIPSI;
    double[] RPSIO;
    double[] IPSIO;
    int i;
    int j;
    int k;
    int loop;
    int il;
    double x;
    double d2r;
    double d2i;
    double dx2;
    double dx2h;
    double[][] a;
    double[][] b;
    double[][] r;
    double[][] u;
    double[][] gam;
    double[] nom;
    double[] bet;
    double denom;
    int innerloops = 1;
    int selector = 0;
    int method = 0;
    double V0;
    double VM = 100.0;
    double Ekin;
    double Epot;
    double Norm;
    double totaltime;
    int icent = 50;
    double inwidth = 50.0;
    double[] ra11;
    double[] ia11;
    double[] ra22;
    double[] ia22;
    double[] ra12;
    double[] ia12;
    double[] rb11;
    double[] ib11;
    double[] rb22;
    double[] ib22;
    double[] rb12;
    double[] ib12;
    double r11;
    double i11;
    double r22;
    double i22;
    double r12;
    double i12;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider speedSlider;
    private JLabel velLabel;
    private JSlider velSlider;

    public void actionPerformed(ActionEvent e) {
        if (this.totaltime < 5000.0) {
            ++this.loop;
            if (this.method == 0) {
                this.waves();
            }
            if (this.method == 1) {
                this.waves2();
            }
            if (this.method == 2) {
                this.waves25p();
            }
            if (this.method == 3) {
                this.waves27p();
            }
            if (this.method == 4) {
                this.waves3();
            }
            this.jLabel9.setText("time: " + this.df1.format(this.totaltime));
            this.timer.setInitialDelay(10);
            this.timer.setDelay(10);
            this.timer.restart();
        }
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    waveapplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init_variables();
        this.speedSlider.setValue(1);
        this.reset_all();
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.velLabel = new JLabel();
        this.velSlider = new JSlider();
        this.jComboBox1 = new JComboBox();
        this.speedSlider = new JSlider();
        this.jButton1 = new JButton();
        this.jSlider1 = new JSlider();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jLabel8 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(400, 400));
        this.jPanel1.setMinimumSize(new Dimension(400, 400));
        this.jPanel1.setPreferredSize(new Dimension(400, 400));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 542, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(200, 600));
        this.jPanel2.setMinimumSize(new Dimension(200, 600));
        this.jPanel2.setPreferredSize(new Dimension(200, 600));
        this.jLabel1.setText("animation speed");
        this.velLabel.setText("jLabel2");
        this.velSlider.setMajorTickSpacing(1);
        this.velSlider.setMaximum(5);
        this.velSlider.setMinimum(1);
        this.velSlider.setPaintLabels(true);
        this.velSlider.setPaintTicks(true);
        this.velSlider.setSnapToTicks(true);
        this.velSlider.setValue(3);
        this.velSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.velSliderMouseDragged(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"quadratic", "quartic", "box"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setMaximum(50);
        this.speedSlider.setMinimum(1);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.speedSliderMouseDragged(evt);
            }
        });
        this.jButton1.setText("Restart");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSlider1.setMaximum(470);
        this.jSlider1.setMinimum(30);
        this.jSlider1.setMinorTickSpacing(50);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                waveapplet.this.jSlider1MouseReleased(evt);
            }
        });
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel6.setText("potential ");
        this.jLabel7.setText("initial position");
        this.jSlider2.setMaximum(50);
        this.jSlider2.setMinimum(10);
        this.jSlider2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                waveapplet.this.jSlider2MouseReleased(evt);
            }
        });
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jLabel8.setText("initial width");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"CN", "SOD3", "SOD5", "SOD7", "SPO"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jComboBox2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(55, 55, 55).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1))).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jSlider2, -2, 144, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jSlider1, -2, 154, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(64, 64, 64).addComponent(this.jLabel8)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.speedSlider, -2, 144, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox1, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.velSlider, -2, 138, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(65, 65, 65).addComponent(this.velLabel)).addGroup(jPanel2Layout.createSequentialGroup().addGap(51, 51, 51).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jComboBox2, -2, 95, -2)))).addContainerGap(54, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jSlider1, this.jSlider2, this.speedSlider, this.velSlider);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.velLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.velSlider, -2, -1, -2).addGap(22, 22, 22).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBox1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addGap(29, 29, 29).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speedSlider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBox2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel9.setText("jLabel9");
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("jLabel3");
        this.jLabel3.setMaximumSize(new Dimension(250, 15));
        this.jLabel3.setMinimumSize(new Dimension(250, 15));
        this.jLabel3.setPreferredSize(new Dimension(250, 15));
        this.jLabel4.setText("jLabel4");
        this.jLabel5.setText("jLabel5");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 544, -2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -2, 230, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel5))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 232, -2).addContainerGap(176, Short.MAX_VALUE)));
        layout.linkSize(0, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 402, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel9).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5))).addComponent(this.jPanel2, -2, 0, Short.MAX_VALUE)).addGap(111, 111, 111)));
    }

    private void velSliderMouseDragged(MouseEvent evt) {
        this.DELTAT = Math.pow(10.0, -this.velSlider.getValue());
        this.velLabel.setText("timestep=" + this.df.format(this.DELTAT));
        this.reset_all();
    }

    private void speedSliderMouseDragged(MouseEvent evt) {
        this.innerloops = this.speedSlider.getValue();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.selector = this.jComboBox1.getSelectedIndex();
        this.reset_all();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset_all();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.timer.stop();
        this.icent = this.jSlider1.getValue();
        this.reset_all();
        this.draw();
    }

    private void jSlider1MouseReleased(MouseEvent evt) {
        this.timer.restart();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.timer.stop();
        this.inwidth = this.jSlider2.getValue();
        this.reset_all();
        this.draw();
    }

    private void jSlider2MouseReleased(MouseEvent evt) {
        this.timer.restart();
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.method = this.jComboBox2.getSelectedIndex();
        this.reset_all();
    }

    void init_variables() {
        this.df = new DecimalFormat("0.000E0");
        this.df1 = new DecimalFormat("0.000000000000");
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.V = new double[this.NDIM];
        this.RPSI = new double[this.NDIM];
        this.IPSI = new double[this.NDIM];
        this.RPSIO = new double[this.NDIM];
        this.IPSIO = new double[this.NDIM];
        this.DRPSI = new double[this.NDIM];
        this.DIPSI = new double[this.NDIM];
        this.a = new double[this.NDIM][2];
        this.b = new double[this.NDIM][2];
        this.r = new double[this.NDIM][2];
        this.u = new double[this.NDIM][2];
        this.gam = new double[this.NDIM][2];
        this.nom = new double[2];
        this.bet = new double[2];
        this.ra11 = new double[this.NHALF];
        this.ia11 = new double[this.NHALF];
        this.ra22 = new double[this.NHALF];
        this.ia22 = new double[this.NHALF];
        this.ra12 = new double[this.NHALF];
        this.ia12 = new double[this.NHALF];
        this.rb11 = new double[this.NHALF];
        this.ib11 = new double[this.NHALF];
        this.rb22 = new double[this.NHALF];
        this.ib22 = new double[this.NHALF];
        this.rb12 = new double[this.NHALF];
        this.ib12 = new double[this.NHALF];
        this.velSlider.setValue(3);
        this.velLabel.setText("timestep=" + this.df.format(this.DELTAT));
    }

    double potential4(int i) {
        double x = (double)(i - this.NDIM / 2) / (double)this.NDIM;
        return 1000.0 * x * x * x * x - x * x * 100.0;
    }

    double potential2(int i) {
        double x = (double)(i - this.NDIM / 2) / (double)this.NDIM;
        return 100.0 * x * x;
    }

    void reset_all() {
        double pref;
        int i;
        double kfac = 188.49555921538757 / (double)this.NDIM;
        this.dx2 = this.DELTAX * this.DELTAX;
        this.dx2h = this.dx2 * 2.0;
        if (this.selector == 0) {
            this.V0 = this.potential2(this.icent);
            for (i = 0; i < this.NDIM; ++i) {
                this.V[i] = this.potential2(i) - this.V0;
                this.RPSI[i] = 0.0;
                this.IPSI[i] = 0.0;
            }
        }
        if (this.selector == 1) {
            this.V0 = this.potential4(this.icent);
            for (i = 0; i < this.NDIM; ++i) {
                this.V[i] = this.potential4(i) - this.V0;
                this.RPSI[i] = 0.0;
                this.IPSI[i] = 0.0;
            }
        }
        if (this.selector == 2) {
            for (i = 0; i < this.NDIM; ++i) {
                this.V[i] = 0.0;
            }
            for (i = 0; i < this.NDIM; ++i) {
                this.x = (double)i - (double)this.icent;
                double arg = this.x / this.inwidth;
                pref = Math.exp(-(arg * arg));
                this.RPSI[i] = pref * Math.cos(this.x * kfac);
                this.IPSI[i] = pref * Math.sin(this.x * kfac);
            }
        }
        if (this.selector == 3) {
            for (i = 0; i < this.NDIM; ++i) {
                this.V[i] = 0.0;
            }
        }
        if (this.selector < 2) {
            for (i = 0; i < this.NDIM; ++i) {
                this.x = (double)i - (double)this.icent;
                this.x /= this.inwidth;
                this.RPSI[i] = pref = Math.exp(-(this.x * this.x));
                this.IPSI[i] = 0.0;
            }
        }
        this.normalize();
        this.loop = 0;
        switch (this.method) {
            case 0: 
            case 1: {
                this.initwaves2();
            }
            case 2: {
                this.initwaves25p();
            }
            case 3: {
                this.initwaves27p();
            }
        }
        this.totaltime = 0.0;
    }

    void tridag() {
        int j;
        this.bet[0] = this.b[0][0];
        this.bet[1] = this.b[0][1];
        this.denom = this.bet[0] * this.bet[0] + this.bet[1] * this.bet[1];
        this.u[0][0] = (this.r[0][0] * this.bet[0] + this.r[0][1] * this.bet[1]) / this.denom;
        this.u[0][1] = (this.r[0][1] * this.bet[0] - this.r[0][0] * this.bet[1]) / this.denom;
        for (j = 1; j < this.NDIM; ++j) {
            this.gam[j][0] = (this.a[j - 1][0] * this.bet[0] + this.a[j - 1][1] * this.bet[1]) / this.denom;
            this.gam[j][1] = (this.a[j - 1][1] * this.bet[0] - this.a[j - 1][0] * this.bet[1]) / this.denom;
            this.bet[0] = this.b[j][0] - this.a[j][0] * this.gam[j][0] + this.a[j][1] * this.gam[j][1];
            this.bet[1] = this.b[j][1] - this.a[j][0] * this.gam[j][1] - this.a[j][1] * this.gam[j][0];
            this.denom = this.bet[0] * this.bet[0] + this.bet[1] * this.bet[1];
            this.nom[0] = this.r[j][0] - this.a[j][0] * this.u[j - 1][0] + this.a[j][1] * this.u[j - 1][1];
            this.nom[1] = this.r[j][1] - this.a[j][0] * this.u[j - 1][1] - this.a[j][1] * this.u[j - 1][0];
            this.u[j][0] = (this.nom[0] * this.bet[0] + this.nom[1] * this.bet[1]) / this.denom;
            this.u[j][1] = (this.nom[1] * this.bet[0] - this.nom[0] * this.bet[1]) / this.denom;
        }
        for (j = this.NDIM - 2; j >= 0; --j) {
            double[] dArray = this.u[j];
            dArray[0] = dArray[0] - (this.gam[j + 1][0] * this.u[j + 1][0] - this.gam[j + 1][1] * this.u[j + 1][1]);
            double[] dArray2 = this.u[j];
            dArray2[1] = dArray2[1] - (this.gam[j + 1][0] * this.u[j + 1][1] + this.gam[j + 1][1] * this.u[j + 1][0]);
        }
    }

    void normalize() {
        this.x = 0.0;
        this.i = 0;
        while (this.i < this.NDIM) {
            this.x = this.x + this.RPSI[this.i] * this.RPSI[this.i] + this.IPSI[this.i] * this.IPSI[this.i];
            ++this.i;
        }
        this.x = Math.sqrt(this.x);
        this.i = 0;
        while (this.i < this.NDIM) {
            this.RPSI[this.i] = this.RPSI[this.i] / this.x;
            this.IPSI[this.i] = this.IPSI[this.i] / this.x;
            ++this.i;
        }
    }

    void ex2(double a11, double a22, double a12) {
        double q = 0.5 * (a22 - a11) / a12;
        double t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
        if (q < 0.0) {
            t = -t;
        }
        double c2 = 1.0 / (1.0 + t * t);
        double cs = t * c2;
        double s2 = t * cs;
        double ev1 = a11 - a12 * t;
        double ev2 = a22 + a12 * t;
        double rx1 = Math.cos(ev1);
        double ix1 = -Math.sin(ev1);
        double rx2 = Math.cos(ev2);
        double ix2 = -Math.sin(ev2);
        this.r11 = c2 * rx1 + s2 * rx2;
        this.i11 = c2 * ix1 + s2 * ix2;
        this.r22 = c2 * rx2 + s2 * rx1;
        this.i22 = c2 * ix2 + s2 * ix1;
        this.r12 = cs * (rx2 - rx1);
        this.i12 = cs * (ix2 - ix1);
    }

    void waves3() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.i22 = 0.0;
        this.r22 = 0.0;
        this.i12 = 0.0;
        this.r12 = 0.0;
        this.i11 = 0.0;
        this.r11 = 0.0;
        this.il = 0;
        while (this.il < this.innerloops) {
            double i2;
            double r2;
            double i1;
            double r1;
            int index;
            this.totaltime += this.DELTAT;
            double a11 = 0.5 * this.DELTAT * (this.V[0] + 1.0 / this.dx2);
            double a22 = 0.25 * this.DELTAT * (this.V[1] + 1.0 / this.dx2);
            double a12 = -0.25 * this.DELTAT / this.dx2h;
            this.ex2(a11, a22, a12);
            this.ra11[0] = this.r11;
            this.ia11[0] = this.i11;
            this.ra22[0] = this.r22;
            this.ia22[0] = this.i22;
            this.ra12[0] = this.r12;
            this.ia12[0] = this.i12;
            for (i = 1; i < this.NHALF - 1; ++i) {
                index = i * 2;
                a11 = 0.25 * this.DELTAT * (this.V[index] + 1.0 / this.dx2);
                a22 = 0.25 * this.DELTAT * (this.V[index + 1] + 1.0 / this.dx2);
                a12 = -0.5 * this.DELTAT / this.dx2h;
                this.ex2(a11, a22, a12);
                this.ra11[i] = this.r11;
                this.ia11[i] = this.i11;
                this.ra22[i] = this.r22;
                this.ia22[i] = this.i22;
                this.ra12[i] = this.r12;
                this.ia12[i] = this.i12;
            }
            index = 2 * (this.NHALF - 1);
            a11 = 0.25 * this.DELTAT * (this.V[index] + 1.0 / this.dx2);
            a22 = 0.5 * this.DELTAT * (this.V[index + 1] + 1.0 / this.dx2);
            a12 = -0.25 * this.DELTAT / this.dx2h;
            this.ex2(a11, a22, a12);
            this.ra11[this.NHALF - 1] = this.r11;
            this.ia11[this.NHALF - 1] = this.i11;
            this.ra22[this.NHALF - 1] = this.r22;
            this.ia22[this.NHALF - 1] = this.i22;
            this.ra12[this.NHALF - 1] = this.r12;
            this.ia12[this.NHALF - 1] = this.i12;
            for (i = 0; i < this.NHALF - 1; ++i) {
                index = i * 2 + 1;
                a11 = 0.5 * this.DELTAT * (this.V[index] + 1.0 / this.dx2);
                a22 = 0.5 * this.DELTAT * (this.V[index + 1] + 1.0 / this.dx2);
                a12 = -this.DELTAT / this.dx2h;
                this.ex2(a11, a22, a12);
                this.rb11[i] = this.r11;
                this.ib11[i] = this.i11;
                this.rb22[i] = this.r22;
                this.ib22[i] = this.i22;
                this.rb12[i] = this.r12;
                this.ib12[i] = this.i12;
            }
            for (i = 0; i < this.NHALF; ++i) {
                index = i * 2;
                r1 = this.ra11[i] * this.RPSI[index] - this.ia11[i] * this.IPSI[index] + this.ra12[i] * this.RPSI[index + 1] - this.ia12[i] * this.IPSI[index + 1];
                i1 = this.ra11[i] * this.IPSI[index] + this.ia11[i] * this.RPSI[index] + this.ra12[i] * this.IPSI[index + 1] + this.ia12[i] * this.RPSI[index + 1];
                r2 = this.ra12[i] * this.RPSI[index] - this.ia12[i] * this.IPSI[index] + this.ra22[i] * this.RPSI[index + 1] - this.ia22[i] * this.IPSI[index + 1];
                i2 = this.ra12[i] * this.IPSI[index] + this.ia12[i] * this.RPSI[index] + this.ra22[i] * this.IPSI[index + 1] + this.ia22[i] * this.RPSI[index + 1];
                this.RPSI[index] = r1;
                this.IPSI[index] = i1;
                this.RPSI[index + 1] = r2;
                this.IPSI[index + 1] = i2;
            }
            for (i = 0; i < this.NHALF - 1; ++i) {
                index = i * 2 + 1;
                r1 = this.rb11[i] * this.RPSI[index] - this.ib11[i] * this.IPSI[index] + this.rb12[i] * this.RPSI[index + 1] - this.ib12[i] * this.IPSI[index + 1];
                i1 = this.rb11[i] * this.IPSI[index] + this.ib11[i] * this.RPSI[index] + this.rb12[i] * this.IPSI[index + 1] + this.ib12[i] * this.RPSI[index + 1];
                r2 = this.rb12[i] * this.RPSI[index] - this.ib12[i] * this.IPSI[index] + this.rb22[i] * this.RPSI[index + 1] - this.ib22[i] * this.IPSI[index + 1];
                i2 = this.rb12[i] * this.IPSI[index] + this.ib12[i] * this.RPSI[index] + this.rb22[i] * this.IPSI[index + 1] + this.ib22[i] * this.RPSI[index + 1];
                this.RPSI[index] = r1;
                this.IPSI[index] = i1;
                this.RPSI[index + 1] = r2;
                this.IPSI[index + 1] = i2;
            }
            for (i = 0; i < this.NHALF; ++i) {
                index = i * 2;
                r1 = this.ra11[i] * this.RPSI[index] - this.ia11[i] * this.IPSI[index] + this.ra12[i] * this.RPSI[index + 1] - this.ia12[i] * this.IPSI[index + 1];
                i1 = this.ra11[i] * this.IPSI[index] + this.ia11[i] * this.RPSI[index] + this.ra12[i] * this.IPSI[index + 1] + this.ia12[i] * this.RPSI[index + 1];
                r2 = this.ra12[i] * this.RPSI[index] - this.ia12[i] * this.IPSI[index] + this.ra22[i] * this.RPSI[index + 1] - this.ia22[i] * this.IPSI[index + 1];
                i2 = this.ra12[i] * this.IPSI[index] + this.ia12[i] * this.RPSI[index] + this.ra22[i] * this.IPSI[index + 1] + this.ia22[i] * this.RPSI[index + 1];
                this.RPSI[index] = r1;
                this.IPSI[index] = i1;
                this.RPSI[index + 1] = r2;
                this.IPSI[index + 1] = i2;
            }
            ++this.il;
        }
        this.Ekin = 0.0;
        this.Epot = 0.0;
        this.Norm = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            double amp = this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i];
            this.Norm += amp;
            this.Epot += amp * this.V[i];
        }
        double su = 0.0;
        for (i = 1; i < this.NDIM - 1; ++i) {
            su = su + this.RPSI[i] * this.RPSI[i + 1] + this.IPSI[i] * this.IPSI[i + 1];
            su = su + this.RPSI[i] * this.RPSI[i - 1] + this.IPSI[i] * this.IPSI[i - 1];
        }
        su = su + this.RPSI[0] * this.RPSI[1] + this.IPSI[0] * this.IPSI[1];
        su = su + this.RPSI[this.NDIM - 1] * this.RPSI[this.NDIM - 2] + this.IPSI[this.NDIM - 1] * this.IPSI[this.NDIM - 2];
        this.Ekin = this.Ekin + su - 2.0 * this.Norm;
        this.Ekin = -this.Ekin / this.dx2h;
        this.jLabel2.setText("Norm=" + this.df1.format(this.Norm));
        this.jLabel3.setText("Epot=" + this.df1.format(this.Epot));
        this.jLabel4.setText("Ekin=" + this.df1.format(this.Ekin));
        this.jLabel5.setText("Etot=" + this.df1.format(this.Epot + this.Ekin));
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void waves() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.il = 0;
        while (this.il < this.innerloops) {
            this.totaltime += this.DELTAT;
            for (i = 0; i < this.NDIM; ++i) {
                this.a[i][0] = 0.0;
                this.a[i][1] = -0.25 * this.DELTAT / this.dx2;
                this.b[i][0] = 1.0;
                this.b[i][1] = 0.5 * this.DELTAT * (this.V[i] + 1.0 / this.dx2);
                this.r[i][0] = this.RPSI[i];
                this.r[i][1] = this.IPSI[i];
            }
            this.tridag();
            for (i = 0; i < this.NDIM; ++i) {
                this.RPSI[i] = 2.0 * this.u[i][0] - this.RPSI[i];
                this.IPSI[i] = 2.0 * this.u[i][1] - this.IPSI[i];
            }
            ++this.il;
        }
        this.Ekin = 0.0;
        this.Epot = 0.0;
        this.Norm = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            double amp = this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i];
            this.Norm += amp;
            this.Epot += amp * this.V[i];
        }
        double su = 0.0;
        for (i = 1; i < this.NDIM - 1; ++i) {
            su = su + this.RPSI[i] * this.RPSI[i + 1] + this.IPSI[i] * this.IPSI[i + 1];
            su = su + this.RPSI[i] * this.RPSI[i - 1] + this.IPSI[i] * this.IPSI[i - 1];
        }
        su = su + this.RPSI[0] * this.RPSI[1] + this.IPSI[0] * this.IPSI[1];
        su = su + this.RPSI[this.NDIM - 1] * this.RPSI[this.NDIM - 2] + this.IPSI[this.NDIM - 1] * this.IPSI[this.NDIM - 2];
        this.Ekin = this.Ekin + su - 2.0 * this.Norm;
        this.Ekin = -this.Ekin / this.dx2h;
        this.jLabel2.setText("Norm=" + this.df1.format(this.Norm));
        this.jLabel3.setText("Epot=" + this.df1.format(this.Epot));
        this.jLabel4.setText("Ekin=" + this.df1.format(this.Ekin));
        this.jLabel5.setText("Etot=" + this.df1.format(this.Epot + this.Ekin));
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void initwaves2() {
        double imdel;
        double rdel;
        int i;
        for (i = 1; i < this.NDIM - 1; ++i) {
            rdel = (this.V[i] + 1.0 / this.dx2) * this.IPSI[i] - this.IPSI[i - 1] / this.dx2h - this.IPSI[i + 1] / this.dx2h;
            this.DRPSI[i] = rdel = -rdel * this.DELTAT;
            imdel = (this.V[i] + 1.0 / this.dx2) * this.RPSI[i] - this.RPSI[i - 1] / this.dx2h - this.RPSI[i + 1] / this.dx2h;
            this.DIPSI[i] = imdel *= this.DELTAT;
        }
        rdel = (this.V[0] + 1.0 / this.dx2) * this.IPSI[0] - this.IPSI[1] / this.dx2h;
        this.DRPSI[0] = rdel = -rdel * this.DELTAT;
        imdel = (this.V[0] + 1.0 / this.dx2) * this.RPSI[0] - this.RPSI[1] / this.dx2h;
        this.DIPSI[0] = imdel *= this.DELTAT;
        rdel = (this.V[this.NDIM - 1] + 1.0 / this.dx2) * this.IPSI[this.NDIM - 1] - this.IPSI[this.NDIM - 2] / this.dx2h;
        this.DRPSI[this.NDIM - 1] = rdel = -rdel * this.DELTAT;
        imdel = (this.V[this.NDIM - 1] + 1.0 / this.dx2) * this.RPSI[this.NDIM - 1] - this.RPSI[this.NDIM - 2] / this.dx2h;
        this.DIPSI[this.NDIM - 1] = imdel *= this.DELTAT;
        for (i = 0; i < this.NDIM; ++i) {
            this.RPSIO[i] = this.RPSI[i] + this.DRPSI[i];
            this.IPSIO[i] = this.IPSI[i] + this.DIPSI[i];
        }
    }

    void initwaves25p() {
        int i;
        double c0 = 1.25;
        double c1 = -0.6666666666666666;
        double c2 = 0.041666666666666664;
        for (i = 0; i < this.NDIM; ++i) {
            double rdel = (this.V[i] + c0 / this.dx2) * this.IPSI[i];
            if (i > 0) {
                rdel += c1 * this.IPSI[i - 1] / this.dx2;
            }
            if (i > 1) {
                rdel += c2 * this.IPSI[i - 2] / this.dx2;
            }
            if (i < this.NDIM - 1) {
                rdel += c1 * this.IPSI[i + 1] / this.dx2;
            }
            if (i < this.NDIM - 2) {
                rdel += c2 * this.IPSI[i + 2] / this.dx2;
            }
            this.DRPSI[i] = rdel = -rdel * this.DELTAT;
            double imdel = (this.V[i] + c0 / this.dx2) * this.RPSI[i];
            if (i > 0) {
                imdel += c1 * this.RPSI[i - 1] / this.dx2;
            }
            if (i > 1) {
                imdel += c2 * this.RPSI[i - 2] / this.dx2;
            }
            if (i < this.NDIM - 1) {
                imdel += c1 * this.RPSI[i + 1] / this.dx2;
            }
            if (i < this.NDIM - 2) {
                imdel += c2 * this.RPSI[i + 2] / this.dx2;
            }
            this.DIPSI[i] = imdel *= this.DELTAT;
        }
        for (i = 0; i < this.NDIM; ++i) {
            this.RPSIO[i] = this.RPSI[i] + this.DRPSI[i];
            this.IPSIO[i] = this.IPSI[i] + this.DIPSI[i];
        }
    }

    void initwaves27p() {
        int i;
        double c0 = 1.3611111111111112;
        double c1 = -0.75;
        double c2 = 0.075;
        double c3 = -0.005555555555555556;
        for (i = 0; i < this.NDIM; ++i) {
            double rdel = (this.V[i] + c0 / this.dx2) * this.IPSI[i];
            if (i > 0) {
                rdel += c1 * this.IPSI[i - 1] / this.dx2;
            }
            if (i > 1) {
                rdel += c2 * this.IPSI[i - 2] / this.dx2;
            }
            if (i > 2) {
                rdel += c3 * this.IPSI[i - 3] / this.dx2;
            }
            if (i < this.NDIM - 1) {
                rdel += c1 * this.IPSI[i + 1] / this.dx2;
            }
            if (i < this.NDIM - 2) {
                rdel += c2 * this.IPSI[i + 2] / this.dx2;
            }
            if (i < this.NDIM - 3) {
                rdel += c3 * this.IPSI[i + 3] / this.dx2;
            }
            this.DRPSI[i] = rdel = -rdel * this.DELTAT;
            double imdel = (this.V[i] + c0 / this.dx2) * this.RPSI[i];
            if (i > 0) {
                imdel += c1 * this.RPSI[i - 1] / this.dx2;
            }
            if (i > 1) {
                imdel += c2 * this.RPSI[i - 2] / this.dx2;
            }
            if (i > 2) {
                imdel += c3 * this.RPSI[i - 3] / this.dx2;
            }
            if (i < this.NDIM - 1) {
                imdel += c1 * this.RPSI[i + 1] / this.dx2;
            }
            if (i < this.NDIM - 2) {
                imdel += c2 * this.RPSI[i + 2] / this.dx2;
            }
            if (i < this.NDIM - 3) {
                imdel += c3 * this.RPSI[i + 3] / this.dx2;
            }
            this.DIPSI[i] = imdel *= this.DELTAT;
        }
        for (i = 0; i < this.NDIM; ++i) {
            this.RPSIO[i] = this.RPSI[i] + this.DRPSI[i];
            this.IPSIO[i] = this.IPSI[i] + this.DIPSI[i];
        }
    }

    void waves2() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.il = 0;
        while (this.il < this.innerloops) {
            double imdel;
            double rdel;
            this.totaltime += this.DELTAT;
            for (i = 1; i < this.NDIM - 1; ++i) {
                rdel = (this.V[i] + 1.0 / this.dx2) * this.IPSI[i] - this.IPSI[i - 1] / this.dx2h - this.IPSI[i + 1] / this.dx2h;
                this.DRPSI[i] = rdel = 2.0 * rdel * this.DELTAT;
                imdel = (this.V[i] + 1.0 / this.dx2) * this.RPSI[i] - this.RPSI[i - 1] / this.dx2h - this.RPSI[i + 1] / this.dx2h;
                this.DIPSI[i] = imdel = -2.0 * imdel * this.DELTAT;
            }
            rdel = (this.V[0] + 1.0 / this.dx2) * this.IPSI[0] - this.IPSI[1] / this.dx2h;
            this.DRPSI[0] = rdel = 2.0 * rdel * this.DELTAT;
            imdel = (this.V[0] + 1.0 / this.dx2) * this.RPSI[0] - this.RPSI[1] / this.dx2h;
            this.DIPSI[0] = imdel = -2.0 * imdel * this.DELTAT;
            rdel = (this.V[this.NDIM - 1] + 1.0 / this.dx2) * this.IPSI[this.NDIM - 1] - this.IPSI[this.NDIM - 2] / this.dx2h;
            this.DRPSI[this.NDIM - 1] = rdel = 2.0 * rdel * this.DELTAT;
            imdel = (this.V[this.NDIM - 1] + 1.0 / this.dx2) * this.RPSI[this.NDIM - 1] - this.RPSI[this.NDIM - 2] / this.dx2h;
            this.DIPSI[this.NDIM - 1] = imdel = -2.0 * imdel * this.DELTAT;
            for (i = 0; i < this.NDIM; ++i) {
                rdel = this.RPSI[i];
                imdel = this.IPSI[i];
                this.RPSI[i] = this.RPSIO[i] + this.DRPSI[i];
                this.IPSI[i] = this.IPSIO[i] + this.DIPSI[i];
                this.RPSIO[i] = rdel;
                this.IPSIO[i] = imdel;
            }
            ++this.il;
        }
        this.Ekin = 0.0;
        this.Epot = 0.0;
        this.Norm = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            double amp = this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i];
            this.Norm += amp;
            this.Epot += amp * this.V[i];
        }
        double su = 0.0;
        for (i = 1; i < this.NDIM - 1; ++i) {
            su = su + this.RPSI[i] * this.RPSI[i + 1] + this.IPSI[i] * this.IPSI[i + 1];
            su = su + this.RPSI[i] * this.RPSI[i - 1] + this.IPSI[i] * this.IPSI[i - 1];
        }
        su = su + this.RPSI[0] * this.RPSI[1] + this.IPSI[0] * this.IPSI[1];
        su = su + this.RPSI[this.NDIM - 1] * this.RPSI[this.NDIM - 2] + this.IPSI[this.NDIM - 1] * this.IPSI[this.NDIM - 2];
        this.Ekin = this.Ekin + su - 2.0 * this.Norm;
        this.Ekin = -this.Ekin / this.dx2h;
        this.jLabel2.setText("Norm=" + this.df1.format(this.Norm));
        this.jLabel3.setText("Epot=" + this.df1.format(this.Epot));
        this.jLabel4.setText("Ekin=" + this.df1.format(this.Ekin));
        this.jLabel5.setText("Etot=" + this.df1.format(this.Epot + this.Ekin));
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void waves25p() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        double c0 = 1.25;
        double c1 = -0.6666666666666666;
        double c2 = 0.041666666666666664;
        this.il = 0;
        while (this.il < this.innerloops) {
            double imdel;
            double rdel;
            this.totaltime += this.DELTAT;
            for (i = 0; i < this.NDIM; ++i) {
                rdel = (this.V[i] + c0 / this.dx2) * this.IPSI[i];
                if (i > 0) {
                    rdel += c1 * this.IPSI[i - 1] / this.dx2;
                }
                if (i > 1) {
                    rdel += c2 * this.IPSI[i - 2] / this.dx2;
                }
                if (i < this.NDIM - 1) {
                    rdel += c1 * this.IPSI[i + 1] / this.dx2;
                }
                if (i < this.NDIM - 2) {
                    rdel += c2 * this.IPSI[i + 2] / this.dx2;
                }
                this.DRPSI[i] = rdel = 2.0 * rdel * this.DELTAT;
                imdel = (this.V[i] + c0 / this.dx2) * this.RPSI[i];
                if (i > 0) {
                    imdel += c1 * this.RPSI[i - 1] / this.dx2;
                }
                if (i > 1) {
                    imdel += c2 * this.RPSI[i - 2] / this.dx2;
                }
                if (i < this.NDIM - 1) {
                    imdel += c1 * this.RPSI[i + 1] / this.dx2;
                }
                if (i < this.NDIM - 2) {
                    imdel += c2 * this.RPSI[i + 2] / this.dx2;
                }
                this.DIPSI[i] = imdel = -2.0 * imdel * this.DELTAT;
            }
            for (i = 0; i < this.NDIM; ++i) {
                rdel = this.RPSI[i];
                imdel = this.IPSI[i];
                this.RPSI[i] = this.RPSIO[i] + this.DRPSI[i];
                this.IPSI[i] = this.IPSIO[i] + this.DIPSI[i];
                this.RPSIO[i] = rdel;
                this.IPSIO[i] = imdel;
            }
            ++this.il;
        }
        this.Ekin = 0.0;
        this.Epot = 0.0;
        this.Norm = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            double amp = this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i];
            this.Norm += amp;
            this.Epot += amp * this.V[i];
        }
        double su = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            su += c0 * (this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i]);
            if (i > 0) {
                su += c1 * (this.RPSI[i] * this.RPSI[i - 1] + this.IPSI[i] * this.IPSI[i - 1]);
            }
            if (i < this.NDIM - 1) {
                su += c1 * (this.RPSI[i] * this.RPSI[i + 1] + this.IPSI[i] * this.IPSI[i + 1]);
            }
            if (i > 1) {
                su += c2 * (this.RPSI[i] * this.RPSI[i - 2] + this.IPSI[i] * this.IPSI[i - 2]);
            }
            if (i >= this.NDIM - 2) continue;
            su += c2 * (this.RPSI[i] * this.RPSI[i + 2] + this.IPSI[i] * this.IPSI[i + 2]);
        }
        this.Ekin = su / this.dx2;
        this.jLabel2.setText("Norm=" + this.df1.format(this.Norm));
        this.jLabel3.setText("Epot=" + this.df1.format(this.Epot));
        this.jLabel4.setText("Ekin=" + this.df1.format(this.Ekin));
        this.jLabel5.setText("Etot=" + this.df1.format(this.Epot + this.Ekin));
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void waves27p() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        double c0 = 1.3611111111111112;
        double c1 = -0.75;
        double c2 = 0.075;
        double c3 = -0.005555555555555556;
        this.il = 0;
        while (this.il < this.innerloops) {
            double imdel;
            double rdel;
            this.totaltime += this.DELTAT;
            for (i = 0; i < this.NDIM; ++i) {
                rdel = (this.V[i] + c0 / this.dx2) * this.IPSI[i];
                if (i > 0) {
                    rdel += c1 * this.IPSI[i - 1] / this.dx2;
                }
                if (i > 1) {
                    rdel += c2 * this.IPSI[i - 2] / this.dx2;
                }
                if (i > 2) {
                    rdel += c3 * this.IPSI[i - 3] / this.dx2;
                }
                if (i < this.NDIM - 1) {
                    rdel += c1 * this.IPSI[i + 1] / this.dx2;
                }
                if (i < this.NDIM - 2) {
                    rdel += c2 * this.IPSI[i + 2] / this.dx2;
                }
                if (i < this.NDIM - 3) {
                    rdel += c3 * this.IPSI[i + 3] / this.dx2;
                }
                this.DRPSI[i] = rdel = 2.0 * rdel * this.DELTAT;
                imdel = (this.V[i] + c0 / this.dx2) * this.RPSI[i];
                if (i > 0) {
                    imdel += c1 * this.RPSI[i - 1] / this.dx2;
                }
                if (i > 1) {
                    imdel += c2 * this.RPSI[i - 2] / this.dx2;
                }
                if (i > 2) {
                    imdel += c3 * this.RPSI[i - 3] / this.dx2;
                }
                if (i < this.NDIM - 1) {
                    imdel += c1 * this.RPSI[i + 1] / this.dx2;
                }
                if (i < this.NDIM - 2) {
                    imdel += c2 * this.RPSI[i + 2] / this.dx2;
                }
                if (i < this.NDIM - 3) {
                    imdel += c3 * this.RPSI[i + 3] / this.dx2;
                }
                this.DIPSI[i] = imdel = -2.0 * imdel * this.DELTAT;
            }
            for (i = 0; i < this.NDIM; ++i) {
                rdel = this.RPSI[i];
                imdel = this.IPSI[i];
                this.RPSI[i] = this.RPSIO[i] + this.DRPSI[i];
                this.IPSI[i] = this.IPSIO[i] + this.DIPSI[i];
                this.RPSIO[i] = rdel;
                this.IPSIO[i] = imdel;
            }
            ++this.il;
        }
        this.Ekin = 0.0;
        this.Epot = 0.0;
        this.Norm = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            double amp = this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i];
            this.Norm += amp;
            this.Epot += amp * this.V[i];
        }
        double su = 0.0;
        for (i = 0; i < this.NDIM; ++i) {
            su += c0 * (this.RPSI[i] * this.RPSI[i] + this.IPSI[i] * this.IPSI[i]);
            if (i > 0) {
                su += c1 * (this.RPSI[i] * this.RPSI[i - 1] + this.IPSI[i] * this.IPSI[i - 1]);
            }
            if (i < this.NDIM - 1) {
                su += c1 * (this.RPSI[i] * this.RPSI[i + 1] + this.IPSI[i] * this.IPSI[i + 1]);
            }
            if (i > 1) {
                su += c2 * (this.RPSI[i] * this.RPSI[i - 2] + this.IPSI[i] * this.IPSI[i - 2]);
            }
            if (i < this.NDIM - 2) {
                su += c2 * (this.RPSI[i] * this.RPSI[i + 2] + this.IPSI[i] * this.IPSI[i + 2]);
            }
            if (i > 2) {
                su += c3 * (this.RPSI[i] * this.RPSI[i - 3] + this.IPSI[i] * this.IPSI[i - 3]);
            }
            if (i >= this.NDIM - 3) continue;
            su += c3 * (this.RPSI[i] * this.RPSI[i + 3] + this.IPSI[i] * this.IPSI[i + 3]);
        }
        this.Ekin = su / this.dx2;
        this.jLabel2.setText("Norm=" + this.df1.format(this.Norm));
        this.jLabel3.setText("Epot=" + this.df1.format(this.Epot));
        this.jLabel4.setText("Ekin=" + this.df1.format(this.Ekin));
        this.jLabel5.setText("Etot=" + this.df1.format(this.Epot + this.Ekin));
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void draw() {
        int y2;
        int y1;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.blue);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)(this.V[i] * 10.0);
            y2 = 200 - (int)(this.V[i + 1] * 10.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NDIM - 1; ++i) {
            y1 = 200 - (int)((this.IPSI[i] * this.IPSI[i] + this.RPSI[i] * this.RPSI[i]) * 1500.0);
            y2 = 200 - (int)((this.IPSI[i + 1] * this.IPSI[i + 1] + this.RPSI[i + 1] * this.RPSI[i + 1]) * 1500.0);
            this.gb.drawLine(i, y1, i + 1, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)waveapplet.this.image, 0, 0, null);
        }
    }
}

