/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class poissonapplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int NMAX = 100;
    int NSIZE = 100;
    double grid0 = 0.1;
    double grid;
    double DK = 80.0;
    double kappa = 0.0;
    double omega = 1.8;
    double radius = 0.25;
    double[][][] U;
    double[][][] eps;
    double[][][] qg;
    int[][][] inside;
    double[] maxdev;
    double[] uzer;
    double csum;
    double vol;
    double r;
    double fac;
    double su;
    double se;
    double smax;
    double e000;
    double e100;
    double e010;
    double e001;
    double em100;
    double e0m10;
    double e00m1;
    int ipp;
    int loop;
    int i_m;
    int j_m;
    int k_m;
    int i;
    int j;
    int k;
    int l;
    int m;
    int n;
    int imax;
    int i1;
    int jj1;
    int k1;
    double x;
    double y;
    double z;
    double dx;
    double dy;
    double dz;
    double q;
    double shielding;
    double hscale;
    int initial = 0;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JTextArea jTextArea1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    poissonapplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init_variables();
        this.reset();
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.loop > 1000) {
            return;
        }
        this.iterate();
        this.timer.setInitialDelay(1);
        this.timer.setDelay(1);
        this.timer.restart();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSlider3 = new JSlider();
        this.jLabel4 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jComboBox1 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 482, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 571, Short.MAX_VALUE));
        this.jLabel1.setText("NSIZE");
        this.jButton1.setText("Restart");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                poissonapplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSlider1.setMaximum(800);
        this.jSlider1.setMinimum(10);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                poissonapplet.this.jSlider1MouseReleased(evt);
            }
        });
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                poissonapplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                poissonapplet.this.jSlider2MouseReleased(evt);
            }
        });
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                poissonapplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("jLabel3");
        this.jSlider3.setMaximum(200);
        this.jSlider3.setMinimum(100);
        this.jSlider3.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                poissonapplet.this.jSlider3MouseReleased(evt);
            }
        });
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                poissonapplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel4.setText("jLabel3");
        this.jSlider4.setMajorTickSpacing(20);
        this.jSlider4.setMinimum(20);
        this.jSlider4.setMinorTickSpacing(10);
        this.jSlider4.setPaintLabels(true);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.setSnapToTicks(true);
        this.jSlider4.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                poissonapplet.this.jSlider4MouseReleased(evt);
            }
        });
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                poissonapplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"zero", "guess"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                poissonapplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel5.setText("jLabel5");
        this.jLabel6.setText("initial values:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(109, 109, 109).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jLabel2))).addGroup(layout.createSequentialGroup().addGap(110, 110, 110).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addGap(114, 114, 114).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addGap(54, 54, 54).addComponent(this.jSlider4, -2, 159, -2)).addGroup(layout.createSequentialGroup().addGap(62, 62, 62).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider2, -2, 159, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSlider1, GroupLayout.Alignment.TRAILING, -1, 159, Short.MAX_VALUE).addComponent(this.jSlider3, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(118, 118, 118).addComponent(this.jLabel1))).addContainerGap(308, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jButton1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(26, 26, 26).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider3, -2, -1, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel6)).addGap(34, 34, 34).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, -1, -2).addGap(50, 50, 50).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 116, -2)).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset();
        this.loop = 0;
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.jLabel2.setText("DK=" + this.df.format((double)this.jSlider1.getValue() * 0.1));
    }

    private void jSlider1MouseReleased(MouseEvent evt) {
        this.DK = (double)this.jSlider1.getValue() * 0.1;
        this.reset();
        this.loop = 0;
    }

    private void jSlider2MouseReleased(MouseEvent evt) {
        this.kappa = (double)this.jSlider2.getValue() * 0.1;
        this.reset();
        this.loop = 0;
    }

    private void jSlider3MouseReleased(MouseEvent evt) {
        this.omega = (double)this.jSlider3.getValue() * 0.01;
        this.reset();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.jLabel3.setText("kappa=" + this.df.format((double)this.jSlider2.getValue() * 0.1));
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.jLabel4.setText("omega=" + this.df.format((double)this.jSlider3.getValue() * 0.01));
    }

    private void jSlider4MouseReleased(MouseEvent evt) {
        this.NSIZE = this.jSlider4.getValue();
        this.reset();
        this.loop = 0;
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.initial = this.jComboBox1.getSelectedIndex();
    }

    void init_variables() {
        this.U = new double[this.NMAX][this.NMAX][this.NMAX];
        this.eps = new double[this.NMAX][this.NMAX][this.NMAX];
        this.qg = new double[this.NMAX][this.NMAX][this.NMAX];
        this.inside = new int[this.NMAX][this.NMAX][this.NMAX];
        this.uzer = new double[this.NMAX];
        this.maxdev = new double[1000];
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.df = new DecimalFormat("##.00");
        this.jSlider2.setValue((int)(10.0 * this.kappa));
        this.jLabel3.setText("kappa=" + this.df.format(this.kappa));
        this.jSlider3.setValue((int)(this.omega * 100.0));
        this.jLabel4.setText("omega=" + this.df.format(this.omega));
        this.jSlider1.setValue((int)(10.0 * this.DK));
        this.jLabel2.setText("DK=" + this.df.format(this.DK));
        this.jSlider4.setValue(this.NSIZE);
    }

    void reset() {
        this.set_variables();
        this.sphere12();
        if (this.initial == 1) {
            this.estimate();
        } else {
            this.initialzero();
        }
        this.loop = 0;
        this.smax = 1.0;
    }

    void set_variables() {
        this.hscale = 500.0 / (double)this.NSIZE;
        this.grid = this.grid0 * this.hscale * 0.1;
        this.jLabel1.setText("NSIZE , grid=" + this.df.format(this.grid));
        this.fac = 1.6021760000000001E-9 / (8.8542E-12 * this.grid);
        this.shielding = this.kappa * this.kappa * this.grid * this.grid;
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.U[this.i][this.j][this.k] = 0.0;
                    this.eps[this.i][this.j][this.k] = this.DK;
                    this.inside[this.i][this.j][this.k] = 0;
                    this.qg[this.l][this.j][this.k] = 0.0;
                    ++this.k;
                }
                ++this.j;
            }
            this.smax = 1.0;
            ++this.i;
        }
        this.i = 0;
        while (this.i < 1000) {
            this.maxdev[this.i] = 1.0;
            ++this.i;
        }
    }

    void sphere12() {
        this.l = this.NSIZE / 2;
        this.j = this.NSIZE / 2;
        this.k = this.NSIZE / 2;
        double cellvol = 4.1887902047863905 * this.radius * this.radius * this.radius / (this.grid * this.grid * this.grid);
        int nreso = 21;
        int nin = 0;
        int nout = 0;
        int nbound = 0;
        int nall = 0;
        this.i1 = 0;
        while (this.i1 < this.NSIZE) {
            this.jj1 = 0;
            while (this.jj1 < this.NSIZE) {
                this.k1 = 0;
                while (this.k1 < this.NSIZE) {
                    double dx = ((double)Math.abs(this.i1 - this.l) + 0.5) * this.grid;
                    double dy = ((double)Math.abs(this.jj1 - this.j) + 0.5) * this.grid;
                    double dz = ((double)Math.abs(this.k1 - this.k) + 0.5) * this.grid;
                    double maxd = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx = ((double)Math.abs(this.i1 - this.l) - 0.5) * this.grid;
                    dy = ((double)Math.abs(this.jj1 - this.j) - 0.5) * this.grid;
                    dz = ((double)Math.abs(this.k1 - this.k) - 0.5) * this.grid;
                    double mind = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (maxd <= this.radius) {
                        this.inside[this.i1][this.jj1][this.k1] = 1;
                        this.eps[this.i1][this.jj1][this.k1] = 1.0;
                        this.qg[this.i1][this.jj1][this.k1] = 1.0 / cellvol;
                        ++nin;
                    }
                    if (mind <= this.radius && maxd > this.radius) {
                        int iv = 0;
                        for (int il = 0; il < nreso; ++il) {
                            for (int jl = 0; jl < nreso; ++jl) {
                                for (int kl = 0; kl < nreso; ++kl) {
                                    int nsub = (nreso - 1) / 2;
                                    dx = (double)(this.i1 - this.l) * this.grid + (double)(il - nsub) * this.grid / (double)nreso;
                                    dy = (double)(this.jj1 - this.j) * this.grid + (double)(jl - nsub) * this.grid / (double)nreso;
                                    dz = (double)(this.k1 - this.k) * this.grid + (double)(kl - nsub) * this.grid / (double)nreso;
                                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                                    if (!(dist <= this.radius)) continue;
                                    ++iv;
                                }
                            }
                        }
                        double vol = (double)iv / (double)(nreso * nreso * nreso);
                        this.inside[this.i1][this.jj1][this.k1] = 1;
                        this.eps[this.i1][this.jj1][this.k1] = 1.0 / (vol + (1.0 - vol) / this.DK);
                        this.qg[this.i1][this.jj1][this.k1] = vol / cellvol;
                        ++nbound;
                    }
                    if (mind > this.radius) {
                        this.inside[this.i1][this.jj1][this.k1] = 0;
                        this.eps[this.i1][this.jj1][this.k1] = this.DK;
                        this.qg[this.i1][this.jj1][this.k1] = 0.0;
                        ++nout;
                    }
                    ++nall;
                    ++this.k1;
                }
                ++this.jj1;
            }
            ++this.i1;
        }
        this.jTextArea1.setText("");
        this.jTextArea1.append("radius of sphere:" + this.radius + "\n" + "cells:" + nall + "\n" + "inside: " + nin + "\n" + "boundary: " + nbound + "\n" + "outside: " + nout + "\n");
        this.csum = 0.0;
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.csum += this.qg[this.i][this.j][this.k];
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        this.jTextArea1.append("total charge " + this.csum + "\n");
    }

    void sphere() {
        this.l = this.NSIZE / 2;
        this.j = this.NSIZE / 2;
        this.k = this.NSIZE / 2;
        this.imax = (int)(this.radius / this.grid);
        int imax2 = (int)(this.radius * this.radius / (this.grid * this.grid));
        this.i1 = -this.imax;
        while (this.i1 < this.imax + 1) {
            this.jj1 = -this.imax;
            while (this.jj1 < this.imax + 1) {
                this.k1 = -this.imax;
                while (this.k1 < this.imax + 1) {
                    if (this.i1 * this.i1 + this.jj1 * this.jj1 + this.k1 * this.k1 <= imax2 && this.l + this.i1 >= 0 && this.l + this.i1 < this.NSIZE && this.j + this.jj1 >= 0 && this.j + 1 < this.NSIZE && this.k + this.k1 >= 0 && this.k + this.k1 < this.NSIZE) {
                        this.inside[this.l + this.i1][this.j + this.jj1][this.k + this.k1] = 1;
                        this.eps[this.l + this.i1][this.j + this.jj1][this.k + this.k1] = 1.0;
                        this.qg[this.l + this.i1][this.j + this.jj1][this.k + this.k1] = 1.0;
                    }
                    ++this.k1;
                }
                ++this.jj1;
            }
            ++this.i1;
        }
        this.csum = 0.0;
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.csum += this.qg[this.i][this.j][this.k];
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.qg[this.i][this.j][this.k] = this.qg[this.i][this.j][this.k] / this.csum;
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    void initialzero() {
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.uzer[this.i] = 0.0;
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.U[this.i][this.j][this.k] = 0.0;
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    void estimate() {
        double erad = this.radius;
        double V0 = 7.2 * (this.DK * this.kappa * erad + this.DK + 2.0) / (this.DK * erad * (1.0 + this.kappa * erad));
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.j = 0;
            while (this.j < this.NSIZE) {
                this.k = 0;
                while (this.k < this.NSIZE) {
                    this.x = this.grid * (double)(this.i - this.NSIZE / 2);
                    this.y = this.grid * (double)(this.j - this.NSIZE / 2);
                    this.z = this.grid * (double)(this.k - this.NSIZE / 2);
                    this.r = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
                    this.U[this.i][this.j][this.k] = this.r < erad ? V0 - 7.2 * this.r * this.r / (erad * erad * erad) : 14.4 * Math.exp(this.kappa * (erad - this.r)) / (this.DK * this.r * (1.0 + this.kappa * erad));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.NSIZE) {
            this.uzer[this.i] = this.U[this.i][this.NSIZE / 2][this.NSIZE / 2];
            ++this.i;
        }
    }

    void iterate() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        if (this.loop < 999) {
            int iy1;
            int iy0;
            this.smax = 0.0;
            this.i = 1;
            while (this.i < this.NSIZE - 1) {
                this.j = 1;
                while (this.j < this.NSIZE - 1) {
                    this.k = 1;
                    while (this.k < this.NSIZE - 1) {
                        this.e000 = this.eps[this.i][this.j][this.k];
                        this.su = this.qg[this.i][this.j][this.k] * this.fac;
                        this.e100 = 2.0 * (this.eps[this.i + 1][this.j][this.k] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i + 1][this.j][this.k] + this.eps[this.i][this.j][this.k]);
                        double s1 = this.U[this.i + 1][this.j][this.k] * this.e100;
                        double e200 = 2.0 * (this.eps[this.i - 1][this.j][this.k] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i - 1][this.j][this.k] + this.eps[this.i][this.j][this.k]);
                        double s2 = this.U[this.i - 1][this.j][this.k] * e200;
                        this.e010 = 2.0 * (this.eps[this.i][this.j + 1][this.k] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i][this.j + 1][this.k] + this.eps[this.i][this.j][this.k]);
                        double s3 = this.U[this.i][this.j + 1][this.k] * this.e010;
                        double e020 = 2.0 * (this.eps[this.i][this.j - 1][this.k] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i][this.j - 1][this.k] + this.eps[this.i][this.j][this.k]);
                        double s4 = this.U[this.i][this.j - 1][this.k] * e020;
                        this.e001 = 2.0 * (this.eps[this.i][this.j][this.k + 1] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i][this.j][this.k + 1] + this.eps[this.i][this.j][this.k]);
                        double s5 = this.U[this.i][this.j][this.k + 1] * this.e001;
                        double e002 = 2.0 * (this.eps[this.i][this.j][this.k - 1] * this.eps[this.i][this.j][this.k]) / (this.eps[this.i][this.j][this.k - 1] + this.eps[this.i][this.j][this.k]);
                        double s6 = this.U[this.i][this.j][this.k - 1] * e002;
                        double em = this.e100 + e200 + this.e010 + e020 + this.e001 + e002;
                        this.su = (this.su + s1 + s2 + s3 + s4 + s5 + s6) / em;
                        if (Math.abs(this.U[this.i][this.j][this.k] - this.su) > this.smax) {
                            this.i_m = this.i;
                            this.j_m = this.j;
                            this.k_m = this.k;
                            this.smax = Math.abs(this.U[this.i][this.j][this.k] - this.su);
                        }
                        this.U[this.i][this.j][this.k] = this.omega * this.su + (1.0 - this.omega) * this.U[this.i][this.j][this.k];
                        ++this.k;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            this.maxdev[this.loop] = this.smax;
            this.csum = 0.0;
            this.i = 1;
            while (this.i < this.NSIZE - 1) {
                this.j = 1;
                while (this.j < this.NSIZE - 1) {
                    this.k = 1;
                    while (this.k < this.NSIZE - 1) {
                        this.csum += this.U[this.i][this.j][this.k] * this.qg[this.i][this.j][this.k];
                        ++this.k;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            this.jLabel5.setText("Energy: " + this.csum * 0.5);
            ++this.loop;
            this.gb.setBackground(Color.white);
            this.gb.clearRect(0, 0, 550, 650);
            this.gb.setColor(Color.black);
            this.gb.drawString("x", 400, 330);
            this.gb.drawString("maximum potential change", 10, 330);
            this.gb.drawLine(0, 300, 400, 300);
            this.i = 0;
            while (this.i <= this.NSIZE / 10) {
                iy0 = (int)((double)(10 * this.i) * this.hscale);
                this.gb.drawLine(iy0, 300, iy0, 307);
                this.gb.drawString("" + this.i * 10, iy0 - 4, 320);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.NSIZE) {
                iy0 = (int)((double)this.i * this.hscale);
                this.gb.drawLine(iy0, 300, iy0, 304);
                ++this.i;
            }
            this.gb.setColor(Color.red);
            this.gb.drawString("red=potential", 160, 20);
            this.i = 1;
            while (this.i < this.NSIZE) {
                iy0 = 300 - (int)(2.0 * this.U[this.i - 1][this.NSIZE / 2][this.NSIZE / 2]);
                iy1 = 300 - (int)(2.0 * this.U[this.i][this.NSIZE / 2][this.NSIZE / 2]);
                this.gb.drawLine((int)(this.hscale * (double)this.i), iy0, (int)(this.hscale * (double)(this.i + 1)), iy1);
                ++this.i;
            }
            this.gb.setColor(Color.blue);
            this.gb.drawString("blue=initial values", 20, 20);
            this.i = 1;
            while (this.i < this.NSIZE) {
                iy0 = 300 - (int)(2.0 * this.uzer[this.i - 1]);
                iy1 = 300 - (int)(2.0 * this.uzer[this.i]);
                this.gb.drawLine((int)(this.hscale * (double)this.i), iy0, (int)(this.hscale * (double)(this.i + 1)), iy1);
                ++this.i;
            }
            this.gb.setColor(Color.green);
            this.i = 1;
            while (this.i < this.loop) {
                if (this.maxdev[this.i] > 1.0E-15) {
                    this.gb.drawLine((int)(50.0 * Math.log(this.i)), (int)(350.0 - 5.0 * Math.log(this.maxdev[this.i - 1])), (int)(50.0 * Math.log(this.i + 1)), (int)(350.0 - 5.0 * Math.log(this.maxdev[this.i])));
                }
                ++this.i;
            }
            this.gb.setColor(Color.black);
            this.i = 1;
            while (this.i < 10) {
                this.gb.drawLine((int)(50.0 * Math.log(10 * this.i)), 350, (int)(50.0 * Math.log(10 * this.i)), 500);
                ++this.i;
            }
            this.i = 1;
            while (this.i < 11) {
                this.gb.drawLine((int)(50.0 * Math.log(100 * this.i)), 350, (int)(50.0 * Math.log(100 * this.i)), 500);
                ++this.i;
            }
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(0.1)), 400, (int)(350.0 - 5.0 * Math.log(0.1)));
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(0.001)), 400, (int)(350.0 - 5.0 * Math.log(0.001)));
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(1.0E-5)), 400, (int)(350.0 - 5.0 * Math.log(1.0E-5)));
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(1.0E-7)), 400, (int)(350.0 - 5.0 * Math.log(1.0E-7)));
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(1.0E-9)), 400, (int)(350.0 - 5.0 * Math.log(1.0E-9)));
            this.gb.drawLine(1, (int)(350.0 - 5.0 * Math.log(1.0E-11)), 400, (int)(350.0 - 5.0 * Math.log(1.0E-11)));
            this.gb.drawString("10", (int)(50.0 * Math.log(10.0)) - 5, 510);
            this.gb.drawString("100", (int)(50.0 * Math.log(100.0)) - 5, 510);
            this.gb.drawString("1000", (int)(50.0 * Math.log(1000.0)) - 5, 510);
            this.gb.drawString("iterations", 200, 520);
            this.gb.drawString("10^-3", 420, (int)(350.0 - 5.0 * Math.log(0.001)));
            this.gb.drawString("10^-7", 420, (int)(350.0 - 5.0 * Math.log(1.0E-7)));
            this.gb.drawString("10^-11", 420, (int)(350.0 - 5.0 * Math.log(1.0E-11)));
            g2.drawImage((Image)this.image, 0, 0, null);
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)poissonapplet.this.image, 0, 0, null);
        }
    }
}

