/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class waveapplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int count;
    int iloop;
    int iter;
    int i;
    int j;
    int k;
    int n;
    int color;
    double x;
    double y;
    double z;
    double x1;
    double x2;
    double y3;
    double y2;
    double dumax;
    double ddu;
    double csmax;
    double facx;
    double fact;
    double kdeltax;
    double sum;
    double sum2;
    double[] amp;
    double[] velo;
    double[] oldsd;
    double[] cp;
    double[] cm;
    double[] omegak;
    double[] u;
    int NMAX = 200;
    int NITER = 10000;
    double deltax = 0.1;
    double DELTAXSQ = 0.01;
    double vel = 1.0;
    double deltat = 0.1;
    double TP = 0.1;
    double TP0 = 0.1;
    double cutoff = 0.4;
    double phase = 0.0;
    double refr = 1.0;
    double refr0 = 1.0;
    boolean nonlinear = false;
    int pulsetype = 0;
    int disptype = 0;
    int anispeed = 1;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider speedSlider;
    private JLabel velLabel;
    private JSlider velSlider;

    public void actionPerformed(ActionEvent e) {
        this.k += this.anispeed - 1;
        this.waves();
        this.timer.setInitialDelay(1);
        this.timer.setDelay(1);
        this.timer.restart();
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    waveapplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("0.000");
        this.amp = new double[this.NMAX];
        this.velo = new double[this.NMAX];
        this.cp = new double[this.NMAX];
        this.cm = new double[this.NMAX];
        this.omegak = new double[this.NMAX];
        this.u = new double[this.NMAX];
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.velSlider.setValue((int)(this.vel * 100.0));
        this.velLabel.setText("velocity=" + this.df1.format(this.vel));
        this.speedSlider.setValue(1);
        this.reset_all();
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.velLabel = new JLabel();
        this.velSlider = new JSlider();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.speedSlider = new JSlider();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(400, 400));
        this.jPanel1.setMinimumSize(new Dimension(400, 400));
        this.jPanel1.setPreferredSize(new Dimension(400, 400));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setText("jLabel1");
        this.velLabel.setText("jLabel2");
        this.velSlider.setMaximum(200);
        this.velSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.velSliderMouseDragged(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"triangular pulse", "Gaussian pulse", "standing wave", "wave packet", "plucked string"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"dispersion on", "dispersion off"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setMaximum(10);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                waveapplet.this.speedSliderMouseDragged(evt);
            }
        });
        this.jButton1.setText("Restart");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waveapplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("animation speed");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(66, 66, 66).addComponent(this.jLabel1)).addGroup(jPanel2Layout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.jButton1)).addGroup(jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.speedSlider, -2, 144, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.velSlider, -2, 138, -2).addComponent(this.velLabel).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jComboBox2, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)))))).addContainerGap(18, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(39, 39, 39)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.velLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.velSlider, -2, -1, -2).addGap(38, 38, 38).addComponent(this.jComboBox1, -2, -1, -2).addGap(44, 44, 44).addComponent(this.jComboBox2, -2, -1, -2).addGap(36, 36, 36).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speedSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addGap(22, 22, 22)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(207, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE)).addContainerGap(133, Short.MAX_VALUE)));
    }

    private void velSliderMouseDragged(MouseEvent evt) {
        this.vel = (double)this.velSlider.getValue() * 0.01;
        this.velLabel.setText("velocity=" + this.df1.format(this.vel));
    }

    private void speedSliderMouseDragged(MouseEvent evt) {
        this.anispeed = this.speedSlider.getValue();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.pulsetype = this.jComboBox1.getSelectedIndex();
        this.reset_all();
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.disptype = this.jComboBox2.getSelectedIndex();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset_all();
    }

    void reset_all() {
        for (int i = 0; i < this.NMAX; ++i) {
            this.amp[i] = 0.0;
            this.velo[i] = 0.0;
        }
        this.k = 0;
        if (this.pulsetype == 0) {
            this.pulse();
        }
        if (this.pulsetype == 2) {
            this.standing_wave();
        }
        if (this.pulsetype == 3) {
            this.wave_packet();
        }
        if (this.pulsetype == 4) {
            this.plucked();
        }
        if (this.pulsetype == 1) {
            this.pulse2();
        }
        this.fourier();
    }

    void pulse() {
        int i;
        for (i = 0; i < this.NMAX; ++i) {
            this.amp[i] = 0.0;
            this.velo[i] = 0.0;
        }
        for (i = this.NMAX / 2 - 15; i < this.NMAX / 2; ++i) {
            this.velo[i] = -this.vel;
        }
        for (i = this.NMAX / 2; i < this.NMAX / 2 + 15; ++i) {
            this.velo[i] = this.vel;
        }
        for (i = this.NMAX / 2 - 15; i < this.NMAX / 2; ++i) {
            this.amp[i] = (double)(i - this.NMAX / 2 + 15) * this.deltat;
        }
        for (i = this.NMAX / 2; i < this.NMAX / 2 + 15; ++i) {
            this.amp[i] = (double)(-(i - this.NMAX / 2 - 15)) * this.deltat;
        }
    }

    void pulse2() {
        for (int i = 0; i < this.NMAX; ++i) {
            double x = (double)(i - this.NMAX / 2) / 10.0;
            this.amp[i] = Math.exp(-x * x);
            this.velo[i] = -this.vel * this.amp[i] * 4.0 * x / (this.deltat * 20.0);
        }
    }

    void standing_wave() {
        int i;
        for (i = 0; i < this.NMAX; ++i) {
            this.amp[i] = 0.0;
            this.velo[i] = 0.0;
        }
        for (i = 0; i < this.NMAX; ++i) {
            this.velo[i] = Math.sin((double)(20 * (i + 1)) * Math.PI / (double)(this.NMAX + 1));
        }
    }

    void wave_packet() {
        int i;
        for (i = 0; i < this.NMAX; ++i) {
            this.amp[i] = 0.0;
            this.velo[i] = 0.0;
        }
        for (i = 0; i < this.NMAX; ++i) {
            this.amp[i] = Math.exp((double)(-(i - this.NMAX / 2) * (i - this.NMAX / 2)) * 0.01) * Math.sin((double)i * Math.PI * 0.3);
        }
    }

    void plucked() {
        for (int i = 0; i < this.NMAX; ++i) {
            this.amp[i] = 0.0;
            this.velo[i] = 0.0;
        }
        this.velo[this.NMAX / 2] = 10.0;
    }

    void fourier() {
        for (int i = 0; i < this.NMAX; ++i) {
            this.kdeltax = (double)(i + 1) * Math.PI / (double)(this.NMAX + 1);
            this.omegak[i] = this.disptype == 0 ? 2.0 * this.vel * Math.sin(this.kdeltax / 2.0) / this.deltax : this.vel * this.kdeltax / this.deltax;
            this.sum = 0.0;
            this.sum2 = 0.0;
            this.j = 0;
            while (this.j < this.NMAX) {
                this.sum += this.amp[this.j] * Math.sin((double)(this.j + 1) * this.kdeltax);
                this.sum2 += this.velo[this.j] * Math.sin((double)(this.j + 1) * this.kdeltax);
                ++this.j;
            }
            this.cp[i] = 2.0 * this.sum / (double)this.NMAX;
            this.cm[i] = 2.0 * this.sum2 / ((double)this.NMAX * this.omegak[i]);
        }
    }

    void waves() {
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        for (i = 0; i < this.NMAX; ++i) {
            this.sum = 0.0;
            for (int j = 0; j < this.NMAX; ++j) {
                this.sum2 = this.cp[j] * Math.cos((double)this.k * this.deltat * this.omegak[j]) + this.cm[j] * Math.sin((double)this.k * this.deltat * this.omegak[j]);
                this.sum += this.sum2 * Math.sin((double)((i + 1) * (j + 1)) * Math.PI / (double)(this.NMAX + 1));
            }
            this.u[i] = this.sum;
        }
        this.gb.setColor(Color.white);
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.red);
        for (i = 0; i < this.NMAX - 1; ++i) {
            int y3 = (int)(200.0 - this.u[i] * 100.0);
            int y2 = (int)(200.0 - this.u[i + 1] * 100.0);
            this.gb.drawLine(2 * i, y3, 2 * i + 2, y2);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
        ++this.k;
        this.jLabel1.setText("" + this.k);
    }

    void draw() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)waveapplet.this.image, 0, 0, null);
        }
    }
}

