/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    double[][] RealC;
    double[][] ImagC;
    double[][] RealC2;
    double[][] ImagC2;
    double[][] RealC3;
    double[][] ImagC3;
    double[][] RealC4;
    double[][] ImagC4;
    double[][] RealF1;
    double[][] ImagF1;
    double[][] RealF2;
    double[][] ImagF2;
    double[][] RealF3;
    double[][] ImagF3;
    double[][] RealF4;
    double[][] ImagF4;
    int nstates = 2;
    int imeas = 0;
    double V = 0.2;
    double DeltaE = 5.0;
    double tstep = 0.002;
    double freq = 0.0;
    double tp = 10.0;
    double t1r = 0.1;
    double t2pr = 0.0;
    double t2r = 0.1;
    double t0 = 10.0;
    double average = 0.0;
    DecimalFormat df;
    private JLabel DEL;
    private JSlider DES;
    private JLabel VL;
    private JSlider VS;
    private JLabel freqL;
    private JButton jButton1;
    private JPanel jPanel1;
    private JLabel t2rlab;
    private JSlider t2rslider;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.timer = new Timer(1000, this);
        this.timer.setInitialDelay(100);
        this.RealC = new double[this.nstates][this.nstates];
        this.ImagC = new double[this.nstates][this.nstates];
        this.RealC2 = new double[this.nstates][this.nstates];
        this.ImagC2 = new double[this.nstates][this.nstates];
        this.RealC3 = new double[this.nstates][this.nstates];
        this.ImagC3 = new double[this.nstates][this.nstates];
        this.RealC4 = new double[this.nstates][this.nstates];
        this.ImagC4 = new double[this.nstates][this.nstates];
        this.RealF1 = new double[this.nstates][this.nstates];
        this.ImagF1 = new double[this.nstates][this.nstates];
        this.RealF2 = new double[this.nstates][this.nstates];
        this.ImagF2 = new double[this.nstates][this.nstates];
        this.RealF3 = new double[this.nstates][this.nstates];
        this.ImagF3 = new double[this.nstates][this.nstates];
        this.RealF4 = new double[this.nstates][this.nstates];
        this.ImagF4 = new double[this.nstates][this.nstates];
        this.df = new DecimalFormat("##0.000");
        this.VS.setValue((int)(this.V * 200.0));
        this.DES.setValue((int)(this.DeltaE * 20.0));
        this.t2rslider.setValue((int)(this.t2r * 50.0));
        this.VL.setText("V=" + this.df.format(this.V));
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.freqL.setText("frequency=" + this.df.format(this.freq));
        this.t2rlab.setText("1/t2=" + this.df.format(this.t2r));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.imeas >= 200) {
            return;
        }
        this.jPanel1.repaint();
        this.timer.setInitialDelay(10);
        this.timer.restart();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.VS = new JSlider();
        this.DES = new JSlider();
        this.freqL = new JLabel();
        this.DEL = new JLabel();
        this.VL = new JLabel();
        this.t2rslider = new JSlider();
        this.t2rlab = new JLabel();
        this.jButton1 = new JButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 597, Short.MAX_VALUE));
        this.VS.setMaximum(200);
        this.VS.setToolTipText("magnitude of the coupling");
        this.VS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.VSMouseDragged(evt);
            }
        });
        this.DES.setMaximum(200);
        this.DES.setToolTipText("energy gap of the two states");
        this.DES.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.DESMouseDragged(evt);
            }
        });
        this.freqL.setText("freq  ");
        this.DEL.setText("DeltaE ");
        this.VL.setText("V          ");
        this.t2rslider.setMaximum(200);
        this.t2rslider.setMinimum(20);
        this.t2rslider.setToolTipText("relaxation rate 1/t2");
        this.t2rslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.t2rsliderMouseDragged(evt);
            }
        });
        this.t2rlab.setText("1/t2");
        this.jButton1.setText("Go");
        this.jButton1.setToolTipText("start new scan");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.VS, -2, 133, -2).addComponent(this.DES, -2, 133, -2).addComponent(this.t2rslider, -2, 133, -2).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.VL)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.DEL)))).addGroup(layout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.t2rlab)).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.freqL))).addContainerGap(34, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.freqL).addGap(65, 65, 65).addComponent(this.VL).addGap(18, 18, 18).addComponent(this.VS, -2, -1, -2).addGap(46, 46, 46).addComponent(this.DEL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DES, -2, -1, -2).addGap(62, 62, 62).addComponent(this.t2rlab).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.t2rslider, -2, -1, -2).addGap(52, 52, 52).addComponent(this.jButton1)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void VSMouseDragged(MouseEvent evt) {
        this.V = (double)this.VS.getValue() * 0.005;
        this.VL.setText("V=" + this.df.format(this.V));
    }

    private void DESMouseDragged(MouseEvent evt) {
        this.DeltaE = (double)this.DES.getValue() * 0.05;
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
    }

    private void t2rsliderMouseDragged(MouseEvent evt) {
        this.t1r = this.t2r = (double)this.t2rslider.getValue() * 0.002;
        this.t2rlab.setText("1/t2=" + this.df.format(this.t2r));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.imeas = 0;
        this.timer.start();
        this.jPanel1.repaint();
    }

    double pulse(double t) {
        double fac = Math.sin(this.freq * t);
        if (t < 10.0) {
            fac *= 1.0 - Math.exp(-t * 0.5);
        }
        return fac;
    }

    void grad(double[][] RC, double[][] IC, double[][] RF, double[][] IF, double t) {
        double Vt = this.V * this.pulse(t);
        RF[0][0] = Vt * (IC[1][0] - IC[0][1]) - this.t1r * (RC[0][0] - 1.0);
        RF[1][1] = Vt * (IC[0][1] - IC[1][0]) - this.t1r * RC[1][1];
        RF[0][1] = Vt * (IC[1][1] - IC[0][0]) - this.DeltaE * IC[0][1] - this.t2r * RC[0][1];
        RF[1][0] = Vt * (IC[0][0] - IC[1][1]) + this.DeltaE * IC[1][0] - this.t2r * RC[1][0];
        IF[0][0] = -Vt * (RC[1][0] - RC[0][1]) - this.t1r * IC[0][0];
        IF[1][1] = -Vt * (RC[0][1] - RC[1][0]) - this.t1r * IC[1][1];
        IF[0][1] = -Vt * (RC[1][1] - RC[0][0]) + this.DeltaE * RC[0][1] - this.t2r * IC[0][1];
        IF[1][0] = -Vt * (RC[0][0] - RC[1][1]) - this.DeltaE * RC[1][0] - this.t2r * IC[1][0];
    }

    void advance(double[][] RC, double[][] IC, double[][] RF, double[][] IF, double[][] RC1, double[][] IC1, double step) {
        for (int i = 0; i < this.nstates; ++i) {
            for (int j = 0; j < this.nstates; ++j) {
                RC1[i][j] = RC[i][j] + RF[i][j] * step;
                IC1[i][j] = IC[i][j] + IF[i][j] * step;
            }
        }
    }

    void rk4(double t) {
        this.grad(this.RealC, this.ImagC, this.RealF1, this.ImagF1, t);
        this.advance(this.RealC, this.ImagC, this.RealF1, this.ImagF1, this.RealC2, this.ImagC2, this.tstep * 0.5);
        this.grad(this.RealC2, this.ImagC2, this.RealF2, this.ImagF2, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF2, this.ImagF2, this.RealC3, this.ImagC3, this.tstep * 0.5);
        this.grad(this.RealC3, this.ImagC3, this.RealF3, this.ImagF3, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF3, this.ImagF3, this.RealC4, this.ImagC4, this.tstep);
        this.grad(this.RealC4, this.ImagC4, this.RealF4, this.ImagF4, t + this.tstep);
        for (int i = 0; i < this.nstates; ++i) {
            for (int j = 0; j < this.nstates; ++j) {
                this.RealC[i][j] = this.RealC[i][j] + this.tstep * (this.RealF1[i][j] + 2.0 * this.RealF2[i][j] + 2.0 * this.RealF3[i][j] + this.RealF4[i][j]) / 6.0;
                this.ImagC[i][j] = this.ImagC[i][j] + this.tstep * (this.ImagF1[i][j] + 2.0 * this.ImagF2[i][j] + 2.0 * this.ImagF3[i][j] + this.ImagF4[i][j]) / 6.0;
            }
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        int i1;
        int iz0;
        int iz1;
        int ip0;
        int ip1;

        void iterate() {
        }

        public double cabs(double x, double y) {
            double r = Math.sqrt(x * x + y * y);
            return r;
        }

        public void paintComponent(Graphics g) {
            if (NewJApplet.this.imeas == 0) {
                super.paintComponent(g);
                g.clearRect(0, 300, 400, 100);
            }
            if (NewJApplet.this.imeas < 200) {
                g.clearRect(0, 50, 400, 200);
                NewJApplet.this.freq = (double)NewJApplet.this.imeas * 0.05;
                NewJApplet.this.freqL.setText("frequency=" + NewJApplet.this.df.format(NewJApplet.this.freq));
                NewJApplet.this.RealC[0][0] = 1.0;
                NewJApplet.this.ImagC[0][0] = 0.0;
                NewJApplet.this.RealC[1][0] = 0.0;
                NewJApplet.this.ImagC[1][0] = 0.0;
                NewJApplet.this.RealC[0][1] = 0.0;
                NewJApplet.this.ImagC[0][1] = 0.0;
                NewJApplet.this.RealC[1][1] = 0.0;
                NewJApplet.this.ImagC[1][1] = 0.0;
                this.iy0 = 250;
                this.ix0 = 100;
                this.iz0 = 0;
                double t = 0.0;
                NewJApplet.this.average = 0.0;
                this.i = 0;
                while (this.i < 400) {
                    this.i1 = 0;
                    while (this.i1 < 100) {
                        NewJApplet.this.rk4(t += NewJApplet.this.tstep);
                        ++this.i1;
                    }
                    if (this.i >= 200) {
                        NewJApplet.this.average += this.cabs(NewJApplet.this.RealC[0][0], NewJApplet.this.ImagC[0][0]) - this.cabs(NewJApplet.this.RealC[1][1], NewJApplet.this.ImagC[1][1]);
                    }
                    g.setColor(Color.black);
                    g.drawRect(0, 50, 400, 200);
                    g.drawRect(0, 300, 400, 100);
                    g.drawString("occupation of initial state", 10, 45);
                    g.drawString("time", 200, 270);
                    g.drawString("stationary value", 10, 295);
                    g.drawString("frequency", 180, 450);
                    g.drawLine(80, 400, 80, 405);
                    g.drawLine(120, 400, 120, 405);
                    g.drawLine(160, 400, 160, 405);
                    g.drawLine(200, 400, 200, 405);
                    g.drawLine(240, 400, 240, 405);
                    g.drawLine(280, 400, 280, 405);
                    g.drawLine(320, 400, 320, 405);
                    g.drawString("0", 0, 420);
                    g.drawString("2", 76, 420);
                    g.drawString("4", 156, 420);
                    g.drawString("6", 236, 420);
                    g.drawString("8", 316, 420);
                    g.drawString("10", 396, 420);
                    this.ix1 = (int)((this.cabs(NewJApplet.this.RealC[0][0], NewJApplet.this.ImagC[0][0]) - this.cabs(NewJApplet.this.RealC[1][1], NewJApplet.this.ImagC[1][1])) * 100.0);
                    g.setColor(Color.red);
                    g.drawLine(this.i, 150 - this.ix0, this.i + 1, 150 - this.ix1);
                    this.ix0 = this.ix1;
                    ++this.i;
                }
                NewJApplet.this.average /= 200.0;
                this.ix1 = (int)(NewJApplet.this.average * 100.0);
                g.drawLine(1, 150 - this.ix1, 400, 150 - this.ix1);
                this.ix0 = (int)(NewJApplet.this.freq * 40.0);
                g.drawOval(this.ix0, 300 + this.ix1, 5, 5);
                ++NewJApplet.this.imeas;
            }
        }
    }
}

