/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    double[] RealC;
    double[] ImagC;
    double[] RealC2;
    double[] ImagC2;
    double[] RealC3;
    double[] ImagC3;
    double[] RealC4;
    double[] ImagC4;
    double[] RealF1;
    double[] ImagF1;
    double[] RealF2;
    double[] ImagF2;
    double[] RealF3;
    double[] ImagF3;
    double[] RealF4;
    double[] ImagF4;
    int nstates = 3;
    double V12 = 1.0;
    double V23 = 0.0;
    double V13 = 0.0;
    double E1 = 0.0;
    double E2 = 0.0;
    double E3 = 0.0;
    double tstep = 0.001;
    double freq = 0.0;
    boolean locked = false;
    DecimalFormat df;
    private JLabel E1Label;
    private JSlider E1Slider;
    private JLabel E2Label;
    private JSlider E2Slider;
    private JLabel E3Label;
    private JSlider E3Slider;
    private JLabel V12Label;
    private JSlider V12Slider;
    private JLabel V13Label;
    private JSlider V13Slider;
    private JLabel V23Label;
    private JSlider V23Slider;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JToggleButton lockButton;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.RealC = new double[this.nstates];
        this.ImagC = new double[this.nstates];
        this.RealC2 = new double[this.nstates];
        this.ImagC2 = new double[this.nstates];
        this.RealC3 = new double[this.nstates];
        this.ImagC3 = new double[this.nstates];
        this.RealC4 = new double[this.nstates];
        this.ImagC4 = new double[this.nstates];
        this.RealF1 = new double[this.nstates];
        this.ImagF1 = new double[this.nstates];
        this.RealF2 = new double[this.nstates];
        this.ImagF2 = new double[this.nstates];
        this.RealF3 = new double[this.nstates];
        this.ImagF3 = new double[this.nstates];
        this.RealF4 = new double[this.nstates];
        this.ImagF4 = new double[this.nstates];
        this.df = new DecimalFormat("##0.0");
        this.V12Slider.setValue((int)(this.V12 * 20.0));
        this.V23Slider.setValue((int)(this.V23 * 20.0));
        this.V13Slider.setValue((int)(this.V13 * 20.0));
        this.E1Slider.setValue((int)(this.E1 * 20.0));
        this.E2Slider.setValue((int)(this.E2 * 20.0));
        this.E3Slider.setValue((int)(this.E3 * 20.0));
        this.V12Label.setText("V12=" + this.df.format(this.V12));
        this.V23Label.setText("V23=" + this.df.format(this.V23));
        this.V13Label.setText("V13=" + this.df.format(this.V13));
        this.E1Label.setText("E1=" + this.df.format(this.E1));
        this.E2Label.setText("E2=" + this.df.format(this.E2));
        this.E3Label.setText("E3=" + this.df.format(this.E3));
        this.lockButton.setSelected(false);
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.V23Slider = new JSlider();
        this.E1Slider = new JSlider();
        this.V12Label = new JLabel();
        this.E1Label = new JLabel();
        this.V12Slider = new JSlider();
        this.V23Label = new JLabel();
        this.V13Slider = new JSlider();
        this.V13Label = new JLabel();
        this.E2Slider = new JSlider();
        this.E3Slider = new JSlider();
        this.E2Label = new JLabel();
        this.E3Label = new JLabel();
        this.lockButton = new JToggleButton();
        this.jLabel1 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 365, Short.MAX_VALUE));
        this.V23Slider.setToolTipText("coupling V23");
        this.V23Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.V23SliderMouseDragged(evt);
            }
        });
        this.E1Slider.setToolTipText("initial state energy");
        this.E1Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.E1SliderMouseDragged(evt);
            }
        });
        this.V12Label.setText("V12");
        this.E1Label.setText("E1");
        this.V12Slider.setToolTipText("coupling V12 ");
        this.V12Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.V12SliderMouseDragged(evt);
            }
        });
        this.V23Label.setText("V23");
        this.V13Slider.setToolTipText("direct coupling V13");
        this.V13Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.V13SliderMouseDragged(evt);
            }
        });
        this.V13Label.setText("V13");
        this.E2Slider.setToolTipText("virtual state energy");
        this.E2Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.E2SliderMouseDragged(evt);
            }
        });
        this.E3Slider.setToolTipText("final state energy");
        this.E3Slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.E3SliderMouseDragged(evt);
            }
        });
        this.E2Label.setText("E2");
        this.E3Label.setText("E3");
        this.lockButton.setText("lock V12 V23");
        this.lockButton.setToolTipText("keep V12=V23");
        this.lockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.lockButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("occupation  of  initial state (blue)   intermediate state (green)   final state (red)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.V23Slider, -2, 133, -2).addComponent(this.V13Slider, -2, 133, -2).addComponent(this.E1Slider, -2, 133, -2).addComponent(this.E2Slider, -2, 133, -2).addComponent(this.E3Slider, -2, 133, -2).addComponent(this.V12Slider, -2, 133, -2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.E3Label)).addComponent(this.lockButton, -2, 152, -2))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.V13Label)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.V23Label)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.E1Label)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.E2Label)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.V12Label))).addContainerGap(41, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lockButton, -2, 24, -2).addGap(15, 15, 15).addComponent(this.V12Label).addGap(16, 16, 16).addComponent(this.V12Slider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.V23Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.V23Slider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.V13Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.V13Slider, -2, -1, -2).addGap(53, 53, 53).addComponent(this.E1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.E1Slider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.E2Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.E2Slider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.E3Label).addGap(12, 12, 12).addComponent(this.E3Slider, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addContainerGap(93, Short.MAX_VALUE)));
    }

    private void V23SliderMouseDragged(MouseEvent evt) {
        this.V23 = (double)this.V23Slider.getValue() * 0.05;
        this.V23Label.setText("V23=" + this.df.format(this.V23));
        if (this.locked) {
            this.V12 = this.V23;
            this.V12Label.setText("V12=" + this.df.format(this.V23));
            this.V12Slider.setValue(this.V23Slider.getValue());
        }
        this.jPanel1.repaint();
    }

    private void E1SliderMouseDragged(MouseEvent evt) {
        this.E1 = (double)this.E1Slider.getValue() * 0.05;
        this.E1Label.setText("E1=" + this.df.format(this.E1));
        this.jPanel1.repaint();
    }

    private void V12SliderMouseDragged(MouseEvent evt) {
        this.V12 = (double)this.V12Slider.getValue() * 0.05;
        this.V12Label.setText("V12=" + this.df.format(this.V12));
        if (this.locked) {
            this.V23 = this.V12;
            this.V23Label.setText("V23=" + this.df.format(this.V12));
            this.V23Slider.setValue(this.V12Slider.getValue());
        }
        this.jPanel1.repaint();
    }

    private void V13SliderMouseDragged(MouseEvent evt) {
        this.V13 = (double)this.V13Slider.getValue() * 0.05;
        this.V13Label.setText("V13=" + this.df.format(this.V13));
        this.jPanel1.repaint();
    }

    private void E2SliderMouseDragged(MouseEvent evt) {
        this.E2 = (double)this.E2Slider.getValue() * 0.05;
        this.E2Label.setText("E2=" + this.df.format(this.E2));
        this.jPanel1.repaint();
    }

    private void E3SliderMouseDragged(MouseEvent evt) {
        this.E3 = (double)this.E3Slider.getValue() * 0.05;
        this.E1Label.setText("E3=" + this.df.format(this.E3));
        this.jPanel1.repaint();
    }

    private void lockButtonActionPerformed(ActionEvent evt) {
        this.locked = this.lockButton.isSelected();
        this.V23Slider.setValue(this.V12Slider.getValue());
        this.V23Label.setText("V23=" + this.df.format(this.V12));
    }

    void grad(double[] RC, double[] IC, double[] RF, double[] IF, double t) {
        RF[0] = this.E1 * IC[0] + this.V12 * IC[1] + this.V13 * IC[2];
        IF[0] = -this.E1 * RC[0] - this.V12 * RC[1] - this.V13 * RC[2];
        RF[1] = this.E2 * IC[1] + this.V12 * IC[0] + this.V23 * IC[2];
        IF[1] = -this.E2 * RC[1] - this.V12 * RC[0] - this.V23 * RC[2];
        RF[2] = this.E3 * IC[2] + this.V13 * IC[0] + this.V23 * IC[1];
        IF[2] = -this.E3 * RC[2] - this.V13 * RC[0] - this.V23 * RC[1];
    }

    void advance(double[] RC, double[] IC, double[] RF, double[] IF, double[] RC1, double[] IC1, double step) {
        for (int i = 0; i < this.nstates; ++i) {
            RC1[i] = RC[i] + RF[i] * step;
            IC1[i] = IC[i] + IF[i] * step;
        }
    }

    void rk4(double t) {
        this.grad(this.RealC, this.ImagC, this.RealF1, this.ImagF1, t);
        this.advance(this.RealC, this.ImagC, this.RealF1, this.ImagF1, this.RealC2, this.ImagC2, this.tstep * 0.5);
        this.grad(this.RealC2, this.ImagC2, this.RealF2, this.ImagF2, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF2, this.ImagF2, this.RealC3, this.ImagC3, this.tstep * 0.5);
        this.grad(this.RealC3, this.ImagC3, this.RealF3, this.ImagF3, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF3, this.ImagF3, this.RealC4, this.ImagC4, this.tstep);
        this.grad(this.RealC4, this.ImagC4, this.RealF4, this.ImagF4, t + this.tstep);
        for (int i = 0; i < this.nstates; ++i) {
            this.RealC[i] = this.RealC[i] + this.tstep * (this.RealF1[i] + 2.0 * this.RealF2[i] + 2.0 * this.RealF3[i] + this.RealF4[i]) / 6.0;
            this.ImagC[i] = this.ImagC[i] + this.tstep * (this.ImagF1[i] + 2.0 * this.ImagF2[i] + 2.0 * this.ImagF3[i] + this.ImagF4[i]) / 6.0;
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        int i1;
        int iz0;
        int iz1;

        void iterate() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            NewJApplet.this.RealC[0] = 1.0;
            NewJApplet.this.ImagC[0] = 0.0;
            this.i = 1;
            while (this.i < NewJApplet.this.nstates) {
                NewJApplet.this.RealC[this.i] = 0.0;
                NewJApplet.this.ImagC[this.i] = 0.0;
                ++this.i;
            }
            this.iy0 = 150;
            this.ix0 = 0;
            this.iz0 = 0;
            double t = 0.0;
            this.i = 0;
            while (this.i < 400) {
                this.i1 = 0;
                while (this.i1 < 50) {
                    NewJApplet.this.rk4(t += NewJApplet.this.tstep);
                    ++this.i1;
                }
                g.setColor(Color.black);
                g.drawRect(0, 50, 400, 250);
                this.iy1 = (int)((NewJApplet.this.RealC[0] * NewJApplet.this.RealC[0] + NewJApplet.this.ImagC[0] * NewJApplet.this.ImagC[0]) * 250.0);
                this.ix1 = (int)((NewJApplet.this.RealC[1] * NewJApplet.this.RealC[1] + NewJApplet.this.ImagC[1] * NewJApplet.this.ImagC[1]) * 250.0);
                this.iz1 = (int)((NewJApplet.this.RealC[2] * NewJApplet.this.RealC[2] + NewJApplet.this.ImagC[2] * NewJApplet.this.ImagC[2]) * 250.0);
                g.setColor(Color.blue);
                g.drawLine(this.i, 300 - this.iy0, this.i + 1, 300 - this.iy1);
                this.iy0 = this.iy1;
                g.setColor(Color.red);
                g.drawLine(this.i, 300 - this.ix0, this.i + 1, 300 - this.ix1);
                this.ix0 = this.ix1;
                g.setColor(Color.green);
                g.drawLine(this.i, 300 - this.iz0, this.i + 1, 300 - this.iz1);
                this.iz0 = this.iz1;
                g.setColor(Color.black);
                g.drawString("time", 200, 320);
                ++this.i;
            }
        }
    }
}

