/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet
implements Runnable {
    private volatile Thread calculatorThread;
    DecimalFormat df;
    DecimalFormat df1;
    BufferedImage image;
    Graphics2D gb;
    Point point1;
    Point point2;
    double[][] history;
    double[] predict;
    double[] deriv;
    double[] current;
    double[] lastcoor;
    int maxorder = 8;
    double deltat = 0.01;
    double time;
    double[] exact;
    double totalerror;
    int method = 0;
    int mymethod = 0;
    double totaltime = 5.0;
    double mytotaltime = 5.0;
    int ybas = 50;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JSlider jSlider1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init_variables();
        this.reset();
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.calculatorThread == thisThread) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mymethod = this.method;
            this.mytotaltime = this.totaltime;
            this.scan();
            this.stop();
        }
    }

    public void start() {
        if (this.calculatorThread == null) {
            this.calculatorThread = new Thread(this);
            this.calculatorThread.start();
        }
    }

    public void stop() {
        Thread tmpcalculatorThread = this.calculatorThread;
        this.calculatorThread = null;
        if (tmpcalculatorThread != null) {
            tmpcalculatorThread.interrupt();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new myPanel();
        this.jComboBox1 = new JComboBox();
        this.jSlider1 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jButton1.setText("STOP");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NewJApplet.this.jPanel1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                NewJApplet.this.jPanel1MousePressed(evt);
            }
        });
        this.jPanel1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jPanel1MouseDragged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 467, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 474, Short.MAX_VALUE));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Euler", "ab2", "ab3", "ab4", "ab5", "ab6", "ab7", "verlet"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jSlider1.setMinimum(1);
        this.jSlider1.setValue(50);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseReleased(evt);
            }
        });
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel1.setText("total time = 5.0");
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("prefactor");
        this.jLabel4.setText("slope");
        this.jLabel5.setText("click and draw a line");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jSlider1, -2, 133, -2).addComponent(this.jLabel1).addComponent(this.jLabel2, -2, 100, -2).addComponent(this.jLabel3).addComponent(this.jLabel4).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox1, -2, -1, -2)).addComponent(this.jLabel5)).addContainerGap(293, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jButton1).addGap(31, 31, 31).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(57, 57, 57).addComponent(this.jComboBox1, -2, -1, -2).addGap(65, 65, 65).addComponent(this.jLabel3).addGap(42, 42, 42).addComponent(this.jLabel4).addGap(37, 37, 37).addComponent(this.jLabel5)).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap(79, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.stop();
        this.method = this.jComboBox1.getSelectedIndex();
        this.gb.clearRect(0, 0, 550, 650);
        this.reset();
        this.start();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.jLabel1.setText("total time =" + this.df1.format((double)this.jSlider1.getValue() * 0.1));
    }

    private void jSlider1MouseReleased(MouseEvent evt) {
        this.stop();
        this.totaltime = (double)this.jSlider1.getValue() * 0.1;
        this.jLabel1.setText("total time =" + this.df1.format(this.totaltime));
        this.gb.clearRect(0, 0, 550, 650);
        this.reset();
        this.start();
    }

    private void jPanel1MouseClicked(MouseEvent evt) {
    }

    private void jPanel1MouseDragged(MouseEvent evt) {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.point2 = this.jPanel1.getMousePosition();
        double x = this.point2.getX() / 50.0;
        double y = (this.point2.getY() - (double)this.ybas) / 20.0;
        double x0 = this.point1.getX() / 50.0;
        double y0 = (this.point1.getY() - (double)this.ybas) / 20.0;
        g2.drawImage((Image)this.image, 0, 0, null);
        g2.drawLine((int)this.point1.getX(), (int)this.point1.getY(), (int)this.point2.getX(), (int)this.point2.getY());
        if (Math.abs(x - x0) > 0.01) {
            double slope = (y - y0) / (x - x0);
            double pref = y - x * slope;
            this.jLabel3.setText("prefactor=" + this.df1.format(pref));
            this.jLabel4.setText("slope=" + this.df1.format(slope));
        }
    }

    private void jPanel1MousePressed(MouseEvent evt) {
        this.point2 = this.point1 = this.jPanel1.getMousePosition();
        double x = this.point1.getX() / 50.0;
        double y = (this.point1.getY() - (double)this.ybas) / 20.0;
    }

    void init_variables() {
        this.history = new double[4][this.maxorder];
        this.current = new double[4];
        this.predict = new double[4];
        this.deriv = new double[4];
        this.exact = new double[4];
        this.lastcoor = new double[2];
        this.df = new DecimalFormat("0.000000E00");
        this.df1 = new DecimalFormat("0.0");
        this.point1 = new Point(0, 0);
        this.point2 = new Point(0, 0);
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
    }

    void reset() {
        for (int i = 1; i < this.maxorder; ++i) {
            this.history[0][i - 1] = -Math.sin((double)(-i) * this.deltat);
            this.history[1][i - 1] = Math.cos((double)(-i) * this.deltat);
            this.history[2][i - 1] = -this.history[1][i - 1];
            this.history[3][i - 1] = this.history[0][i - 1];
        }
        this.lastcoor[0] = Math.cos(-this.deltat);
        this.lastcoor[1] = Math.sin(-this.deltat);
        this.current[0] = 1.0;
        this.current[1] = 0.0;
        this.current[2] = 0.0;
        this.current[3] = 1.0;
        this.time = 0.0;
    }

    void calc_forces() {
        double x = this.current[0];
        double y = this.current[1];
        double vx = this.current[2];
        double vy = this.current[3];
        double r2 = x * x + y * y;
        double r = Math.sqrt(r2);
        this.deriv[2] = -x / (r * r2);
        this.deriv[3] = -y / (r * r2);
        this.deriv[0] = vx;
        this.deriv[1] = vy;
    }

    void cycle(int norder) {
        for (int j = 0; j < 4; ++j) {
            for (int i = norder - 1; i >= 0; --i) {
                this.history[j][i + 1] = this.history[j][i];
            }
            this.history[j][0] = this.deriv[j];
        }
    }

    void exact_values() {
        this.exact[0] = Math.cos(this.time);
        this.exact[1] = Math.sin(this.time);
        this.exact[2] = -this.exact[1];
        this.exact[3] = this.exact[0];
    }

    void advance() {
        this.calc_forces();
        switch (this.mymethod) {
            case 0: {
                this.Euler();
                break;
            }
            case 1: {
                this.ab2();
                break;
            }
            case 2: {
                this.ab3();
                break;
            }
            case 3: {
                this.ab4();
                break;
            }
            case 4: {
                this.ab5();
                break;
            }
            case 5: {
                this.ab6();
                break;
            }
            case 6: {
                this.ab7();
                break;
            }
            case 7: {
                this.verlet();
                break;
            }
        }
        this.time += this.deltat;
    }

    void verlet() {
        for (int i = 0; i < 2; ++i) {
            double newval = 2.0 * this.current[i] - this.lastcoor[i] + this.deriv[i + 2] * this.deltat * this.deltat;
            this.lastcoor[i] = this.current[i];
            this.current[i] = newval;
        }
    }

    void ab7() {
        this.cycle(7);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.current[n] = this.current[n] + this.deltat * (198721.0 * this.history[i][0] - 447288.0 * this.history[i][1] + 705549.0 * this.history[i][2] - 688256.0 * this.history[i][3] + 407139.0 * this.history[i][4] - 134472.0 * this.history[i][5] + 19087.0 * this.history[i][6]) / 60480.0;
        }
    }

    void ab6() {
        this.cycle(6);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.current[n] = this.current[n] + this.deltat * (4277.0 * this.history[i][0] - 7923.0 * this.history[i][1] + 9982.0 * this.history[i][2] - 7298.0 * this.history[i][3] + 2877.0 * this.history[i][4] - 475.0 * this.history[i][5]) / 1440.0;
        }
    }

    void ab5() {
        this.cycle(5);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.current[n] = this.current[n] + this.deltat * (1901.0 * this.history[i][0] - 2774.0 * this.history[i][1] + 2616.0 * this.history[i][2] - 1274.0 * this.history[i][3] + 251.0 * this.history[i][4]) / 720.0;
        }
    }

    void ab4() {
        this.cycle(4);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.current[n] = this.current[n] + this.deltat * (55.0 * this.history[i][0] - 59.0 * this.history[i][1] + 37.0 * this.history[i][2] - 9.0 * this.history[i][3]) / 24.0;
        }
    }

    void ab3() {
        this.cycle(3);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.current[n] = this.current[n] + this.deltat * (23.0 * this.history[i][0] - 16.0 * this.history[i][1] + 5.0 * this.history[i][2]) / 12.0;
        }
    }

    void ab2() {
        this.cycle(2);
        for (int i = 0; i < 4; ++i) {
            this.current[i] = this.current[i] + 0.5 * this.deltat * (3.0 * this.history[i][0] - this.history[i][1]);
        }
    }

    void Euler() {
        for (int i = 0; i < 4; ++i) {
            this.current[i] = this.current[i] + this.deltat * this.deriv[i];
        }
    }

    void calc_error() {
        this.exact_values();
        this.totalerror = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.totalerror += Math.abs(this.current[i] - this.exact[i]);
        }
    }

    void calc_error_v() {
        this.exact_values();
        this.totalerror = 0.0;
        for (int i = 0; i < 2; ++i) {
            this.totalerror += Math.abs(this.current[i] - this.exact[i]);
        }
    }

    void scan() {
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.gb.setColor(Color.black);
        double yc = 1.0;
        for (i = 0; i < 16; ++i) {
            this.hline(yc);
            yc *= 0.1;
        }
        yc = 0.1;
        for (i = 1; i < 16; i += 2) {
            this.hlab(i, yc);
            yc *= 0.01;
        }
        yc = 0.1;
        for (i = 0; i < 8; ++i) {
            this.vline(yc);
            this.vlab(i + 1, yc);
            yc *= 0.1;
        }
        this.gb.drawString("time step", 200, 400);
        this.gb.drawString("sum of absolute coordinate errors", 100, 20);
        this.gb.setColor(Color.red);
        this.deltat = 0.1;
        for (int k = 1; k < 40; ++k) {
            this.jLabel2.setText("" + (k + 1) + " of 40");
            this.reset();
            int nsteps = (int)(this.mytotaltime / this.deltat);
            for (i = 0; i < nsteps; ++i) {
                this.advance();
                if (!Thread.interrupted()) continue;
                return;
            }
            if (this.mymethod == 7) {
                this.calc_error_v();
            } else {
                this.calc_error_v();
            }
            int ix0 = -((int)(Math.log10(this.deltat) * 50.0));
            int iy0 = this.ybas - (int)(Math.log10(this.totalerror) * 20.0);
            this.gb.fillOval(ix0 - 4, iy0 - 4, 8, 8);
            g2.drawImage((Image)this.image, 0, 0, null);
            g2.drawLine((int)this.point1.getX(), (int)this.point1.getY(), (int)this.point2.getX(), (int)this.point2.getY());
            this.deltat *= 0.7;
        }
    }

    void hline(double y) {
        int iy0 = this.ybas - (int)(Math.log10(y) * 20.0);
        this.gb.drawLine(50, iy0, 400, iy0);
    }

    void hlab(int om, double y) {
        int iy0 = this.ybas - (int)(Math.log10(y) * 20.0);
        int ix0 = 20;
        this.gb.drawString("10", ix0 - 10, iy0 + 5);
        this.gb.drawString("-" + om, ix0 + 5, iy0);
    }

    void vline(double x) {
        int ix0 = -((int)(Math.log10(x) * 50.0));
        this.gb.drawLine(ix0, this.ybas, ix0, 360);
    }

    void vlab(int om, double x) {
        int ix0 = -((int)(Math.log10(x) * 50.0));
        int iy0 = 380;
        this.gb.drawString("10", ix0 - 10, iy0);
        this.gb.drawString("-" + om, ix0 + 5, iy0 - 5);
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

