/*
 * Decompiled with CFR 0.152.
 */
package gpoly;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    public int number_segments;
    public int numb_loops;
    public int n_aver;
    public int iav;
    public int ndata;
    public int window_w = 10;
    public double emin;
    public double elast;
    public double etot;
    public double xharm;
    public double kT;
    public double kappa;
    public double length;
    public double ekin;
    public double epot;
    public double tstep;
    public double damp;
    public double xcoor;
    public double ycoor;
    public double xtry;
    public double ytry;
    public double forcx;
    public double forcy;
    public double vx;
    public double vy;
    public double dx;
    public double dv;
    public double vtry;
    public double[] datax;
    public double[] datay;
    public double eq_distance;
    double stdv;
    double ekinav;
    double epotav;
    double lengav;
    double extensav;
    double extensavn;
    double extenq;
    int[] ixp;
    int[] iyp;
    DecimalFormat df;
    DecimalFormat df2;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;

    public void actionPerformed(ActionEvent e) {
        this.aver();
        this.jPanel2.repaint();
        this.jPanel1.repaint();
        this.timer.restart();
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.setup();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        this.df = new DecimalFormat("##0.00000000", unusualSymbols);
        this.df2 = new DecimalFormat("##0.00", unusualSymbols);
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel2 = new myPanel2();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(400, 350));
        this.jPanel1.setMinimumSize(new Dimension(400, 350));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(400, 350));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 348, Short.MAX_VALUE));
        this.jLabel1.setText("Epot");
        this.jLabel3.setText("elongation");
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.setMinimum(-100);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jSlider3.setMaximum(500);
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel4.setText("friction");
        this.jLabel5.setText("force");
        this.jLabel6.setText("spring");
        this.jSlider4.setMaximum(1000);
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel7.setText("temperature");
        this.jLabel8.setText("Ekin");
        this.jLabel9.setText("Etot");
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(400, 200));
        this.jPanel2.setMinimumSize(new Dimension(400, 200));
        this.jPanel2.setPreferredSize(new Dimension(400, 200));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 198, Short.MAX_VALUE));
        this.jButton1.setText("excite");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("reset");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -2, 183, -2).addComponent(this.jLabel4, -2, 180, -2).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addComponent(this.jSlider2, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addComponent(this.jSlider1, -1, -1, Short.MAX_VALUE).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addComponent(this.jSlider3, -1, -1, Short.MAX_VALUE).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addComponent(this.jSlider4, -1, -1, Short.MAX_VALUE).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 213, -2).addComponent(this.jLabel8, -2, 202, -2).addComponent(this.jLabel9, -2, 204, -2).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jButton2))))).addContainerGap()));
        layout.linkSize(0, this.jSlider1, this.jSlider2, this.jSlider3, this.jSlider4);
        layout.linkSize(0, this.jLabel1, this.jLabel3, this.jLabel8, this.jLabel9);
        layout.linkSize(0, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7);
        layout.linkSize(0, this.jButton1, this.jButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addGap(108, 108, 108).addComponent(this.jLabel3).addGap(71, 71, 71).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addGap(39, 39, 39).addComponent(this.jLabel4, -2, 16, -2).addGap(2, 2, 2).addComponent(this.jSlider1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addGap(1, 1, 1).addComponent(this.jSlider2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addGap(1, 1, 1).addComponent(this.jSlider3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addGap(1, 1, 1).addComponent(this.jSlider4, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap()));
        layout.linkSize(1, this.jSlider1, this.jSlider2, this.jSlider3, this.jSlider4);
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.damp = (double)this.jSlider1.getValue() * 0.1;
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.kappa = (double)this.jSlider2.getValue() * 0.25;
        this.drawpot();
        this.jPanel1.repaint();
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.xharm = this.jSlider3.getValue();
        this.drawpot();
        this.jPanel1.repaint();
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.kT = (double)this.jSlider4.getValue() * 0.01;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.xcoor = 1.0;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.ndata = 0;
    }

    public void setup() {
        this.number_segments = 20;
        this.eq_distance = 1.0;
        this.kT = 0.0;
        this.tstep = 0.005;
        this.damp = 0.1;
        this.emin = 1000.0;
        this.elast = 1000.0;
        this.etot = 1000.0;
        this.xharm = 10.0;
        this.kT = 10.0;
        this.kappa = 0.0;
        this.numb_loops = 10;
        this.n_aver = 250;
        this.iav = 0;
        this.ekinav = 0.0;
        this.epotav = 0.0;
        this.lengav = 0.0;
        this.extensav = 0.0;
        this.extensavn = 0.0;
        this.extenq = 0.0;
        this.datax = new double[100];
        this.datay = new double[100];
        this.ndata = 0;
        this.ixp = new int[400];
        this.iyp = new int[400];
        this.xcoor = 1.0;
        this.ycoor = 0.0;
        this.vx = 0.0;
        this.vy = 0.0;
        this.jSlider1.setValue((int)(10.0 * this.damp));
        this.jSlider2.setValue((int)(this.kappa * 10.0));
        this.jSlider3.setValue((int)this.xharm);
        this.jSlider4.setValue((int)(100.0 * this.kT));
        this.drawpot();
    }

    public double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    public void rk2() {
        this.forcx = this.kappa + this.kT * (Math.random() - 0.5);
        this.xtry = this.xcoor + this.vx * this.tstep * 0.5;
        this.vtry = this.vx * (1.0 - this.damp * this.tstep * 0.5) - this.xharm * this.xcoor * this.tstep * 0.5 + this.forcx * this.tstep * 0.5;
        this.dx = this.vtry * this.tstep;
        this.dv = -this.damp * this.vtry * this.tstep - this.xharm * this.xtry * this.tstep + this.forcx * this.tstep;
        this.xcoor += this.dx;
        this.vx += this.dv;
        this.ekin = 0.5 * this.vx * this.vx;
        this.epot = 0.5 * this.xharm * this.xcoor * this.xcoor - this.kappa * this.xcoor;
    }

    public void drawpot() {
        for (int i = 0; i < 400; ++i) {
            double xx = (double)(i - 200) * 0.01;
            double vv = xx * xx * this.xharm * 0.5 - this.kappa * xx;
            int iy = 200 - (int)(vv * 1.0);
            this.ixp[i] = i;
            this.iyp[i] = iy;
        }
    }

    public void aver() {
        this.xtry = 0.0;
        this.ytry = 0.0;
        if (this.iav == 0) {
            this.ekinav = 0.0;
            this.epotav = 0.0;
            this.lengav = 0.0;
            this.extensav = 0.0;
            this.extenq = 0.0;
        }
        for (int iverl = 0; iverl < this.numb_loops; ++iverl) {
            this.rk2();
        }
        this.ekinav += this.ekin;
        this.epotav += this.epot;
        this.lengav += this.length;
        this.extensav += this.xcoor;
        this.extenq += this.xcoor * this.xcoor;
        ++this.iav;
        if (this.iav >= this.n_aver) {
            this.iav = 0;
            this.extensavn = this.extensav / (double)this.n_aver;
            this.extenq /= (double)this.n_aver;
            this.stdv = Math.sqrt(this.extenq - this.extensavn * this.extensavn);
            this.lengav /= (double)this.n_aver;
            this.jLabel1.setText("Epot:" + this.df.format(this.epotav / (double)this.n_aver));
            this.jLabel8.setText("Ekin:" + this.df.format(this.ekinav / (double)this.n_aver));
            this.jLabel9.setText("Etot:" + this.df.format((this.ekinav + this.epotav) / (double)this.n_aver));
            this.jLabel3.setText("elongation:" + this.df2.format(this.extensavn) + " +- " + this.df2.format(this.stdv));
        }
        this.jLabel5.setText("force:" + this.df2.format(this.kappa * 0.1));
        this.jLabel4.setText("friction:" + this.df2.format(this.damp));
        this.jLabel6.setText("spring:" + this.df2.format(this.xharm));
        this.jLabel7.setText("temperature:" + this.df2.format(this.kT));
    }

    class myPanel
    extends JPanel {
        int ix;
        int iy;
        int ix1;
        int iy1;
        int i2;
        int i;
        double sx;
        double sy;
        double rx;
        double ry;
        double r2;
        double r2s;
        double r;
        double edel;
        double bofa;
        double rn;
        double vv;
        double xx;

        myPanel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics g2 = NewJApplet.this.jPanel2.getGraphics();
            g.drawString("potential energy V(x)", 10, 10);
            g.drawPolyline(NewJApplet.this.ixp, NewJApplet.this.iyp, 400);
            int ix = (int)(NewJApplet.this.xcoor * 100.0) + 200;
            this.vv = NewJApplet.this.xcoor * NewJApplet.this.xcoor * NewJApplet.this.xharm * 0.5 - NewJApplet.this.kappa * NewJApplet.this.xcoor;
            int iy = 200 - (int)(this.vv * 1.0);
            g.fillOval(ix - 4, iy - 4, 8, 8);
        }
    }

    class myPanel2
    extends JPanel {
        myPanel2() {
        }

        public void paintComponent(Graphics g) {
            g.clearRect(1, 1, 400, 200);
            g.drawLine(0, 100, 400, 100);
            g.drawLine(200, 0, 200, 200);
            g.drawString("x", 380, 90);
            g.drawString("v", 210, 10);
            g.drawString("phase space", 10, 10);
            int ix = (int)(NewJApplet.this.xcoor * 100.0) + 200;
            int iy = (int)(NewJApplet.this.vx * 100.0 + 100.0);
            g.fillOval(ix - 4, iy - 4, 8, 8);
        }
    }
}

