/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class finitelapplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int iy0;
    int iy1;
    int ix0;
    int ix1;
    double tscale;
    int NMAX = 1800;
    int points_phi = 12;
    int points_theta = 12;
    int points = 12;
    double radius = 1.0;
    double DK = 20.0;
    double damp = 1.0;
    double distance = 0.0;
    int loop;
    int i;
    int j;
    int k;
    int l;
    int indx;
    int nelements;
    double rfex;
    double ss;
    double c1;
    double c2;
    double phi;
    double theta;
    double rf;
    double dx;
    double dy;
    double dz;
    double d2;
    double d3;
    double ww;
    double x;
    double y;
    double z;
    double grid;
    double f_value;
    double[] xi;
    double[] yi;
    double[] zi;
    double[] qi;
    double[] area;
    double[] xn;
    double[] ynn;
    double[] zn;
    double[] B;
    double[][] W;
    int[] xpoints;
    int[] ypoints;
    boolean equal_area = false;
    boolean horizontal = true;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JToggleButton jToggleButton1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    finitelapplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init_variables();
        this.reset();
        this.timer = new Timer(100, this);
        this.timer.setInitialDelay(100);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.loop > 1000) {
            return;
        }
        this.iterate();
        this.timer.setInitialDelay(10);
        this.timer.setDelay(10);
        this.timer.restart();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new myPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jLabel3 = new JLabel();
        this.jSlider3 = new JSlider();
        this.jLabel4 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jLabel5 = new JLabel();
        this.jButton1 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jLabel6 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 385, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 488, Short.MAX_VALUE));
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("jLabel2");
        this.jSlider1.setMaximum(900);
        this.jSlider1.setMinimum(100);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                finitelapplet.this.jSlider1MouseReleased(evt);
            }
        });
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                finitelapplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.setMajorTickSpacing(6);
        this.jSlider2.setMaximum(42);
        this.jSlider2.setMinimum(6);
        this.jSlider2.setPaintLabels(true);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setSnapToTicks(true);
        this.jSlider2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                finitelapplet.this.jSlider2MouseReleased(evt);
            }
        });
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                finitelapplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jLabel3.setText("jLabel2");
        this.jSlider3.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                finitelapplet.this.jSlider3MouseReleased(evt);
            }
        });
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                finitelapplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel4.setText("jLabel2");
        this.jSlider4.setMaximum(90);
        this.jSlider4.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                finitelapplet.this.jSlider4MouseReleased(evt);
            }
        });
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                finitelapplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel5.setText("jLabel2");
        this.jButton1.setText("restart");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                finitelapplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText("equal area");
        this.jToggleButton1.setHideActionText(true);
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                finitelapplet.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("jLabel1");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("horizontal");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                finitelapplet.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("vertical");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                finitelapplet.this.jRadioButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jSlider1, -2, 156, -2).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jToggleButton1)).addComponent(this.jLabel1).addComponent(this.jLabel6).addComponent(this.jLabel4).addComponent(this.jSlider3, -2, 156, -2).addComponent(this.jLabel3).addComponent(this.jSlider2, -2, 156, -2).addComponent(this.jLabel5).addComponent(this.jSlider4, -2, 156, -2).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addGap(18, 18, 18).addComponent(this.jRadioButton2))).addContainerGap(172, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel6).addGap(33, 33, 33).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addGap(26, 26, 26).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider4, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jToggleButton1)))).addContainerGap(54, Short.MAX_VALUE)));
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.jLabel2.setText("DK=" + this.df.format(Math.pow((double)this.jSlider1.getValue() * 0.01, 2.0)));
    }

    private void jSlider1MouseReleased(MouseEvent evt) {
        this.DK = Math.pow((double)this.jSlider1.getValue() * 0.01, 2.0);
        this.reset();
        this.loop = 0;
    }

    private void jSlider2MouseReleased(MouseEvent evt) {
        this.points_phi = this.points = this.jSlider2.getValue();
        this.points_theta = this.points;
        this.reset();
        this.loop = 0;
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.points = this.jSlider2.getValue();
    }

    private void jSlider3MouseReleased(MouseEvent evt) {
        double damp1 = (double)this.jSlider3.getValue() * 0.01;
        this.jLabel4.setText("damping=" + this.df.format(damp1));
        this.damp = 1.0 - damp1;
        this.reset();
        this.loop = 0;
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.jLabel4.setText("damping=" + this.df.format((double)this.jSlider3.getValue() * 0.01));
    }

    private void jSlider4MouseReleased(MouseEvent evt) {
        this.distance = (double)this.jSlider4.getValue() * 0.01;
        this.jLabel5.setText("distance=" + this.df.format(this.distance));
        this.reset();
        this.loop = 0;
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.distance = (double)this.jSlider4.getValue() * 0.01;
        this.jLabel5.setText("distance=" + this.df.format(this.distance));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset();
        this.loop = 0;
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.equal_area = this.jToggleButton1.isSelected();
        this.reset();
        this.loop = 0;
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.horizontal = this.jRadioButton1.isSelected();
        this.reset();
        this.loop = 0;
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.horizontal = !this.jRadioButton2.isSelected();
        this.reset();
        this.loop = 0;
    }

    void init_variables() {
        this.xi = new double[this.NMAX];
        this.yi = new double[this.NMAX];
        this.zi = new double[this.NMAX];
        this.qi = new double[this.NMAX];
        this.area = new double[this.NMAX];
        this.xn = new double[this.NMAX];
        this.ynn = new double[this.NMAX];
        this.zn = new double[this.NMAX];
        this.B = new double[this.NMAX];
        this.W = new double[this.NMAX][this.NMAX];
        this.xpoints = new int[4];
        this.ypoints = new int[4];
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.df = new DecimalFormat("#0.00");
        this.df1 = new DecimalFormat("#0.000000000000");
        this.jSlider1.setValue((int)(10.0 * this.DK));
        this.jLabel2.setText("DK=" + this.df.format(this.DK));
        this.jSlider2.setValue(this.points);
        this.jSlider3.setValue((int)(this.damp * 100.0));
        this.jLabel4.setText("damping=" + this.df.format(this.damp));
        this.jSlider4.setValue((int)(this.distance * 100.0));
        this.jLabel5.setText("distance=" + this.df.format(this.distance));
    }

    double exact_value(double s) {
        double sn;
        double sum = 1.0 / this.DK;
        double s2 = sn = s * s / (this.radius * this.radius);
        for (int i = 1; i < 30; ++i) {
            sum += sn * (double)(i + 1) / ((double)i + (double)(i + 1) * this.DK);
            sn *= s2;
        }
        sum = sum * (1.0 - this.DK) * 7.2;
        return sum;
    }

    void draw_elements() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        for (int i = 0; i < this.points_phi; ++i) {
            for (int j = 0; j < this.points_theta; ++j) {
                double z4;
                double y4;
                double x4;
                double z3;
                double y3;
                double x3;
                double z2;
                double y2;
                double x2;
                double z1;
                double y1;
                double x1;
                double phi1 = (double)i * 2.0 * Math.PI / (double)this.points_phi;
                double theta1 = (double)j * Math.PI / (double)this.points_theta;
                double phi2 = (double)(i + 1) * 2.0 * Math.PI / (double)this.points_phi;
                double theta2 = (double)(j + 1) * Math.PI / (double)this.points_theta;
                if (this.horizontal) {
                    x1 = Math.sin(theta1) * Math.cos(phi1);
                    y1 = Math.sin(theta1) * Math.sin(phi1);
                    z1 = Math.cos(theta1);
                    x2 = Math.sin(theta1) * Math.cos(phi2);
                    y2 = Math.sin(theta1) * Math.sin(phi2);
                    z2 = Math.cos(theta1);
                    x3 = Math.sin(theta2) * Math.cos(phi2);
                    y3 = Math.sin(theta2) * Math.sin(phi2);
                    z3 = Math.cos(theta2);
                    x4 = Math.sin(theta2) * Math.cos(phi1);
                    y4 = Math.sin(theta2) * Math.sin(phi1);
                    z4 = Math.cos(theta2);
                } else {
                    x1 = Math.sin(theta1) * Math.cos(phi1);
                    z1 = Math.sin(theta1) * Math.sin(phi1);
                    y1 = Math.cos(theta1);
                    x2 = Math.sin(theta1) * Math.cos(phi2);
                    z2 = Math.sin(theta1) * Math.sin(phi2);
                    y2 = Math.cos(theta1);
                    x3 = Math.sin(theta2) * Math.cos(phi2);
                    z3 = Math.sin(theta2) * Math.sin(phi2);
                    y3 = Math.cos(theta2);
                    x4 = Math.sin(theta2) * Math.cos(phi1);
                    z4 = Math.sin(theta2) * Math.sin(phi1);
                    y4 = Math.cos(theta2);
                }
                if (y1 + y2 + y3 + y4 < 0.0) {
                    Color col;
                    int ic;
                    this.xpoints[0] = (int)(100.0 * x1) + 150;
                    this.ypoints[0] = (int)(100.0 * z1) + 350;
                    this.xpoints[1] = (int)(100.0 * x2) + 150;
                    this.ypoints[1] = (int)(100.0 * z2) + 350;
                    this.xpoints[2] = (int)(100.0 * x3) + 150;
                    this.ypoints[2] = (int)(100.0 * z3) + 350;
                    this.xpoints[3] = (int)(100.0 * x4) + 150;
                    this.ypoints[3] = (int)(100.0 * z4) + 350;
                    if (this.qi[index] < 0.0) {
                        ic = (int)(-this.qi[index] * 250.0);
                        if (ic > 255) {
                            ic = 255;
                        }
                        col = new Color(ic, 255 - ic, 255 - ic);
                    } else {
                        ic = (int)(this.qi[index] * 500.0);
                        if (ic > 255) {
                            ic = 255;
                        }
                        col = new Color(255 - ic, 255 - ic, ic);
                    }
                    this.gb.setColor(col);
                    this.gb.fillPolygon(this.xpoints, this.ypoints, 4);
                    this.gb.setColor(Color.black);
                    this.gb.drawPolygon(this.xpoints, this.ypoints, 4);
                }
                ++index;
            }
        }
    }

    void draw_equal_elements() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        for (int i = 0; i < this.points_phi; ++i) {
            for (int j = 0; j < this.points_theta; ++j) {
                double z4;
                double y4;
                double x4;
                double z3;
                double y3;
                double x3;
                double z2;
                double y2;
                double x2;
                double z1;
                double y1;
                double x1;
                double phi1 = (double)i * 2.0 * Math.PI / (double)this.points_phi;
                double c1 = 1.0 - (double)j * 2.0 / (double)this.points_theta;
                double s1 = Math.sqrt(1.0 - c1 * c1);
                double phi2 = (double)(i + 1) * 2.0 * Math.PI / (double)this.points_phi;
                double c2 = 1.0 - (double)(j + 1) * 2.0 / (double)this.points_theta;
                double s2 = Math.sqrt(1.0 - c2 * c2);
                if (this.horizontal) {
                    x1 = s1 * Math.cos(phi1);
                    y1 = s1 * Math.sin(phi1);
                    z1 = c1;
                    x2 = s1 * Math.cos(phi2);
                    y2 = s1 * Math.sin(phi2);
                    z2 = c1;
                    x3 = s2 * Math.cos(phi2);
                    y3 = s2 * Math.sin(phi2);
                    z3 = c2;
                    x4 = s2 * Math.cos(phi1);
                    y4 = s2 * Math.sin(phi1);
                    z4 = c2;
                } else {
                    x1 = s1 * Math.cos(phi1);
                    z1 = s1 * Math.sin(phi1);
                    y1 = c1;
                    x2 = s1 * Math.cos(phi2);
                    z2 = s1 * Math.sin(phi2);
                    y2 = c1;
                    x3 = s2 * Math.cos(phi2);
                    z3 = s2 * Math.sin(phi2);
                    y3 = c2;
                    x4 = s2 * Math.cos(phi1);
                    z4 = s2 * Math.sin(phi1);
                    y4 = c2;
                }
                if (y1 + y2 + y3 + y4 < 0.0) {
                    Color col;
                    int ic;
                    this.xpoints[0] = (int)(100.0 * x1) + 150;
                    this.ypoints[0] = (int)(100.0 * z1) + 350;
                    this.xpoints[1] = (int)(100.0 * x2) + 150;
                    this.ypoints[1] = (int)(100.0 * z2) + 350;
                    this.xpoints[2] = (int)(100.0 * x3) + 150;
                    this.ypoints[2] = (int)(100.0 * z3) + 350;
                    this.xpoints[3] = (int)(100.0 * x4) + 150;
                    this.ypoints[3] = (int)(100.0 * z4) + 350;
                    if (this.qi[index] < 0.0) {
                        ic = (int)(-this.qi[index] * 250.0);
                        if (ic > 255) {
                            ic = 255;
                        }
                        col = new Color(ic, 255 - ic, 255 - ic);
                    } else {
                        ic = (int)(this.qi[index] * 500.0);
                        if (ic > 255) {
                            ic = 255;
                        }
                        col = new Color(255 - ic, 255 - ic, ic);
                    }
                    this.gb.setColor(col);
                    this.gb.fillPolygon(this.xpoints, this.ypoints, 4);
                    this.gb.setColor(Color.black);
                    this.gb.drawPolygon(this.xpoints, this.ypoints, 4);
                }
                ++index;
            }
        }
    }

    void generate_elements() {
        this.indx = 0;
        this.rfex = -14.4 * (1.0 - 1.0 / this.DK) / this.radius;
        this.f_value = 2.0 * (1.0 - this.DK) / (1.0 + this.DK);
        this.f_value /= Math.PI * 4;
        this.ss = 0.0;
        this.i = 0;
        while (this.i < this.points_phi) {
            this.j = 0;
            while (this.j < this.points_theta) {
                this.phi = ((double)this.i + 0.5) * 2.0 * Math.PI / (double)this.points_phi;
                this.theta = ((double)this.j + 0.5) * Math.PI / (double)this.points_theta;
                this.xi[this.indx] = Math.sin(this.theta) * Math.cos(this.phi);
                this.yi[this.indx] = Math.sin(this.theta) * Math.sin(this.phi);
                this.zi[this.indx] = Math.cos(this.theta);
                this.xn[this.indx] = this.xi[this.indx];
                this.ynn[this.indx] = this.yi[this.indx];
                this.zn[this.indx] = this.zi[this.indx];
                this.xi[this.indx] = this.xi[this.indx] * this.radius;
                this.yi[this.indx] = this.yi[this.indx] * this.radius;
                this.zi[this.indx] = this.zi[this.indx] * this.radius;
                this.c1 = Math.cos((double)this.j * Math.PI / (double)this.points_theta);
                this.c2 = Math.cos((double)(this.j + 1) * Math.PI / (double)this.points_theta);
                this.area[this.indx] = this.radius * this.radius * (this.c1 - this.c2) * 2.0 * Math.PI / (double)this.points_phi;
                this.ss += this.area[this.indx];
                ++this.indx;
                ++this.j;
            }
            ++this.i;
        }
        this.nelements = this.indx;
        this.jLabel3.setText("elements=" + this.nelements);
    }

    void generate_equal_elements() {
        this.indx = 0;
        this.rfex = -14.4 * (1.0 - 1.0 / this.DK) / this.radius;
        this.f_value = 2.0 * (1.0 - this.DK) / (1.0 + this.DK);
        this.f_value /= Math.PI * 4;
        this.ss = 0.0;
        this.i = 0;
        while (this.i < this.points_phi) {
            this.j = 0;
            while (this.j < this.points_theta) {
                this.phi = ((double)this.i + 0.5) * 2.0 * Math.PI / (double)this.points_phi;
                double c = 1.0 - ((double)this.j + 0.5) * 2.0 / (double)this.points_theta;
                this.theta = ((double)this.j + 0.5) * Math.PI / (double)this.points_theta;
                this.xi[this.indx] = Math.sqrt(1.0 - c * c) * Math.cos(this.phi);
                this.yi[this.indx] = Math.sqrt(1.0 - c * c) * Math.sin(this.phi);
                this.zi[this.indx] = c;
                this.xn[this.indx] = this.xi[this.indx];
                this.ynn[this.indx] = this.yi[this.indx];
                this.zn[this.indx] = this.zi[this.indx];
                this.xi[this.indx] = this.xi[this.indx] * this.radius;
                this.yi[this.indx] = this.yi[this.indx] * this.radius;
                this.zi[this.indx] = this.zi[this.indx] * this.radius;
                this.c1 = 1.0 - (double)this.j * 2.0 / (double)this.points_theta;
                this.c2 = 1.0 - (double)(this.j + 1) * 2.0 / (double)this.points_theta;
                this.area[this.indx] = this.radius * this.radius * (this.c1 - this.c2) * 2.0 * Math.PI / (double)this.points_phi;
                this.ss += this.area[this.indx];
                ++this.indx;
                ++this.j;
            }
            ++this.i;
        }
        this.nelements = this.indx;
        this.jLabel3.setText("elements=" + this.nelements);
    }

    void reset() {
        if (this.equal_area) {
            this.generate_equal_elements();
        } else {
            this.generate_elements();
        }
        this.loop = 0;
        for (int i = 0; i < this.NMAX; ++i) {
            this.qi[i] = 0.0;
        }
    }

    void iterate() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        if (this.loop == 0) {
            this.gb.setBackground(Color.white);
            this.gb.clearRect(0, 0, 550, 650);
            this.i = 0;
            while (this.i < this.nelements) {
                this.dx = this.xi[this.i];
                this.dy = this.yi[this.i];
                this.dz = this.zi[this.i];
                if (this.horizontal) {
                    this.dy += this.distance;
                } else {
                    this.dz += this.distance;
                }
                this.d2 = this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
                this.d3 = Math.sqrt(this.d2) * this.d2;
                this.ww = this.xn[this.i] * this.dx + this.ynn[this.i] * this.dy + this.zn[this.i] * this.dz;
                this.B[this.i] = this.f_value * this.ww / this.d3;
                ++this.i;
            }
        }
        if (this.loop < 100) {
            this.i = 0;
            while (this.i < this.nelements) {
                this.j = 0;
                while (this.j < this.nelements) {
                    if (this.i == this.j) {
                        this.W[this.i][this.j] = 1.0;
                    } else {
                        this.dx = this.xi[this.i] - this.xi[this.j];
                        this.dy = this.yi[this.i] - this.yi[this.j];
                        this.dz = this.zi[this.i] - this.zi[this.j];
                        this.d2 = this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
                        this.d3 = Math.sqrt(this.d2) * this.d2;
                        this.ww = this.xn[this.i] * this.dx + this.ynn[this.i] * this.dy + this.zn[this.i] * this.dz;
                        this.W[this.i][this.j] = this.f_value * this.ww * this.area[this.j] * this.qi[this.j] / this.d3;
                    }
                    ++this.j;
                }
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.nelements) {
                this.qi[this.i] = (1.0 - this.damp) * this.qi[this.i] + this.damp * this.B[this.i];
                this.j = 0;
                while (this.j < this.nelements) {
                    if (this.i != this.j) {
                        this.qi[this.i] = this.qi[this.i] + this.damp * this.W[this.i][this.j];
                    }
                    ++this.j;
                }
                ++this.i;
            }
            double rf0 = this.rf;
            this.rf = 0.0;
            this.i = 0;
            while (this.i < this.nelements) {
                this.d2 = this.horizontal ? this.xi[this.i] * this.xi[this.i] + (this.yi[this.i] + this.distance) * (this.yi[this.i] + this.distance) + this.zi[this.i] * this.zi[this.i] : this.xi[this.i] * this.xi[this.i] + (this.zi[this.i] + this.distance) * (this.zi[this.i] + this.distance) + this.yi[this.i] * this.yi[this.i];
                this.rf += this.qi[this.i] * this.area[this.i] / Math.sqrt(this.d2);
                ++this.i;
            }
            this.gb.setColor(Color.black);
            if (this.equal_area) {
                this.draw_equal_elements();
            } else {
                this.draw_elements();
            }
            this.gb.setColor(Color.red);
            if (this.loop > 0) {
                this.gb.drawLine(2 * (this.loop - 1), 50 - (int)(36.0 * rf0), 2 * this.loop, 50 - (int)(36.0 * this.rf));
            }
            this.gb.setColor(Color.blue);
            this.gb.drawLine(0, 50 - (int)(5.0 * this.exact_value(this.distance)), 300, 50 - (int)(5.0 * this.exact_value(this.distance)));
            this.gb.setColor(Color.black);
            this.gb.drawLine(0, 75, 300, 75);
            this.gb.drawLine(0, 100, 300, 100);
            this.gb.drawLine(0, 125, 300, 125);
            this.gb.drawLine(0, 150, 300, 150);
            this.gb.drawLine(0, 175, 300, 175);
            this.gb.drawLine(0, 200, 300, 200);
            this.gb.drawLine(0, 225, 300, 225);
            this.gb.drawString("-5eV", 310, 75);
            this.gb.drawString("-10eV", 310, 100);
            this.gb.drawString("-15eV", 310, 125);
            this.gb.drawString("-20eV", 310, 150);
            this.gb.drawString("-25eV", 310, 175);
            this.gb.drawString("-30eV", 310, 200);
            this.gb.drawString("-35eV", 310, 225);
            this.jLabel1.setText("red:solvation energy=" + this.df1.format(7.2 * this.rf) + " eV ");
            this.jLabel6.setText("blue:analytical value=" + this.df1.format(this.exact_value(this.distance)) + " eV");
            g2.drawImage((Image)this.image, 0, 0, null);
            ++this.loop;
        }
    }

    public class myPanel
    extends JPanel {
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)finitelapplet.this.image, 0, 0, null);
        }
    }
}

