/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewJApplet
extends JApplet {
    double[][] RealC;
    double[][] ImagC;
    double[][] RealC2;
    double[][] ImagC2;
    double[][] RealC3;
    double[][] ImagC3;
    double[][] RealC4;
    double[][] ImagC4;
    double[][] RealF1;
    double[][] ImagF1;
    double[][] RealF2;
    double[][] ImagF2;
    double[][] RealF3;
    double[][] ImagF3;
    double[][] RealF4;
    double[][] ImagF4;
    int nstates = 2;
    double V = 1.0;
    double DeltaE = 2.0;
    double tstep = 5.0E-4;
    double freq = 0.0;
    double tp = 1.0;
    double tp1 = 10.0;
    double t1r = 0.0;
    double t2r = 0.0;
    double t0 = 10.0;
    double t01 = 10.0;
    boolean twopulses = false;
    boolean lock = true;
    DecimalFormat df;
    private JLabel DEL;
    private JSlider DES;
    private JLabel VL;
    private JSlider VS;
    private JLabel freqL;
    private JSlider freqS;
    private JPanel jPanel1;
    private JToggleButton jToggleButton1;
    private JLabel t1rlab;
    private JSlider t1rslider;
    private JLabel t2rlab;
    private JSlider t2rslider;
    private JLabel tplab;
    private JSlider tpslider;
    private JLabel tzlab;
    private JSlider tzslider;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.RealC = new double[this.nstates][this.nstates];
        this.ImagC = new double[this.nstates][this.nstates];
        this.RealC2 = new double[this.nstates][this.nstates];
        this.ImagC2 = new double[this.nstates][this.nstates];
        this.RealC3 = new double[this.nstates][this.nstates];
        this.ImagC3 = new double[this.nstates][this.nstates];
        this.RealC4 = new double[this.nstates][this.nstates];
        this.ImagC4 = new double[this.nstates][this.nstates];
        this.RealF1 = new double[this.nstates][this.nstates];
        this.ImagF1 = new double[this.nstates][this.nstates];
        this.RealF2 = new double[this.nstates][this.nstates];
        this.ImagF2 = new double[this.nstates][this.nstates];
        this.RealF3 = new double[this.nstates][this.nstates];
        this.ImagF3 = new double[this.nstates][this.nstates];
        this.RealF4 = new double[this.nstates][this.nstates];
        this.ImagF4 = new double[this.nstates][this.nstates];
        this.df = new DecimalFormat("##0.000");
        this.VS.setValue((int)(this.V * 20.0));
        this.DES.setValue((int)(this.DeltaE * 20.0));
        this.freqS.setValue((int)(this.freq * 20.0));
        this.tpslider.setValue((int)(this.tp * 20.0));
        this.t1rslider.setValue((int)(this.t1r * 100.0));
        this.t2rslider.setValue((int)(this.t2r * 100.0));
        this.tzslider.setValue((int)(this.t0 * 10.0));
        this.VL.setText("V=" + this.df.format(this.V));
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.freqL.setText("frequency=" + this.df.format(this.freq));
        this.tplab.setText("tp=" + this.df.format(this.tp));
        this.t1rlab.setText("1/t1=" + this.df.format(this.t1r));
        this.t2rlab.setText("1/t2=" + this.df.format(this.t2r));
        this.tzlab.setText("t0=" + this.df.format(this.t0));
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.VS = new JSlider();
        this.DES = new JSlider();
        this.freqL = new JLabel();
        this.DEL = new JLabel();
        this.freqS = new JSlider();
        this.VL = new JLabel();
        this.tpslider = new JSlider();
        this.t1rlab = new JLabel();
        this.t1rslider = new JSlider();
        this.t2rslider = new JSlider();
        this.tplab = new JLabel();
        this.t2rlab = new JLabel();
        this.tzslider = new JSlider();
        this.tzlab = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.VS.setMaximum(200);
        this.VS.setToolTipText("magnitude of the perturbation");
        this.VS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.VSMouseDragged(evt);
            }
        });
        this.DES.setMaximum(200);
        this.DES.setToolTipText("energy gap of the two states");
        this.DES.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.DESMouseDragged(evt);
            }
        });
        this.freqL.setText("freq  ");
        this.DEL.setText("DeltaE ");
        this.freqS.setMaximum(200);
        this.freqS.setToolTipText("frequency of the perturbation");
        this.freqS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.freqSMouseDragged(evt);
            }
        });
        this.VL.setText("V          ");
        this.tpslider.setMaximum(200);
        this.tpslider.setToolTipText("pulse duration");
        this.tpslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.tpsliderMouseDragged(evt);
            }
        });
        this.t1rlab.setText("1/T1");
        this.t1rslider.setMaximum(400);
        this.t1rslider.setToolTipText("relaxation time t1");
        this.t1rslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.t1rsliderMouseDragged(evt);
            }
        });
        this.t2rslider.setMaximum(200);
        this.t2rslider.setToolTipText("relaxation time t2");
        this.t2rslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.t2rsliderMouseDragged(evt);
            }
        });
        this.tplab.setText("tp");
        this.t2rlab.setText("1/T2");
        this.tzslider.setMaximum(200);
        this.tzslider.setToolTipText("time of second pulse ");
        this.tzslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.tzsliderMouseDragged(evt);
            }
        });
        this.tzlab.setText("t0");
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.setText("lock T1=T2");
        this.jToggleButton1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewJApplet.this.jToggleButton1StateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.freqS, -2, 133, -2).addComponent(this.VS, -2, 133, -2).addComponent(this.DES, -2, 133, -2).addComponent(this.t1rslider, -2, 133, -2).addComponent(this.t2rslider, -2, 133, -2).addComponent(this.tzslider, -2, 133, -2).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.VL)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.freqL)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.DEL)))).addGroup(layout.createSequentialGroup().addGap(65, 65, 65).addComponent(this.tplab)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tpslider, -2, 133, -2)).addGroup(layout.createSequentialGroup().addGap(71, 71, 71).addComponent(this.tzlab)).addGroup(layout.createSequentialGroup().addGap(66, 66, 66).addComponent(this.t1rlab)).addGroup(layout.createSequentialGroup().addGap(64, 64, 64).addComponent(this.t2rlab)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleButton1))).addContainerGap(161, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.freqL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freqS, -2, -1, -2).addGap(30, 30, 30).addComponent(this.VL).addGap(18, 18, 18).addComponent(this.VS, -2, -1, -2).addGap(46, 46, 46).addComponent(this.DEL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DES, -2, -1, -2).addGap(27, 27, 27).addComponent(this.tplab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tpslider, -2, -1, -2).addGap(29, 29, 29).addComponent(this.tzlab).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tzslider, -2, -1, -2).addGap(46, 46, 46).addComponent(this.t1rlab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.t1rslider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.t2rlab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.t2rslider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleButton1).addGap(0, 116, Short.MAX_VALUE))).addContainerGap()));
    }

    private void VSMouseDragged(MouseEvent evt) {
        this.V = (double)this.VS.getValue() * 0.05;
        this.VL.setText("V=" + this.df.format(this.V));
        this.jPanel1.repaint();
    }

    private void DESMouseDragged(MouseEvent evt) {
        this.DeltaE = (double)this.DES.getValue() * 0.05;
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.jPanel1.repaint();
    }

    private void freqSMouseDragged(MouseEvent evt) {
        this.freq = (double)this.freqS.getValue() * 0.05;
        this.freqL.setText("frequency=" + this.df.format(this.freq));
        this.jPanel1.repaint();
    }

    private void tpsliderMouseDragged(MouseEvent evt) {
        this.tp = (double)this.tpslider.getValue() * 0.05;
        this.tplab.setText("tp=" + this.df.format(this.tp));
        this.jPanel1.repaint();
    }

    private void t1rsliderMouseDragged(MouseEvent evt) {
        this.t1r = (double)this.t1rslider.getValue() * 0.001;
        if (this.lock) {
            this.t2r = 0.5 * this.t1r;
            this.t2rlab.setText("1/t2=" + this.df.format(this.t2r));
            this.t2rslider.setValue((int)(this.t2r * 1000.0));
        }
        this.t1rlab.setText("1/t1=" + this.df.format(this.t1r));
        this.jPanel1.repaint();
    }

    private void t2rsliderMouseDragged(MouseEvent evt) {
        this.t2r = (double)this.t2rslider.getValue() * 0.001;
        if (this.lock) {
            this.t1r = this.t2r * 2.0;
            this.t1rlab.setText("1/T1=" + this.df.format(this.t1r));
            this.t1rslider.setValue((int)(this.t1r * 1000.0));
        }
        this.t2rlab.setText("1/T2=" + this.df.format(this.t2r));
        this.jPanel1.repaint();
    }

    private void tzsliderMouseDragged(MouseEvent evt) {
        this.t0 = (double)this.tzslider.getValue() * 0.1;
        this.tzlab.setText("t0=" + this.df.format(this.t0));
        this.jPanel1.repaint();
    }

    private void jToggleButton1StateChanged(ChangeEvent evt) {
        this.lock = this.jToggleButton1.isSelected();
        this.jPanel1.repaint();
    }

    double pulse(double t) {
        double arg = (t - this.t0) / this.tp;
        return Math.cos(this.freq * t) * Math.exp(-arg * arg);
    }

    double pulse2(double t) {
        double arg = (t - this.t01) / this.tp1;
        return Math.cos(this.freq * t) * Math.exp(-arg * arg);
    }

    void grad(double[][] RC, double[][] IC, double[][] RF, double[][] IF, double t) {
        double arg = (t - 10.0) / this.tp;
        double Vt = this.V * this.pulse(t);
        if (this.twopulses) {
            Vt += this.V * this.pulse2(t);
        }
        RF[0][0] = Vt * (IC[1][0] - IC[0][1]) - this.t1r * (RC[0][0] - 1.0);
        RF[1][1] = Vt * (IC[0][1] - IC[1][0]) - this.t1r * RC[1][1];
        RF[0][1] = Vt * (IC[1][1] - IC[0][0]) - this.DeltaE * IC[0][1] - this.t2r * RC[0][1];
        RF[1][0] = Vt * (IC[0][0] - IC[1][1]) + this.DeltaE * IC[1][0] - this.t2r * RC[1][0];
        IF[0][0] = -Vt * (RC[1][0] - RC[0][1]) - this.t1r * IC[0][0];
        IF[1][1] = -Vt * (RC[0][1] - RC[1][0]) - this.t1r * IC[1][1];
        IF[0][1] = -Vt * (RC[1][1] - RC[0][0]) + this.DeltaE * RC[0][1] - this.t2r * IC[0][1];
        IF[1][0] = -Vt * (RC[0][0] - RC[1][1]) - this.DeltaE * RC[1][0] - this.t2r * IC[1][0];
    }

    void advance(double[][] RC, double[][] IC, double[][] RF, double[][] IF, double[][] RC1, double[][] IC1, double step) {
        for (int i = 0; i < this.nstates; ++i) {
            for (int j = 0; j < this.nstates; ++j) {
                RC1[i][j] = RC[i][j] + RF[i][j] * step;
                IC1[i][j] = IC[i][j] + IF[i][j] * step;
            }
        }
    }

    void rk4(double t) {
        this.grad(this.RealC, this.ImagC, this.RealF1, this.ImagF1, t);
        this.advance(this.RealC, this.ImagC, this.RealF1, this.ImagF1, this.RealC2, this.ImagC2, this.tstep * 0.5);
        this.grad(this.RealC2, this.ImagC2, this.RealF2, this.ImagF2, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF2, this.ImagF2, this.RealC3, this.ImagC3, this.tstep * 0.5);
        this.grad(this.RealC3, this.ImagC3, this.RealF3, this.ImagF3, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF3, this.ImagF3, this.RealC4, this.ImagC4, this.tstep);
        this.grad(this.RealC4, this.ImagC4, this.RealF4, this.ImagF4, t + this.tstep);
        for (int i = 0; i < this.nstates; ++i) {
            for (int j = 0; j < this.nstates; ++j) {
                this.RealC[i][j] = this.RealC[i][j] + this.tstep * (this.RealF1[i][j] + 2.0 * this.RealF2[i][j] + 2.0 * this.RealF3[i][j] + this.RealF4[i][j]) / 6.0;
                this.ImagC[i][j] = this.ImagC[i][j] + this.tstep * (this.ImagF1[i][j] + 2.0 * this.ImagF2[i][j] + 2.0 * this.ImagF3[i][j] + this.ImagF4[i][j]) / 6.0;
            }
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        int i1;
        int iz0;
        int iz1;
        int ip0;
        int ip1;
        int blx0;
        int blx1;
        int blz0;
        int blz1;

        void iterate() {
        }

        public double cabs(double x, double y) {
            double r = Math.sqrt(x * x + y * y);
            return r;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            NewJApplet.this.RealC[0][0] = 1.0;
            NewJApplet.this.ImagC[0][0] = 0.0;
            NewJApplet.this.RealC[1][0] = 0.0;
            NewJApplet.this.ImagC[1][0] = 0.0;
            NewJApplet.this.RealC[0][1] = 0.0;
            NewJApplet.this.ImagC[0][1] = 0.0;
            NewJApplet.this.RealC[1][1] = 0.0;
            NewJApplet.this.ImagC[1][1] = 0.0;
            this.iy0 = 62;
            this.ix0 = 0;
            this.iz0 = 0;
            this.blz0 = this.iy0 - this.ix0;
            this.blx0 = 0;
            double t = 0.0;
            g.drawString("Bloch sphere", 10, 500);
            g.drawOval(107, 438, 187, 125);
            this.i = 0;
            while (this.i < 400) {
                this.i1 = 0;
                while (this.i1 < 100) {
                    NewJApplet.this.rk4(t += NewJApplet.this.tstep);
                    ++this.i1;
                }
                g.setColor(Color.black);
                g.drawRect(0, 50, 400, 250);
                g.drawRect(0, 300, 400, 100);
                g.drawString("blue=rho(1,1) red=rho(2,2) green=|rho(1,2)|", 10, 10);
                this.iy1 = (int)(this.cabs(NewJApplet.this.RealC[0][0], NewJApplet.this.ImagC[0][0]) * 250.0);
                this.ix1 = (int)(this.cabs(NewJApplet.this.RealC[1][1], NewJApplet.this.ImagC[1][1]) * 250.0);
                this.iz1 = (int)(this.cabs(NewJApplet.this.RealC[0][1], NewJApplet.this.ImagC[0][1]) * 250.0);
                this.blz1 = (this.iy1 - this.ix1) / 4;
                this.blx1 = (int)(NewJApplet.this.RealC[0][1] * 187.0);
                g.setColor(Color.blue);
                g.drawLine(this.i, 300 - this.iy0, this.i + 1, 300 - this.iy1);
                this.iy0 = this.iy1;
                g.setColor(Color.red);
                g.drawLine(this.i, 300 - this.ix0, this.i + 1, 300 - this.ix1);
                this.ix0 = this.ix1;
                g.setColor(Color.green);
                g.drawLine(this.i, 300 - this.iz0, this.i + 1, 300 - this.iz1);
                this.iz0 = this.iz1;
                g.setColor(Color.black);
                g.drawString("time ", 200, 420);
                double psum = NewJApplet.this.pulse((double)this.i * 100.0 * NewJApplet.this.tstep);
                double psum1 = NewJApplet.this.pulse((double)(this.i + 1) * 100.0 * NewJApplet.this.tstep);
                if (NewJApplet.this.twopulses) {
                    psum += NewJApplet.this.pulse2((double)this.i * 100.0 * NewJApplet.this.tstep);
                    psum1 += NewJApplet.this.pulse2((double)(this.i + 1) * 100.0 * NewJApplet.this.tstep);
                }
                this.ip0 = (int)(psum * 50.0);
                this.ip1 = (int)(psum1 * 50.0);
                g.drawLine(this.i, 350 - this.ip0, this.i + 1, 350 - this.ip1);
                g.setColor(Color.red);
                g.drawLine(200 + this.blx0, 500 + this.blz0, 200 + this.blx1, 500 + this.blz1);
                this.blx0 = this.blx1;
                this.blz0 = this.blz1;
                ++this.i;
            }
        }
    }
}

