/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements Runnable {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    volatile Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int i;
    int j;
    int k;
    int l;
    int loop;
    double dxxt;
    double tt;
    double sp2;
    double time_now;
    double dxx;
    double dv;
    double da;
    double[] ampl;
    double[] velo;
    double[] oldsd;
    double[] deltav;
    double[] deltaa;
    double[] ampl1;
    double[] velo1;
    int NDIM = 500;
    int NITER = 10000;
    double space_grid = 0.001;
    double time_grid = 0.001;
    double c0s = 0.05;
    double c0 = 0.25;
    double c00s = 0.05;
    double dc = -0.005;
    double omega = 20.0;
    double omega0 = 20.0;
    double damp = 2.0;
    double TP = 0.1;
    double TP0 = 0.1;
    double cutoff = 0.4;
    double phase = 0.0;
    double refr = 1.0;
    double refr0 = 1.0;
    boolean nonlinear = false;
    int pulsetype = 0;
    int boundtype = 0;
    int method = 0;
    boolean periodic = true;
    private JLabel c0lab;
    private JSlider c0slider;
    private JButton clearbutton;
    private JLabel cutofflabel;
    private JSlider cutoffslider;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("0.000");
        this.ampl = new double[this.NDIM];
        this.velo = new double[this.NDIM + 1];
        this.ampl1 = new double[this.NDIM];
        this.velo1 = new double[this.NDIM + 1];
        this.oldsd = new double[this.NDIM];
        this.deltav = new double[this.NDIM + 1];
        this.deltaa = new double[this.NDIM];
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.cutofflabel.setText("pulse width=" + this.df1.format(this.TP));
        this.cutoffslider.setValue((int)(this.TP * 200.0));
        this.c0slider.setValue((int)(this.c0s * 100.0));
        this.c0lab.setText("velocity=Courant=" + this.df1.format(Math.sqrt(this.c0s)));
        this.stop();
        this.reset_all();
        this.initval();
        this.start();
    }

    public void run() {
        while (Thread.currentThread() == this.calculatorThread) {
            this.waves();
        }
    }

    public void start() {
        if (this.calculatorThread == null) {
            this.calculatorThread = new Thread(this);
            this.calculatorThread.start();
        }
    }

    public void stop() {
        Thread tmpBlinker = this.calculatorThread;
        this.calculatorThread = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.cutoffslider = new JSlider();
        this.cutofflabel = new JLabel();
        this.clearbutton = new JButton();
        this.jLabel1 = new JLabel();
        this.c0slider = new JSlider();
        this.c0lab = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setDoubleBuffered(false);
        this.jPanel1.setMaximumSize(new Dimension(500, 550));
        this.jPanel1.setMinimumSize(new Dimension(500, 550));
        this.jPanel1.setPreferredSize(new Dimension(500, 550));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 523, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 548, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(120, 550));
        this.jPanel2.setMinimumSize(new Dimension(120, 550));
        this.jPanel2.setPreferredSize(new Dimension(120, 550));
        this.cutoffslider.setMajorTickSpacing(20);
        this.cutoffslider.setMaximum(200);
        this.cutoffslider.setMinimum(5);
        this.cutoffslider.setToolTipText("pulse period");
        this.cutoffslider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.cutoffsliderMouseReleased(evt);
            }
        });
        this.cutoffslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.cutoffsliderMouseDragged(evt);
            }
        });
        this.cutofflabel.setText("jLabel1");
        this.clearbutton.setText("start");
        this.clearbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.clearbuttonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.c0slider.setMinimum(2);
        this.c0slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.c0sliderMouseDragged(evt);
            }
        });
        this.c0lab.setText("jLabel1");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"leap frog", "LW", "ICN"}));
        this.jComboBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox3ActionPerformed(evt);
            }
        });
        this.jButton1.setText("stop");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Gaussian");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Triangular");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Rectangular");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cutofflabel, -1, -1, Short.MAX_VALUE).addComponent(this.c0lab, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.jLabel1)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jComboBox3, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearbutton)))).addComponent(this.c0slider, -2, 117, -2).addComponent(this.cutoffslider, -2, 125, -2)).addGap(0, 75, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.c0slider, this.cutoffslider);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.c0lab, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.c0slider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.cutofflabel, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffslider, -2, -1, -2).addGap(55, 55, 55).addComponent(this.jComboBox3, -2, -1, -2).addGap(36, 36, 36).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.clearbutton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4).addGap(39, 39, 39).addComponent(this.jLabel1).addContainerGap(116, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 525, Short.MAX_VALUE).addGap(44, 44, 44).addComponent(this.jPanel2, -2, 220, -2).addGap(307, 307, 307)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap(226, Short.MAX_VALUE)));
    }

    private void clearbuttonActionPerformed(ActionEvent evt) {
        this.drawwaves();
        this.start();
    }

    private void cutoffsliderMouseDragged(MouseEvent evt) {
        this.cutofflabel.setText("pulse duration=" + this.df1.format(this.TP));
        this.stop();
        this.TP = this.TP0 = (double)this.cutoffslider.getValue() * 0.01;
        this.cutofflabel.setText("pulse width=" + this.df1.format(this.TP0));
        this.initval();
        this.drawwaves();
        this.jPanel1.repaint();
    }

    private void c0sliderMouseDragged(MouseEvent evt) {
        this.c00s = (double)this.c0slider.getValue() * 0.01;
        this.c0lab.setText("velocity=Courant=" + this.df1.format(Math.sqrt(this.c00s)));
    }

    private void cutoffsliderMouseReleased(MouseEvent evt) {
        this.TP0 = (double)this.cutoffslider.getValue() * 0.01;
        this.initval();
        this.drawwaves();
    }

    private void jComboBox3ActionPerformed(ActionEvent evt) {
        this.stop();
        this.method = this.jComboBox3.getSelectedIndex();
        this.start();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.stop();
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
            this.deltaa[i] = 0.0;
            this.deltav[i] = 0.0;
        }
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
        this.refr = this.refr0;
        this.pulsetype = 0;
        this.initval();
        this.drawwaves();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.stop();
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
            this.deltaa[i] = 0.0;
            this.deltav[i] = 0.0;
        }
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
        this.refr = this.refr0;
        this.pulsetype = 1;
        this.initval();
        this.drawwaves();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.stop();
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
            this.deltaa[i] = 0.0;
            this.deltav[i] = 0.0;
        }
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
        this.refr = this.refr0;
        this.pulsetype = 2;
        this.initval();
        this.drawwaves();
    }

    void reset_all() {
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
            this.oldsd[i] = 0.0;
        }
        this.sp2 = this.space_grid * this.space_grid;
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
    }

    double signal_tr(double t) {
        double t2 = 2.0 * t;
        if (t2 > 0.5 + this.TP / 4.0 || t2 < 0.5 - this.TP / 4.0) {
            return 0.0;
        }
        if (t2 < 0.5) {
            return 1.0 + 4.0 * (t2 - 0.5) / this.TP;
        }
        return 1.0 + 4.0 * (0.5 - t2) / this.TP;
    }

    double signal_sq(double t) {
        double t2 = 2.0 * t;
        if (t2 > 0.5 + this.TP / 4.0 || t2 < 0.5 - this.TP / 4.0) {
            return 0.0;
        }
        return 1.0;
    }

    double signal_g(double t) {
        double t2 = 2.0 * t;
        double aa = 5.0 * (t2 - 0.5) / this.TP;
        return Math.exp(-aa * aa);
    }

    void initval() {
        this.time_now = 0.0;
        this.i = 0;
        while (this.i < this.NDIM) {
            double time_ad;
            this.time_now = (double)this.i * this.time_grid;
            int ip = this.i;
            if (this.method == 0) {
                time_ad = this.time_now + this.time_grid;
                if (ip == this.NDIM) {
                    ip = 0;
                }
            } else {
                time_ad = this.time_now;
            }
            if (this.pulsetype == 1) {
                this.ampl[this.i] = this.signal_tr(this.time_now);
                this.velo[ip] = -this.signal_tr(time_ad);
            }
            if (this.pulsetype == 2) {
                this.ampl[this.i] = this.signal_sq(this.time_now);
                this.velo[ip] = -this.signal_sq(time_ad);
            }
            if (this.pulsetype == 0) {
                this.ampl[this.i] = this.signal_g(this.time_now);
                this.velo[ip] = -this.signal_g(time_ad);
            }
            ++this.i;
        }
        this.time_now = 0.0;
    }

    void drawwaves() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.gb.setColor(Color.white);
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.black);
        this.gb.setColor(Color.red);
        this.i = 0;
        while (this.i < this.NDIM - 1) {
            this.gb.drawLine(this.i, 300 - (int)(100.0 * this.ampl[this.i]), this.i + 1, 300 - (int)(100.0 * this.ampl[this.i + 1]));
            ++this.i;
        }
        this.gb.setColor(Color.blue);
        this.i = 0;
        while (this.i < this.NDIM - 1) {
            this.gb.drawLine(this.i, 300 - (int)(100.0 * this.velo[this.i]), this.i + 1, 300 - (int)(100.0 * this.velo[this.i + 1]));
            ++this.i;
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    void waves() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.c0s = this.c00s;
        this.c0 = Math.sqrt(this.c0s);
        this.time_now += this.time_grid;
        this.jLabel1.setText("time=" + this.df1.format(this.time_now));
        if (this.method == 0 && !this.periodic) {
            this.i = 0;
            while (this.i < this.NDIM - 1) {
                this.dv = this.c0 * (this.ampl[this.i + 1] - this.ampl[this.i]) / this.space_grid;
                this.velo[this.i] = this.velo[this.i] + this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = -this.ampl[this.NDIM - 1] / this.space_grid;
            this.velo[this.NDIM - 1] = this.velo[this.NDIM - 1] + this.dv * this.time_grid;
            this.i = 1;
            while (this.i < this.NDIM) {
                this.dv = this.c0 * (this.velo[this.i] - this.velo[this.i - 1]) / this.space_grid;
                this.ampl[this.i] = this.ampl[this.i] + this.dv * this.time_grid;
                ++this.i;
            }
        }
        if (this.method == 0 && this.periodic) {
            this.i = 0;
            while (this.i < this.NDIM - 1) {
                this.dv = this.c0 * (this.ampl[this.i + 1] - this.ampl[this.i]) / this.space_grid;
                this.velo[this.i] = this.velo[this.i] + this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = this.c0 * (this.ampl[0] - this.ampl[this.NDIM - 1]) / this.space_grid;
            this.velo[this.NDIM - 1] = this.velo[this.NDIM - 1] + this.dv * this.time_grid;
            this.i = 1;
            while (this.i < this.NDIM) {
                this.dv = this.c0 * (this.velo[this.i] - this.velo[this.i - 1]) / this.space_grid;
                this.ampl[this.i] = this.ampl[this.i] + this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = this.c0 * (this.velo[0] - this.velo[this.NDIM - 1]) / this.space_grid;
            this.ampl[0] = this.ampl[0] + this.dv * this.time_grid;
        }
        if (this.method == 1 && !this.periodic) {
            this.deltav[0] = this.dv = this.c0 * (this.ampl[1] - this.ampl[0]) / this.space_grid + this.c0s * 0.5 * (2.0 * this.velo[1] - 2.0 * this.velo[0]) * this.time_grid / this.sp2;
            this.deltav[this.NDIM] = this.dv = this.c0 * 0.5 * -this.ampl[this.NDIM - 1] / this.space_grid + this.c0s * 0.5 * (this.velo[this.NDIM - 1] - 2.0 * this.velo[this.NDIM]) * this.time_grid / this.sp2;
            this.i = 1;
            while (this.i < this.NDIM - 1) {
                this.deltaa[this.i] = this.dv = this.c0 * 0.5 * (this.velo[this.i + 1] - this.velo[this.i - 1]) / this.space_grid + this.c0s * 0.5 * (this.ampl[this.i + 1] + this.ampl[this.i - 1] - 2.0 * this.ampl[this.i]) * this.time_grid / this.sp2;
                this.deltav[this.i] = this.dv = this.c0 * 0.5 * (this.ampl[this.i + 1] - this.ampl[this.i - 1]) / this.space_grid + this.c0s * 0.5 * (this.velo[this.i + 1] + this.velo[this.i - 1] - 2.0 * this.velo[this.i]) * this.time_grid / this.sp2;
                ++this.i;
            }
            this.deltaa[this.NDIM - 1] = this.dv = this.c0 * 0.5 * (this.velo[this.NDIM - 1] - this.velo[this.NDIM - 2]) / this.space_grid + this.c0s * 0.5 * (this.ampl[this.NDIM - 2] - 2.0 * this.ampl[this.NDIM - 1]) * this.time_grid / this.sp2;
            this.deltav[this.NDIM - 1] = this.dv = this.c0 * 0.5 * -this.ampl[this.NDIM - 2] / this.space_grid + this.c0s * 0.5 * (this.velo[this.NDIM - 1] + this.velo[this.NDIM - 2] - 2.0 * this.velo[this.NDIM - 1]) * this.time_grid / this.sp2;
            this.velo[0] = this.velo[0] + this.deltav[0] * this.time_grid;
            this.velo[this.NDIM] = this.velo[this.NDIM] + this.deltav[this.NDIM] * this.time_grid;
            this.i = 1;
            while (this.i < this.NDIM) {
                this.ampl[this.i] = this.ampl[this.i] + this.deltaa[this.i] * this.time_grid;
                this.velo[this.i] = this.velo[this.i] + this.deltav[this.i] * this.time_grid;
                ++this.i;
            }
        }
        if (this.method == 1 && this.periodic) {
            this.deltav[0] = this.dv = this.c0 * 0.5 * (this.ampl[1] - this.ampl[this.NDIM - 1]) / this.space_grid + this.c0s * 0.5 * (this.velo[this.NDIM - 1] + this.velo[1] - 2.0 * this.velo[0]) * this.time_grid / this.sp2;
            this.deltaa[0] = this.dv = this.c0 * 0.5 * (this.velo[1] - this.velo[this.NDIM - 1]) / this.space_grid + this.c0s * 0.5 * (this.ampl[1] + this.ampl[this.NDIM - 1] - 2.0 * this.ampl[0]) * this.time_grid / this.sp2;
            this.i = 1;
            while (this.i < this.NDIM - 1) {
                this.deltaa[this.i] = this.dv = this.c0 * 0.5 * (this.velo[this.i + 1] - this.velo[this.i - 1]) / this.space_grid + this.c0s * 0.5 * (this.ampl[this.i + 1] + this.ampl[this.i - 1] - 2.0 * this.ampl[this.i]) * this.time_grid / this.sp2;
                this.deltav[this.i] = this.dv = this.c0 * 0.5 * (this.ampl[this.i + 1] - this.ampl[this.i - 1]) / this.space_grid + this.c0s * 0.5 * (this.velo[this.i + 1] + this.velo[this.i - 1] - 2.0 * this.velo[this.i]) * this.time_grid / this.sp2;
                ++this.i;
            }
            this.deltaa[this.NDIM - 1] = this.dv = this.c0 * 0.5 * (this.velo[0] - this.velo[this.NDIM - 2]) / this.space_grid + this.c0s * 0.5 * (this.ampl[0] + this.ampl[this.NDIM - 2] - 2.0 * this.ampl[this.NDIM - 1]) * this.time_grid / this.sp2;
            this.deltav[this.NDIM - 1] = this.dv = this.c0 * 0.5 * (this.ampl[0] - this.ampl[this.NDIM - 2]) / this.space_grid + this.c0s * 0.5 * (this.velo[0] + this.velo[this.NDIM - 2] - 2.0 * this.velo[this.NDIM - 1]) * this.time_grid / this.sp2;
            this.i = 0;
            while (this.i < this.NDIM) {
                this.ampl[this.i] = this.ampl[this.i] + this.deltaa[this.i] * this.time_grid;
                this.velo[this.i] = this.velo[this.i] + this.deltav[this.i] * this.time_grid;
                ++this.i;
            }
        }
        if (this.method == 2 && this.periodic) {
            this.i = 1;
            while (this.i < this.NDIM - 1) {
                this.dv = this.c0 * (this.ampl[this.i + 1] - this.ampl[this.i - 1]) / this.space_grid;
                this.velo1[this.i] = this.velo[this.i] + 0.25 * this.dv * this.time_grid;
                this.dv = this.c0 * (this.velo[this.i + 1] - this.velo[this.i - 1]) / this.space_grid;
                this.ampl1[this.i] = this.ampl[this.i] + 0.25 * this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = this.c0 * (this.ampl[1] - this.ampl[this.NDIM - 1]) / this.space_grid;
            this.velo1[0] = this.velo[0] + 0.25 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo[1] - this.velo[this.NDIM - 1]) / this.space_grid;
            this.ampl1[0] = this.ampl[0] + 0.25 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.ampl[0] - this.ampl[this.NDIM - 2]) / this.space_grid;
            this.velo1[this.NDIM - 1] = this.velo[this.NDIM - 1] + 0.25 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo[0] - this.velo[this.NDIM - 2]) / this.space_grid;
            this.ampl1[this.NDIM - 1] = this.ampl[this.NDIM - 1] + 0.25 * this.dv * this.time_grid;
            this.i = 1;
            while (this.i < this.NDIM - 1) {
                this.dv = this.c0 * (this.ampl1[this.i + 1] - this.ampl1[this.i - 1]) / this.space_grid;
                this.deltav[this.i] = this.velo[this.i] + 0.5 * this.dv * this.time_grid;
                this.dv = this.c0 * (this.velo1[this.i + 1] - this.velo1[this.i - 1]) / this.space_grid;
                this.deltaa[this.i] = this.ampl[this.i] + 0.5 * this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = this.c0 * (this.ampl1[0] - this.ampl1[this.NDIM - 2]) / this.space_grid;
            this.deltav[this.NDIM - 1] = this.velo[this.NDIM - 1] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo1[0] - this.velo1[this.NDIM - 2]) / this.space_grid;
            this.deltaa[this.NDIM - 1] = this.ampl[this.NDIM - 1] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.ampl1[1] - this.ampl1[this.NDIM - 1]) / this.space_grid;
            this.deltav[0] = this.velo[0] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo1[1] - this.velo1[this.NDIM - 1]) / this.space_grid;
            this.deltaa[0] = this.ampl[0] + 0.5 * this.dv * this.time_grid;
            this.i = 0;
            while (this.i < this.NDIM) {
                this.velo1[this.i] = 0.5 * (this.velo[this.i] + this.deltav[this.i]);
                this.ampl1[this.i] = 0.5 * (this.ampl[this.i] + this.deltaa[this.i]);
                ++this.i;
            }
            this.i = 1;
            while (this.i < this.NDIM - 1) {
                this.dv = this.c0 * (this.ampl1[this.i + 1] - this.ampl1[this.i - 1]) / this.space_grid;
                this.velo[this.i] = this.velo[this.i] + 0.5 * this.dv * this.time_grid;
                this.dv = this.c0 * (this.velo1[this.i + 1] - this.velo1[this.i - 1]) / this.space_grid;
                this.ampl[this.i] = this.ampl[this.i] + 0.5 * this.dv * this.time_grid;
                ++this.i;
            }
            this.dv = this.c0 * (this.ampl1[0] - this.ampl1[this.NDIM - 2]) / this.space_grid;
            this.velo[this.NDIM - 1] = this.velo[this.NDIM - 1] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo1[0] - this.velo1[this.NDIM - 2]) / this.space_grid;
            this.ampl[this.NDIM - 1] = this.ampl[this.NDIM - 1] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.ampl1[1] - this.ampl1[this.NDIM - 1]) / this.space_grid;
            this.velo[0] = this.velo[0] + 0.5 * this.dv * this.time_grid;
            this.dv = this.c0 * (this.velo1[1] - this.velo1[this.NDIM - 1]) / this.space_grid;
            this.ampl[0] = this.ampl[0] + 0.5 * this.dv * this.time_grid;
        }
        this.gb.setColor(Color.white);
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.black);
        this.gb.setColor(Color.red);
        this.i = 0;
        while (this.i < this.NDIM - 1) {
            this.gb.drawLine(this.i, 300 - (int)(100.0 * this.ampl[this.i]), this.i + 1, 300 - (int)(100.0 * this.ampl[this.i + 1]));
            ++this.i;
        }
        this.gb.setColor(Color.blue);
        this.i = 0;
        while (this.i < this.NDIM - 1) {
            this.gb.drawLine(this.i, 300 - (int)(100.0 * this.velo[this.i]), this.i + 1, 300 - (int)(100.0 * this.velo[this.i + 1]));
            ++this.i;
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

