/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    int nmax = 10000;
    int Npoints = 100;
    int nplot = 100;
    double[] q1;
    double[] q2;
    double[] a1;
    double[] a2;
    double[] bk;
    double[] x;
    double[] y;
    double a = 10.0;
    double b = 0.001;
    double reler = 0.1;
    double af = 0.0;
    double bf = 0.0;
    int[] ixp;
    int[] iyp;
    DecimalFormat df;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.q1 = new double[this.nmax];
        this.q2 = new double[this.nmax];
        this.a1 = new double[this.nmax];
        this.a2 = new double[this.nmax];
        this.bk = new double[this.nmax];
        this.x = new double[this.nmax];
        this.y = new double[this.nmax];
        this.ixp = new int[this.nplot];
        this.iyp = new int[this.nplot];
        this.df = new DecimalFormat("##0.000000");
        this.a = this.jSlider2.getValue();
        this.jLabel1.setText("true a=" + this.df.format(this.a));
        this.b = (double)this.jSlider1.getValue() * 1.0E-4;
        this.jLabel2.setText("true b=" + this.df.format(this.b));
        this.reler = (double)this.jSlider3.getValue() * 0.005;
        this.jLabel5.setText("err=" + this.df.format(this.reler));
        this.gendat();
        this.fit1();
        this.jPanel1.repaint();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jSlider3 = new JSlider();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 429, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 495, Short.MAX_VALUE));
        this.jLabel3.setText("jLabel3");
        this.jLabel4.setText("jLabel4");
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel2.setText("jLabel2");
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.jButton1.setText("Go");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel5.setText("jLabel5");
        this.jLabel6.setText("fitted parameters:");
        this.jLabel7.setText("jLabel7");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider3, -2, -1, -2).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jSlider2, -2, -1, -2).addComponent(this.jLabel6))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3))).addGroup(layout.createSequentialGroup().addGap(88, 88, 88).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addGap(86, 86, 86).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addGap(75, 75, 75).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, 185, -2))).addContainerGap(434, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(54, 54, 54).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(27, 27, 27).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addGap(50, 50, 50).addComponent(this.jButton1).addGap(58, 58, 58).addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel4).addGap(28, 28, 28).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jPanel1, -2, -1, -2))).addContainerGap(84, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.gendat();
        this.fit1();
        this.jPanel1.repaint();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.a = this.jSlider2.getValue();
        this.jLabel1.setText("true a=" + this.df.format(this.a));
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.b = (double)this.jSlider1.getValue() * 1.0E-4;
        this.jLabel2.setText("true b=" + this.df.format(this.b));
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.reler = (double)this.jSlider3.getValue() * 0.005;
        this.jLabel5.setText("err=" + this.df.format(this.reler));
    }

    public double RMS() {
        double s = 0.0;
        for (int i = 0; i < this.Npoints; ++i) {
            double xp = this.x[i];
            double yp = this.af * xp + this.bf * xp * xp * xp - this.y[i];
            s += yp * yp;
        }
        return Math.sqrt(s / (double)this.Npoints);
    }

    public double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    public void gendat() {
        for (int i = 0; i < this.Npoints; ++i) {
            this.x[i] = (double)i * 3.0 + 10.0;
            this.y[i] = this.a * this.x[i] + this.b * this.x[i] * this.x[i] * this.x[i];
            double r = this.randgauss();
            this.y[i] = this.y[i] * (1.0 + r * this.reler);
        }
    }

    public void fit1() {
        double yp;
        double xp;
        int i;
        double yx3s = 0.0;
        double x6s = 0.0;
        double x4s = 0.0;
        double x2s = 0.0;
        double xys = 0.0;
        for (i = 0; i < this.Npoints; ++i) {
            xys += this.x[i] * this.y[i];
            x2s += this.x[i] * this.x[i];
            x4s += this.x[i] * this.x[i] * this.x[i] * this.x[i];
            x6s += this.x[i] * this.x[i] * this.x[i] * this.x[i] * this.x[i] * this.x[i];
            yx3s += this.y[i] * this.x[i] * this.x[i] * this.x[i];
        }
        double det = (x2s /= (double)this.Npoints) * (x6s /= (double)this.Npoints) - (x4s /= (double)this.Npoints) * x4s;
        double det1 = (xys /= (double)this.Npoints) * x6s - (yx3s /= (double)this.Npoints) * x4s;
        double det2 = x2s * yx3s - xys * x4s;
        this.af = det1 / det;
        this.bf = det2 / det;
        this.jLabel3.setText("a=" + this.df.format(this.af));
        this.jLabel4.setText("b=" + this.df.format(this.bf));
        this.jLabel7.setText("RMS=" + this.df.format(this.RMS()));
        for (i = 0; i < this.nplot; ++i) {
            xp = i * 3 + 10;
            yp = this.a * xp + this.b * xp * xp * xp;
        }
        for (i = 0; i < this.nplot; ++i) {
            xp = i * 3 + 10;
            yp = this.af * xp + this.bf * xp * xp * xp;
        }
    }

    public class myPanel
    extends JPanel {
        int ix;
        int iy;
        int i;
        double xp;
        double yp;

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.drawLine(0, 400, 300, 400);
            g.drawLine(0, 400, 0, 0);
            this.i = 100;
            while (this.i < 400) {
                g.drawLine(this.i, 400, this.i, 410);
                g.drawString("" + this.i, this.i - 15, 430);
                this.i += 100;
            }
            this.i = 100;
            while (this.i < 400) {
                g.drawLine(0, this.i, 10, this.i);
                g.drawString("" + this.i * 100, 20, 400 - this.i);
                this.i += 100;
            }
            g.drawString("x", 320, 410);
            g.drawString("y=a*x+b*x*x*x", 10, 10);
            this.i = 0;
            while (this.i < NewJApplet.this.Npoints) {
                this.ix = (int)NewJApplet.this.x[this.i];
                this.iy = 400 - (int)(0.01 * NewJApplet.this.y[this.i]);
                g.fillOval(this.ix, this.iy, 5, 5);
                ++this.i;
            }
            this.i = 0;
            while (this.i < NewJApplet.this.nplot) {
                this.xp = this.i * 3 + 10;
                this.yp = NewJApplet.this.a * this.xp + NewJApplet.this.b * this.xp * this.xp * this.xp;
                NewJApplet.this.ixp[this.i] = (int)this.xp;
                NewJApplet.this.iyp[this.i] = 400 - (int)(0.01 * this.yp);
                ++this.i;
            }
            g.drawString("black=true curve", 200, 370);
            g.drawPolyline(NewJApplet.this.ixp, NewJApplet.this.iyp, NewJApplet.this.nplot);
            g.setColor(Color.RED);
            g.drawString("red=fitted curve", 200, 390);
            this.i = 0;
            while (this.i < NewJApplet.this.nplot) {
                this.xp = this.i * 3 + 10;
                this.yp = NewJApplet.this.af * this.xp + NewJApplet.this.bf * this.xp * this.xp * this.xp;
                NewJApplet.this.ixp[this.i] = (int)this.xp;
                NewJApplet.this.iyp[this.i] = 400 - (int)(0.01 * this.yp);
                ++this.i;
            }
            g.drawPolyline(NewJApplet.this.ixp, NewJApplet.this.iyp, NewJApplet.this.nplot);
        }
    }
}

