/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    public double[] xcoor;
    public double[] ycoor;
    public double[] zcoor;
    public double[] d;
    public double[] e;
    public int max_segments = 5000;
    public int number_segments = 10;
    public int window_w;
    public double[][] gyrtens;
    public double[][] zmat;
    public double rgav;
    public double r2av;
    public double rcav;
    public double d1av;
    public double d2av;
    public double d0av;
    public int nav;
    public int ierr;
    DecimalFormat df;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSlider jSlider1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.xcoor = new double[this.max_segments];
        this.ycoor = new double[this.max_segments];
        this.zcoor = new double[this.max_segments];
        this.gyrtens = new double[3][3];
        this.zmat = new double[3][3];
        this.d = new double[3];
        this.e = new double[3];
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        this.df = new DecimalFormat("##0.000", unusualSymbols);
        this.init_walk();
    }

    public void init_walk() {
        this.rgav = 0.0;
        this.r2av = 0.0;
        this.rcav = 0.0;
        this.nav = 0;
        this.d1av = 0.0;
        this.d2av = 0.0;
        this.d0av = 0.0;
        this.window_w = 150 / (int)Math.sqrt(this.number_segments);
        this.jLabel18.setText("points:" + this.number_segments);
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(400, 400));
        this.jPanel1.setMinimumSize(new Dimension(400, 400));
        this.jPanel1.setPreferredSize(new Dimension(400, 400));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        this.jButton1.setText("one shot");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("--");
        this.jLabel2.setText("--");
        this.jLabel3.setText("--");
        this.jLabel4.setText("--");
        this.jLabel8.setText("--");
        this.jLabel9.setText("--");
        this.jButton2.setText("average 1000");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel10.setText("gyration radius^2");
        this.jLabel11.setText("end to end radius^2");
        this.jLabel12.setText("center radius ^2");
        this.jLabel16.setText("--");
        this.jLabel17.setText("ordered eigenvalues of gyration tensor");
        this.jSlider1.setMajorTickSpacing(100);
        this.jSlider1.setMaximum(1000);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel18.setText("jLabel18");
        this.jLabel19.setText("last shot");
        this.jLabel20.setText("average");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel20).addComponent(this.jLabel19, -2, 69, -2)).addGap(33, 33, 33).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel13)).addGap(54, 54, 54).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel15)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addGap(58, 58, 58).addComponent(this.jLabel7)))).addComponent(this.jLabel17)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -1, 209, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addGap(18, 18, 18).addComponent(this.jLabel9)).addComponent(this.jLabel12, -1, 209, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel4)).addComponent(this.jLabel11, -1, 228, Short.MAX_VALUE).addComponent(this.jButton2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSlider1, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(20, 20, 20)).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16).addComponent(this.jLabel18)).addContainerGap()))));
        layout.linkSize(0, this.jButton1, this.jButton2);
        layout.linkSize(0, this.jLabel13, this.jLabel14, this.jLabel15, this.jLabel5, this.jLabel6, this.jLabel7);
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel8, this.jLabel9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(58, 58, 58).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(37, 37, 37).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel4)).addGap(29, 29, 29).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jLabel9)).addGap(39, 39, 39).addComponent(this.jButton2).addGap(18, 18, 18).addComponent(this.jButton1).addGap(27, 27, 27).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18)).addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel17).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel20))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16))).addContainerGap(26, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.walk();
        this.jPanel1.repaint();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        for (int ilo = 0; ilo < 1000; ++ilo) {
            this.walk();
        }
        this.jPanel1.repaint();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        double expo = (double)this.jSlider1.getValue() / 200.0;
        this.number_segments = (int)Math.pow(10.0, expo);
        if (this.number_segments > this.max_segments) {
            this.number_segments = this.max_segments;
        }
        this.init_walk();
        this.jLabel18.setText("points:" + this.number_segments);
    }

    public void walk() {
        int i;
        this.xcoor[0] = 0.0;
        this.ycoor[0] = 0.0;
        this.zcoor[0] = 0.0;
        for (i = 1; i < this.number_segments; ++i) {
            double r = Math.random();
            double phi = r * 2.0 * Math.PI;
            double c_p = Math.cos(phi);
            double s_p = Math.sin(phi);
            double c_t = r = 2.0 * (Math.random() - 0.5);
            double s_t = Math.sqrt(1.0 - c_t * c_t);
            this.xcoor[i] = this.xcoor[i - 1] + s_t * c_p;
            this.ycoor[i] = this.ycoor[i - 1] + s_t * s_p;
            this.zcoor[i] = this.zcoor[i - 1] + c_t;
        }
        double xm = 0.0;
        double ym = 0.0;
        double zm = 0.0;
        for (i = 0; i < this.number_segments; ++i) {
            xm += this.xcoor[i];
            ym += this.ycoor[i];
            zm += this.zcoor[i];
        }
        double rc = (xm /= (double)this.number_segments) * xm + (ym /= (double)this.number_segments) * ym + (zm /= (double)this.number_segments) * zm;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.gyrtens[i][j] = 0.0;
            }
        }
        for (i = 1; i < this.number_segments; ++i) {
            double x1 = this.xcoor[i] - xm;
            double y1 = this.ycoor[i] - ym;
            double z1 = this.zcoor[i] - zm;
            double[] dArray = this.gyrtens[0];
            dArray[0] = dArray[0] + x1 * x1;
            double[] dArray2 = this.gyrtens[0];
            dArray2[1] = dArray2[1] + x1 * y1;
            double[] dArray3 = this.gyrtens[0];
            dArray3[2] = dArray3[2] + x1 * z1;
            double[] dArray4 = this.gyrtens[1];
            dArray4[0] = dArray4[0] + y1 * x1;
            double[] dArray5 = this.gyrtens[1];
            dArray5[1] = dArray5[1] + y1 * y1;
            double[] dArray6 = this.gyrtens[1];
            dArray6[2] = dArray6[2] + y1 * z1;
            double[] dArray7 = this.gyrtens[2];
            dArray7[0] = dArray7[0] + z1 * x1;
            double[] dArray8 = this.gyrtens[2];
            dArray8[1] = dArray8[1] + z1 * y1;
            double[] dArray9 = this.gyrtens[2];
            dArray9[2] = dArray9[2] + z1 * z1;
        }
        int n2 = this.number_segments * this.number_segments;
        double rg = (this.gyrtens[0][0] + this.gyrtens[1][1] + this.gyrtens[2][2]) / (double)n2;
        double r2 = this.xcoor[this.number_segments - 1] * this.xcoor[this.number_segments - 1] + this.ycoor[this.number_segments - 1] * this.ycoor[this.number_segments - 1] + this.zcoor[this.number_segments - 1] * this.zcoor[this.number_segments - 1];
        this.rgav += rg;
        this.r2av += (r2 /= (double)this.number_segments);
        this.rcav += (rc /= (double)this.number_segments);
        ++this.nav;
        this.jLabel1.setText(this.df.format(rg));
        this.jLabel2.setText(this.df.format(r2));
        this.jLabel3.setText("av:" + this.df.format(this.rgav / (double)this.nav));
        this.jLabel4.setText("av:" + this.df.format(this.r2av / (double)this.nav));
        this.jLabel8.setText(this.df.format(rc));
        this.jLabel9.setText("av:" + this.df.format(this.rcav / (double)this.nav));
        this.tred2(3, this.gyrtens, this.d, this.e, this.zmat);
        this.tql2(3, this.d, this.e, this.gyrtens, this.ierr);
        this.d0av += this.d[0] / (double)n2;
        this.d1av += this.d[1] / (double)n2;
        this.d2av += this.d[2] / (double)n2;
        this.jLabel5.setText(this.df.format(this.d[0] / (double)n2));
        this.jLabel6.setText(this.df.format(this.d[1] / (double)n2));
        this.jLabel7.setText(this.df.format(this.d[2] / (double)n2));
        this.jLabel13.setText(this.df.format(this.d0av / (double)this.nav));
        this.jLabel14.setText(this.df.format(this.d1av / (double)this.nav));
        this.jLabel15.setText(this.df.format(this.d2av / (double)this.nav));
        this.jLabel16.setText("shots:" + this.nav);
    }

    public void tql2(int n, double[] d, double[] e, double[][] a, int ierr) {
        ierr = 0;
        if (n > 1) {
            int k;
            double p;
            int i;
            for (i = 1; i < n; ++i) {
                e[i - 1] = e[i];
            }
            double f = 0.0;
            double tst1 = 0.0;
            e[n - 1] = 0.0;
            for (int l = 0; l < n; ++l) {
                double tst2;
                int count = 0;
                double h = Math.abs(d[l]) + Math.abs(e[l]);
                if (tst1 < h) {
                    tst1 = h;
                }
                int m = l;
                boolean iterate = true;
                do {
                    if ((tst2 = tst1 + Math.abs(e[m])) == tst1) {
                        iterate = false;
                    }
                    if (m >= n - 1) {
                        iterate = false;
                    }
                    if (!iterate || m >= n - 1) continue;
                    ++m;
                } while (iterate);
                if (m > l) {
                    count = 0;
                    iterate = true;
                    do {
                        double c;
                        ++count;
                        double g = d[l];
                        p = (d[l + 1] - g) / (2.0 * e[l]);
                        double r = this.pythag(p, 1.0);
                        d[l] = e[l] / (p + Math.copySign(r, p));
                        d[l + 1] = e[l] * (p + Math.copySign(r, p));
                        double dl1 = d[l + 1];
                        h = g - d[l];
                        i = l + 2;
                        while (i < n) {
                            int n2 = i++;
                            d[n2] = d[n2] - h;
                        }
                        f += h;
                        p = d[m];
                        double c2 = c = 1.0;
                        double c3 = c;
                        double el1 = e[l + 1];
                        double s = 0.0;
                        double s2 = 0.0;
                        for (i = m - 1; i >= l; --i) {
                            c3 = c2;
                            c2 = c;
                            s2 = s;
                            g = c * e[i];
                            h = c * p;
                            r = this.pythag(p, e[i]);
                            e[i + 1] = s * r;
                            s = e[i] / r;
                            c = p / r;
                            p = c * d[i] - s * g;
                            d[i + 1] = h + s * (c * g + s * d[i]);
                            for (k = 0; k < n; ++k) {
                                h = a[k][i + 1];
                                a[k][i + 1] = s * a[k][i] + c * h;
                                a[k][i] = c * a[k][i] - s * h;
                            }
                        }
                        p = -s * s2 * c3 * el1 * e[l] / dl1;
                        e[l] = s * p;
                        d[l] = c * p;
                        tst2 = tst1 + Math.abs(e[l]);
                        if (tst2 <= tst1) {
                            iterate = false;
                        }
                        if (count < 30) continue;
                        iterate = false;
                    } while (iterate);
                    if (count >= 30) {
                        ierr = l;
                        break;
                    }
                }
                d[l] = d[l] + f;
                e[l] = 0.0;
            }
            for (i = 0; i < n - 1; ++i) {
                int j;
                k = i;
                p = d[i];
                for (j = i + 1; j < n; ++j) {
                    if (!(d[j] < p)) continue;
                    k = j;
                    p = d[j];
                }
                if (k == i) continue;
                d[k] = d[i];
                d[i] = p;
                for (j = 0; j < n; ++j) {
                    p = a[j][i];
                    a[j][i] = a[j][k];
                    a[j][k] = p;
                }
            }
        }
    }

    private double pythag(double x, double y) {
        double r = Math.sqrt(x * x + y * y);
        return r;
    }

    public void tred2(int n, double[][] a, double[] d, double[] e, double[][] z) {
        int i;
        for (i = 0; i < n; ++i) {
            d[i] = a[n - 1][i];
        }
        if (n > 1) {
            double g;
            int j;
            int k;
            double h;
            for (i = n - 1; i > 0; --i) {
                h = 0.0;
                double scale = 0.0;
                for (k = 0; k < i; ++k) {
                    scale += Math.abs(d[k]);
                }
                if (scale == 0.0) {
                    e[i] = d[i - 1];
                    for (j = 0; j < i; ++j) {
                        d[j] = a[i - 1][j];
                        a[i][j] = 0.0;
                        a[j][i] = 0.0;
                    }
                } else {
                    for (k = 0; k < i; ++k) {
                        d[k] = d[k] / scale;
                        h += d[k] * d[k];
                    }
                    double f = d[i - 1];
                    g = Math.sqrt(h);
                    if (f > 0.0) {
                        g = -g;
                    }
                    e[i] = scale * g;
                    h -= f * g;
                    d[i - 1] = f - g;
                    for (j = 0; j < i; ++j) {
                        e[j] = 0.0;
                    }
                    for (j = 0; j < i; ++j) {
                        a[j][i] = f = d[j];
                        g = e[j] + a[j][j] * f;
                        for (k = j + 1; k < i; ++k) {
                            g += a[k][j] * d[k];
                            e[k] = e[k] + a[k][j] * f;
                        }
                        e[j] = g;
                    }
                    f = 0.0;
                    for (j = 0; j < i; ++j) {
                        e[j] = e[j] / h;
                        f += e[j] * d[j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < i; ++j) {
                        e[j] = e[j] - hh * d[j];
                    }
                    for (j = 0; j < i; ++j) {
                        f = d[j];
                        g = e[j];
                        for (k = j; k < i; ++k) {
                            a[k][j] = a[k][j] - f * e[k] - g * d[k];
                        }
                        d[j] = a[i - 1][j];
                        a[i][j] = 0.0;
                    }
                }
                d[i] = h;
            }
            for (i = 0; i < n - 1; ++i) {
                a[n - 1][i] = a[i][i];
                a[i][i] = 1.0;
                h = d[i + 1];
                if (h != 0.0) {
                    for (k = 0; k <= i; ++k) {
                        d[k] = a[k][i + 1] / h;
                    }
                    for (j = 0; j <= i; ++j) {
                        g = 0.0;
                        for (k = 0; k <= i; ++k) {
                            g += a[k][i + 1] * a[k][j];
                        }
                        for (k = 0; k <= i; ++k) {
                            a[k][j] = a[k][j] - g * d[k];
                        }
                    }
                }
                for (k = 0; k <= i; ++k) {
                    a[k][i + 1] = 0.0;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            d[i] = a[n - 1][i];
            a[n - 1][i] = 0.0;
        }
        a[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    class myPanel
    extends JPanel {
        myPanel() {
        }

        public void paintComponent(Graphics g) {
            int iy;
            int ix;
            int i;
            super.paintComponent(g);
            for (i = 0; i < NewJApplet.this.number_segments - 1; ++i) {
                ix = (int)(NewJApplet.this.xcoor[i] * (double)NewJApplet.this.window_w + 200.0);
                iy = (int)(200.0 - NewJApplet.this.ycoor[i] * (double)NewJApplet.this.window_w);
                int ix1 = (int)(NewJApplet.this.xcoor[i + 1] * (double)NewJApplet.this.window_w + 200.0);
                int iy1 = (int)(200.0 - NewJApplet.this.ycoor[i + 1] * (double)NewJApplet.this.window_w);
                g.drawLine(ix, iy, ix1, iy1);
            }
            for (i = 0; i < NewJApplet.this.number_segments; ++i) {
                ix = (int)(NewJApplet.this.xcoor[i] * (double)NewJApplet.this.window_w + 200.0);
                iy = (int)(200.0 - NewJApplet.this.ycoor[i] * (double)NewJApplet.this.window_w);
                if (i == NewJApplet.this.number_segments - 1) {
                    g.setColor(Color.red);
                }
                g.drawOval(ix - 5, iy - 5, 10, 10);
            }
        }
    }
}

