/*
 * NewJApplet.java
 *
 * Created on January 18, 2008, 7:16 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;

import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet
        implements ActionListener {

    Timer timer;
    double[][] u, du, checksum, v, dv;
    double[] alpha, beta, rs, xsol, u_c, gam_c, av, bv, cv;
    double[] real1, real2, imag1, imag2;
    int[] ireal1, ireal2, iimag1, iimag2, itim;
    double x, y, z, x1, x2, y3, y2, dumax, ddu, csmax, DELTAT;
    int count, iloop, iter, i, j, k, n, color, window_w;
    int selector, ivalues;
    double a0, a1, gam1, duij, a1r, a0r, u_av, v_av;
    int nmax = 150;
    int nmaxsq = nmax * nmax;
    int w_h = 400;
    double DELTAX = 0.1;
    double DELTAXSQ = 0.01;
    double r_val = 0.5;
    double a_val = 0.5;
    double m_val = 0.5;
    double b_val = 0.5;
    double D_u = 1.0;
    double D_v = 1.0;
    double eps = 0.01;
    double init_amp = 0.1;
    double vertfac = 100.0;
    double Peq, Heq;
    double time;
    boolean hold, p2d;
    int initial = 0;
    DecimalFormat df, df2,df3;
    Graphics2D gb;
    BufferedImage image;

    public void actionPerformed(ActionEvent e) {

        iterate();
        //jPanel1.repaint();

        if (!hold) {
            timer.restart();
        }
    }

    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                    DELTAT = 0.01;
                    jSlider4.setValue(100);
                    init_arrays();
                    initialize();

                    selector = 0;
                    ivalues = 0;




                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        timer = new Timer(1, this);
        timer.setInitialDelay(1);
        timer.setDelay(1);
        timer.start();
    }

    public void init_arrays() {
        u = new double[nmax][nmax];
        du = new double[nmax][nmax];

        v = new double[nmax][nmax];
        dv = new double[nmax][nmax];
        real1 = new double[100];
        real2 = new double[100];
        imag1 = new double[100];
        imag2 = new double[100];
        alpha = new double[nmax];
        beta = new double[nmax];
        av = new double[nmax];
        bv = new double[nmax];
        cv = new double[nmax];
        rs = new double[nmax];
        xsol = new double[nmax];
        u_c = new double[nmax];
        gam_c = new double[nmax];
        checksum = new double[nmax][nmax];
        ireal1 = new int[100];
        ireal2 = new int[100];
        iimag1 = new int[100];
        iimag2 = new int[100];
        itim = new int[100];
        df = new DecimalFormat("##0.0");
        df2 = new DecimalFormat("##0.000");
        df3 = new DecimalFormat("0.0000");
        image =
                new BufferedImage(750, 450, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 750, 450);
    }

    public void initialize() {
        double r;








        for (i = 0; i < nmax; i++) {
            for (j = 0; j < nmax; j++) {


                u[i][j] = 0;
                v[i][j] = 0;
                du[i][j] = 0.0;


                dv[i][j] = 0.0;
            }
        }


        Heq = m_val / b_val;
        Peq = r_val / a_val;

        if (initial == 0) {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {
                    r = Math.random();
                    u[i][j] = (0 + init_amp * r);


                    r = Math.random();
                    v[i][j] = (0 + init_amp * r);
                }
            }
        }

        if (initial == 1) {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {
                    r = Math.random();
                    u[i][j] = (Heq + init_amp * r);


                    r = Math.random();
                    v[i][j] = (Peq + init_amp * r);
                }
            }
        }






        if (initial == 2) {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {
                    u[i][j] = Heq + init_amp;
                    v[i][j] = Peq;
                }
            }
        }

        if (initial == 3) {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {
                    v[i][j] = Peq;
                    r = (i - nmax / 2) * (i - nmax / 2) + (j - nmax / 2) * (j - nmax / 2);
                    r = 5200 * r / (nmax * nmax);
                    u[i][j] = 0 + init_amp * Math.exp(-r);
                }
            }
        }


        if (initial == 4) {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {
                    v[i][j] = Peq;
                    r = (i - nmax / 2) * (i - nmax / 2) + (j - nmax / 2) * (j - nmax / 2);
                    r = 4 * r / (nmax * nmax);
                    u[i][j] = Heq + init_amp * Math.exp(-r);
                }
            }


        }



        count = 0;
        window_w = 2;

        for (i = 0; i < 100; i++) {
            itim[i] = 2 * i;
        }
        jSlider4.setValue((int) (D_v * 100));
        jLabel6.setText("D_v=" + df.format(D_v));
        jSlider2.setValue((int) (a_val * 100));
        jLabel4.setText("a=" + df.format(a_val));
        jSlider3.setValue((int) (b_val * 100));
        jLabel5.setText("b=" + df.format(b_val));
        jSlider6.setValue((int) (r_val * 100));
        jLabel8.setText("r=" + df.format(r_val));
        jSlider5.setValue((int) (m_val * 100));
        jLabel7.setText("m=" + df.format(m_val));
        jSlider7.setValue((int) (D_u * 100));
        jLabel9.setText("D_u=" + df.format(D_u));

        time = 0;

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jPanel3 = new myPanel2();
        jLabel3 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jToggleButton2 = new javax.swing.JToggleButton();
        jSlider9 = new javax.swing.JSlider();
        jLabel13 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jToggleButton1 = new javax.swing.JToggleButton();
        jComboBox1 = new javax.swing.JComboBox();
        jSlider8 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jSlider1 = new javax.swing.JSlider();
        jSlider2 = new javax.swing.JSlider();
        jSlider3 = new javax.swing.JSlider();
        jSlider4 = new javax.swing.JSlider();
        jLabel1 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jSlider5 = new javax.swing.JSlider();
        jSlider6 = new javax.swing.JSlider();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jSlider7 = new javax.swing.JSlider();
        jLabel9 = new javax.swing.JLabel();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setMaximumSize(new java.awt.Dimension(750, 450));
        jPanel1.setMinimumSize(new java.awt.Dimension(750, 450));
        jPanel1.setPreferredSize(new java.awt.Dimension(750, 450));
        jPanel1.setRequestFocusEnabled(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 453, Short.MAX_VALUE)
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel3.setMaximumSize(new java.awt.Dimension(700, 150));
        jPanel3.setMinimumSize(new java.awt.Dimension(700, 150));
        jPanel3.setPreferredSize(new java.awt.Dimension(700, 150));

        jLabel3.setText("jLabel3");

        jLabel11.setText("jLabel11");

        jLabel12.setText("jLabel12");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(449, 449, 449)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(jLabel11)
                    .addComponent(jLabel12, javax.swing.GroupLayout.PREFERRED_SIZE, 265, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(505, 505, 505))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel3)
                .addGap(52, 52, 52)
                .addComponent(jLabel12)
                .addGap(22, 22, 22))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel4.setMaximumSize(new java.awt.Dimension(120, 607));
        jPanel4.setMinimumSize(new java.awt.Dimension(120, 607));

        jToggleButton2.setText("2d/3d");
        jToggleButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton2ActionPerformed(evt);
            }
        });

        jSlider9.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider9.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider9MouseDragged(evt);
            }
        });

        jLabel13.setText("3d scale");

        jButton1.setText("restart");
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButton1MouseClicked(evt);
            }
        });

        jToggleButton1.setText("freeze");
        jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton1ActionPerformed(evt);
            }
        });
        jToggleButton1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jToggleButton1KeyPressed(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "0+noise", "eq+noise", "constant", "peak", "gauss" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jSlider8.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider8.setValue(10);
        jSlider8.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider8MouseDragged(evt);
            }
        });

        jLabel2.setText("amplitude");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel13)
                            .addComponent(jSlider8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2)
                            .addComponent(jSlider9, javax.swing.GroupLayout.PREFERRED_SIZE, 59, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(0, 38, Short.MAX_VALUE))
                    .addComponent(jToggleButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jToggleButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jSlider8, jSlider9});

        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jToggleButton2, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(62, 62, 62)
                .addComponent(jLabel13)
                .addGap(18, 18, 18)
                .addComponent(jSlider9, javax.swing.GroupLayout.PREFERRED_SIZE, 102, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(32, 32, 32)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSlider8, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jButton1)
                .addGap(18, 18, 18)
                .addComponent(jToggleButton1)
                .addGap(18, 18, 18)
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(64, Short.MAX_VALUE))
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jSlider8, jSlider9});

        jPanel5.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel5.setPreferredSize(new java.awt.Dimension(582, 118));

        jSlider1.setMajorTickSpacing(1);
        jSlider1.setMaximum(0);
        jSlider1.setMinimum(-4);
        jSlider1.setPaintLabels(true);
        jSlider1.setPaintTicks(true);
        jSlider1.setSnapToTicks(true);
        jSlider1.setValue(-2);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jSlider2.setMaximum(700);
        jSlider2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider2MouseReleased(evt);
            }
        });
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jSlider3.setMaximum(700);
        jSlider3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider3MouseReleased(evt);
            }
        });
        jSlider3.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider3MouseDragged(evt);
            }
        });

        jSlider4.setMaximum(500);
        jSlider4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider4MouseReleased(evt);
            }
        });
        jSlider4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider4MouseDragged(evt);
            }
        });

        jLabel1.setText("log(timestep)");

        jLabel4.setText("jLabel4");

        jLabel5.setText("jLabel5");

        jLabel6.setText("jLabel6");

        jSlider5.setMaximum(700);
        jSlider5.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider5MouseReleased(evt);
            }
        });
        jSlider5.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider5MouseDragged(evt);
            }
        });

        jSlider6.setMaximum(700);
        jSlider6.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider6MouseReleased(evt);
            }
        });
        jSlider6.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider6MouseDragged(evt);
            }
        });

        jLabel7.setText("jLabel7");

        jLabel8.setText("jLabel8");

        jSlider7.setMaximum(500);
        jSlider7.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider7MouseReleased(evt);
            }
        });
        jSlider7.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider7MouseDragged(evt);
            }
        });

        jLabel9.setText("jLabel9");

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGap(88, 88, 88)
                        .addComponent(jLabel4)
                        .addGap(178, 178, 178)
                        .addComponent(jLabel5)
                        .addGap(180, 180, 180)
                        .addComponent(jLabel9)
                        .addGap(154, 154, 154)
                        .addComponent(jLabel6))
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addGroup(jPanel5Layout.createSequentialGroup()
                                        .addGap(23, 23, 23)
                                        .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(jPanel5Layout.createSequentialGroup()
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addGap(88, 88, 88)
                                .addComponent(jLabel7)
                                .addGap(178, 178, 178)
                                .addComponent(jLabel8)))
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addGap(18, 18, 18)
                                .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addGap(101, 101, 101)
                                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel1)))))
                .addContainerGap(16, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabel4)
                                .addComponent(jLabel5)
                                .addComponent(jLabel9))
                            .addComponent(jLabel6)))
                    .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel7)
                            .addComponent(jLabel8)))
                    .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel1)))
                .addContainerGap(13, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, 750, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, 883, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(781, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 455, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(5370, 5370, 5370))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseClicked
        initialize();
        eq_val();
        //timer.stop();
        //tredtest();
        jPanel3.repaint();
    }//GEN-LAST:event_jButton1MouseClicked

private void jToggleButton1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jToggleButton1KeyPressed
// TODO add your handling code here:
}//GEN-LAST:event_jToggleButton1KeyPressed

private void jToggleButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton1ActionPerformed
    hold = jToggleButton1.isSelected();
    if (!hold) {
        timer.start();
    } else {
        timer.stop();
    }// TODO add your handling code here:
}//GEN-LAST:event_jToggleButton1ActionPerformed

private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
    initial = jComboBox1.getSelectedIndex();
    initialize();// TODO add your handling code here:
}//GEN-LAST:event_jComboBox1ActionPerformed

private void jToggleButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton2ActionPerformed
    p2d = jToggleButton2.isSelected();    // TODO add your handling code here:
}//GEN-LAST:event_jToggleButton2ActionPerformed

private void jSlider8MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider8MouseDragged
    init_amp = jSlider8.getValue() * 0.01;
    initialize();
// TODO add your handling code here:
}//GEN-LAST:event_jSlider8MouseDragged

private void jSlider9MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider9MouseDragged
    vertfac = jSlider9.getValue();
// TODO add your handling code here:
}//GEN-LAST:event_jSlider9MouseDragged

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
       timer.stop();
        a_val = jSlider2.getValue() * 0.01;
        jLabel4.setText("a=" + df.format(a_val));
        eq_val();
        jPanel3.repaint();  // TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jSlider2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseReleased
        initialize();
        timer.start();
    }//GEN-LAST:event_jSlider2MouseReleased

    private void jSlider3MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseDragged
        timer.stop();
        b_val = jSlider3.getValue() * 0.01;
        jLabel5.setText("b=" + df.format(b_val));
        eq_val();
        jPanel3.repaint();
       
    }//GEN-LAST:event_jSlider3MouseDragged

    private void jSlider3MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseReleased
        initialize();
        timer.start();
    }//GEN-LAST:event_jSlider3MouseReleased

    private void jSlider5MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider5MouseDragged
    timer.stop();
    m_val = jSlider5.getValue() * 0.01;
    jLabel7.setText("m=" + df.format(m_val));
    eq_val();
    jPanel3.repaint();
    }//GEN-LAST:event_jSlider5MouseDragged

    private void jSlider5MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider5MouseReleased
      initialize();
        timer.start();  
    }//GEN-LAST:event_jSlider5MouseReleased

    private void jSlider6MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider6MouseDragged
       timer.stop();
    r_val = jSlider6.getValue() * 0.01;
    jLabel8.setText("r=" + df.format(r_val));
    eq_val();
    jPanel3.repaint();  
    }//GEN-LAST:event_jSlider6MouseDragged

    private void jSlider6MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider6MouseReleased
      initialize();
        timer.start();    
    }//GEN-LAST:event_jSlider6MouseReleased

    private void jSlider7MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider7MouseDragged
        timer.stop();
    D_u = jSlider7.getValue() * 0.01;
    jLabel9.setText("D_u=" + df.format(D_u));
    jPanel3.repaint(); 
    }//GEN-LAST:event_jSlider7MouseDragged

    private void jSlider7MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider7MouseReleased
       initialize();
        timer.start();   
    }//GEN-LAST:event_jSlider7MouseReleased

    private void jSlider4MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseDragged
        timer.stop();
    D_v = jSlider4.getValue() * 0.01;
    jLabel6.setText("D_v=" + df.format(D_v));
    jPanel3.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider4MouseDragged

    private void jSlider4MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseReleased
      initialize();
        timer.start();   
    }//GEN-LAST:event_jSlider4MouseReleased

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        double ii;
    ii = jSlider1.getValue();
    DELTAT = Math.pow(10, ii); 
    }//GEN-LAST:event_jSlider1MouseDragged

    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton jButton1;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider jSlider3;
    private javax.swing.JSlider jSlider4;
    private javax.swing.JSlider jSlider5;
    private javax.swing.JSlider jSlider6;
    private javax.swing.JSlider jSlider7;
    private javax.swing.JSlider jSlider8;
    private javax.swing.JSlider jSlider9;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToggleButton jToggleButton2;
    // End of variables declaration//GEN-END:variables

    public void eq_val() {
        Heq = m_val / b_val;
        Peq = r_val / a_val;
    }

    public void iterate() {
        int ix, iy, ix1, iy1, ix2, iy2, i2;
        double del;
        Graphics g;
        g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g;

        eq_val();

        implu();
        implv();

        sumuv();

        time += DELTAT;
        jLabel12.setText("time=" + df3.format(time));

        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 750, 450);
        if (!p2d) {
            for (i = nmax - 1; i > 0; i--) {
                for (j = 0; j < nmax - 1; j++) {


                    del = u[i][j] - u_av;
                    if (del > 0.1) {
                        color = 1;
                    } else if (del > 0.01) {
                        color = 2;
                    } else if (del < -0.1) {
                        color = 3;
                    } else if (del < -0.01) {
                        color = 4;
                    } else {
                        color = 5;
                    }



                    x1 = j + i / 2;
                    y3 = i + (u[i][j]) * vertfac;
                    x2 = j + 1 + i / 2;
                    y2 = i + (u[i][j + 1]) * vertfac;
                    ix1 = (int) (x1 * window_w);
                    iy1 = w_h - (int) (y3 * window_w);
                    ix2 = (int) (x2 * window_w);
                    iy2 = w_h - (int) (y2 * window_w);

                    if (color == 5) {
                        gb.setColor(Color.GRAY);
                    }
                    if (color == 1) {
                        gb.setColor(Color.red);
                    }
                    if (color == 2) {
                        gb.setColor(Color.yellow);
                    }
                    if (color == 3) {
                        gb.setColor(Color.blue);
                    }
                    if (color == 4) {
                        gb.setColor(Color.green);
                    }





                    gb.drawLine(ix1, iy1, ix2, iy2);
                }
            }


            for (i = nmax - 1; i > 0; i--) {
                for (j = 0; j < nmax - 1; j++) {


                    del = v[i][j] - v_av;
                    if (del > 0.1) {
                        color = 1;
                    } else if (del > 0.01) {
                        color = 2;
                    } else if (del < -0.1) {
                        color = 3;
                    } else if (del < -0.01) {
                        color = 4;
                    } else {
                        color = 5;
                    }



                    x1 = j + i / 2;
                    y3 = i + (v[i][j]) * vertfac;
                    x2 = j + 1 + i / 2;
                    y2 = i + (v[i][j + 1]) * vertfac;
                    ix1 = (int) (x1 * window_w) + 300;
                    iy1 = w_h - (int) (y3 * window_w);
                    ix2 = (int) (x2 * window_w) + 300;
                    iy2 = w_h - (int) (y2 * window_w);

                    if (color == 5) {
                        gb.setColor(Color.GRAY);
                    }
                    if (color == 1) {
                        gb.setColor(Color.red);
                    }
                    if (color == 2) {
                        gb.setColor(Color.yellow);
                    }
                    if (color == 3) {
                        gb.setColor(Color.blue);
                    }
                    if (color == 4) {
                        gb.setColor(Color.green);
                    }





                    gb.drawLine(ix1, iy1, ix2, iy2);
                }
            }





        } else {
            for (i = 0; i < nmax; i++) {
                for (j = 0; j < nmax; j++) {

                    del = u[i][j] - u_av;
                    if (del > 0.1) {
                        color = 1;
                    } else if (del > 0.01) {
                        color = 2;
                    } else if (del < -0.1) {
                        color = 3;
                    } else if (del < -0.01) {
                        color = 4;
                    } else {
                        color = 5;
                    }


                    if (color == 5) {
                        gb.setColor(Color.black);
                    }
                    if (color == 1) {
                        gb.setColor(Color.red);
                    }
                    if (color == 2) {
                        gb.setColor(Color.yellow);
                    }
                    if (color == 3) {
                        gb.setColor(Color.blue);
                    }
                    if (color == 4) {
                        gb.setColor(Color.green);
                    }




                    gb.fillRect(2 * i, 2 * j, 2, 2);
                }
            }



        }

        g2.drawImage(image, 0, 0, null);
    }

    public class myPanel extends javax.swing.JPanel {

        double a0r, a1r;

        public void paintComponent(Graphics g2) {








            int ix, iy, ix1, iy1, ix2, iy2, i2;
            double del;

            super.paintComponent(g2);

            g2.drawImage(image, 0, 0, null);

        //jLabel1.setText("" + Math.log10(dumax));







        }
    }

    void dispersion() {




        int ix, iy, ix1, iy1, ix2, iy2, i2;
        double k, rp, imp, rp2, imp2, alp, bet, z;
        //Graphics g;
        //g=jPanel3.getGraphics();

        //jLabel6.setText(""+a_val+"  "+b_val);

        for (i = 0; i < 100; i++) {

            k = (0.01 * Math.PI * i / DELTAX);
            alp = (D_u - D_v) * k * k * DELTAXSQ;
            bet = 4 * m_val * r_val;

            real1[i] = -0.5 * (D_u + D_v) * k * k * DELTAXSQ;
            real2[i] = real1[i];
            imag1[i] = imag2[i] = 0;

            z = 0.25 * (alp * alp - bet);

            if (z > 0) {
                real1[i] += Math.sqrt(z);
                real2[i] -= Math.sqrt(z);

            } else {



                z = Math.sqrt(-z);
                imag1[i] += z;
                imag2[i] -= z;






            }

            iimag1[i] = 50 - (int) (5 * imag1[i]);
            iimag2[i] = 50 - (int) (5 * imag2[i]);
            ireal1[i] = 50 - (int) (5 * real1[i]);
            ireal2[i] = 50 - (int) (5 * real2[i]);

        }




    }

    void tred() {


        /* solves the system of equations
        a1* x[i-1]+a0*x[i]+ a1*x[i+1] =rs[i]
         */
        double bet;
        int ic, jc;


        alpha[nmax - 2] = -av[nmax - 1] / bv[nmax - 1];
        beta[nmax - 2] = rs[nmax - 1] / bv[nmax - 1];



        for (jc = nmax - 3; jc >= 0; jc--) {
            bet = bv[jc + 1] + cv[jc + 1] * alpha[jc + 1];
            alpha[jc] = -av[jc + 1] / bet;
            beta[jc] = (rs[jc + 1] - cv[jc + 1] * beta[jc + 1]) / bet;
        }

        bet = bv[0] + cv[0] * alpha[0];
        xsol[0] = (rs[0] - cv[0] * beta[0]) / bet;

        for (jc = 0; jc < nmax - 1; jc++) {
            xsol[jc + 1] = alpha[jc] * xsol[jc] + beta[jc];
        }


    }

    void implu() {
        double sp1, sp2;
        int ic;
        count++;

        /* Koeffizienten des Gleichungssystems */

        a0 = 1.0 + 2 * DELTAT * D_u;
        a1 = -DELTAT * D_u;

        for (ic = 0; ic < nmax; ic++) {
            av[ic] = a1;
            bv[ic] = a0;
            cv[ic] = a1;

        }

        bv[0] -= 0.5;
        bv[nmax - 1] -= (2 * a1 * a1);

        for (j = 0; j < nmax; j++) {








            for (i = 0; i < nmax; i++) {
                rs[i] = u[i][j] + (r_val * u[i][j] - u[i][j] * v[i][j] * a_val) * DELTAT;
            }

            tred();

            for (i = 0; i < nmax; i++) {
                u[i][j] = xsol[i];
            }

            // now correct for periodic bc

            for (i = 0; i < nmax; i++) {
                rs[i] = 0;
            }
            rs[0] = 1;
            rs[nmax - 1] = 2 * a1;

            tred();

            sp1 = 0.5 * xsol[0] + xsol[nmax - 1] * a1;
            sp2 = 0.5 * u[0][j] + u[nmax - 1][j] * a1;

            for (i = 0; i < nmax; i++) {
                u[i][j] -= xsol[i] * sp2 / (1 + sp1);

            }



        }


        /* jetzt in j-Richtung */

        /* Koeffizienten des Gleichungssystems */

        a0 = 1.0 + 2 * DELTAT * D_u;
        a1 = -DELTAT * D_u;
        for (ic = 0; ic < nmax; ic++) {
            av[ic] = a1;
            bv[ic] = a0;
            cv[ic] = a1;

        }

        bv[0] -= 0.5;
        bv[nmax - 1] -= (2 * a1 * a1);
        for (i = 0; i < nmax; i++) {






            for (j = 0; j < nmax; j++) {
                rs[j] = u[i][j];
            }

            tred();




            for (j = 0; j < nmax; j++) {
                u[i][j] = xsol[j];
            }

            for (j = 0; j < nmax; j++) {
                rs[j] = 0;
            }
            rs[0] = 1;
            rs[nmax - 1] = 2 * a1;

            tred();

            sp1 = 0.5 * xsol[0] + xsol[nmax - 1] * a1;
            sp2 = 0.5 * u[i][0] + u[i][nmax - 1] * a1;

            for (j = 0; j < nmax; j++) {
                u[i][j] -= xsol[j] * sp2 / (1 + sp1);

            }


        }

    }

    void implv() {


        double sp1, sp2;
        int ic;


        for (j = 0; j < nmax; j++) {


            /* Koeffizienten des Gleichungssystems */

            a0 = 1.0 + 2 * DELTAT * D_v;
            a1 = -DELTAT * D_v;

            for (ic = 0; ic < nmax; ic++) {
                av[ic] = a1;
                bv[ic] = a0;
                cv[ic] = a1;

            }

            bv[0] -= 0.5;
            bv[nmax - 1] -= (2 * a1 * a1);


            for (i = 0; i < nmax; i++) {
                rs[i] = v[i][j] + (u[i][j] * v[i][j] * b_val - m_val * v[i][j]) * DELTAT;
            }

            tred();





            for (i = 0; i < nmax; i++) {
                v[i][j] = xsol[i];
            }
            for (i = 0; i < nmax; i++) {
                rs[i] = 0;
            }
            rs[0] = 1;
            rs[nmax - 1] = 2 * a1;

            tred();

            sp1 = 0.5 * xsol[0] + xsol[nmax - 1] * a1;
            sp2 = 0.5 * v[0][j] + v[nmax - 1][j] * a1;

            for (i = 0; i < nmax; i++) {
                v[i][j] -= xsol[i] * sp2 / (1 + sp1);

            }



        }


        /* jetzt in j-Richtung */

        for (i = 0; i < nmax; i++) {

            /* Koeffizienten des Gleichungssystems */

            a0 = 1.0 + 2 * DELTAT * D_v;
            a1 = -DELTAT * D_v;

            for (ic = 0; ic < nmax; ic++) {
                av[ic] = a1;
                bv[ic] = a0;
                cv[ic] = a1;

            }

            bv[0] -= 0.5;
            bv[nmax - 1] -= (2 * a1 * a1);

            for (j = 0; j < nmax; j++) {
                rs[j] = v[i][j];
            }

            tred();




            for (j = 0; j < nmax; j++) {
                v[i][j] = xsol[j];
            }

            for (j = 0; j < nmax; j++) {
                rs[j] = 0;
            }
            rs[0] = 1;
            rs[nmax - 1] = 2 * a1;

            tred();

            sp1 = 0.5 * xsol[0] + xsol[nmax - 1] * a1;
            sp2 = 0.5 * v[i][0] + v[i][nmax - 1] * a1;

            for (j = 0; j < nmax; j++) {
                v[i][j] -= xsol[j] * sp2 / (1 + sp1);

            }


        }

    }

    public void sumuv() {
        int i, j;
        double su, sv;

        su = 0;
        sv = 0;
        for (i = 0; i < nmax; i++) {
            for (j = 0; j < nmax; j++) {
                su += u[i][j];
                sv += v[i][j];

            }
        }

        u_av = su / nmaxsq;
        v_av = sv / nmaxsq;

        jLabel3.setText("av u=" + df2.format(u_av) + "  eq u=" + df2.format(Heq));
        jLabel11.setText("av v=" + df2.format(v_av) + "  eq v=" + df2.format(Peq));



    }

    public class myPanel2 extends javax.swing.JPanel {

        public void paintComponent(Graphics g) {



















            int i, ix, iy, ix1, iy1, ix2, iy2, i2;
            double k, rp, imp, rp2, imp2, alp, bet, z;

            super.paintComponent(g);
            dispersion();



            g.setColor(Color.red);
            g.drawString("Real(lambda(k))", 150, 20);

            g.setColor(Color.blue);

            g.drawString("Imag(lambda(k))", 10, 20);

            g.setColor(Color.black);
            g.drawLine(0, 50, 200, 50);
            g.drawString("k", 205, 50);



            for (i = 0; i < 100; i++) {



                g.setColor(Color.red);

                g.drawPolyline(itim, ireal1, 100);
                g.drawPolyline(itim, ireal2, 100);
//                iy = 50 - (int) (imag1[i] * 10);
//                g.drawOval(i * 2, iy, 2, 2);

                //               iy = 50 - (int) (imag2[i] * 10);
                //             g.drawOval(i * 2, iy, 2, 2);

                g.setColor(Color.blue);
                g.drawPolyline(itim, iimag1, 100);
                g.drawPolyline(itim, iimag2, 100);


            //               iy = 50 - (int) (real1[i] * 10);
            //               g.drawOval(i * 2, iy, 2, 2);

            //               iy = 50 - (int) (real2[i] * 10);
            //               g.drawOval(i * 2, iy, 2, 2);
            }


        }
    }
}



